/*
 *  This file is part of the KDE System Control Tool,
 *  Copyright (C)1999 Thorsten Westheider <twesthei@physik.uni-bielefeld.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ****************************************************************************/

#include "parport.h"


ParallelPort::ParallelPort(uint portno, parportclass pclass) : _portno(portno),
							       _class(pclass)
{
  _baseclass = BaseClassConnector;
}


/*
 * Public methods
 *****************/
 
QString  ParallelPort::deviceName()
{
  QString  portstr;
  
  portstr.sprintf(" (LPT%u)", _portno+1);
  
  switch (_class)
  {
    case ParPortClassDefault : return QString(i18n("Printer connector"))+portstr;
    case ParPortClassECP     : return QString(i18n("ECP printer connector"))+portstr;
    default                  : return QString(i18n("Unknown printer connector"))+portstr;
  }
}


QString  ParallelPort::deviceClassName()
{
  return "";
}


Device::devstate  ParallelPort::deviceState()
{
  return DeviceStateReady; // Doh...have to check that, actually
}
