/*
 *  This file is part of the KDE System Control Tool,
 *  Copyright (C)1999 Thorsten Westheider <twesthei@physik.uni-bielefeld.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ****************************************************************************/

#ifndef __ISAPNPDEVICE_H
#define __ISAPNPDEVICE_H

#include <kapp.h>

#include "device.h"
#include "resbaseconf.h"


class ISAPnPDevice : public Device
{
  public:
  
    enum isapnpclass { ISAPnPClassNetworkOther     = 0xf280,
    		       ISAPnPClassMultimediaAudio  = 0xf401,                       
		       ISAPnPClassInputOther       = 0xf980 };
  
    ISAPnPDevice(QString vendorid, uint deviceid, QString devicename,
                 uint logid, QString logname);
		     
    ~ISAPnPDevice() {}
    
    void  addBaseConfig(ResourceBaseConfig *config) { _conflist.append(config); }
    void  setActive(bool b)			    { _active = b;		}
    
    bool                        active()      const { return _active;	        }

    virtual bustype             busType()     const { return BusISA;            }
    
    virtual ResourceBaseConfig  *baseConfig(int i)  { return _conflist.at(i);   }
    virtual ResourceBaseConfig  *firstConfig()      { return _conflist.first(); }
    virtual ResourceBaseConfig  *nextConfig()       { return _conflist.first(); }
    virtual uint                numConfigs()  const { return _conflist.count(); }
    virtual int                 settingsBasedOn();
    
    virtual QString             deviceClassName();
    virtual QString             deviceName()	    { return _devicename+' '+_logname; }
    virtual devstate            deviceState();
    virtual QString             vendorName()	    { return _vendorname;	       }
    
  private:
  
    QList<ResourceBaseConfig>  _conflist;
  
    QString                    _vendorname;
    QString                    _vendorid;
    QString                    _devicename;
    QString                    _logname;
    uint                       _deviceid, _logid;
    isapnpclass                _class;
    bool                       _active;
    
    void  lookupData();
};


#endif
