/***************************************************************************
    $Id: kpcwizard.h,v 1.11 1999/09/23 16:06:31 stephan Exp $
    copyright : (C) 1999 by Stephan Heigl       <stephan@heigl-gmbh.de>
                (C) 1999 by Willy De la Court   <Willy.DelaCourt@pandora.be>
 ***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************
    $Log: kpcwizard.h,v $
    Revision 1.11  1999/09/23 16:06:31  stephan
    Minor changes in kpcwizard

    Revision 1.10  1999/09/19 13:43:29  wdl
    kpcwizard is now a shared library

    Revision 1.9  1999/09/18 15:45:13  stephan
    Minor changes.

    Revision 1.8  1999/09/09 11:28:43  stephan
    Fixed some things for the new spool handling

    Revision 1.7  1999/08/30 20:04:23  wdl
    First working version of knewwizard. It needs a lot of cleanup.

    Revision 1.6  1999/08/27 16:42:56  wdl
    Standard Headers

 ***************************************************************************/
#ifndef KPCWIZARD_H
#define KPCWIZARD_H

#include <kapp.h>
#include <qwidget.h>
#include <qstring.h>

#include "knewwizard.h"
#include "intropage.h"
#include "locationpage.h"
#include "modelpage.h"
#include "networkpage.h"
#include "portpage.h"
#include "paperpage.h"
#include "finishpage.h"

#include "kpcapi.h"
#include "kpcprinter.h"
#include "kpcspool.h"

class KpcWizard : public KNewWizard {
  Q_OBJECT 
public: 
  /** construtor */
  KpcWizard(QWidget *parent=0, const char* name=0, bool modal=false);
  /** destructor */
  ~KpcWizard();
public slots:
	void setNetworkSetup(KpcPrinter::netType);
	void currentPage(int page);
	void cancelSetup();
	void setupPrinter();
private:
	KpcPrinter getSummary();

	IntroPage 		*myIntroPage;
	LocationPage 	*myLocPage;
	NetworkPage 	*myNetworkPage;
	ModelPage 		*myModelPage;
	PortPage 			*myPortPage;
	PaperPage 		*myPaperPage;
  FinishPage 		*myFinishPage;

  int prevPage;
  bool inCurrentPage;
	KpcPrinter::netType netSetup;
	bool standalone;
};
#endif






























