/***************************************************************************
    $Id: htmlhelp.cpp,v 1.3 1999/08/27 16:42:55 wdl Exp $
    copyright : (C) 1999 by Stephan Heigl       <stephan@heigl-gmbh.de>
                (C) 1999 by Willy De la Court   <Willy.DelaCourt@pandora.be>
 ***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************
    $Log: htmlhelp.cpp,v $
    Revision 1.3  1999/08/27 16:42:55  wdl
    Standard Headers

 ***************************************************************************/
#include "htmlhelp.h"

HTMLHelp::HTMLHelp(QWidget *parent, const char *name ) : QWidget(parent,name) {
/**
	* Constructor
	**/

	DocView = new KHTMLWidget(this);
	DocView->setGeometry(0,0,width(),height());		
	setDocRoot(kapp->kde_datadir() + "/kpcwizard/wizard");
}


HTMLHelp::~HTMLHelp(){
}

void HTMLHelp::setDocRoot(const char *val){
/**
  * Set the document root of the kpcwizards helpfiles and appends to the value(val) the language
	* if theres no support for the users language we check if there is one for his 2nd and 3rd lang.
	* if theres absolute no support for the users prefered languages we use the default one
  **/
	QStrList *LangLst = new QStrList();
	QString *tmpStr = new QString();
	QDir *tmpDir = new QDir();
	KLocale *myLoc = new KLocale();
	bool haveLang;
	haveLang = false;
	*LangLst = myLoc->languageList();
	for(*tmpStr = LangLst->first(); *tmpStr != 0; *tmpStr = LangLst->next()){
		tmpStr->prepend("/");
		tmpStr->prepend(val);
		tmpDir->setPath(tmpStr->data());
		if(!haveLang) {
			if(tmpDir->exists()) { DocRoot = tmpStr->data(); haveLang = true;} else { DocRoot = val; DocRoot.append("/en");}
		}		
	}
	delete(tmpDir); delete(myLoc); delete(tmpStr); delete(LangLst);
}

void HTMLHelp::showHelp(const char *fileName){
/**
	* loads the specified(fileName) file and displays it as rendered HTML
	**/
	QString fileN(fileName);
	fileN.prepend("/");
	fileN.prepend(DocRoot.data());
	QFile HelpFile(fileN.data());
	QTextStream HelpStrm( &HelpFile );
	if(!HelpFile.open( IO_ReadOnly )) { printf("\nFile %s not found!!\n",fileN.data()); return; }
	DocView->begin(fileN.data());
	DocView->parse();
	while(!HelpStrm.eof()){
		DocView->write(HelpStrm.readLine().data());
	}
	DocView->end();
	DocView->show();
	HelpFile.close();
}

void HTMLHelp::resizeEvent(QResizeEvent *event){
/**
	* 	handle resize events....as usual...
	**/
	DocView->setGeometry(0,0,width(),height());		
}








