/***************************************************************************
    $Id: printerdbentry.h,v 1.1 1999/09/14 00:26:28 wdl Exp $
    copyright : (C) 1999 by Stephan Heigl       <stephan@heigl-gmbh.de>
                (C) 1999 by Willy De la Court   <Willy.DelaCourt@pandora.be>
 ***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************
    $Log: printerdbentry.h,v $
    Revision 1.1  1999/09/14 00:26:28  wdl
    Restructuring of directories

    Revision 1.3  1999/08/27 16:43:03  wdl
    Standard Headers

 ***************************************************************************/
#ifndef PRINTERDBENTRY_H
#define PRINTERDBENTRY_H

#include <assert.h>
#include <qstring.h>
#include <qlist.h>
/**
  *@author Stephan Heigl
  */

class printerDBentry {
public: 
	printerDBentry();
	printerDBentry(printerDBentry &to_cp);
	~printerDBentry();

	const char * getModelName() { return ModelName.data(); }
	const char * getManufactor() { return Manufactor.data(); }
	const char * getGSoptions() { return GSoptions.data(); }
	QList<QString> getColorRes() { return ColorRes; }
	QList<QString> getMonoRes() { return MonoRes; }
	QList<QString> getPaperFormats() { return PaperFormats; }
	const char * getGSdriver() { return GSdriver.data(); }
	
  bool isPostScriptPrinter()  { return PostScriptPrinter; }
	bool isColorPrinter() { return ColorPrinter; }

	void setModelName(const char *val) { ModelName = val; }
  void setManufactor(const char *val) { Manufactor = val; }
	void setGSoptions(const char *val) { GSoptions = val; }
	void setColorRes(const char *val); // separated by ;
	void setMonoRes(const char *val); //  separated by ;
	void setPaperFormats(const char *val); // separated by ;
  void setGSdriver(const char *val) { GSdriver = val; }
	void setColorPrinter(bool val) { ColorPrinter = val; }
	void setPostScriptPrinter(bool val) { PostScriptPrinter = val; }
		
private:
	QString ModelName;
	QString Manufactor;
	bool PostScriptPrinter;
	bool ColorPrinter;
	QString GSoptions;
	QList<QString> ColorRes;
	QList<QString> MonoRes;
	QList<QString> PaperFormats;
	QString GSdriver;
};

class printerDBmanufactor {
public:
	printerDBmanufactor();
	printerDBmanufactor(printerDBmanufactor &);
	~printerDBmanufactor();

	void setName(const char *val) { Name = val; }
	void setLogo(const char *val) { Logo = val; }
	void setWeb(const char *val) { Web = val; }
	void setModelFile(const char *val) { ModelFile = val; }

	const char * getLogo() { return Logo.data(); }
	const char * getWeb() { return Web.data(); }
	const char * getModelFile() { return ModelFile.data(); }
	const char * getName() { return Name.data(); }

private:
	QString Name;
	QString Logo;
	QString Web;
	QString ModelFile;		
};
#endif





