/***************************************************************************
    $Id: printerdbentry.cpp,v 1.1 1999/09/14 00:26:28 wdl Exp $
    copyright : (C) 1999 by Stephan Heigl       <stephan@heigl-gmbh.de>
                (C) 1999 by Willy De la Court   <Willy.DelaCourt@pandora.be>
 ***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************
    $Log: printerdbentry.cpp,v $
    Revision 1.1  1999/09/14 00:26:28  wdl
    Restructuring of directories

    Revision 1.4  1999/08/27 16:43:03  wdl
    Standard Headers

 ***************************************************************************/
#include "printerdbentry.h"

printerDBentry::printerDBentry(){
}

printerDBentry::printerDBentry(printerDBentry &to_cp){
	ColorPrinter = to_cp.isColorPrinter();
	PostScriptPrinter = to_cp.isPostScriptPrinter();
	ModelName = to_cp.getModelName();
	Manufactor = to_cp.getManufactor();
	GSoptions = to_cp.getGSoptions();
	GSdriver = to_cp.getGSdriver();
	ColorRes = to_cp.getColorRes();
	MonoRes = to_cp.getMonoRes();
	PaperFormats = to_cp.getPaperFormats();
}

printerDBentry::~printerDBentry(){
}

void printerDBentry::setColorRes(const char *val){
	QString *tmpStr	= new QString;
	ColorRes.clear();
	for(*tmpStr = strtok((char *)val,";"); *tmpStr != NULL; *tmpStr = strtok(NULL,";")) ColorRes.append(new QString(*tmpStr));
	delete(tmpStr);
}

void printerDBentry::setMonoRes(const char *val){
	QString *tmpStr	= new QString;
	MonoRes.clear();
	for(*tmpStr = strtok((char *)val,";"); *tmpStr != NULL; *tmpStr = strtok(NULL,";")) MonoRes.append(new QString(*tmpStr));
	delete(tmpStr);
}

void printerDBentry::setPaperFormats(const char *val){
	QString *tmpStr	= new QString;
	PaperFormats.clear();
	assert(val);
	for(*tmpStr = strtok((char *)val,";"); *tmpStr != NULL; *tmpStr = strtok(NULL,";")) PaperFormats.append(new QString(*tmpStr));
	delete(tmpStr);
}

printerDBmanufactor::printerDBmanufactor(){
}

printerDBmanufactor::printerDBmanufactor(printerDBmanufactor &tc){
	Logo = tc.getLogo();	
	Web = tc.getWeb();
	ModelFile = tc.getModelFile();
	Name = tc.getName();
}

printerDBmanufactor::~printerDBmanufactor(){
}






