/***************************************************************************
    $Id: kpcspool.cpp,v 1.1 1999/09/14 00:26:26 wdl Exp $
    copyright : (C) 1999 by Stephan Heigl       <stephan@heigl-gmbh.de>
                (C) 1999 by Willy De la Court   <Willy.DelaCourt@pandora.be>
 ***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************
    $Log: kpcspool.cpp,v $
    Revision 1.1  1999/09/14 00:26:26  wdl
    Restructuring of directories

    Revision 1.2  1999/09/09 11:28:43  stephan
    Fixed some things for the new spool handling

    Revision 1.1  1999/09/09 06:01:58  stephan
    Added OO style spool handling (by using KpcSpool)

 ***************************************************************************/
#include "kpcspool.h"

KpcSpool::KpcSpool(){
Color = KpcSpool::mono;
Xres = 300;
Yres = 300;
TypeRecognition = KpcSpool::automatic;
PaperFormat = KpcSpool::def;
DefSpool = false;
}

KpcSpool::KpcSpool(KpcSpool &t_c){
	Color = t_c.getColor();
	Xres = t_c.getXres();
	Yres = t_c.getYres();
	TypeRecognition = t_c.getTypeRecognition();
	PaperFormat = t_c.getPaperFormat();
	name = t_c.getName();
}

KpcSpool::KpcSpool(const char *valName, bool isDef=false ,typeRecog valRec=KpcSpool::automatic, col valCol=KpcSpool::color, paperFormat valPap=KpcSpool::def, int valX=0,int valY=0){
	Color = valCol;
	Xres = valX;
	Yres = valY;
	TypeRecognition = valRec;
	PaperFormat = valPap;
	name = valName;
	DefSpool = isDef;
}

KpcSpool::~KpcSpool(){
}








