/***************************************************************************
    $Id: kpcprinter.h,v 1.1 1999/09/14 00:26:26 wdl Exp $
    copyright : (C) 1999 by Stephan Heigl       <stephan@heigl-gmbh.de>
                (C) 1999 by Willy De la Court   <Willy.DelaCourt@pandora.be>
 ***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************
    $Log: kpcprinter.h,v $
    Revision 1.1  1999/09/14 00:26:26  wdl
    Restructuring of directories

    Revision 1.7  1999/09/09 06:01:57  stephan
    Added OO style spool handling (by using KpcSpool)

    Revision 1.6  1999/08/29 15:03:41  stephan
    Added 2 methods for user specific printers which are not in the db

    Revision 1.5  1999/08/27 16:43:01  wdl
    Standard Headers

 ***************************************************************************/
#ifndef KPCPRINTER_H
#define KPCPRINTER_H


#include <qstring.h>
#include <qlist.h>

#include "printerdb.h"
#include "printerdbentry.h"

#include "kpcspool.h"
/**
	* Represents a printer for the KpcAPI
	* @see KpcAPI.
	*
	* Use this to modify/add/remove printers.
	**/


class KpcPrinter {
	public:
		enum netType { local, appletalk, smb, lpd, netware, ethernet };

		KpcPrinter();
		KpcPrinter(KpcPrinter &);
		~KpcPrinter();

		void setModel(const char *val) { Model = val; DbName = val; }
		void setManufactor(const char *val) { Manufactor = val; }
		void setPort(const char *val) { Port = val; }
		void setPaperFormat(const char *val) { PaperFormat = val; }
    /**
			* Set the type of networkprinter if it is a locale one, just set KpcPrinter::local.
			*
			* Appletalk = KpcPrinter::appletalk<BR>
			* Win9x/NT/Lanman etc = KpcPrinter::smb<BR>
			* Unix/LPD = KpcPrinter::lpd<BR>
			* NovellNetware = KpcPrinter::netware<BR>
			* JetDirect etc = KpcPrinter::ethernet
			**/
		void setNetworkType(netType val) { NetworkType = val; }

		void setDefaultPrinter(bool val) { DefaultPrinter = val; }
		void setRemoteMachine(const char *val) { RemoteMachine = val; }
  	void setRemoteQueue(const char *val) { RemoteQueue = val; }
    /**
			* Return the GSDriver u have set with setGSDriver
			* if GSDriver is empty its loaded from db ...
			* use set/getGSDriver in this class ONLY if u want to set the gs-driver by yourself
			**/
		void setGSDriver(const char *val) { GSDriver = val; }
		 /**
			* Return the GSOptions u have set with setGSOptions
			* if GSOptions is empty its loaded from db ...
			* use set/getGSOptions in this class ONLY if u want to set the gs-options by yourself
			**/
		void setGSOptions(const char *val) { GSOptions = val; }
		// for some special cases (e.g. 2 printer of same manufact. + model)
		void setDbName(const char *val) { DbName = val; }
		const char *getDbName() { return DbName.data(); }
		//
		netType getNetworkType() { return NetworkType; }
		
		bool isDefaultPrinter() { return DefaultPrinter; }
		const char *getModel() { return Model.data(); }
		const char *getManufactor() { return Manufactor.data(); }
		const char *getPort() { return Port.data(); }
		const char *getPaperFormat() { return PaperFormat.data(); }
		const char *getRemoteMachine() { return RemoteMachine.data(); }
		const char *getRemoteQueue() { return RemoteQueue.data(); }
    /**
			* Return the GSDriver u have set with setGSDriver
			* if GSDriver is empty its loaded from db ...
			* use set/getGSDriver in this class ONLY if u want to set the gs-driver by yourself
			**/
		const char *getGSDriver() { return GSDriver.data(); }
		 /**
			* Return the GSOptions u have set with setGSOptions
			* if GSOptions is empty its loaded from db ...
			* use set/getGSOptions in this class ONLY if u want to set the gs-options by yourself
			**/
		const char *getGSOptions() { return GSOptions.data(); }
    /**
			* Return a list of supported paper formats. You MUST use setModel and and setManufactor first!
			**/
		QList<QString> getSupportedPaperFormats();
		/**
			* Return a list of supported Mono-Resolutions.You MUST use setModel and and setManufactor first!
			**/
		QList<QString> getSupportedMonoRes();

		/**
			* Return a list of supported Color-Resolutions.You MUST use setModel and and setManufactor first!
			**/
		QList<QString> getSupportedColorRes();

		/**
			* Add a spool
			* @see KpcSpool
			**/
		bool addSpool(KpcSpool *);
		/**
			* Remove a spool
			* @see KpcSpool
			**/
		bool removeSpool(const char *);
		/**
			* List spools for this Printer
			* @see KpcSpool
			**/
		QList<QString> getSpoolLstName();
		QList<KpcSpool> getSpoolLst() { return SpoolLst; }
		
	private:
		QString DbName;
		QString Model;
		QString Manufactor;
		QString Port;
		QString PaperFormat;
		QString SpoolName;

		QString GSDriver;
		QString GSOptions;

		bool DefaultPrinter;
		QString RemoteMachine,RemoteQueue;
		netType NetworkType;

		QList<KpcSpool> SpoolLst;
};

#endif












