/***************************************************************************
                          configeditdialog.cpp  -  description
                             -------------------
    begin                : Sat May 15 13:31:44 MEST 1999

    copyright            : (C) 1999 by Andreas Heck
    email                : aheck@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "configeditdialog.h"

ConfigEditDialog::ConfigEditDialog( QWidget *parent, const char *name, bool addMode )
  : QDialog( parent, name, TRUE )
{
  group = new QGroupBox(this);
  group->setGeometry(5, 5, 355, 210);

  okButton = new QPushButton(i18n("OK"), this);
  okButton->setGeometry(50,225, 100, 25);
  connect( okButton, SIGNAL(clicked()), SLOT(accept()) );

  cancelButton = new QPushButton(i18n("Cancel"), this);
  cancelButton->setGeometry(215, 225, 100, 25);
  connect( cancelButton, SIGNAL(clicked()), SLOT(reject()) );

  nameLabel = new QLabel(i18n("Configuration name:"), group);
  nameLabel->move(10, 20);
  nameLabel->setAutoResize(true);

  nameEdit = new QLineEdit(group);
  nameEdit->setGeometry(180, 10, 165, 25);

  osLabel = new QLabel(i18n("Operating system:"), group);
  osLabel->move(10, 60);
  osLabel->setAutoResize(true);

  osComboBox = new QComboBox(false, group);
  osComboBox->setGeometry(180, 50, 165, 25);
  osComboBox->insertItem(i18n("Linux"));
  osComboBox->insertItem(i18n("Other os"));
  connect(osComboBox, SIGNAL(activated(int)), this, SLOT(osChange()) );

  partitionLabel = new QLabel(i18n("(Root-) Partition to boot:"), group);
  partitionLabel->move(10, 100);
  partitionLabel->setAutoResize(true);

  partitionEdit = new QLineEdit(group);
  partitionEdit->setGeometry(180, 90, 165, 25);

  kernelLabel = new QLabel(i18n("Kernel to boot:"), group);
  kernelLabel->move(10, 140);
  kernelLabel->setAutoResize(true);

  kernelEdit = new QLineEdit(group);
  kernelEdit->setGeometry(180, 130, 135, 25);
  connect(kernelEdit, SIGNAL(textChanged(const char *)), this, SLOT(kernelChanged(const char *)));

  kernelButton = new QPushButton(group);
  kernelButton->setGeometry(320, 130, 25, 25);
  connect(kernelButton, SIGNAL(clicked()), this, SLOT(changeKernel()));
  QToolTip::add(kernelButton, i18n("Browse for a kernel"));

  KIconLoader icon;
  kernelButton->setPixmap(icon.loadIcon("fileopen.xpm"));

  appendLabel = new QLabel(group);
  appendLabel->setGeometry(10,180,10,25);
  appendLabel->setAutoResize(true);
  appendLabel->setText(i18n("Append:"));

  appendEdit = new QLineEdit(group);
  appendEdit->setGeometry(180,170,165,25);

  setFixedSize(365, 260);

  if (addMode == true)
    caption = i18n("Add: ");
  else
    caption = i18n("Edit: ");

  nameChanged(nameEdit->text());
  connect(nameEdit, SIGNAL(textChanged(const char*)), this, SLOT(nameChanged(const char*)));
}

void ConfigEditDialog::setConfig( OSProperties *osEntry )
{
 nameEdit->setText(osEntry->label);
 if (!osEntry->isLinux)
   osComboBox->setCurrentItem(1);
 partitionEdit->setText(osEntry->positionOnDisk);
 kernelEdit->setText(osEntry->kernel);
 appendEdit->setText(osEntry->append);

 osChange();
}

void ConfigEditDialog::osChange()
{
  bool enabled = !osComboBox->currentItem();
  kernelLabel->setEnabled(enabled);
  kernelEdit->setEnabled(enabled);
  kernelButton->setEnabled(enabled);
  appendLabel->setEnabled(enabled);
  appendEdit->setEnabled(enabled);
}

QString ConfigEditDialog::getLabel()
{
 QString value = nameEdit->text();
 return value;
}

bool ConfigEditDialog::isLinux()
{
 if (osComboBox->currentItem() == 0)
   return true;
 else
   return false;
}

QString ConfigEditDialog::getPartition()
{
 QString value = partitionEdit->text();
 return value;
}

QString ConfigEditDialog::getKernel()
{
 QString value = "";
 if (isLinux())
   value = kernelEdit->text();
 return value;
}

QString ConfigEditDialog::getAppend()
{
 QString value = "";
 if (isLinux())
   value = appendEdit->text();
 return value;
}

void ConfigEditDialog::nameChanged(const char *text)
{
 QString tmp;

 tmp.sprintf("%s%s", caption.data(), text);
 setCaption(tmp);
}

void ConfigEditDialog::changeKernel()
{
 QString kernel = KFileDialog::getOpenFileName("/boot/", "*");
 if (kernel)
   kernelEdit->setText(kernel);
}

void ConfigEditDialog::kernelChanged(const char *text)
{
 QString tip = text;
 tip = tip.stripWhiteSpace();
 if (tip != "")
   {
    QToolTip::remove(kernelEdit);
    QToolTip::add(kernelEdit, text);
   }
 else
   QToolTip::remove(kernelEdit);
}
