/************************************************************************
 * kcreateinst - part of kinst package - scriptbuild.cpp                *
 * Copyright (C) 2000  Steffen Sobiech                                  *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to the Free Software          *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 ************************************************************************/

#include "scriptbuild.h"
#include "stringfunc.h"
#include "tparams.h"
#include "locale.h"

#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>
#include <qdialog.h>
#include <qmessagebox.h>
#include <drag.h>

#ifndef MIN_WIDTH
#define MIN_WIDTH 550
#endif

#ifndef MIN_HEIGHT
#define MIN_HEIGHT 400
#endif

#ifndef EOL
#define EOL 10
#endif

// MOC
#include "scriptbuild.moc"

kcreateinstScriptBuild::kcreateinstScriptBuild(QWidget *parent,
					       const char *name)
  : QDialog(parent, name, true)
{
  // General properties
  setCaption(_i18n("kcreateinst - Script Builder"));
  resize(MIN_WIDTH, MIN_HEIGHT);
  setMinimumWidth(MIN_WIDTH);
  setMinimumHeight(MIN_HEIGHT);

  // Create params
  actparams = new tParams;

  // Create scriptfilename_label
  scriptfilename_label = new QLabel(this);
  scriptfilename_label->setText(_i18n("Script's filename"));
  scriptfilename_label->show();

  // Create scriptfilename_edit
  scriptfilename_edit = new QLineEdit(this);
  scriptfilename_edit->setText("");
  scriptfilename_edit->show();
  connect(scriptfilename_edit, SIGNAL(textChanged(const char*)),
	  SLOT(scriptfilename_changed()));

  // Create scriptfilename_button
  scriptfilename_button = new QPushButton(this);
  scriptfilename_button->setText(_i18n("Browse"));
  scriptfilename_button->show();
  connect(scriptfilename_button, SIGNAL(clicked()), SLOT(filenamebrowse()));

  // Create typeselect_group with members
  typeselect_group = new QButtonGroup(_i18n("Choose script function"), this);
  docinst_radio = new QRadioButton(typeselect_group);
  docinst_radio->setText(_i18n("Docs"));
  docinst_radio->setChecked(true);
  connect(docinst_radio, SIGNAL(toggled(bool)), SLOT(typeselect_changed()));
  localedirinst_radio = new QRadioButton(typeselect_group);
  localedirinst_radio->setText(_i18n("Locale"));
  connect(localedirinst_radio, SIGNAL(toggled(bool)),
	  SLOT(typeselect_changed()));
  datadirinst_radio = new QRadioButton(typeselect_group);
  datadirinst_radio->setText(_i18n("Data dir"));
  connect(datadirinst_radio, SIGNAL(toggled(bool)),
	  SLOT(typeselect_changed()));
  MIMEinst_radio = new QRadioButton(typeselect_group);
  MIMEinst_radio->setText(_i18n("MIME-Types"));
  connect(MIMEinst_radio, SIGNAL(toggled(bool)), SLOT(typeselect_changed()));
  deletedir_radio = new QRadioButton(typeselect_group);
  deletedir_radio->setText(_i18n("Delete dir"));
  connect(deletedir_radio, SIGNAL(toggled(bool)), SLOT(typeselect_changed()));
  typeselect_group->show();

  // Create options_frame
  options_frame = new QFrame(this);
  options_frame->setFrameStyle(QFrame::Box|QFrame::Sunken);
  options_frame->show();

  // Create description_label
  description_label = new QLabel(this);
  description_label->setText("");
  description_label->setAlignment(AlignLeft | AlignTop | WordBreak);
  description_label->hide();

  // Create var1_label
  var1_label = new QLabel(this);
  var1_label->setText("");
  var1_label->hide();

  // Create var1_edit
  var1_edit = new QLineEdit(this);
  var1_edit->setText("");
  var1_edit->hide();

  // Create var1_button
  var1_button = new QPushButton(this);
  var1_button->setText(_i18n("Browse"));
  var1_button->hide();
  connect(var1_button, SIGNAL(clicked()), SLOT(Browse1Pressed()));

  // Create var2_label
  var2_label = new QLabel(this);
  var2_label->setText("");
  var2_label->hide();

  // Create var2_edit
  var2_edit = new QLineEdit(this);
  var2_edit->setText("");
  var2_edit->hide();

  // Create var2_button
  var2_button = new QPushButton(this);
  var2_button->setText(_i18n("Browse"));
  var2_button->hide();
  connect(var2_button, SIGNAL(clicked()), SLOT(Browse2Pressed()));

  // Create var3_label
  var3_label = new QLabel(this);
  var3_label->setText("");
  var3_label->hide();

  // Create var3_edit
  var3_edit = new QLineEdit(this);
  var3_edit->setText("");
  var3_edit->hide();

  // Create var3_button
  var3_button = new QPushButton(this);
  var3_button->setText(_i18n("Browse"));
  var3_button->hide();
  connect(var3_button, SIGNAL(clicked()), SLOT(Browse3Pressed()));

  // Create var4_label
  var4_label = new QLabel(this);
  var4_label->setText("");
  var4_label->hide();

  // Create var4_edit
  var4_edit = new QLineEdit(this);
  var4_edit->setText("");
  var4_edit->hide();

  // Create var4_button
  var4_button = new QPushButton(this);
  var4_button->setText(_i18n("Browse"));
  var4_button->hide();
  connect(var4_button, SIGNAL(clicked()), SLOT(Browse4Pressed()));

  // Create add_button
  add_button = new QPushButton(this);
  add_button->setText(_i18n("Add to script"));
  add_button->setEnabled(false);
  add_button->show();
  connect(add_button, SIGNAL(clicked()), SLOT(AddPressed()));

  // Create script2arch_button
  script2arch_button = new QPushButton(this);
  script2arch_button->setText(_i18n("Add script to archive"));
  script2arch_button->setEnabled(false);
  script2arch_button->show();
  connect(script2arch_button, SIGNAL(clicked()), SLOT(Add2ArchPressed()));

  // Create help_button
  help_button = new QPushButton(this);
  help_button->setText(_i18n("Help"));
  help_button->show();
  connect(help_button, SIGNAL(clicked()), SLOT(help_pressed()));

  // Create cancel_button
  // cancel_button = new QPushButton(this);
  // cancel_button->setText(_i18n("Cancel"));
  // cancel_button->show();
  // connect(cancel_button, SIGNAL(clicked()), SLOT(cancel_pressed()));

  // Create OK button
  ok_button = new QPushButton(this);
  ok_button->setText(_i18n("OK"));
  ok_button->show();
  connect(ok_button, SIGNAL(clicked()), SLOT(ok_pressed()));

  // Create File Selection Dialog
  FileSelector = new KFileDialog(getenv("HOME"), "*", this, "FileSelector",
                                 false, false);
  FileSelector->hide();

  // Create TGZViewer
  TGZViewer = new tTGZViewDlg(this, "TGZView");
  TGZViewer->hide();

  typeselect_changed();
}

void kcreateinstScriptBuild::resizeEvent(QResizeEvent*)
{
  // Resize scriptfilename_label
  scriptfilename_label->setGeometry(10,
				    10,
				    width()-20,
				    15);

  // Resize scriptfilename_edit
  scriptfilename_edit->setGeometry(10,
				   27,
				   width()-85,
				   20);

  // Resize scriptfilename_button
  scriptfilename_button->setGeometry(scriptfilename_edit->x()+
				     scriptfilename_edit->width()+5,
				     scriptfilename_edit->y()-2,
				     width()-scriptfilename_edit->x()-
				     scriptfilename_edit->width()-15,
				     scriptfilename_edit->height()+4);

  // Resize typeselect_group and members
  typeselect_group->setGeometry(10,
				scriptfilename_edit->y()+
				scriptfilename_edit->height()+5,
				width()-20,
				45);

  docinst_radio->setGeometry(5,
			     20,
			     (typeselect_group->width()-20)/5,
			     15);

  localedirinst_radio->setGeometry(docinst_radio->x()+
				   docinst_radio->width()+5,
				   20,
				   (typeselect_group->width()-30)/5,
				   15);
   
  datadirinst_radio->setGeometry(localedirinst_radio->x()+
				 localedirinst_radio->width()+5,
				 20,
				 (typeselect_group->width()-30)/5,
				 15);

  MIMEinst_radio->setGeometry(datadirinst_radio->x()+
			      datadirinst_radio->width()+5,
			      20,
			      (typeselect_group->width()-30)/5,
			      15);

  deletedir_radio->setGeometry(MIMEinst_radio->x()+MIMEinst_radio->width()+5,
			       20,
			       (typeselect_group->width()-30)/5,
			       15);

  // Resize options_frame
  options_frame->setGeometry(10,
			     typeselect_group->y()+
			     typeselect_group->height()+5,
			     width()-20,
			     height()-45-
			     typeselect_group->y()-
			     typeselect_group->height());

  // Resize description_label
  description_label->setGeometry(options_frame->x()+10,
				 options_frame->y()+10,
				 options_frame->width()-20,
				 30);

  // Resize var1_label
  var1_label->setGeometry(options_frame->x()+10,
			  description_label->y()+
			  description_label->height()+5,
			  options_frame->width()-20,
			  15);

  // Resize var1_edit
  var1_edit->setGeometry(options_frame->x()+10,
			 var1_label->y()+var1_label->height()+2,
			 options_frame->width()-85,
			 20);

  // Resize var1_button
  var1_button->setGeometry(var1_edit->x()+
			   var1_edit->width()+5,
			   var1_edit->y()-2,
			   options_frame->width()-var1_edit->x()-
			   var1_edit->width()-5,
			   var1_edit->height()+4);

  // Resize var2_label
  var2_label->setGeometry(options_frame->x()+10,
			  var1_edit->y()+
			  var1_edit->height()+10,
			  options_frame->width()-20,
			  15);

  // Resize var2_edit
  var2_edit->setGeometry(options_frame->x()+10,
			 var2_label->y()+var2_label->height()+2,
			 options_frame->width()-85,
			 20);

  // Resize var2_button
  var2_button->setGeometry(var2_edit->x()+
			   var2_edit->width()+5,
			   var2_edit->y()-2,
			   options_frame->width()-var2_edit->x()-
			   var2_edit->width()-5,
			   var2_edit->height()+4);

  // Resize var3_label
  var3_label->setGeometry(options_frame->x()+10,
			  var2_edit->y()+
			  var2_edit->height()+10,
			  options_frame->width()-20,
			  15);

  // Resize var3_edit
  var3_edit->setGeometry(options_frame->x()+10,
			 var3_label->y()+var3_label->height()+2,
			 options_frame->width()-85,
			 20);

  // Resize var3_button
  var3_button->setGeometry(var3_edit->x()+
			   var3_edit->width()+5,
			   var3_edit->y()-2,
			   options_frame->width()-var3_edit->x()-
			   var3_edit->width()-5,
			   var3_edit->height()+4);

  // Resize var4_label
  var4_label->setGeometry(options_frame->x()+10,
			  var3_edit->y()+
			  var3_edit->height()+10,
			  options_frame->width()-20,
			  15);

  // Resize var4_edit
  var4_edit->setGeometry(options_frame->x()+10,
			 var4_label->y()+var4_label->height()+2,
			 options_frame->width()-85,
			 20);

  // Resize var4_button
  var4_button->setGeometry(var4_edit->x()+
			   var4_edit->width()+5,
			   var4_edit->y()-2,
			   options_frame->width()-var4_edit->x()-
			   var4_edit->width()-5,
			   var4_edit->height()+4);

  // Resize add_button
  add_button->setGeometry(options_frame->x()+
			  (options_frame->width())/3-80,
			  options_frame->y()+
			  options_frame->height()-
			  35,
			  160,
			  30);

  // Resize script2arch_button
  script2arch_button->setGeometry(options_frame->x()+
				  (options_frame->width()*2)/3-80,
				  options_frame->y()+
				  options_frame->height()-
				  35,
				  160,
				  30);

  // Resize help_button
  help_button->setGeometry(width()-100,
			   height()-35,
			   90,
			   30);

  // Resize cancel_button
  // cancel_button->setGeometry((width()/2)-45,
  //		     height()-35,
  //		     90,
  //		     30);

  // Resize OK button
  ok_button->setGeometry(10,
			 height()-35,
			 90,
			 30);
}

void kcreateinstScriptBuild::setParams(tParams* params)
{
  strcpy(actparams->KIFOptions.ProgramName,
	 params->KIFOptions.ProgramName);
  strcpy(actparams->KIFOptions.SourceFile,
	 params->KIFOptions.SourceFile);
  strcpy(actparams->KIFOptions.SourceFileType,
	 params->KIFOptions.SourceFileType);
  actparams->scriptpath = params->scriptpath;

  typeselect_changed();
}

void kcreateinstScriptBuild::Browse1Pressed()
{
  QString String;
  String = TGZViewer->getFilePath(actparams->KIFOptions.SourceFile);

  if(qstrlen(String) > 0)
    {
      var1_edit->setText(String);
    }

  TGZViewer->hide();
}

void kcreateinstScriptBuild::Browse2Pressed()
{
  QString String;
  String = TGZViewer->getFilePath(actparams->KIFOptions.SourceFile);

  if(qstrlen(String) > 0)
    {
      var2_edit->setText(String);
    }

  TGZViewer->hide();
}

void kcreateinstScriptBuild::Browse3Pressed()
{
  QString String;
  String = TGZViewer->getFilePath(actparams->KIFOptions.SourceFile);

  if(qstrlen(String) > 0)
    {
      var3_edit->setText(String);
    }

  TGZViewer->hide();
}

void kcreateinstScriptBuild::Browse4Pressed()
{
  QString String;
  String = TGZViewer->getFilePath(actparams->KIFOptions.SourceFile);

  if(qstrlen(String) > 0)
    {
      var4_edit->setText(String);
    }

  TGZViewer->hide();
}

void kcreateinstScriptBuild::filenamebrowse()
{
  QString String;
  String = FileSelector->getOpenFileName(getenv("HOME"),
  					 "*", this,
  					 "filenamebrowse");

  if(qstrlen(String) > 0)
    {
      qstrncpy(scriptfilename, String, FILENAME_MAX);
      scriptfilename_edit->setText(String);
    }

  FileSelector->hide();
}

void kcreateinstScriptBuild::typeselect_changed()
{
  description_label->hide();
  var1_label->hide();
  var1_edit->hide();
  var1_button->hide();
  var2_label->hide();
  var2_edit->hide();
  var2_button->hide();
  var3_label->hide();
  var3_edit->hide();
  var3_button->hide();
  var4_label->hide();
  var4_edit->hide();
  var4_button->hide();

  if(docinst_radio->isChecked())
    {
      description_label->setText(_i18n("This script module will install the help files/directories in the specified directory. Refer to this dialog's help section."));
      description_label->show();
      var1_label->setText(_i18n("Documentation directory in your package"));
      var1_label->show();
      var1_edit->setText("");
      var1_edit->show();
      var1_button->show();

      var2_label->setText(_i18n("Application's KDE name"));
      var2_label->show();
      var2_edit->setText(actparams->KIFOptions.ProgramName);
      var2_edit->show();
    }

  if(localedirinst_radio->isChecked())
    {
      description_label->setText(_i18n("This script module will install the application's locale (gmo) files. Refer to this dialog's help section."));
      description_label->show();
      var1_label->setText(_i18n("Locale directory in your package"));
      var1_label->show();
      var1_edit->setText("");
      var1_edit->show();
      var1_button->show();

      var2_label->setText(_i18n("Application's KDE name"));
      var2_label->show();
      var2_edit->setText(actparams->KIFOptions.ProgramName);
      var2_edit->show();
    }

  if(datadirinst_radio->isChecked())
    {
      description_label->setText(_i18n("This script module will install your application's datadir to the appropriate KDE applications datadir pool (see help)."));
      description_label->show();
      var1_label->setText(_i18n("Data directory in your package"));
      var1_label->show();
      var1_edit->setText("");
      var1_edit->show();
      var1_button->show();

      var2_label->setText(_i18n("Application's KDE name"));
      var2_label->show();
      var2_edit->setText(actparams->KIFOptions.ProgramName);
      var2_edit->show();
    }

  if(MIMEinst_radio->isChecked())
    {
      description_label->setText(_i18n("This script module will install the KDE MIME link files in the specified directory to the specified KDE MIME group."));
      description_label->show();
      var1_label->setText(_i18n("MIME directory in your package"));
      var1_label->show();
      var1_edit->setText("");
      var1_edit->show();
      var1_button->show();

      var2_label->setText(_i18n("Application's KDE name"));
      var2_label->show();
      var2_edit->setText(actparams->KIFOptions.ProgramName);
      var2_edit->show();

      var3_label->setText(_i18n("MIME group"));
      var3_label->show();
      var3_edit->setText("");
      var3_edit->show();
    }

  if(deletedir_radio->isChecked())
    {
      description_label->setText(_i18n("This script module will delete the specified directory."));
      description_label->show();
      var1_label->setText(_i18n("Directory in your package"));
      var1_label->show();
      var1_edit->setText("");
      var1_edit->show();
      var1_button->show();
    }
}

void kcreateinstScriptBuild::AddPressed()
{
  FILE* f;
  char filename[FILENAME_MAX];
  char s[65535];
  int err;

  f = NULL;

  qstrncpy(filename, scriptfilename_edit->text(), FILENAME_MAX);

  f = fopen(filename, "a");
  if(f == NULL)
    {
      QMessageBox::warning(this,
			   _i18n("kcreateinst - Script Builder"),
                           _i18n("Error while adding to script\n"));
      return;
    }

  chmod(filename, S_IXUSR || S_IRUSR || S_IWUSR);

  if(fputs("#! /bin/sh", f) <= 0)
    {
      if(f != NULL) fclose(f);
      QMessageBox::warning(this,
			   _i18n("kcreateinst - Script Builder"),
			   _i18n("Error while adding to script\n"));
      return;
    }

  if(fputc(EOL, f) != EOL)
    {
      if(f != NULL) fclose(f);
      QMessageBox::warning(this,
			   _i18n("kcreateinst - Script Builder"),
			   _i18n("Error while adding to script\n"));
      return;
    }

  // Add var1

  qstrncpy(s, var1_edit->text(), 65535);

  if(docinst_radio->isChecked())
    {
      if(fputs("DOC_DIR=", f) <= 0)
	{
	  if(f != NULL) fclose(f);
	  QMessageBox::warning(this,
			       _i18n("kcreateinst - Script Builder"),
			       _i18n("Error while adding to script\n"));
	  return;
	}
      if(fputs(s, f) <= 0)
	{
	  if(f != NULL) fclose(f);
	  QMessageBox::warning(this,
			       _i18n("kcreateinst - Script Builder"),
			       _i18n("Error while adding to script\n"));
	  return;
	}
      if(fputc(EOL, f) != EOL)
	{
	  if(f != NULL) fclose(f);
	  QMessageBox::warning(this,
			       _i18n("kcreateinst - Script Builder"),
			       _i18n("Error while adding to script\n"));
	  return;
	}
    }

  if(localedirinst_radio->isChecked())
    {
      if(fputs("PO_DIR=", f) <= 0)
	{
	  if(f != NULL) fclose(f);
	  QMessageBox::warning(this,
			       _i18n("kcreateinst - Script Builder"),
			       _i18n("Error while adding to script\n"));
	  return;
	}
      if(fputs(s, f) <= 0)
	{
	  if(f != NULL) fclose(f);
	  QMessageBox::warning(this,
			       _i18n("kcreateinst - Script Builder"),
			       _i18n("Error while adding to script\n"));
	  return;
	}
      if(fputc(EOL, f) != EOL)
	{
	  if(f != NULL) fclose(f);
	  QMessageBox::warning(this,
			       _i18n("kcreateinst - Script Builder"),
			       _i18n("Error while adding to script\n"));
	  return;
	}
    }

  if(datadirinst_radio->isChecked())
    {
      if(fputs("DATA_DIR=", f) <= 0)
	{
	  if(f != NULL) fclose(f);
	  QMessageBox::warning(this,
			       _i18n("kcreateinst - Script Builder"),
			       _i18n("Error while adding to script\n"));
	  return;
	}
      if(fputs(s, f) <= 0)
	{
	  if(f != NULL) fclose(f);
	  QMessageBox::warning(this,
			       _i18n("kcreateinst - Script Builder"),
			       _i18n("Error while adding to script\n"));
	  return;
	}
      if(fputc(EOL, f) != EOL)
	{
	  if(f != NULL) fclose(f);
	  QMessageBox::warning(this,
			       _i18n("kcreateinst - Script Builder"),
			       _i18n("Error while adding to script\n"));
	  return;
	}
    }

  if(MIMEinst_radio->isChecked())
    {
      if(fputs("MIME_DIR=", f) <= 0)
	{
	  if(f != NULL) fclose(f);
	  QMessageBox::warning(this,
			       _i18n("kcreateinst - Script Builder"),
			       _i18n("Error while adding to script\n"));
	  return;
	}
      if(fputs(s, f) <= 0)
	{
	  if(f != NULL) fclose(f);
	  QMessageBox::warning(this,
			       _i18n("kcreateinst - Script Builder"),
			       _i18n("Error while adding to script\n"));
	  return;
	}
      if(fputc(EOL, f) != EOL)
	{
	  if(f != NULL) fclose(f);
	  QMessageBox::warning(this,
			       _i18n("kcreateinst - Script Builder"),
			       _i18n("Error while adding to script\n"));
	  return;
	}
    }

  if(deletedir_radio->isChecked())
    {
      if(fputs("DIR=", f) <= 0)
	{
	  if(f != NULL) fclose(f);
	  QMessageBox::warning(this,
			       _i18n("kcreateinst - Script Builder"),
			       _i18n("Error while adding to script\n"));
	  return;
	}
      if(fputs(s, f) <= 0)
	{
	  if(f != NULL) fclose(f);
	  QMessageBox::warning(this,
			       _i18n("kcreateinst - Script Builder"),
			       _i18n("Error while adding to script\n"));
	  return;
	}
      if(fputc(EOL, f) != EOL)
	{
	  if(f != NULL) fclose(f);
	  QMessageBox::warning(this,
			       _i18n("kcreateinst - Script Builder"),
			       _i18n("Error while adding to script\n"));
	  return;
	}
    }

  // Add var2

  qstrncpy(s, var2_edit->text(), 65535);

  if(docinst_radio->isChecked())
    {
      if(fputs("APPNAME=", f) <= 0)
	{
	  if(f != NULL) fclose(f);
	  QMessageBox::warning(this,
			       _i18n("kcreateinst - Script Builder"),
			       _i18n("Error while adding to script\n"));
	  return;
	}
      if(fputs(s, f) <= 0)
	{
	  if(f != NULL) fclose(f);
	  QMessageBox::warning(this,
			       _i18n("kcreateinst - Script Builder"),
			       _i18n("Error while adding to script\n"));
	  return;
	}
      if(fputc(EOL, f) != EOL)
	{
	  if(f != NULL) fclose(f);
	  QMessageBox::warning(this,
			       _i18n("kcreateinst - Script Builder"),
			       _i18n("Error while adding to script\n"));
	  return;
	}
    }

  if(localedirinst_radio->isChecked())
    {
      if(fputs("APPNAME=", f) <= 0)
	{
	  if(f != NULL) fclose(f);
	  QMessageBox::warning(this,
			       _i18n("kcreateinst - Script Builder"),
			       _i18n("Error while adding to script\n"));
	  return;
	}
      if(fputs(s, f) <= 0)
	{
	  if(f != NULL) fclose(f);
	  QMessageBox::warning(this,
			       _i18n("kcreateinst - Script Builder"),
			       _i18n("Error while adding to script\n"));
	  return;
	}
      if(fputc(EOL, f) != EOL)
	{
	  if(f != NULL) fclose(f);
	  QMessageBox::warning(this,
			       _i18n("kcreateinst - Script Builder"),
			       _i18n("Error while adding to script\n"));
	  return;
	}
    }

  if(datadirinst_radio->isChecked())
    {
      if(fputs("APPNAME=", f) <= 0)
	{
	  if(f != NULL) fclose(f);
	  QMessageBox::warning(this,
			       _i18n("kcreateinst - Script Builder"),
			       _i18n("Error while adding to script\n"));
	  return;
	}
      if(fputs(s, f) <= 0)
	{
	  if(f != NULL) fclose(f);
	  QMessageBox::warning(this,
			       _i18n("kcreateinst - Script Builder"),
			       _i18n("Error while adding to script\n"));
	  return;
	}
      if(fputc(EOL, f) != EOL)
	{
	  if(f != NULL) fclose(f);
	  QMessageBox::warning(this,
			       _i18n("kcreateinst - Script Builder"),
			       _i18n("Error while adding to script\n"));
	  return;
	}
    }

  if(MIMEinst_radio->isChecked())
    {
      if(fputs("APPNAME=", f) <= 0)
	{
	  if(f != NULL) fclose(f);
	  QMessageBox::warning(this,
			       _i18n("kcreateinst - Script Builder"),
			       _i18n("Error while adding to script\n"));
	  return;
	}
      if(fputs(s, f) <= 0)
	{
	  if(f != NULL) fclose(f);
	  QMessageBox::warning(this,
			       _i18n("kcreateinst - Script Builder"),
			       _i18n("Error while adding to script\n"));
	  return;
	}
      if(fputc(EOL, f) != EOL)
	{
	  if(f != NULL) fclose(f);
	  QMessageBox::warning(this,
			       _i18n("kcreateinst - Script Builder"),
			       _i18n("Error while adding to script\n"));
	  return;
	}
    }

  // Add var3

  qstrncpy(s, var3_edit->text(), 65535);

  if(MIMEinst_radio->isChecked())
    {
      if(fputs("MIMEGROUP=", f) <= 0)
	{
	  if(f != NULL) fclose(f);
	  QMessageBox::warning(this,
			       _i18n("kcreateinst - Script Builder"),
			       _i18n("Error while adding to script\n"));
	  return;
	}
      if(fputs(s, f) <= 0)
	{
	  if(f != NULL) fclose(f);
	  QMessageBox::warning(this,
			       _i18n("kcreateinst - Script Builder"),
			       _i18n("Error while adding to script\n"));
	  return;
	}
      if(fputc(EOL, f) != EOL)
	{
	  if(f != NULL) fclose(f);
	  QMessageBox::warning(this,
			       _i18n("kcreateinst - Script Builder"),
			       _i18n("Error while adding to script\n"));
	  return;
	}
    }

  if(f != NULL) fclose(f);

  // Add the templates

  strcpy(s, "cat \"");

  if(docinst_radio->isChecked())
    {
      strcat(s, actparams->scriptpath);
      strcat(s, "/template_docinst\" >> \"");
      strcat(s, filename);
      strcat(s, "\"");

      err = system(s);

      if((err == 127) || (err == -1))
	{
	  QMessageBox::warning(this,
			       _i18n("kcreateinst - Script Builder"),
			       _i18n("Error while adding to script\n"));
	  return;
	}
    }

  if(localedirinst_radio->isChecked())
    {
      strcat(s, actparams->scriptpath);
      strcat(s, "/template_localeinst\" >> \"");
      strcat(s, filename);
      strcat(s, "\"");

      err = system(s);

      if((err == 127) || (err == -1))
	{
	  QMessageBox::warning(this,
			       _i18n("kcreateinst - Script Builder"),
			       _i18n("Error while adding to script\n"));
	  return;
	}
    }

  if(datadirinst_radio->isChecked())
    {
      strcat(s, actparams->scriptpath);
      strcat(s, "/template_datadirinst\" >> \"");
      strcat(s, filename);
      strcat(s, "\"");

      err = system(s);

      if((err == 127) || (err == -1))
	{
	  QMessageBox::warning(this,
			       _i18n("kcreateinst - Script Builder"),
			       _i18n("Error while adding to script\n"));
	  return;
	}
    }

  if(MIMEinst_radio->isChecked())
    {
      strcat(s, actparams->scriptpath);
      strcat(s, "/template_mimeinst\" >> \"");
      strcat(s, filename);
      strcat(s, "\"");

      err = system(s);

      if((err == 127) || (err == -1))
	{
	  QMessageBox::warning(this,
			       _i18n("kcreateinst - Script Builder"),
			       _i18n("Error while adding to script\n"));
	  return;
	}
    }

  if(deletedir_radio->isChecked())
    {
      strcat(s, actparams->scriptpath);
      strcat(s, "/template_deletedir\" >> \"");
      strcat(s, filename);
      strcat(s, "\"");

      err = system(s);

      if((err == 127) || (err == -1))
	{
	  QMessageBox::warning(this,
			       _i18n("kcreateinst - Script Builder"),
			       _i18n("Error while adding to script\n"));
	  return;
	}
    }

  QMessageBox::information(this,
			   _i18n("kcreateinst - Script Builder"),
			   _i18n("Added succesfully.\n"));
}

void kcreateinstScriptBuild::Add2ArchPressed()
{
  char InvokeCommand[1024];
  char install_to[FILENAME_MAX];
  char origdir[FILENAME_MAX];
  int err;

  if((strlen(actparams->KIFOptions.SourceFile) == 0) ||
     (actparams->KIFOptions.SourceFile[strlen(actparams->KIFOptions.SourceFile) - 1] != 'z') ||
     (actparams->KIFOptions.SourceFile[strlen(actparams->KIFOptions.SourceFile) - 2] != 'g'))
    {
#ifdef _DEBUG_
      printf("scriptbuild:  No valid package to add to present\n");
#endif
      return;
    }

  tmpnam(install_to);

  // Extract TGZ to temporary directory

#ifdef _DEBUG_
  printf("scriptbuild:  Extracting package %s ...\n",
	 actparams->KIFOptions.SourceFile);
#endif

  strncpy(InvokeCommand, "tar xfz \"", 1024);
  _strncat(InvokeCommand, actparams->KIFOptions.SourceFile, 1024);
  _strncat(InvokeCommand, "\"", 1024);

#ifdef _DEBUG_
  printf("scriptbuild:  Extraction command: %s\n", InvokeCommand);
#endif

#ifdef _DEBUG_
  printf("scriptbuild:  Changing to directory %s\n", install_to);
#endif

  getcwd(origdir, FILENAME_MAX);

  if(!(mkdir(install_to, 0755) == 0))
    {
      fprintf(stderr, _i18n("Warning: Unable to create directory %s\n"), install_to);
    }
  if(!(chdir(install_to) == 0))
    {
      fprintf(stderr, _i18n("Error changing to directory %s\n"), install_to);
      QMessageBox::warning(this, _i18n("kcreateinst - Script Builder"),
			   _i18n("Error while extracting your source package"));
      return;
    }

  err = system(InvokeCommand);

  if(err == 127)
    {
      fprintf(stderr, _i18n("scriptbuild:  Error invoking shell.\n"));
      QMessageBox::warning(this, _i18n("kcreateinst - Script Builder"),
			   _i18n("Error while adding script to package:\nError invoking shell.\n"));
      return;
    }
  if(err == -1)
    {
      fprintf(stderr, _i18n("scriptbuild:  General failure while utilizing tar.\n"));
      QMessageBox::warning(this, _i18n("kcreateinst - Script Builder"),
			   _i18n("Error while adding script to package:\nGeneral failure while utilizing tar.\n"));
      return;
    }

  // Add script to directory

#ifdef _DEBUG_
  printf("scriptbuild:  Adding script to package ...\n");
#endif

  strncpy(InvokeCommand, "cp -f \"", 1024);
  _strncat(InvokeCommand, scriptfilename, 1024);
  _strncat(InvokeCommand, "\" \"", 1024);
  _strncat(InvokeCommand, install_to, 1024);
  _strncat(InvokeCommand, "\"", 1024);

#ifdef _DEBUG_
  printf("scriptbuild:  Copy command: %s\n", InvokeCommand);
#endif

  err = system(InvokeCommand);

  if(err == 127)
    {
      fprintf(stderr, _i18n("scriptbuild:  Error invoking shell.\n"));
      QMessageBox::warning(this, _i18n("kcreateinst - Script Builder"),
			   _i18n("Error while adding script to package:\nError invoking shell.\n"));
      return;
    }
  if(err == -1)
    {
      fprintf(stderr, _i18n("scriptbuild:  General failure while utilizing tar.\n"));
      QMessageBox::warning(this, _i18n("kcreateinst - Script Builder"),
			   _i18n("Error while adding script to package:\nGeneral failure while utilizing cp.\n"));
      return;
    }

  // Compress directory to original TGZ location

#ifdef _DEBUG_
  printf("scriptbuild:  Recompressing archive %s ...\n",
	 actparams->KIFOptions.SourceFile);
#endif

  strncpy(InvokeCommand, "tar cfz \"", 1024);
  _strncat(InvokeCommand, actparams->KIFOptions.SourceFile, 1024);
  _strncat(InvokeCommand, "\" .", 1024);

#ifdef _DEBUG_
  printf("scriptbuild:  Compress command: %s\n", InvokeCommand);
#endif

  err = system(InvokeCommand);

  if(err == 127)
    {
      fprintf(stderr, _i18n("scriptbuild:  Error invoking shell.\n"));
      QMessageBox::warning(this, _i18n("kcreateinst - Script Builder"),
			   _i18n("Error while adding script to package:\nError invoking shell.\n"));
      return;
    }
  if(err == -1)
    {
      fprintf(stderr, _i18n("scriptbuild:  General failure while utilizing tar.\n"));
      QMessageBox::warning(this, _i18n("kcreateinst - Script Builder"),
			   _i18n("Error while adding script to package:\nGeneral failure while utilizing tar.\n"));
      return;
    }

#ifdef _DEBUG_
  printf("scriptbuild:  Changing to directory %s\n", origdir);
#endif

  if(!(chdir(origdir) == 0))
    fprintf(stderr, _i18n("Error (non fatal) changing to directory %s\n"),
	    origdir);

  // Delete temporary directory

#ifdef _DEBUG_
  printf("scriptbuild:  Deleting temporary files ...\n");
#endif

  strncpy(InvokeCommand, "rm -f -r \"", 1024);
  _strncat(InvokeCommand, install_to, 1024);
  _strncat(InvokeCommand, "\"", 1024);

#ifdef _DEBUG_
  printf("scriptbuild:  Delete command: %s\n", InvokeCommand);
#endif

  err = system(InvokeCommand);

  if(err == 127)
    {
      fprintf(stderr, _i18n("scriptbuild:  Error invoking shell.\n"));
      QMessageBox::warning(this, _i18n("kcreateinst - Script Builder"),
			   _i18n("Error while adding script to package:\nError invoking shell.\n"));
      return;
    }
  if(err == -1)
    {
      fprintf(stderr, _i18n("scriptbuild:  General failure while utilizing tar.\n"));
      QMessageBox::warning(this, _i18n("kcreateinst - Script Builder"),
			   _i18n("Error while adding script to package:\nGeneral failure while utilizing rm.\n"));
      return;
    }

  // Success.

  QMessageBox::information(this, _i18n("kcreateinst - Script Builder"),
			   _i18n("Added succesfully.\nYou should now select this script in the main window."));
}

void kcreateinstScriptBuild::ok_pressed()
{
  hide();
}

void kcreateinstScriptBuild::cancel_pressed()
{
  hide();
}

void kcreateinstScriptBuild::help_pressed()
{
  if(docinst_radio->isChecked())
    kapp->invokeHTMLHelp("kcreateinst/scriptbuild.html", "docs");

  if(localedirinst_radio->isChecked())
    kapp->invokeHTMLHelp("kcreateinst/scriptbuild.html", "locale");

  if(datadirinst_radio->isChecked())
    kapp->invokeHTMLHelp("kcreateinst/scriptbuild.html", "datadir");

  if(MIMEinst_radio->isChecked())
    kapp->invokeHTMLHelp("kcreateinst/scriptbuild.html", "MIME");

  if(deletedir_radio->isChecked())
    kapp->invokeHTMLHelp("kcreateinst/scriptbuild.html", "deletedir");
}

void kcreateinstScriptBuild::scriptfilename_changed()
{
  if(qstrlen(scriptfilename_edit->text()) > 0)
    {
      add_button->setEnabled(true);
      script2arch_button->setEnabled(true);
      qstrncpy(scriptfilename, scriptfilename_edit->text(), FILENAME_MAX);
    }
  else
    {
      add_button->setEnabled(false);
      script2arch_button->setEnabled(false);
    }
}
