/***************************************************************************
                          khseccounter.h  -  description                              
                             -------------------                                         
    begin                : Thu Aug 19 1999                                           
    copyright            : (C) 1999 by Ruediger Anlauf                         
    email                : Ruediger.Anlauf@gmx.net                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef KHSECCOUNTER_H
#define KHSECCOUNTER_H

#include <qobject.h>

class QTimer;

/**
  *@author Ruediger Anlauf
  *@short a class counting seconds
	*/

class KHSecCounter : public QObject  {

Q_OBJECT

public:
	/** constructor */
	KHSecCounter( int secs );

	/** destructor */
	~KHSecCounter();
  /**  */
  void stop();
  /**  */
  void restart();
  /**  */
  bool isActive();
  /**  */
  void changeInterval( int value );

protected:
	/** how many seconds have been counted yet ? */
	static int secsCounted;

	/** how many seconds shall be counted in total ? */
	int secsToCount;

	/** timer, counting one second */
	QTimer *timer;

protected slots:
	/** counts one second further */
	void iterateSecs();

signals:
	/** emitted, when the secs from constructor have passed */
	void timeout();

	/** emitted each second
		* @param int value, reporting how many seconds are left
		*/
	void secsLeft( int );
};

#endif















