//Auto-generated by kalyptus. DO NOT EDIT.
namespace KTextEditor {
    using Kimono;
    using System;
    using Qyoto;
    /// <remarks>
    ///  \short An object representing a section of text, from one Cursor to another.
    ///  A Range is a basic class which represents a range of text with two Cursors,
    ///  from a start() position to an end() position.
    ///  For simplicity and convenience, ranges always maintain their start position to
    ///  be before or equal to their end position.  Attempting to set either the
    ///  start or end of the range beyond the respective end or start will result in
    ///  both values being set to the specified position.  In the constructor, the
    ///  start and end will be swapped if necessary.
    ///  If you want additional functionality such as the ability to maintain position
    ///  in a document, see SmartRange.
    ///  \sa SmartRange
    ///  \author Hamish Rodda \<rodda@kde.org\>
    ///  </remarks>        <short>    \short An object representing a section of text, from one Cursor to another.</short>
    [SmokeClass("KTextEditor::Range")]
    public class Range : Object, IDisposable {
        protected SmokeInvocation interceptor = null;
        private IntPtr smokeObject;
        protected Range(Type dummy) {}
        protected void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(Range), this);
        }
        private static SmokeInvocation staticInterceptor = null;
        static Range() {
            staticInterceptor = new SmokeInvocation(typeof(Range), null);
        }
        // friend Range operator+(const KTextEditor::Range& arg1,const KTextEditor::Range& arg2); >>>> NOT CONVERTED
        // friend Range operator-(const KTextEditor::Range& arg1,const KTextEditor::Range& arg2); >>>> NOT CONVERTED
        // friend Range operator&(const KTextEditor::Range& arg1,const KTextEditor::Range& arg2); >>>> NOT CONVERTED
        // friend bool operator==(const KTextEditor::Range& arg1,const KTextEditor::Range& arg2); >>>> NOT CONVERTED
        // friend bool operator>(const KTextEditor::Range& arg1,const KTextEditor::Range& arg2); >>>> NOT CONVERTED
        // friend bool operator<(const KTextEditor::Range& arg1,const KTextEditor::Range& arg2); >>>> NOT CONVERTED
        /// <remarks>
        ///  Default constructor. Creates a valid range from position (0, 0) to
        ///  position (0, 0).
        ///      </remarks>        <short>    Default constructor.</short>
        public Range() : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("Range", "Range()", typeof(void));
        }
        /// <remarks>
        ///  Constructor which creates a range from \e start to \e end.
        ///  If start is after end, they will be swapped.
        ///  \param start start position
        ///  \param end end position
        ///      </remarks>        <short>    Constructor which creates a range from \e start to \e end.</short>
        public Range(KTextEditor.Cursor start, KTextEditor.Cursor end) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("Range##", "Range(const KTextEditor::Cursor&, const KTextEditor::Cursor&)", typeof(void), typeof(KTextEditor.Cursor), start, typeof(KTextEditor.Cursor), end);
        }
        /// <remarks>
        ///  Constructor which creates a single-line range from <pre>start</pre>,
        ///  extending <pre>width</pre> characters along the same line.
        ///  \param start start position
        ///  \param width width of this range in columns along the same line
        ///      </remarks>        <short>    Constructor which creates a single-line range from \p start,  extending \p width characters along the same line.</short>
        public Range(KTextEditor.Cursor start, int width) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("Range#$", "Range(const KTextEditor::Cursor&, int)", typeof(void), typeof(KTextEditor.Cursor), start, typeof(int), width);
        }
        /// <remarks>
        ///  Constructor which creates a range from <pre>start</pre>, to <pre>endLine</pre>, <pre>endColumn</pre>.
        ///  \param start start position
        ///  \param endLine end line
        ///  \param endColumn end column
        ///      </remarks>        <short>    Constructor which creates a range from \p start, to \p endLine, \p endColumn.</short>
        public Range(KTextEditor.Cursor start, int endLine, int endColumn) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("Range#$$", "Range(const KTextEditor::Cursor&, int, int)", typeof(void), typeof(KTextEditor.Cursor), start, typeof(int), endLine, typeof(int), endColumn);
        }
        /// <remarks>
        ///  Constructor which creates a range from \e startLine, \e startColumn to \e endLine, \e endColumn.
        ///  \param startLine start line
        ///  \param startColumn start column
        ///  \param endLine end line
        ///  \param endColumn end column
        ///      </remarks>        <short>    Constructor which creates a range from \e startLine, \e startColumn to \e endLine, \e endColumn.</short>
        public Range(int startLine, int startColumn, int endLine, int endColumn) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("Range$$$$", "Range(int, int, int, int)", typeof(void), typeof(int), startLine, typeof(int), startColumn, typeof(int), endLine, typeof(int), endColumn);
        }
        /// <remarks>
        ///  Copy constructor.
        ///  \param copy the range from which to copy the start and end position.
        ///      </remarks>        <short>    Copy constructor.</short>
        public Range(KTextEditor.Range copy) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("Range#", "Range(const KTextEditor::Range&)", typeof(void), typeof(KTextEditor.Range), copy);
        }
        /// <remarks>
        ///  Validity check.  In the base class, returns true unless the range starts before (0,0).
        ///      </remarks>        <short>    Validity check.</short>
        [SmokeMethod("isValid() const")]
        public virtual bool IsValid() {
            return (bool) interceptor.Invoke("isValid", "isValid() const", typeof(bool));
        }
        /// <remarks>
        ///  Returns whether this range is a SmartRange.
        ///      </remarks>        <short>    Returns whether this range is a SmartRange.</short>
        [SmokeMethod("isSmartRange() const")]
        public virtual bool IsSmartRange() {
            return (bool) interceptor.Invoke("isSmartRange", "isSmartRange() const", typeof(bool));
        }
        /// <remarks>
        ///  Returns this range as a SmartRange, if it is one.
        ///      </remarks>        <short>    Returns this range as a SmartRange, if it is one.</short>
        [SmokeMethod("toSmartRange() const")]
        public virtual KTextEditor.SmartRange ToSmartRange() {
            return (KTextEditor.SmartRange) interceptor.Invoke("toSmartRange", "toSmartRange() const", typeof(KTextEditor.SmartRange));
        }
        /// <remarks>
        ///  Get the start position of this range. This will always be <= end().
        ///  This non-const function allows direct manipulation of the start position,
        ///  while still retaining notification support.
        ///  If start is set to a position after end, end will be moved to the
        ///  same position as start, as ranges are not allowed to have
        ///  start() > end().
        ///  <b>Note:<> If you want to change both start() and end() simultaneously,
        ///        you should use setRange(), for several reasons:
        ///        <li>otherwise</li>, the rule preventing start() > end() may alter your intended change
        ///        <li>any</li> notifications needed will be performed multiple times for no benefit
        ///  \returns a reference to the start position of this range.
        ///      </remarks>        <short>    Get the start position of this range.</short>
        public KTextEditor.Cursor Start() {
            return (KTextEditor.Cursor) interceptor.Invoke("start", "start()", typeof(KTextEditor.Cursor));
        }
        /// <remarks>
        ///  Get the end position of this range. This will always be >= start().
        ///  This non-const function allows direct manipulation of the end position,
        ///  while still retaining notification support.
        ///  If end is set to a position before start, start will be moved to the
        ///  same position as end, as ranges are not allowed to have
        ///  start() > end().
        ///  <b>Note:<> If you want to change both start() and end() simultaneously,
        ///        you should use setRange(), for several reasons:
        ///        <li>otherwise</li>, the rule preventing start() > end() may alter your intended change
        ///        <li>any</li> notifications needed will be performed multiple times for no benefit
        ///  \returns a reference to the end position of this range.
        ///  \internal this function is to allow for covariant return of SmartCursor%s.
        ///      </remarks>        <short>    Get the end position of this range.</short>
        public KTextEditor.Cursor End() {
            return (KTextEditor.Cursor) interceptor.Invoke("end", "end()", typeof(KTextEditor.Cursor));
        }
        /// <remarks>
        ///  Convenience function.  Set the start and end lines to <pre>line</pre>.
        ///  \param line the line number to assign to start() and end()
        ///      </remarks>        <short>    Convenience function.</short>
        public void SetBothLines(int line) {
            interceptor.Invoke("setBothLines$", "setBothLines(int)", typeof(void), typeof(int), line);
        }
        /// <remarks>
        ///  Convenience function.  Set the start and end columns to <pre>column</pre>.
        ///  \param column the column number to assign to start() and end()
        ///      </remarks>        <short>    Convenience function.</short>
        public void SetBothColumns(int column) {
            interceptor.Invoke("setBothColumns$", "setBothColumns(int)", typeof(void), typeof(int), column);
        }
        /// <remarks>
        ///  Set the start and end cursors to \e range.start() and \e range.end() respectively.
        ///  \param range range to assign to this range
        ///      </remarks>        <short>    Set the start and end cursors to \e range.</short>
        [SmokeMethod("setRange(const KTextEditor::Range&)")]
        public virtual void SetRange(KTextEditor.Range range) {
            interceptor.Invoke("setRange#", "setRange(const KTextEditor::Range&)", typeof(void), typeof(KTextEditor.Range), range);
        }
        /// <remarks>
        ///  \overload
        ///  \n \n
        ///  Set the start and end cursors to \e start and \e end respectively.
        ///  <b>Note:<> If \e start is after \e end, they will be reversed.
        ///  \param start start cursor
        ///  \param end end cursor
        ///      </remarks>        <short>    \overload  \n \n  Set the start and end cursors to \e start and \e end respectively.</short>
        public void SetRange(KTextEditor.Cursor start, KTextEditor.Cursor end) {
            interceptor.Invoke("setRange##", "setRange(const KTextEditor::Cursor&, const KTextEditor::Cursor&)", typeof(void), typeof(KTextEditor.Cursor), start, typeof(KTextEditor.Cursor), end);
        }
        /// <remarks>
        ///  Expand this range if necessary to contain <pre>range</pre>.
        ///  \param range range which this range should contain
        ///  \return \e true if expansion occurred, \e false otherwise
        ///      </remarks>        <short>    Expand this range if necessary to contain \p range.</short>
        [SmokeMethod("expandToRange(const KTextEditor::Range&)")]
        public virtual bool ExpandToRange(KTextEditor.Range range) {
            return (bool) interceptor.Invoke("expandToRange#", "expandToRange(const KTextEditor::Range&)", typeof(bool), typeof(KTextEditor.Range), range);
        }
        /// <remarks>
        ///  Confine this range if necessary to fit within <pre>range</pre>.
        ///  \param range range which should contain this range
        ///  \return \e true if confinement occurred, \e false otherwise
        ///      </remarks>        <short>    Confine this range if necessary to fit within \p range.</short>
        [SmokeMethod("confineToRange(const KTextEditor::Range&)")]
        public virtual bool ConfineToRange(KTextEditor.Range range) {
            return (bool) interceptor.Invoke("confineToRange#", "confineToRange(const KTextEditor::Range&)", typeof(bool), typeof(KTextEditor.Range), range);
        }
        /// <remarks>
        ///  Check whether this range is wholly contained within one line, ie. if
        ///  the start() and end() positions are on the same line.
        ///  \return \e true if both the start and end positions are on the same
        ///          line, otherwise \e false
        ///      </remarks>        <short>    Check whether this range is wholly contained within one line, ie.</short>
        public bool OnSingleLine() {
            return (bool) interceptor.Invoke("onSingleLine", "onSingleLine() const", typeof(bool));
        }
        /// <remarks>
        ///  Returns the number of lines separating the start() and end() positions.
        ///  \return the number of lines separating the start() and end() positions;
        ///          0 if the start and end lines are the same.
        ///      </remarks>        <short>    Returns the number of lines separating the start() and end() positions.</short>
        public int NumberOfLines() {
            return (int) interceptor.Invoke("numberOfLines", "numberOfLines() const", typeof(int));
        }
        /// <remarks>
        ///  Returns the number of columns separating the start() and end() positions.
        ///  \return the number of columns separating the start() and end() positions;
        ///          0 if the start and end columns are the same.
        ///      </remarks>        <short>    Returns the number of columns separating the start() and end() positions.</short>
        public int ColumnWidth() {
            return (int) interceptor.Invoke("columnWidth", "columnWidth() const", typeof(int));
        }
        /// <remarks>
        ///  Returns true if this range contains no characters, ie. the start() and
        ///  end() positions are the same.
        ///  \returns \e true if the range contains no characters, otherwise \e false
        ///      </remarks>        <short>    Returns true if this range contains no characters, ie.</short>
        public bool IsEmpty() {
            return (bool) interceptor.Invoke("isEmpty", "isEmpty() const", typeof(bool));
        }
        /// <remarks>
        ///  Check whether the this range wholly encompasses \e range.
        ///  \param range range to check
        ///  \return \e true, if this range contains \e range, otherwise \e false
        ///      </remarks>        <short>    Check whether the this range wholly encompasses \e range.</short>
        public bool Contains(KTextEditor.Range range) {
            return (bool) interceptor.Invoke("contains#", "contains(const KTextEditor::Range&) const", typeof(bool), typeof(KTextEditor.Range), range);
        }
        /// <remarks>
        ///  Check to see if <pre>cursor</pre> is contained within this range, ie >= start() and \< end().
        ///  \param cursor the position to test for containment
        ///  \return \e true if the cursor is contained within this range, otherwise \e false.
        ///      </remarks>        <short>    Check to see if \p cursor is contained within this range, ie >= start() and \< end().</short>
        public bool Contains(KTextEditor.Cursor cursor) {
            return (bool) interceptor.Invoke("contains#", "contains(const KTextEditor::Cursor&) const", typeof(bool), typeof(KTextEditor.Cursor), cursor);
        }
        /// <remarks>
        ///  Returns true if this range wholly encompasses <pre>line</pre>.
        ///  \param line line to check
        ///  \return \e true if the line is wholly encompassed by this range, otherwise \e false.
        ///      </remarks>        <short>    Returns true if this range wholly encompasses \p line.</short>
        public bool ContainsLine(int line) {
            return (bool) interceptor.Invoke("containsLine$", "containsLine(int) const", typeof(bool), typeof(int), line);
        }
        /// <remarks>
        ///  Check whether the range contains \e column.
        ///  \param column column to check
        ///  \return \e true if the range contains \e column, otherwise \e false
        ///      </remarks>        <short>    Check whether the range contains \e column.</short>
        public bool ContainsColumn(int column) {
            return (bool) interceptor.Invoke("containsColumn$", "containsColumn(int) const", typeof(bool), typeof(int), column);
        }
        /// <remarks>
        ///  Check whether the this range overlaps with \e range.
        ///  \param range range to check against
        ///  \return \e true, if this range overlaps with \e range, otherwise \e false
        ///      </remarks>        <short>    Check whether the this range overlaps with \e range.</short>
        public bool Overlaps(KTextEditor.Range range) {
            return (bool) interceptor.Invoke("overlaps#", "overlaps(const KTextEditor::Range&) const", typeof(bool), typeof(KTextEditor.Range), range);
        }
        /// <remarks>
        ///  Check whether the range overlaps at least part of \e line.
        ///  \param line line to check
        ///  \return \e true, if the range overlaps at least part of \e line, otherwise \e false
        ///      </remarks>        <short>    Check whether the range overlaps at least part of \e line.</short>
        public bool OverlapsLine(int line) {
            return (bool) interceptor.Invoke("overlapsLine$", "overlapsLine(int) const", typeof(bool), typeof(int), line);
        }
        /// <remarks>
        ///  Check to see if this range overlaps <pre>column</pre>; that is, if <pre>column</pre> is
        ///  between start().column() and end().column().  This function is most likely
        ///  to be useful in relation to block text editing.
        ///  \param column the column to test
        ///  \return \e true if the column is between the range's starting and ending
        ///          columns, otherwise \e false.
        ///      </remarks>        <short>    Check to see if this range overlaps \p column; that is, if \p column is  between start().</short>
        public bool OverlapsColumn(int column) {
            return (bool) interceptor.Invoke("overlapsColumn$", "overlapsColumn(int) const", typeof(bool), typeof(int), column);
        }
        /// <remarks>
        ///  Determine where <pre>cursor</pre> is positioned in relationship to this range.
        ///  Equivalency (a return value of 0) is returned when <pre>cursor</pre> is \e contained
        ///  within the range, not when \e overlapped - i.e., <pre>cursor</pre> may be on a
        ///  line which is also partially occupied by this range, but the position
        ///  may not be eqivalent.  For overlap checking, use positionRelativeToLine().
        ///  \param cursor position to check
        ///  \return \e -1 if before, \e +1 if after, and \e 0 if <pre>cursor</pre> is contained within the range.
        ///  \see positionRelativeToLine()
        ///      </remarks>        <short>    Determine where \p cursor is positioned in relationship to this range.</short>
        public int PositionRelativeToCursor(KTextEditor.Cursor cursor) {
            return (int) interceptor.Invoke("positionRelativeToCursor#", "positionRelativeToCursor(const KTextEditor::Cursor&) const", typeof(int), typeof(KTextEditor.Cursor), cursor);
        }
        /// <remarks>
        ///  Determine where <pre>line</pre> is positioned in relationship to this range.
        ///  Equivalency (a return value of 0) is returned when <pre>line</pre> is \e overlapped
        ///  within the range, not when \e contained - i.e., this range may not cover an entire line,
        ///  but <pre>line</pre>'s position will still be eqivalent.  For containment checking, use positionRelativeToCursor().
        ///  \param line line to check
        ///  \return \e -1 if before, \e +1 if after, and \e 0 if <pre>line</pre> is overlapped by this range.
        ///  \see positionRelativeToCursor()
        ///      </remarks>        <short>    Determine where \p line is positioned in relationship to this range.</short>
        public int PositionRelativeToLine(int line) {
            return (int) interceptor.Invoke("positionRelativeToLine$", "positionRelativeToLine(int) const", typeof(int), typeof(int), line);
        }
        /// <remarks>
        ///  Check whether <pre>cursor</pre> is located at either of the start() or end()
        ///  boundaries.
        ///  \param cursor cursor to check
        ///  \return \e true if the cursor is equal to <pre>start</pre>() or <pre>end</pre>(),
        ///          otherwise \e false.
        ///      </remarks>        <short>    Check whether \p cursor is located at either of the start() or end()  boundaries.</short>
        public bool BoundaryAtCursor(KTextEditor.Cursor cursor) {
            return (bool) interceptor.Invoke("boundaryAtCursor#", "boundaryAtCursor(const KTextEditor::Cursor&) const", typeof(bool), typeof(KTextEditor.Cursor), cursor);
        }
        /// <remarks>
        ///  Check whether <pre>line</pre> is on the same line as either of the start() or
        ///  end() boundaries.
        ///  \param line line to check
        ///  \return \e true if <pre>line</pre> is on the same line as either of the
        ///          boundaries, otherwise \e false
        ///      </remarks>        <short>    Check whether \p line is on the same line as either of the start() or  end() boundaries.</short>
        public bool BoundaryOnLine(int line) {
            return (bool) interceptor.Invoke("boundaryOnLine$", "boundaryOnLine(int) const", typeof(bool), typeof(int), line);
        }
        /// <remarks>
        ///  Check whether <pre>column</pre> is on the same column as either of the start()
        ///  or end() boundaries.
        ///  \param column column to check
        ///  \return \e true if <pre>column</pre> is on the same column as either of the
        ///          boundaries, otherwise \e false
        ///      </remarks>        <short>    Check whether \p column is on the same column as either of the start()  or end() boundaries.</short>
        public bool BoundaryOnColumn(int column) {
            return (bool) interceptor.Invoke("boundaryOnColumn$", "boundaryOnColumn(int) const", typeof(bool), typeof(int), column);
        }
        /// <remarks>
        ///  Intersects this range with another, returning the shared area of
        ///  the two ranges.
        ///  \param range other range to intersect with this
        ///  \return the intersection of this range and the supplied \a range.
        ///      </remarks>        <short>    Intersects this range with another, returning the shared area of  the two ranges.</short>
        public KTextEditor.Range Intersect(KTextEditor.Range range) {
            return (KTextEditor.Range) interceptor.Invoke("intersect#", "intersect(const KTextEditor::Range&) const", typeof(KTextEditor.Range), typeof(KTextEditor.Range), range);
        }
        /// <remarks>
        ///  Returns the smallest range which encompasses this range and the
        ///  supplied \a range.
        ///  \param range other range to encompass
        ///  \return the smallest range which contains this range and the supplied \a range.
        ///      </remarks>        <short>    Returns the smallest range which encompasses this range and the  supplied \a range.</short>
        public KTextEditor.Range Encompass(KTextEditor.Range range) {
            return (KTextEditor.Range) interceptor.Invoke("encompass#", "encompass(const KTextEditor::Range&) const", typeof(KTextEditor.Range), typeof(KTextEditor.Range), range);
        }
        /// <remarks>
        ///  Addition operator. Takes two ranges and returns their summation.
        ///  \param r1 the first range
        ///  \param r2 the second range
        ///  \return a the summation of the two input ranges
        ///      </remarks>        <short>    Addition operator.</short>
        /// <remarks>
        ///  Subtraction operator. Takes two ranges and returns the subtraction
        ///  of <pre>r2</pre> from <pre>r1</pre>.
        ///  \param r1 the first range
        ///  \param r2 the second range
        ///  \return a range representing the subtraction of <pre>r2</pre> from <pre>r1</pre>
        ///      </remarks>        <short>    Subtraction operator.</short>
        /// <remarks>
        ///  Intersects \a r1 and \a r2.
        ///  \param r1 the first range
        ///  \param r2 the second range
        ///  \return the intersected range, invalid() if there is no overlap
        ///      </remarks>        <short>    Intersects \a r1 and \a r2.</short>
        /// <remarks>
        ///  Equality operator.
        ///  \param r1 first range to compare
        ///  \param r2 second range to compare
        ///  \return \e true if \e r1 and \e r2 equal, otherwise \e false
        ///      </remarks>        <short>    Equality operator.</short>
        /// <remarks>
        ///  Greater than operator.  Looks only at the position of the two ranges,
        ///  does not consider their size.
        ///  \param r1 first range to compare
        ///  \param r2 second range to compare
        ///  \return \e true if \e r1 starts after where \e r2 ends, otherwise \e false
        ///      </remarks>        <short>    Greater than operator.</short>
        /// <remarks>
        ///  Less than operator.  Looks only at the position of the two ranges,
        ///  does not consider their size.
        ///  \param r1 first range to compare
        ///  \param r2 second range to compare
        ///  \return \e true if \e r1 ends before \e r2 begins, otherwise \e false
        ///      </remarks>        <short>    Less than operator.</short>
        /// <remarks>
        ///  Notify this range that one or both of the cursors' position has changed directly.
        ///  \param cursor the cursor that changed. If null, both cursors have changed.
        ///  \param from the previous position of this range
        ///  \internal
        ///      </remarks>        <short>    Notify this range that one or both of the cursors' position has changed directly.</short>
        [SmokeMethod("rangeChanged(KTextEditor::Cursor*, const KTextEditor::Range&)")]
        protected virtual void RangeChanged(KTextEditor.Cursor cursor, KTextEditor.Range from) {
            interceptor.Invoke("rangeChanged##", "rangeChanged(KTextEditor::Cursor*, const KTextEditor::Range&)", typeof(void), typeof(KTextEditor.Cursor), cursor, typeof(KTextEditor.Range), from);
        }
        ~Range() {
            interceptor.Invoke("~Range", "~Range()", typeof(void));
        }
        public void Dispose() {
            interceptor.Invoke("~Range", "~Range()", typeof(void));
        }
        /// <remarks>
        ///  Returns an invalid range.
        ///      </remarks>        <short>    Returns an invalid range.</short>
        public static KTextEditor.Range Invalid() {
            return (KTextEditor.Range) staticInterceptor.Invoke("invalid", "invalid()", typeof(KTextEditor.Range));
        }
    }
}
