import QtQuick 1.0
import org.kde.analitza 1.0
import widgets 1.0

KAlgebraPage
{
	Analitza {
		id: a
	}
	
	function doSelectAll()
	{
		input.selectAll()
	}
	
	ListModel { id: itemModel }
	
	ExpressionInput {
		id: input
		focus: true
		
		Keys.onReturnPressed: {
			var res = a.execute(text)
			
			if(!a.isCorrect) {
				if(res)
					itemModel.append({ result: "Error: " + res })
				else
					itemModel.append({ result: "Error: " + a.errors })
			} else
				itemModel.insert(0, { result: text + " = " + res.expression });
			
			input.selectAll();
			
			view.currentIndex = 0
		}
		
		width: parent.width
		anchors.top: parent.top
	}
	
	SimpleListView {
		model: itemModel
		id: view
		
		role: "result"
		
		anchors {
			top: input.bottom
			bottom: parent.bottom
			left: parent.left
			right: parent.right
		}
	}
}