//Auto-generated by kalyptus. DO NOT EDIT.
namespace DOM {
	using Kimono;
	using System;
	using Qyoto;
	/// <remarks>
	///  The <code>Document</code> interface represents the entire HTML or
	///  XML document. Conceptually, it is the root of the document tree,
	///  and provides the primary access to the document's data.
	///   Since elements, text nodes, comments, processing instructions,
	///  etc. cannot exist outside the context of a <code>Document</code>
	///  , the <code>Document</code> interface also contains the factory
	///  methods needed to create these objects. The <code>Node</code>
	///  objects created have a <code>ownerDocument</code> attribute which
	///  associates them with the <code>Document</code> within whose
	///  context they were created.
	///  </remarks>		<short>    The <code>Document</code> interface represents the entire HTML or  XML document.</short>
	[SmokeClass("DOM::Document")]
	public class Document : DOM.Node, IDisposable {
 		protected Document(Type dummy) : base((Type) null) {}
		protected new void CreateProxy() {
			interceptor = new SmokeInvocation(typeof(Document), this);
		}
		// DOM::Document* Document(DOM::DocumentImpl* arg1); >>>> NOT CONVERTED
		public Document() : this((Type) null) {
			CreateProxy();
			interceptor.Invoke("Document", "Document()", typeof(void));
		}
		/// <remarks>
		///  don't create an implementation if false
		///  use at own risk
		///      </remarks>		<short>    don't create an implementation if false  use at own risk      </short>
		public Document(bool arg1) : this((Type) null) {
			CreateProxy();
			interceptor.Invoke("Document$", "Document(bool)", typeof(void), typeof(bool), arg1);
		}
		public Document(DOM.Document other) : this((Type) null) {
			CreateProxy();
			interceptor.Invoke("Document#", "Document(const DOM::Document&)", typeof(void), typeof(DOM.Document), other);
		}
		public Document(DOM.Node other) : this((Type) null) {
			CreateProxy();
			interceptor.Invoke("Document#", "Document(const DOM::Node&)", typeof(void), typeof(DOM.Node), other);
		}
		/// <remarks>
		///  The Document Type Declaration (see <code>DocumentType</code>
		///  ) associated with this document. For HTML documents as well as
		///  XML documents without a document type declaration this returns
		///  <code>null</code> . The DOM Level 1 does not support editing
		///  the Document Type Declaration, therefore <code>docType</code>
		///  cannot be altered in any way.
		///      </remarks>		<short>    The Document Type Declaration (see <code>DocumentType</code>  ) associated with this document.</short>
		public DOM.DocumentType Doctype() {
			return (DOM.DocumentType) interceptor.Invoke("doctype", "doctype() const", typeof(DOM.DocumentType));
		}
		/// <remarks>
		///  The <code>DOMImplementation</code> object that handles this
		///  document. A DOM application may use objects from multiple
		///  implementations.
		///      </remarks>		<short>    The <code>DOMImplementation</code> object that handles this  document.</short>
		public DOM.DOMImplementation Implementation() {
			return (DOM.DOMImplementation) interceptor.Invoke("implementation", "implementation() const", typeof(DOM.DOMImplementation));
		}
		/// <remarks>
		///  This is a convenience attribute that allows direct access to
		///  the child node that is the root element of the document. For
		///  HTML documents, this is the element with the tagName "HTML".
		///      </remarks>		<short>    This is a convenience attribute that allows direct access to  the child node that is the root element of the document.</short>
		public DOM.Element DocumentElement() {
			return (DOM.Element) interceptor.Invoke("documentElement", "documentElement() const", typeof(DOM.Element));
		}
		/// <remarks>
		///  Creates an element of the type specified. Note that the
		///  instance returned implements the Element interface, so
		///  attributes can be specified directly on the returned object.
		/// <param> name="tagName" The name of the element type to instantiate. For
		///  XML, this is case-sensitive. For HTML, the <code>tagName</code>
		///  parameter may be provided in any case, but it must be
		///  mapped to the canonical uppercase form by the DOM
		///  implementation.
		/// </param>     </remarks>		<return> A new <code>Element</code> object.
		/// </return>
		/// 		<short>    Creates an element of the type specified.</short>
		public DOM.Element CreateElement(DOM.DOMString tagName) {
			return (DOM.Element) interceptor.Invoke("createElement#", "createElement(const DOM::DOMString&)", typeof(DOM.Element), typeof(DOM.DOMString), tagName);
		}
		/// <remarks>
		///  Introduced in DOM Level 2
		///  Creates an element of the given qualified name and namespace URI.
		/// <param> name="namespaceURI" The namespace URI of the element to create.
		/// </param><param> name="qualifiedName" The qualified name of the element type to instantiate.
		/// </param></remarks>		<return> A new Element object with the following attributes:
		/// </return>
		/// 		<short>    Introduced in DOM Level 2  Creates an element of the given qualified name and namespace URI.</short>
		public DOM.Element CreateElementNS(DOM.DOMString namespaceURI, DOM.DOMString qualifiedName) {
			return (DOM.Element) interceptor.Invoke("createElementNS##", "createElementNS(const DOM::DOMString&, const DOM::DOMString&)", typeof(DOM.Element), typeof(DOM.DOMString), namespaceURI, typeof(DOM.DOMString), qualifiedName);
		}
		/// <remarks>
		///  Creates an empty <code>DocumentFragment</code> object.
		///      </remarks>		<return> A new <code>DocumentFragment</code> .
		/// </return>
		/// 		<short>    Creates an empty <code>DocumentFragment</code> object.</short>
		public DOM.DocumentFragment CreateDocumentFragment() {
			return (DOM.DocumentFragment) interceptor.Invoke("createDocumentFragment", "createDocumentFragment()", typeof(DOM.DocumentFragment));
		}
		/// <remarks>
		///  Creates a <code>Text</code> node given the specified string.
		/// <param> name="data" The data for the node.
		/// </param>     </remarks>		<return> The new <code>Text</code> object.
		/// </return>
		/// 		<short>    Creates a <code>Text</code> node given the specified string.</short>
		public DOM.Text CreateTextNode(DOM.DOMString data) {
			return (DOM.Text) interceptor.Invoke("createTextNode#", "createTextNode(const DOM::DOMString&)", typeof(DOM.Text), typeof(DOM.DOMString), data);
		}
		/// <remarks>
		///  Creates a <code>Comment</code> node given the specified
		///  string.
		/// <param> name="data" The data for the node.
		/// </param>     </remarks>		<return> The new <code>Comment</code> object.
		/// </return>
		/// 		<short>    Creates a <code>Comment</code> node given the specified  string.</short>
		public DOM.Comment CreateComment(DOM.DOMString data) {
			return (DOM.Comment) interceptor.Invoke("createComment#", "createComment(const DOM::DOMString&)", typeof(DOM.Comment), typeof(DOM.DOMString), data);
		}
		/// <remarks>
		///  Creates a <code>CDATASection</code> node whose value is the
		///  specified string.
		/// <param> name="data" The data for the <code>CDATASection</code>
		///  contents.
		/// </param>     </remarks>		<return> The new <code>CDATASection</code> object.
		/// </return>
		/// 		<short>    Creates a <code>CDATASection</code> node whose value is the  specified string.</short>
		public DOM.CDATASection CreateCDATASection(DOM.DOMString data) {
			return (DOM.CDATASection) interceptor.Invoke("createCDATASection#", "createCDATASection(const DOM::DOMString&)", typeof(DOM.CDATASection), typeof(DOM.DOMString), data);
		}
		/// <remarks>
		///  Creates a <code>ProcessingInstruction</code> node given the
		///  specified name and data strings.
		/// <param> name="target" The target part of the processing instruction.
		/// </param><param> name="data" The data for the node.
		/// </param>  NOT_SUPPORTED_ERR: Raised if this document is an HTML
		///  document.
		///      </remarks>		<return> The new <code>ProcessingInstruction</code> object.
		/// </return>
		/// 		<short>    Creates a <code>ProcessingInstruction</code> node given the  specified name and data strings.</short>
		public DOM.ProcessingInstruction CreateProcessingInstruction(DOM.DOMString target, DOM.DOMString data) {
			return (DOM.ProcessingInstruction) interceptor.Invoke("createProcessingInstruction##", "createProcessingInstruction(const DOM::DOMString&, const DOM::DOMString&)", typeof(DOM.ProcessingInstruction), typeof(DOM.DOMString), target, typeof(DOM.DOMString), data);
		}
		/// <remarks>
		///  Creates an <code>Attr</code> of the given name. Note that the
		///  <code>Attr</code> instance can then be set on an <code>Element</code>
		///  using the <code>setAttribute</code> method.
		/// <param> name="name" The name of the attribute.
		/// </param>     </remarks>		<return> A new <code>Attr</code> object.
		/// </return>
		/// 		<short>    Creates an <code>Attr</code> of the given name.</short>
		public DOM.Attr CreateAttribute(DOM.DOMString name) {
			return (DOM.Attr) interceptor.Invoke("createAttribute#", "createAttribute(const DOM::DOMString&)", typeof(DOM.Attr), typeof(DOM.DOMString), name);
		}
		/// <remarks>
		///  Introduced in DOM Level 2
		///  Creates an attribute of the given qualified name and namespace URI.
		///  HTML-only DOM implementations do not need to implement this method.
		/// <param> name="namespaceURI" The namespace URI of the attribute to create.
		/// </param><param> name="qualifiedName" The qualified name of the attribute to instantiate.
		/// </param></remarks>		<return> A new Attr object with the following attributes:
		///  Node.nodeName - qualifiedName
		///  Node.namespaceURI - namespaceURI
		///  Node.prefix - prefix, extracted from qualifiedName, or null if there is
		///  no prefix
		///  Node.localName - local name, extracted from qualifiedName
		///  Attr.name - qualifiedName
		///  Node.nodeValue - the empty string
		/// </return>
		/// 		<short>    Introduced in DOM Level 2  Creates an attribute of the given qualified name and namespace URI.</short>
		public DOM.Attr CreateAttributeNS(DOM.DOMString namespaceURI, DOM.DOMString qualifiedName) {
			return (DOM.Attr) interceptor.Invoke("createAttributeNS##", "createAttributeNS(const DOM::DOMString&, const DOM::DOMString&)", typeof(DOM.Attr), typeof(DOM.DOMString), namespaceURI, typeof(DOM.DOMString), qualifiedName);
		}
		/// <remarks>
		///  Creates an EntityReference object.
		/// <param> name="name" The name of the entity to reference.
		/// </param>  NOT_SUPPORTED_ERR: Raised if this document is an HTML
		///  document.
		///      </remarks>		<return> The new <code>EntityReference</code> object.
		/// </return>
		/// 		<short>    Creates an EntityReference object.</short>
		public DOM.EntityReference CreateEntityReference(DOM.DOMString name) {
			return (DOM.EntityReference) interceptor.Invoke("createEntityReference#", "createEntityReference(const DOM::DOMString&)", typeof(DOM.EntityReference), typeof(DOM.DOMString), name);
		}
		/// <remarks>
		///  Moved from HTMLDocument in DOM Level 2
		///  Returns the Element whose <code>id</code> is given by
		///  elementId. If no such element exists, returns <code>null</code>
		///  . Behavior is not defined if more than one element has
		///  this <code>id</code> .
		/// <param> name="elementId" The unique <code>id</code> value for an
		///  element.
		/// </param>     </remarks>		<return> The matching element.
		/// </return>
		/// 		<short>    Moved from HTMLDocument in DOM Level 2  Returns the Element whose <code>id</code> is given by  elementId.</short>
		public DOM.Element GetElementById(DOM.DOMString elementId) {
			return (DOM.Element) interceptor.Invoke("getElementById#", "getElementById(const DOM::DOMString&) const", typeof(DOM.Element), typeof(DOM.DOMString), elementId);
		}
		/// <remarks>
		///  No Exceptions.
		///  Returns a <code>ArrayList</code> of all the <code>Element</code> 's
		///  with a given tag name in the order in which they
		///  would be encountered in a preorder traversal of the
		///  <code>Document</code> tree.
		/// <param> name="tagname" The name of the tag to match on. The special
		///  value "*" matches all tags.
		/// </param>     </remarks>		<return> A new <code>NodeList</code> object containing all the
		///  matched <code>Element</code> s.
		/// </return>
		/// 		<short>    No Exceptions.</short>
		public DOM.NodeList GetElementsByTagName(DOM.DOMString tagname) {
			return (DOM.NodeList) interceptor.Invoke("getElementsByTagName#", "getElementsByTagName(const DOM::DOMString&)", typeof(DOM.NodeList), typeof(DOM.DOMString), tagname);
		}
		/// <remarks>
		///  Introduced in DOM Level 2
		///  No Exceptions
		///  Returns an ArrayList of all the Elements with a given local name and
		///  namespace URI in the order in which they are encountered in a preorder
		///  traversal of the Document tree.
		/// <param> name="namespaceURI" The namespace URI of the elements to match on. The
		///  special value "*" matches all namespaces.
		/// </param><param> name="localName" The local name of the elements to match on. The special
		///  value "*" matches all local names.
		/// </param></remarks>		<return> A new NodeList object containing all the matched Elements.
		///      </return>
		/// 		<short>    Introduced in DOM Level 2  No Exceptions </short>
		public DOM.NodeList GetElementsByTagNameNS(DOM.DOMString namespaceURI, DOM.DOMString localName) {
			return (DOM.NodeList) interceptor.Invoke("getElementsByTagNameNS##", "getElementsByTagNameNS(const DOM::DOMString&, const DOM::DOMString&)", typeof(DOM.NodeList), typeof(DOM.DOMString), namespaceURI, typeof(DOM.DOMString), localName);
		}
		/// <remarks>
		///  Introduced in HTML 5.
		///  No Exceptions.
		///  Returns a <code>ArrayList</code> of all the <code>Element</code> 's
		///  with a given class name in the order in which they
		///  would be encountered in a preorder traversal of the
		///  <code>Document</code> tree.
		/// <param> name="tagname" An unordered set of unique space-separated
		///  tokens representing classes.
		/// </param></remarks>		<return> A new <code>NodeList</code> object containing all the
		///  matched <code>Element</code> s.
		/// </return>
		/// 		<short>    Introduced in HTML 5.</short>
		public DOM.NodeList GetElementsByClassName(DOM.DOMString className) {
			return (DOM.NodeList) interceptor.Invoke("getElementsByClassName#", "getElementsByClassName(const DOM::DOMString&)", typeof(DOM.NodeList), typeof(DOM.DOMString), className);
		}
		/// <remarks>
		///  Introduced in DOM Level 2
		///  Imports a node from another document to this document. The returned node
		///  has no parent; (parentNode is null). The source node is not altered or
		///  removed from the original document; this method creates a new copy of
		///  the source node.
		///  For all nodes, importing a node creates a node object owned by the
		///  importing document, with attribute values identical to the source node's
		///  nodeName and nodeType, plus the attributes related to namespaces
		///  (prefix, localName, and namespaceURI).
		///  As in the cloneNode operation on a Node, the source node is not altered.
		///  Additional information is copied as appropriate to the nodeType,
		///  attempting to mirror the behavior expected if a fragment of XML or HTML
		///  source was copied from one document to another, recognizing that the two
		///  documents may have different DTDs in the XML case. The following list
		///  describes the specifics for each type of node.
		///  ATTRIBUTE_NODE
		///  The ownerElement attribute is set to null and the specified flag is set
		///  to true on the generated Attr. The descendants of the source Attr are
		///  recursively imported and the resulting nodes reassembled to form the
		///  corresponding subtree. Note that the deep parameter has no effect on
		///  Attr nodes; they always carry their children with them when imported.
		///  DOCUMENT_FRAGMENT_NODE
		///  If the deep option was set to true, the descendants of the source
		///  element are recursively imported and the resulting nodes reassembled to
		///  form the corresponding subtree. Otherwise, this simply generates an
		///  empty DocumentFragment.
		///  DOCUMENT_NODE
		///  Document nodes cannot be imported.
		///  DOCUMENT_TYPE_NODE
		///  DocumentType nodes cannot be imported.
		///  ELEMENT_NODE
		///  Specified attribute nodes of the source element are imported, and the
		///  generated Attr nodes are attached to the generated Element. Default
		///  attributes are not copied, though if the document being imported into
		///  defines default attributes for this element name, those are assigned. If
		///  the importNode deep parameter was set to true, the descendants of the
		///  source element are recursively imported and the resulting nodes
		///  reassembled to form the corresponding subtree.
		///  ENTITY_NODE
		///  Entity nodes can be imported, however in the current release of the DOM
		///  the DocumentType is readonly. Ability to add these imported nodes to a
		///  DocumentType will be considered for addition to a future release of the
		///  DOM.
		///  On import, the publicId, systemId, and notationName attributes are
		///  copied. If a deep import is requested, the descendants of the source
		///  Entity are recursively imported and the resulting nodes reassembled to
		///  form the corresponding subtree.
		///  ENTITY_REFERENCE_NODE Only the EntityReference itself is copied, even if
		///  a deep import is requested, since the source and destination documents
		///  might have defined the entity differently. If the document being
		///  imported into provides a definition for this entity name, its value is
		///  assigned.
		///  NOTATION_NODE
		///  Notation nodes can be imported, however in the current release of the
		///  DOM the DocumentType is readonly. Ability to add these imported nodes to
		///  a DocumentType will be considered for addition to a future release of
		///  the DOM.
		///  On import, the publicId and systemId attributes are copied.
		///  Note that the deep parameter has no effect on Notation nodes since they
		///  never have any children.
		///  PROCESSING_INSTRUCTION_NODE
		///  The imported node copies its target and data values from those of the
		///  source node.
		///  TEXT_NODE, CDATA_SECTION_NODE, COMMENT_NODE
		///  These three types of nodes inheriting from CharacterData copy their data
		///  and length attributes from those of the source node.
		/// <param> name="importedNode" The node to import.
		/// </param><param> name="deep" If true, recursively import the subtree under the specified
		///  node; if false, import only the node itself, as explained above. This
		///  has no effect on Attr, EntityReference, and Notation nodes.
		/// </param></remarks>		<return> The imported node that belongs to this Document.
		/// </return>
		/// 		<short>    Introduced in DOM Level 2 </short>
		public DOM.Node ImportNode(DOM.Node importedNode, bool deep) {
			return (DOM.Node) interceptor.Invoke("importNode#$", "importNode(const DOM::Node&, bool)", typeof(DOM.Node), typeof(DOM.Node), importedNode, typeof(bool), deep);
		}
		/// <remarks>
		///  not part of the DOM
		///      </remarks>		<short>   </short>
		public bool IsHTMLDocument() {
			return (bool) interceptor.Invoke("isHTMLDocument", "isHTMLDocument() const", typeof(bool));
		}
		/// <remarks>
		///  Introduced in DOM Level 2
		///  This method is from the DocumentRange interface
		/// </remarks>		<return> Range
		///  The initial state of the Range returned from this method is such that
		///  both of its boundary-points are positioned at the beginning of the
		///  corresponding Document, before any content. The Range returned can only
		///  be used to select content associated with this Document, or with
		///  DocumentFragments and Attrs for which this Document is the ownerDocument.
		///      </return>
		/// 		<short>    Introduced in DOM Level 2  This method is from the DocumentRange interface </short>
		public DOM.Range CreateRange() {
			return (DOM.Range) interceptor.Invoke("createRange", "createRange()", typeof(DOM.Range));
		}
		/// <remarks>
		///  Introduced in DOM Level 2
		///  This method is from the DocumentTraversal interface
		///  Create a new NodeIterator over the subtree rooted at the specified node.
		/// <param> name="root" The node which will be iterated together with its children.
		///  The iterator is initially positioned just before this node. The
		///  whatToShow flags and the filter, if any, are not considered when setting
		///  this position. The root must not be null.
		/// </param><param> name="whatToShow" This flag specifies which node types may appear in the
		///  logical view of the tree presented by the iterator. See the description
		///  of NodeFilter for the set of possible SHOW_ values. These flags can be
		///  combined using OR.
		/// </param><param> name="filter" The NodeFilter to be used with this NodeIterator, or null to
		///  indicate no filter.
		/// </param><param> name="entityReferenceExpansion" The value of this flag determines
		///  whether entity reference nodes are expanded.
		/// </param></remarks>		<return> NodeIterator The newly created NodeIterator.
		/// </return>
		/// 		<short>    Introduced in DOM Level 2  This method is from the DocumentTraversal interface </short>
		public DOM.NodeIterator CreateNodeIterator(DOM.Node root, ulong whatToShow, DOM.NodeFilter filter, bool entityReferenceExpansion) {
			return (DOM.NodeIterator) interceptor.Invoke("createNodeIterator#$#$", "createNodeIterator(DOM::Node, unsigned long, DOM::NodeFilter, bool)", typeof(DOM.NodeIterator), typeof(DOM.Node), root, typeof(ulong), whatToShow, typeof(DOM.NodeFilter), filter, typeof(bool), entityReferenceExpansion);
		}
		/// <remarks>
		///  Introduced in DOM Level 2
		///  This method is from the DocumentTraversal interface
		///  Create a new TreeWalker over the subtree rooted at the specified node.
		/// <param> name="root" The node which will serve as the root for the TreeWalker.
		///  The whatToShow flags and the NodeFilter are not considered when setting
		///  this value; any node type will be accepted as the root. The currentNode
		///  of the TreeWalker is initialized to this node, whether or not it is
		///  visible. The root functions as a stopping point for traversal methods
		///  that look upward in the document structure, such as parentNode and
		///  nextNode. The root must not be null.
		/// </param><param> name="whatToShow" This flag specifies which node types may appear in the
		///  logical view of the tree presented by the tree-walker. See the
		///  description of NodeFilter for the set of possible SHOW_ values. These
		///  flags can be combined using OR.
		/// </param><param> name="filter" The NodeFilter to be used with this TreeWalker, or null to
		///  indicate no filter.
		/// </param><param> name="entityReferenceExpansion" If this flag is false, the contents of
		///  EntityReference nodes are not presented in the logical view.
		/// </param></remarks>		<return> The newly created TreeWalker.
		/// </return>
		/// 		<short>    Introduced in DOM Level 2  This method is from the DocumentTraversal interface </short>
		public DOM.TreeWalker CreateTreeWalker(DOM.Node root, ulong whatToShow, DOM.NodeFilter filter, bool entityReferenceExpansion) {
			return (DOM.TreeWalker) interceptor.Invoke("createTreeWalker#$#$", "createTreeWalker(DOM::Node, unsigned long, DOM::NodeFilter, bool)", typeof(DOM.TreeWalker), typeof(DOM.Node), root, typeof(ulong), whatToShow, typeof(DOM.NodeFilter), filter, typeof(bool), entityReferenceExpansion);
		}
		/// <remarks>
		///  Introduced in DOM Level 2
		///  This method is from the DocumentEvent interface
		///  The createEvent method is used in creating Events when it is either
		///  inconvenient or unnecessary for the user to create an Event themselves.
		///  In cases where the implementation provided Event is insufficient, users
		///  may supply their own Event implementations for use with the
		///  dispatchEvent method.
		/// <param> name="eventType" The eventType parameter specifies the type of Event
		///  interface to be created. If the Event interface specified is supported
		///  by the implementation this method will return a new Event of the
		///  interface type requested. If the Event is to be dispatched via the
		///  dispatchEvent method the appropriate event init method must be called
		///  after creation in order to initialize the Event's values. As an example,
		///  a user wishing to synthesize some kind of UIEvent would call createEvent
		///  with the parameter "UIEvents". The initUIEvent method could then be
		///  called on the newly created UIEvent to set the specific type of UIEvent
		///  to be dispatched and set its context information.
		/// </param></remarks>		<return> The newly created EventExceptions
		/// </return>
		/// 		<short>    Introduced in DOM Level 2  This method is from the DocumentEvent interface </short>
		public DOM.Event CreateEvent(DOM.DOMString eventType) {
			return (DOM.Event) interceptor.Invoke("createEvent#", "createEvent(const DOM::DOMString&)", typeof(DOM.Event), typeof(DOM.DOMString), eventType);
		}
		/// <remarks>
		///  Introduced in DOM Level 2
		///  This method is from the DocumentView interface
		///  The default AbstractView for this Document, or null if none available.
		///      </remarks>		<short>    Introduced in DOM Level 2  This method is from the DocumentView interface </short>
		public DOM.AbstractView DefaultView() {
			return (DOM.AbstractView) interceptor.Invoke("defaultView", "defaultView() const", typeof(DOM.AbstractView));
		}
		/// <remarks>
		///  Introduced in DOM Level 2
		///  This method is from the DocumentStyle interface
		///  A list containing all the style sheets explicitly linked into or
		///  embedded in a document. For HTML documents, this includes external style
		///  sheets, included via the HTML LINK element, and inline STYLE elements.
		///  In XML, this includes external style sheets, included via style sheet
		///  processing instructions (see [XML-StyleSheet]).
		///      </remarks>		<short>    Introduced in DOM Level 2  This method is from the DocumentStyle interface </short>
		public DOM.StyleSheetList StyleSheets() {
			return (DOM.StyleSheetList) interceptor.Invoke("styleSheets", "styleSheets() const", typeof(DOM.StyleSheetList));
		}
		/// <remarks>
		///  CSS3 mechanism for selecting alternate stylesheets using the DOM.
		///  Might change without further notice.
		///      </remarks>		<short>    CSS3 mechanism for selecting alternate stylesheets using the DOM.</short>
		public DOM.DOMString PreferredStylesheetSet() {
			return (DOM.DOMString) interceptor.Invoke("preferredStylesheetSet", "preferredStylesheetSet()", typeof(DOM.DOMString));
		}
		public DOM.DOMString SelectedStylesheetSet() {
			return (DOM.DOMString) interceptor.Invoke("selectedStylesheetSet", "selectedStylesheetSet()", typeof(DOM.DOMString));
		}
		public void SetSelectedStylesheetSet(DOM.DOMString aString) {
			interceptor.Invoke("setSelectedStylesheetSet#", "setSelectedStylesheetSet(const DOM::DOMString&)", typeof(void), typeof(DOM.DOMString), aString);
		}
		/// <remarks>
		///  Adds a new style sheet to the list of style sheets.
		///  The new style sheet will be applied after all author and implicit
		///  style sheets, but before the user style sheet.
		///  Create new style sheets with e. g.
		///  <code>DOMImplementation</code>.CreateCSSStyleSheet
		///  This is not part of the official DOM.
		/// <param> name="sheet" style sheet
		/// </param></remarks>		<short>    Adds a new style sheet to the list of style sheets.</short>
		public void AddStyleSheet(DOM.StyleSheet sheet) {
			interceptor.Invoke("addStyleSheet#", "addStyleSheet(const DOM::StyleSheet&)", typeof(void), typeof(DOM.StyleSheet), sheet);
		}
		/// <remarks>
		///  Removes a style sheet to the list of style sheets.
		///  Only sheets added by <code>addStyleSheet</code> may be removed.
		///  This is not part of the official DOM.
		/// <param> name="sheet" style sheet to remove
		/// </param></remarks>		<short>    Removes a style sheet to the list of style sheets.</short>
		public void RemoveStyleSheet(DOM.StyleSheet sheet) {
			interceptor.Invoke("removeStyleSheet#", "removeStyleSheet(const DOM::StyleSheet&)", typeof(void), typeof(DOM.StyleSheet), sheet);
		}
		/// <remarks>
		/// </remarks>		<return> The KHTML view widget of this document.
		///      </return>
		/// 		<short>   </short>
		public KHTMLView View() {
			return (KHTMLView) interceptor.Invoke("view", "view() const", typeof(KHTMLView));
		}
		/// <remarks>
		///  Introduced in DOM Level 2
		///  This method is from the DocumentCSS interface
		///  This method is used to retrieve the override style declaration for a
		///  specified element and a specified pseudo-element.
		/// <param> name="elt" The element whose style is to be modified. This parameter
		///  cannot be null.
		/// </param><param> name="pseudoElt" The pseudo-element or null if none.
		/// </param></remarks>		<return> The override style declaration.
		///      </return>
		/// 		<short>    Introduced in DOM Level 2  This method is from the DocumentCSS interface </short>
		public DOM.CSSStyleDeclaration GetOverrideStyle(DOM.Element elt, DOM.DOMString pseudoElt) {
			return (DOM.CSSStyleDeclaration) interceptor.Invoke("getOverrideStyle##", "getOverrideStyle(const DOM::Element&, const DOM::DOMString&)", typeof(DOM.CSSStyleDeclaration), typeof(DOM.Element), elt, typeof(DOM.DOMString), pseudoElt);
		}
		/// <remarks>
		///  Introduced in DOM Level 3
		///  This method is from the DocumentLS interface
		///  Indicates whether the method DocumentLS.load() should be synchronous or
		///  asynchronous. When the async attribute is set to true the load method
		///  returns control to the caller before the document has completed loading.
		///  The default value of this attribute is true.
		///      </remarks>		<short>    Introduced in DOM Level 3  This method is from the DocumentLS interface </short>
		public bool Async() {
			return (bool) interceptor.Invoke("async", "async() const", typeof(bool));
		}
		/// <remarks>
		///  Introduced in DOM Level 3
		///  This method is from the DocumentLS interface
		///  see async
		/// </remarks>		<short>    Introduced in DOM Level 3  This method is from the DocumentLS interface </short>
		public void SetAsync(bool arg1) {
			interceptor.Invoke("setAsync$", "setAsync(bool)", typeof(void), typeof(bool), arg1);
		}
		/// <remarks>
		///  Introduced in DOM Level 3
		///  This method is from the DocumentLS interface
		///  If the document is currently being loaded as a result of the method load
		///  being invoked the loading and parsing is immediately aborted. The
		///  possibly partial result of parsing the document is discarded and the
		///  document is cleared.
		///      </remarks>		<short>    Introduced in DOM Level 3  This method is from the DocumentLS interface </short>
		public void Abort() {
			interceptor.Invoke("abort", "abort()", typeof(void));
		}
		/// <remarks>
		///  Introduced in DOM Level 3
		///  This method is from the DocumentLS interface
		///  Replaces the content of the document with the result of parsing the
		///  given URI. Invoking this method will either block the caller or return
		///  to the caller immediately depending on the value of the async attribute.
		///  Once the document is fully loaded a "load" event (as defined in
		///  [DOM Level 3 Events], except that the Event.targetNode will be the
		///  document, not an element) will be dispatched on the document. If an
		///  error occurs, an implementation dependent "error" event will be
		///  dispatched on the document. If this method is called on a document that
		///  is currently loading, the current load is interrupted and the new URI
		///  load is initiated.
		///  When invoking this method the parameters used in the DOMParser interface
		///  are assumed to have their default values with the exception that the
		///  parameters "entities", "normalize-characters",
		///  "check-character-normalization" are set to "false".
		///  The result of a call to this method is the same the result of a call to
		///  DOMParser.parseWithContext with an input stream referencing the URI that
		///  was passed to this call, the document as the context node, and the
		///  action ACTION_REPLACE_CHILDREN.
		/// <param> name="uri" of type DOMString
		///  The URI reference for the XML file to be loaded. If this is a relative
		///  URI, the base URI used by the implementation is implementation dependent.
		/// </param></remarks>		<return> If async is set to true load returns true if the document load
		///  was successfully initiated. If an error occurred when initiating the
		///  document load, load returns false.
		///  If async is set to false load returns true if the document was
		///  successfully loaded and parsed. If an error occurred when either loading
		///  or parsing the URI, load returns false.
		///      </return>
		/// 		<short>    Introduced in DOM Level 3  This method is from the DocumentLS interface </short>
		public void Load(DOM.DOMString uri) {
			interceptor.Invoke("load#", "load(const DOM::DOMString&)", typeof(void), typeof(DOM.DOMString), uri);
		}
		/// <remarks>
		///  Introduced in DOM Level 3
		///  This method is from the DocumentLS interface
		///  Replace the content of the document with the result of parsing the input
		///  string, this method is always synchronous. This method always parses
		///  from a DOMString, which means the data is always UTF-16. All other
		///  encoding information is ignored.
		///  The parameters used in the DOMParser interface are assumed to have their
		///  default values when invoking this method.
		///  The result of a call to this method is the same as the result of a call
		///  to DOMParser.parseWithContext with an input stream containing the string
		///  passed to this call, the document as the context node, and the action
		///  ACTION_REPLACE_CHILDREN.
		/// <param> name="source" A string containing an XML document.
		///      </param></remarks>		<short>    Introduced in DOM Level 3  This method is from the DocumentLS interface </short>
		public void LoadXML(DOM.DOMString source) {
			interceptor.Invoke("loadXML#", "loadXML(const DOM::DOMString&)", typeof(void), typeof(DOM.DOMString), source);
		}
		/// <remarks>
		///  not part of the official DOM
		///  Documents are read-only by default, but they can be made editable by
		///  entering "design mode".
		/// </remarks>		<return> whether this document is in design mode.
		///      </return>
		/// 		<short>    not part of the official DOM </short>
		public bool DesignMode() {
			return (bool) interceptor.Invoke("designMode", "designMode() const", typeof(bool));
		}
		/// <remarks>
		///  not part of the official DOM
		/// <param> name="enable" <code>true</code> to enable design mode, <code>false</code> to disable.
		/// </param></remarks>		<short>    not part of the official DOM </short>
		/// 		<see> designMode</see>
		public void SetDesignMode(bool enable) {
			interceptor.Invoke("setDesignMode$", "setDesignMode(bool)", typeof(void), typeof(bool), enable);
		}
		/// <remarks>
		///  not part of the DOM
		///  completes a given URL
		///      </remarks>		<short>    not part of the DOM </short>
		public DOM.DOMString CompleteURL(DOM.DOMString url) {
			return (DOM.DOMString) interceptor.Invoke("completeURL#", "completeURL(const DOM::DOMString&)", typeof(DOM.DOMString), typeof(DOM.DOMString), url);
		}
		public new DOM.DOMString ToString() {
			return (DOM.DOMString) interceptor.Invoke("toString", "toString() const", typeof(DOM.DOMString));
		}
		/// <remarks>
		///  not part of the DOM
		///  javascript editing command support
		///      </remarks>		<short>    not part of the DOM </short>
		public bool ExecCommand(DOM.DOMString command, bool userInterface, DOM.DOMString value) {
			return (bool) interceptor.Invoke("execCommand#$#", "execCommand(const DOM::DOMString&, bool, const DOM::DOMString&)", typeof(bool), typeof(DOM.DOMString), command, typeof(bool), userInterface, typeof(DOM.DOMString), value);
		}
		public bool QueryCommandEnabled(DOM.DOMString command) {
			return (bool) interceptor.Invoke("queryCommandEnabled#", "queryCommandEnabled(const DOM::DOMString&)", typeof(bool), typeof(DOM.DOMString), command);
		}
		public bool QueryCommandIndeterm(DOM.DOMString command) {
			return (bool) interceptor.Invoke("queryCommandIndeterm#", "queryCommandIndeterm(const DOM::DOMString&)", typeof(bool), typeof(DOM.DOMString), command);
		}
		public bool QueryCommandState(DOM.DOMString command) {
			return (bool) interceptor.Invoke("queryCommandState#", "queryCommandState(const DOM::DOMString&)", typeof(bool), typeof(DOM.DOMString), command);
		}
		public bool QueryCommandSupported(DOM.DOMString command) {
			return (bool) interceptor.Invoke("queryCommandSupported#", "queryCommandSupported(const DOM::DOMString&)", typeof(bool), typeof(DOM.DOMString), command);
		}
		public DOM.DOMString QueryCommandValue(DOM.DOMString command) {
			return (DOM.DOMString) interceptor.Invoke("queryCommandValue#", "queryCommandValue(const DOM::DOMString&)", typeof(DOM.DOMString), typeof(DOM.DOMString), command);
		}
		/// <remarks>
		///  not part of the DOM
		///  Updates the rendered display after one or more changes to
		///  the DOM structure
		///      </remarks>		<short>    not part of the DOM </short>
		public void UpdateRendering() {
			interceptor.Invoke("updateRendering", "updateRendering()", typeof(void));
		}
		~Document() {
			interceptor.Invoke("~Document", "~Document()", typeof(void));
		}
		public new void Dispose() {
			interceptor.Invoke("~Document", "~Document()", typeof(void));
		}
	}
}
