
#ifndef _K_SSL_SOCKET_H_
#define _K_SSL_SOCKET_H_

/*
    ksslsocket.h - KDE SSL Socket

    Copyright (c) 2004      by Jason Keirstead <jason@keirstead.org>

    Kopete    (c) 2002-2003 by the Kopete developers <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#include <QVariant>
#include <kextsock.h>
#include <kio/slavebase.h>

class KSSLSocketPrivate;

class KSSLSocket : public KExtendedSocket
{
	Q_OBJECT

	public:
		KSSLSocket();
		~KSSLSocket();

		Q_LONG read( char* data, Q_ULONG maxLen );
		Q_LONG write( const char* data, Q_ULONG len );

	signals:
		void sslFailure();

	private slots:
		void slotConnected();
		void slotDisconnected();

	private:
		int verifyCertificate();
		int messageBox( KIO::SlaveBase::MessageBoxType type, const QString &text,
			const QString &caption,	const QString &buttonYes, const QString &buttonNo );


		//Copied frm tcpslavebase to simply integrating their dialog function
		void setMetaData( const QString &, const QVariant & );
		bool hasMetaData( const QString & );
		QString metaData( const QString & );

		KSSLSocketPrivate *d;
};

#endif
