//////////////////////////////////////////////////////////////////////////////
// ShadowConfigurationUi.cpp
// -------------------
//
// Copyright (c) 2009 Hugo Pereira Da Costa <hugo.pereira@free.fr>
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
// IN THE SOFTWARE.
//////////////////////////////////////////////////////////////////////////////

#include "oxygenshadowconfigurationui.h"

#include <KLocale>
#include <QtGui/QLabel>
#include <QtGui/QLayout>

namespace Oxygen
{

  //_________________________________________________________
  ShadowConfigurationUi::ShadowConfigurationUi( QWidget* parent ):
    QGroupBox( parent )
  {
    ui.setupUi( this );

    // connections
    ui.outerColor->setEnabled( false );
    connect( ui.useOuterColor, SIGNAL( toggled( bool ) ), SLOT( enableOuterColor() ) );
    connect( this, SIGNAL( toggled( bool ) ), SLOT( enableOuterColor() ) );

    connect( ui.shadowSize, SIGNAL( valueChanged( int ) ), SIGNAL( changed() ) );
    connect( ui.verticalOffset, SIGNAL( valueChanged( int ) ), SIGNAL( changed() ) );
    connect( ui.innerColor, SIGNAL( changed( const QColor& ) ), SIGNAL( changed() ) );
    connect( ui.outerColor, SIGNAL( changed( const QColor& ) ), SIGNAL( changed() ) );
    connect( ui.useOuterColor, SIGNAL( toggled( bool ) ), SIGNAL( changed() ) );
  }

}
