/* This file is part of the KDE Project
   Copyright (c) 2008 Sebastian Trueg <trueg@kde.org>

   Based on code generated by dbusxml2cpp version 0.6
   dbusxml2cpp is Copyright (C) 2006 Trolltech ASA. All rights reserved.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License version 2 as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#include "strigiserviceadaptor.h"
#include "strigiservice.h"
#include "indexscheduler.h"

#include <QtCore/QUrl>
#include <QtCore/QDateTime>
#include <QtCore/QFile>
#include <QtCore/QDataStream>

#include <KDebug>


Nepomuk::StrigiServiceAdaptor::StrigiServiceAdaptor( StrigiService* parent )
    : QDBusAbstractAdaptor(parent),
      m_service( parent )
{
    connect( m_service, SIGNAL( statusStringChanged() ),
             this, SIGNAL( statusChanged() ) );
    connect( m_service->indexScheduler(), SIGNAL( indexingStarted() ),
             this, SIGNAL( indexingStarted() ) );
    connect( m_service->indexScheduler(), SIGNAL( indexingStopped() ),
             this, SIGNAL( indexingStopped() ) );
    connect( m_service->indexScheduler(), SIGNAL( indexingFolder(QString) ),
             this, SIGNAL( indexingFolder(QString) ) );
}


Nepomuk::StrigiServiceAdaptor::~StrigiServiceAdaptor()
{
}


bool Nepomuk::StrigiServiceAdaptor::isIndexing()
{
    // handle method call org.kde.nepomuk.Strigi.isIndexing
    return m_service->indexScheduler()->isIndexing();
}


bool Nepomuk::StrigiServiceAdaptor::isSuspended()
{
    // handle method call org.kde.nepomuk.Strigi.isSuspended
    return m_service->indexScheduler()->isSuspended();
}


QString Nepomuk::StrigiServiceAdaptor::currentFolder()
{
    return m_service->indexScheduler()->currentFolder();
}


void Nepomuk::StrigiServiceAdaptor::resume()
{
    // handle method call org.kde.nepomuk.Strigi.resume
    m_service->setSuspended( false );
}


void Nepomuk::StrigiServiceAdaptor::suspend()
{
    // handle method call org.kde.nepomuk.Strigi.suspend
    m_service->setSuspended( true );
}


void Nepomuk::StrigiServiceAdaptor::updateFolder( const QString& path )
{
    m_service->indexScheduler()->updateDir( path );
}


void Nepomuk::StrigiServiceAdaptor::updateAllFolders()
{
    m_service->indexScheduler()->updateAll();
}


void Nepomuk::StrigiServiceAdaptor::analyzeResource( const QString& uri, uint mTime, const QByteArray& data )
{
    QDataStream stream( data );
    m_service->indexScheduler()->analyzeResource( QUrl::fromEncoded( uri.toAscii() ), QDateTime::fromTime_t( mTime ), stream );
}


void Nepomuk::StrigiServiceAdaptor::analyzeResourceFromTempFileAndDeleteTempFile( const QString& uri, uint mTime, const QString& tmpFile )
{
    QFile file( tmpFile );
    if ( file.open( QIODevice::ReadOnly ) ) {
        QDataStream stream( &file );
        m_service->indexScheduler()->analyzeResource( QUrl::fromEncoded( uri.toAscii() ), QDateTime::fromTime_t( mTime ), stream );
        file.remove();
    }
    else {
        kDebug() << "Failed to open" << tmpFile;
    }
}


QString Nepomuk::StrigiServiceAdaptor::userStatusString() const
{
    return m_service->userStatusString();
}
