
#include "phpqt_internals.h"
#include "VirtualMethodCall.h"
#include "VirtualMethodReturnValue.h"

#include "marshall_types.h"

VirtualMethodCall::VirtualMethodCall(Smoke *smoke, const Smoke::Index meth, const Smoke::Stack stack, zval* obj, zval **sp) :
 	MethodCallBase( smoke, meth, stack, sp), _obj(obj)
{
  	_args = _smoke->argumentList + method().args;
}

VirtualMethodCall::~VirtualMethodCall()
{
}

Marshall::Action
VirtualMethodCall::action()
{
	return Marshall::ToZVAL;
}

zval*
VirtualMethodCall::var()
{
    return _sp[_cur];
}

const int
VirtualMethodCall::items()
{
	return method().numArgs;
}

void
VirtualMethodCall::callMethod()
{
	if (_called) return;
	_called = true;

	zval* retval = PHPQt::callPHPMethod(_obj, _smoke->methodNames[method().name], items(), _sp);
	VirtualMethodReturnValue r(_smoke, _method, _stack, retval);
//	efree( retval );
}

bool
VirtualMethodCall::cleanup()
{
	return false;
}
