# - Try to find the pciutils directory library
# Once done this will define
#
#  PCIUTILS_FOUND - system has PCIUtils
#  PCIUTILS_INCLUDE_DIR - the PCIUTILS include directory
#  PCIUTILS_LIBRARIES - The libraries needed to use PCIUtils

if(PCIUTILS_INCLUDE_DIR AND PCIUTILS_LIBRARIES)
   set(PCIUTILS_FIND_QUIETLY TRUE)
endif(PCIUTILS_INCLUDE_DIR AND PCIUTILS_LIBRARIES)

FIND_PATH(PCIUTILS_INCLUDE_DIR pci/pci.h)

FIND_LIBRARY(PCIUTILS_LIBRARY NAMES pci)
if(PCIUTILS_LIBRARY)
  FIND_LIBRARY(RESOLV_LIBRARY NAMES resolv)
  if(RESOLV_LIBRARY)
    set(PCIUTILS_LIBRARIES ${PCIUTILS_LIBRARY} ${RESOLV_LIBRARY})
  else(RESOLV_LIBRARY)
    set(PCIUTILS_LIBRARIES ${PCIUTILS_LIBRARY})
  endif(RESOLV_LIBRARY)
endif(PCIUTILS_LIBRARY)


include(FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(PCIUTILS DEFAULT_MSG PCIUTILS_LIBRARIES PCIUTILS_INCLUDE_DIR)

MARK_AS_ADVANCED(PCIUTILS_INCLUDE_DIR PCIUTILS_LIBRARIES)

