/***************************************************************************
                         main.cpp  -  description
                            -------------------
   begin                : Fre Nov 16 14:52:33 CET 2001
   copyright            : (C) 2001 by Matthias Messmer <bmlmessmer@web.de> &
                                     Carsten Niehaus <cniehaus@gmx.de> &
                                     Robert Gogolok <mail@robert-gogolok.de>

***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// KDE includes
#include <KCmdLineArgs>
#include <KAboutData>
#include <KLocale>
#include <KApplication>

// local includes
#include "kpercentage.h"

static const char description[] =
    I18N_NOOP( "A program to improve your skills in calculating with percentages" );

int main( int argc, char *argv[] )
{
    KAboutData aboutData
    (
        "kpercentage", 0,
        ki18n( "KPercentage" ),
        KPERCENTAGE_VERSION, ki18n(description), KAboutData::License_GPL,
        ki18n("(c) 2001-2007, Matthias Messmer"),
        KLocalizedString(), 0,
        "submit@bugs.kde.org"
    );
    aboutData.addAuthor( ki18n("Matthias Messmer"), ki18n( "coding, coding and coding" ), "bmlmessmer@web.de" );
    aboutData.addAuthor( ki18n("Carsten Niehaus"), ki18n( "CVS, coding and sed-script" ), "cniehaus@gmx.de" );
    aboutData.addAuthor( ki18n("Robert Gogolok"), ki18n( "CVS, coding and Makefile stuff" ), "mail@robert-gogolok.de" );
    aboutData.addCredit( ki18n("Elhay Achiam"), ki18n( "Pixmaps" ), "e_achiam@netvision.net.il" );
    aboutData.addCredit( ki18n("Danny Allen"), ki18n( "Pixmaps" ), "danny@dannyallen.co.uk" );
    aboutData.addCredit( ki18n("Jonathan Drews"), ki18n( "Spelling and Language" ), "j.e.drews@att.net" );
    aboutData.addCredit( ki18n("Primoz Anzur"), ki18n( "Cleaning and bugfixing code" ), "zerokode@gmx.net" );
    aboutData.addCredit( ki18n("David Vignoni"), ki18n("SVG icon"), "david80v@tin.it" );

    KCmdLineArgs::init( argc, argv, &aboutData );

    KCmdLineOptions options;
    KCmdLineArgs::addCmdLineOptions( options ); // Add our own options.

    KApplication a;
    KPercentage *kpercentage = new KPercentage( "kpercentage" );
    kpercentage->resize( 550, 250 );
    kpercentage->setMinimumSize( 550, 250 );
    QObject::connect(kapp, SIGNAL(lastWindowClosed()), kapp, SLOT(quit()));

    /*
     * no window is shown here, cause constructor of KPercentage shows
     * splash screen first, then the main window is shown.
     */

    return a.exec();
}
