/* This file is part of KGraphViewer.
   Copyright (C) 2005-2007 Gael de Chalendar <kleag@free.fr>

   KGraphViewer is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation, version 2.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
   02110-1301, USA
*/

/* This file was callgraphview.cpp, part of KCachegrind.
   Copyright (C) 2003 Josef Weidendorfer <Josef.Weidendorfer@gmx.de>

   KCachegrind is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation, version 2.
*/


#include "graphexporter.h"
#include "dotgraph.h"

#include <QFile>
#include <QTextStream>

#include <kdebug.h>
#include <ktemporaryfile.h>
#include <kapplication.h>

GraphExporter::GraphExporter()
{
}

GraphExporter::~GraphExporter()
{
}

QString GraphExporter::writeDot(const DotGraph* graph, const QString& fileName)
{
  kDebug() << fileName;

  QString actualFileName = fileName;

  if (fileName.isEmpty())
  {
    KTemporaryFile tempFile;
    tempFile.setSuffix(".dot");
    if (!tempFile.open()) 
    {
      kError() << "Unable to open for temp file for writing " << tempFile.name() << endl;
      exit(2);
    }
    actualFileName = tempFile.name();
    kDebug() << "using " << actualFileName;
  }
  
  QFile f(actualFileName);
  if (!f.open(QIODevice::WriteOnly | QIODevice::Text))
  {
    kError() << "Unable to open file for writing " << fileName << endl;
    exit(2);
  }
  
  QTextStream stream(&f);

  stream << "digraph \"";
  if (graph->id()!="\"\"")
  {
    stream <<graph->id();
  }
  stream <<"\" {\n";

  stream << "graph [" << *graph <<"]" << endl;

  /// @TODO Subgraph are not represented as needed in DotGraph, so it is not
  /// possible to save them back : to be changed !
  kDebug() << "writing subgraphs";
  GraphSubgraphMap::const_iterator sit;
  for ( sit = graph->subgraphs().begin();
  sit != graph->subgraphs().end(); ++sit )
  {
    const GraphSubgraph& s = **sit;
    (stream) << s;
  }

  kDebug() << "writing nodes";
  GraphNodeMap::const_iterator nit;
  for ( nit = graph->nodes().begin();
        nit != graph->nodes().end(); ++nit )
  {
    (stream) << **nit;
  }

  kDebug() << "writing edges";
  GraphEdgeMap::const_iterator eit;
  for ( eit = graph->edges().begin();
        eit != graph->edges().end(); ++eit )
  {
    kDebug() << "writing edge" << (*eit)->id();
    stream << **eit;
  }

  stream << "}\n";

  f.close();
  return actualFileName;
}

