import org.kde.qt.*;

public class Tut8 extends QWidget {
	public Tut8() {
		QPushButton quit = new QPushButton("Quit", this, "quit");
		quit.setFont(new QFont("Times", 18, QFont.Bold, false));

		connect(quit, SIGNAL("clicked()"), qApp(), SLOT("quit()"));

		LCDRange angle = new LCDRange(this, "angle");
		angle.setRange(5, 70);

		CannonField cannonField = new CannonField(this, "cannonField");

		connect(angle, SIGNAL("valueChanged(int)"),
						cannonField, SLOT("setAngle(int)"));
		connect(cannonField, SIGNAL("angleChanged(int)"),
						angle, SLOT("setValue(int)"));

		QGridLayout grid = new QGridLayout(this, 2, 2, 10, -1, null);
		//2x2, 10 pixel border

		grid.addWidget(quit, 0, 0);
		grid.addWidget(angle, 1, 0, Qt.AlignTop);
		grid.addWidget(cannonField, 1, 1);
		grid.setColStretch(1, 10);

		angle.setValue(60);
		angle.setFocus();
	}
	
	public static void main(String[] args) {
		QApplication a = new QApplication(args);
		Tut8 w = new Tut8();
		w.setGeometry( 100, 100, 500, 355 );
		
		a.setMainWidget(w);
		w.show();
		a.exec();
		return;
	}
	
	static {
		try {
			Class c = Class.forName("org.kde.qt.qtjava");
		} catch (Exception e) {
			e.printStackTrace();
			System.out.println("Can't load qtjava class");
		}
	}
}
