//Auto-generated by kalyptus. DO NOT EDIT.
package org.kde.koala;

import org.kde.qt.Qt;
import org.kde.qt.QtSupport;
import org.kde.qt.QPixmap;
import org.kde.qt.QImage;
import org.kde.qt.QPixmap;

/**

 Off-screen paint device with extended features.
 KPixmap has two new color modes, WebColor and LowColor, applicable
 to 8bpp displays.
 In WebColor mode all images are dithered to the Netscape palette,
 even when they have their own color table. WebColor is the default
 mode for KPixmap so that standard applications can share the Netscape
 palette across the desktop.
 In LowColor mode images are checked to see if their color table
 matches the KDE icon palette. If the color tables do not match, the
 images are dithered to a minimal 3x3x3 color cube. LowColor mode can
 be used to load icons, background images etc. so that components of
 the desktop which are always present use no more than 40 colors.
		@author Mark Donohoe (donohoe@kde.org)

		@version $Id: KPixmap.java 473384 2005-10-23 14:17:09Z rdale $
 
		@short    Off-screen paint device with extended features.

*/
public class KPixmap extends QPixmap  {
	protected KPixmap(Class dummy){super((Class) null);}
	/**	
		 This enumeration provides a color pallete specification
				@short    This enumeration provides a color pallete specification 
		@see KPixmap#convertFromImage
		@see KPixmap#load
	*/
	public static final int Auto = 0;
	public static final int Color = 1;
	public static final int Mono = 2;
	public static final int LowColor = 3;
	public static final int WebColor = 4;

	/**	
		 This enumeration provides a gradient mode specification
			 		@short    This enumeration provides a gradient mode specification
	*/
	public static final int Horizontal = 0;
	public static final int Vertical = 1;
	public static final int Diagonal = 2;
	public static final int CrossDiagonal = 3;

	/**	
		 Constructs a null pixmap.
			 		@short    Constructs a null pixmap.
	*/
	public KPixmap() {
		super((Class) null);
		newKPixmap();
	}
	private native void newKPixmap();
	/**	
		 Copies the QPixmap <code>pix.</code>
		         		@short    Copies the QPixmap <code>pix.</code>
	*/
	public KPixmap(QPixmap pix) {
		super((Class) null);
		newKPixmap(pix);
	}
	private native void newKPixmap(QPixmap pix);
	/**	
		 Converts an image and sets this pixmap.
			 The conversion_flags argument is a bitwise-OR from the
		 following choices. The options marked (default) are the
		 choice if no other choice from the list is included (they
		 are zero):
			 Color/Mono preference
		
			<li>
			WebColor -  If the image has depth 1 and contains
			 only black and white pixels then the pixmap becomes monochrome. If
			 the pixmap has a depth of 8 bits per pixel then the Netscape
			 palette is used for the pixmap color table.
			</li>
			
			<li>
			LowColor - If the image has depth 1 and contains only black and
			 white pixels then the pixmap becomes monochrome. If the pixmap has a
			 depth of 8 bits per pixel and the image does not posess a color table
			 that matches the Icon palette a 3x3x3 color cube is used for the
			 pixmap color table.
			</li>
			
			<li>
			AutoColor (default) - If the image has depth 1 and contains
			 only black and white pixels, then the pixmap becomes
			 monochrome.
			</li>
			
			<li>
			ColorOnly - The pixmap is dithered/converted to the native
			 display depth.
			</li>
			
			<li>
			MonoOnly - The pixmap becomes monochrome. If necessary, it
			 is dithered using the chosen dithering algorithm.
			</li>
				 Dithering mode preference, for RGB channels
		
			<li>
			DiffuseDither (default) - A high quality dither.
			</li>
			
			<li>
			OrderedDither - A faster more ordered dither.
			</li>
			
			<li>
			ThresholdDither - No dithering, closest color is used.
			</li>
				 Dithering mode preference, for alpha channel
		
			<li>
			DiffuseAlphaDither - A high quality dither.
			</li>
			
			<li>
			OrderedAlphaDither - A faster more ordered dither.
			</li>
			
			<li>
			ThresholdAlphaDither (default) - No dithering.
			</li>
				 Color matching versus dithering preference
		
			<li>
			PreferDither - Always dither 32-bit images when the image
			 is being converted to 8-bits. This is the default when
			 converting to a pixmap.
			</li>
			
			<li>
			AvoidDither - Only dither 32-bit images if the image has
			 more than 256 colors and it is being converted to 8-bits.
			 This is the default when an image is converted for the
			 purpose of saving to a file.
			</li>
				 Passing 0 for <code>conversion_flags</code> gives all the default
		 options.
			@param img the image to convert
			@param conversion_flags bitmask, described above
				@return <code>true</code> if successful.

		@short    Converts an image and sets this pixmap.
	*/
	public native boolean convertFromImage(QImage img, int conversion_flags);
	public native boolean convertFromImage(QImage img);
	/**	
		 Loads a pixmap from the file <code>fileName.</code>
			 If format is specified, the loader attempts to read the
		 pixmap using the specified format. If format is not
		 specified (default), the loader reads a few bytes from the
		 header to guess the file format.
			 The QImageIO documentation lists the supported image
		 formats and explains how to add extra formats.
			@param fileName the name of the file to load the image from
			@param format the format for the image
			@param conversion_flags a bitmask, as described in 
		        convertFromImage()
				@return <code>true</code> if successful, or false if the pixmap
         could not be loaded.

		@short    Loads a pixmap from the file <code>fileName.</code>
	*/
	public native boolean load(String fileName, String format, int conversion_flags);
	public native boolean load(String fileName, String format);
	public native boolean load(String fileName);
	/**	
		 Returns true if the image posesses a color table that
		 matches the Icon palette or false otherwise.
			 An image with one color not found in the Icon palette is
		 considered to be a match, since this extra color may be a
		 transparent background.
			@param image the image to test
				@short    Returns true if the image posesses a color table that  matches the Icon palette or false otherwise.
	*/
	public native boolean checkColorTable(QImage image);
	/** Deletes the wrapped C++ instance */
	protected native void finalize() throws InternalError;
	/** Delete the wrapped C++ instance ahead of finalize() */
	public native void dispose();
	/** Has the wrapped C++ instance been deleted? */
	public native boolean isDisposed();
}
