//Auto-generated by kalyptus. DO NOT EDIT.
package org.kde.koala;

import org.kde.qt.Qt;
import org.kde.qt.QColor;
import org.kde.qt.QMetaObject;
import org.kde.qt.QtSupport;
import org.kde.qt.QPaintEvent;
import org.kde.qt.QSize;
import org.kde.qt.QWidget;
import org.kde.qt.QWidget;

/**

 Displays a round  or rectangular light emitting diode.
 It is configurable to five colors, the two on/off states and three
 styles (or "looks");
 It may display itself in a performant flat view, a round view with
 light spot or a round view sunken in the screen.
 \image html kled.png "KDE LED Widget"
		@author Joerg Habenicht, Richard J. Moore (rich@kde.org) 1998, 1999
 
		@short An LED widget.

*/
public class KLed extends QWidget  {
	protected KLed(Class dummy){super((Class) null);}
	/**	
		 Status of the light is on/off.
				@short LED on/off.
	*/
	public static final int Off = 0;
	public static final int On = 1;

	/**	
		 Shades of the lamp.
				@short LED shape.
	*/
	public static final int Rectangular = 0;
	public static final int Circular = 1;

	/**	
		 Displays a flat, round or sunken LED.
			 Displaying the LED flat is less time and color consuming,
		 but not so nice to see.
			 The sunken LED itself is (certainly) smaller than the round LED
		 because of the 3 shading circles and is
		 most time consuming. Makes sense for LED > 15x15 pixels.
			 <b></b>imings: \n
		 ( AMD K5/133, Diamond Stealth 64 PCI Graphics, widgetsize 29x29 )
		
			<li>
			flat Approximately 0.7 msec per paint
			</li>
			
			<li>
			round Approximately 2.9 msec per paint
			</li>
			
			<li>
			sunken Approximately 3.3 msec per paint
			</li>
				 The widget will be updated on the next repaining event.
				@short LED look.
	*/
	public static final int Flat = 0;
	public static final int Raised = 1;
	public static final int Sunken = 2;

	public native QMetaObject metaObject();
	public native String className();
	/**	
		 Constructs a green, round LED widget which will initially
		 be turned on.
		   		@short    Constructs a green, round LED widget which will initially  be turned on.
	*/
	public KLed(QWidget parent, String name) {
		super((Class) null);
		newKLed(parent,name);
	}
	private native void newKLed(QWidget parent, String name);
	public KLed(QWidget parent) {
		super((Class) null);
		newKLed(parent);
	}
	private native void newKLed(QWidget parent);
	public KLed() {
		super((Class) null);
		newKLed();
	}
	private native void newKLed();
	/**	
		 Constructor with the ledcolor, the parent widget, and the name.
			 The State will be defaulted On and the Look round.
			@param col Initial color of the LED.
			@param parent Will be handed over to QWidget.
			@param name Will be handed over to QWidget.
				@short Constructor.
	*/
	public KLed(QColor col, QWidget parent, String name) {
		super((Class) null);
		newKLed(col,parent,name);
	}
	private native void newKLed(QColor col, QWidget parent, String name);
	public KLed(QColor col, QWidget parent) {
		super((Class) null);
		newKLed(col,parent);
	}
	private native void newKLed(QColor col, QWidget parent);
	public KLed(QColor col) {
		super((Class) null);
		newKLed(col);
	}
	private native void newKLed(QColor col);
	/**	
		 Constructor with the ledcolor, ledstate, ledlook,
		 the parent widget, and the name.
			 Differs from above only in the parameters, which configure all settings.
			@param col Initial color of the LED.
			@param state Sets the State.
			@param look Sets the Look.
			@param shape Sets the Shape (rectangular or circular)
			@param parent Will be handed over to QWidget.
			@param name Will be handed over to QWidget.
				@short Constructor.
	*/
	public KLed(QColor col, int state, int look, int shape, QWidget parent, String name) {
		super((Class) null);
		newKLed(col,state,look,shape,parent,name);
	}
	private native void newKLed(QColor col, int state, int look, int shape, QWidget parent, String name);
	public KLed(QColor col, int state, int look, int shape, QWidget parent) {
		super((Class) null);
		newKLed(col,state,look,shape,parent);
	}
	private native void newKLed(QColor col, int state, int look, int shape, QWidget parent);
	public KLed(QColor col, int state, int look, int shape) {
		super((Class) null);
		newKLed(col,state,look,shape);
	}
	private native void newKLed(QColor col, int state, int look, int shape);
	/**	
		 Returns the current state of the widget (on/off).
				@short Returns LED state.    
		@see State
	*/
	public native int state();
	public native int shape();
	/**	
		 Returns the color of the widget
				@short Returns LED color.    
		@see Color
	*/
	public native QColor color();
	/**	
		 Returns the look of the widget.
				@short Returns LED look.    
		@see Look
	*/
	public native int look();
	/**	
		 Returns the factor to darken the LED.
				@short Returns dark factor.
		@see #setDarkFactor
	*/
	public native int darkFactor();
	/**	
		 Sets the state of the widget to On or Off.
			 The widget will be painted immediately.
			@param state The LED state: on or off.
				@short Set LED state.    
		@see #on
		@see #off
		@see #toggle
		@see #toggleState
	*/
	public native void setState(int state);
	/**	
		 Set the shape of the LED to <code>s.</code>
		   		@short    Set the shape of the LED to <code>s.</code>
	*/
	public native void setShape(int s);
	/**	
		 Set the color of the widget.
		 The Color is shown with the KLed.On state.
		 The KLed.Off state is shown with QColor.dark() method
			 The widget calls the update() method, so it will
		 be updated when entering the main event loop.
			@param color New color of the LED.
				@short Sets the LED color.    
		@see Color
	*/
	public native void setColor(QColor color);
	/**	
		 Sets the factor to darken the LED in OFF state.
		 Same as QColor.dark().
		 "darkfactor should be greater than 100, else the LED gets lighter
		 in OFF state.
		 Defaults to 300.
			@param darkfactor sets the factor to darken the LED.
				@short sets the factor to darken the LED.    
		@see org.kde.qt.QColor
	*/
	public native void setDarkFactor(int darkfactor);
	/**	
		 Sets the look of the widget.
			 The look may be flat, round or sunken.
		 The widget calls the update() method, so it will
		 be updated when entering the main event loop.
			@param look New look of the LED.
				@short Sets LED look.    
		@see Look
	*/
	public native void setLook(int look);
	public native QSize sizeHint();
	public native QSize minimumSizeHint();
	/**	
		 Toggles the state of the led from Off to On or vice versa.
			 The widget repaints itself immediately.
		   		@short    Toggles the state of the led from Off to On or vice versa.
	*/
	public native void toggle();
	/**	
		 Sets the state of the widget to On.
			 The widget will be painted immediately.
				@short    Sets the state of the widget to On.
		@see #off
		@see #toggle
		@see #toggleState
		@see #setState
	*/
	public native void on();
	/**	
		 Sets the state of the widget to Off.
			 The widget will be painted immediately.
				@short    Sets the state of the widget to Off.
		@see #on
		@see #toggle
		@see #toggleState
		@see #setState
	*/
	public native void off();
	/**	
		 Paints a circular, flat LED.
		   		@short    Paints a circular, flat LED.
	*/
	protected native void paintFlat();
	/**	
		 Paints a circular, raised LED.
		   		@short    Paints a circular, raised LED.
	*/
	protected native void paintRound();
	/**	
		 Paints a circular, sunken LED.
		   		@short    Paints a circular, sunken LED.
	*/
	protected native void paintSunken();
	/**	
		 Paints a rectangular, flat LED.
		   		@short    Paints a rectangular, flat LED.
	*/
	protected native void paintRect();
	/**	
		 Paints a rectangular LED, either raised or
		 sunken, depending on its argument.
		   		@short    Paints a rectangular LED, either raised or  sunken, depending on its argument.
	*/
	protected native void paintRectFrame(boolean raised);
	protected native void paintEvent(QPaintEvent arg1);
	/**	
		 Compute LED width
		   		@short    Compute LED width
	*/
	protected native int ensureRoundLed();
	/**	
		 Paint the cached antialiased pixmap corresponding to the state if any
				@return true if the pixmap was painted, false if it hasn't been created yet
   
		@short    Paint the cached antialiased pixmap corresponding to the state if any
	*/
	protected native boolean paintCachedPixmap();
	/** Deletes the wrapped C++ instance */
	protected native void finalize() throws InternalError;
	/** Delete the wrapped C++ instance ahead of finalize() */
	public native void dispose();
	/** Has the wrapped C++ instance been deleted? */
	public native boolean isDisposed();
}
