/*
Copyright (c) 2000 Simon Hausmann <hausmann@kde.org>
Copyright (c) 2000 Lars Knoll <knoll@kde.org>
Copyright (c) 1999 Preston Brown <pbrown@kde.org>
Copyright (c) 1999, 2000 Matthias Ettrich <ettrich@kde.org>

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#ifndef __dcopc_dcopobject_h__
#define __dcopc_dcopobject_h__

#ifdef __cplusplus
extern "C" {
#endif

#include <X11/ICE/ICElib.h>

#include <dcopc/marshal.h>
#include <dcopc/util.h>

#include <gtk/gtk.h>

#define DCOP_TYPE_OBJECT             (dcop_object_get_type())
#define DCOP_OBJECT(obj)             GTK_CHECK_CAST((obj), DCOP_TYPE_OBJECT, DcopObject)
#define DCOP_OBJECT_CLASS(klass)     GTK_CHECK_CLASS_CAST((klass), DCOP_TYPE_OBJECT, DcopObjectClass)
#define DCOP_IS_OBJECT(obj)          GTK_CHECK_TYPE((obj), DCOP_TYPE_OBJECT)
#define DCOP_IS_OBJECT_CLASS(klass)  GTK_CHECK_CLASS_TYPE((klass), DCOP_TYPE_OBJECT)
#define DCOP_ID(obj) (dcop_object_get_id(obj))

typedef struct _DcopObject DcopObject;
typedef struct _DcopObjectClass DcopObjectClass;

struct _DcopObject
{
    GtkObject obj;
    void *data;
};

struct _DcopObjectClass
{
    GtkObjectClass parent_class;

    gboolean (*process) ( DcopObject *obj, const gchar *fun, dcop_data *data,
                          gchar **reply_type, dcop_data **reply_data );
    gboolean (*process_dynamic) ( DcopObject *obj, const gchar *fun, dcop_data *data,
                                  gchar **reply_type, dcop_data **reply_data );

    GList *(*functions) ( DcopObject *obj );
    GList *(*interfaces) ( DcopObject *obj );
};

GtkType dcop_object_get_type(void);

DcopObject *dcop_object_new( void );

void dcop_object_set_id( DcopObject *obj, const gchar *id );
const gchar *dcop_object_get_id( DcopObject *obj);

gboolean dcop_object_process( DcopObject *obj, const gchar *fun, dcop_data *data,
                              gchar **reply_type, dcop_data **reply_data );

gboolean dcop_object_process_dynamic( DcopObject *obj, const gchar *fun, dcop_data *data,
                                      gchar **reply_type, dcop_data **reply_data );

GList *dcop_object_functions( DcopObject *obj );

GList *dcop_object_interfaces( DcopObject *obj );

DcopObject *dcop_object_lookup( const gchar *name );

GList *dcop_object_match( const gchar *partial_id );

#ifdef __cplusplus
}
#endif

#endif
