import org.kde.qt.*;

public class LCDRange extends QVBox {
	private QSlider slider;
	
	public LCDRange(QWidget parent, String name) {
		super(parent, name);
		QLCDNumber lcd = new QLCDNumber(2, this, "lcd");
		slider = new QSlider(Horizontal, this, "slider");
		slider.setRange(0, 99);
		slider.setValue(0);
		
		connect(slider, SIGNAL("valueChanged(int)"),
						lcd, SLOT("display(int)"));
		connect(slider, SIGNAL("valueChanged(int)"),
						SIGNAL("valueChanged(int)"));
	}
	public LCDRange(QWidget parent) {
		this(parent, null);
	}

	public int value() {
		return slider.value();
	}

	public void setValue(int value) {
		slider.setValue(value);
	}
}
