
#include "|NAMELITTLE|.h"
#include "filesave.xpm"
#include "fileopen.xpm"
#include "filenew.xpm"

|NAME|::|NAME|() : QextMdiMainFrm(0),
  m_currentNumber(1)
{
  setCaption("|NAME| ");
  
  ///////////////////////////////////////////////////////////////////
  // call inits to invoke all other construction parts
  initMenuBar();
  initToolBar();
  initStatusBar();

  initDoc();
  initView();
}

|NAME|::~|NAME|()
{
}

void |NAME|::initMenuBar()
{
  ///////////////////////////////////////////////////////////////////
  // MENUBAR

  ///////////////////////////////////////////////////////////////////
  // menuBar entry fileMenu

  fileMenu=new QPopupMenu();
  fileMenu->insertItem("&New", this, SLOT(slotFileNew()), CTRL+Key_N, ID_FILE_NEW);
  fileMenu->insertItem("&Open...", this, SLOT(slotFileOpen()), CTRL+Key_O, ID_FILE_OPEN);
  fileMenu->insertSeparator();
  fileMenu->insertItem("&Save", this, SLOT(slotFileSave()), CTRL+Key_S, ID_FILE_SAVE);
  fileMenu->insertItem("Save &as...", this, SLOT(slotFileSaveAs()), 0, ID_FILE_SAVE_AS);
  fileMenu->insertItem("&Close", this, SLOT(slotFileClose()), CTRL+Key_W, ID_FILE_CLOSE);
  fileMenu->insertSeparator();
  fileMenu->insertItem("&Print", this, SLOT(slotFilePrint()), CTRL+Key_P, ID_FILE_PRINT);
  fileMenu->insertSeparator();
  fileMenu->insertItem("E&xit", this, SLOT(slotFileQuit()), CTRL+Key_Q, ID_FILE_QUIT);

  ///////////////////////////////////////////////////////////////////
  // menuBar entry editMenu
  editMenu=new QPopupMenu();
  editMenu->insertItem("Cu&t", this, SLOT(slotEditCut()), CTRL+Key_X, ID_EDIT_CUT);
  editMenu->insertItem("&Copy", this, SLOT(slotEditCopy()), CTRL+Key_C, ID_EDIT_COPY);
  editMenu->insertItem("&Paste", this, SLOT(slotEditPaste()), CTRL+Key_V, ID_EDIT_PASTE);
 
  
  ///////////////////////////////////////////////////////////////////
  // menuBar entry viewMenu
  viewMenu=new QPopupMenu();
  viewMenu->setCheckable(true);
  viewMenu->insertItem("&Toolbar", this, SLOT(slotViewToolBar()), 0, ID_VIEW_TOOLBAR);
  viewMenu->insertItem("&Statusbar", this, SLOT(slotViewStatusBar()), 0, ID_VIEW_STATUSBAR);
  viewMenu->insertItem("T&askbar", this, SLOT(slotViewTaskBar()), 0, ID_VIEW_TASKBAR);

  viewMenu->setItemChecked(ID_VIEW_TOOLBAR, true);
  viewMenu->setItemChecked(ID_VIEW_STATUSBAR, true);
  viewMenu->setItemChecked(ID_VIEW_TASKBAR, true);

  ///////////////////////////////////////////////////////////////////
  // EDIT YOUR APPLICATION SPECIFIC MENUENTRIES HERE
  
  ///////////////////////////////////////////////////////////////////
  // menuBar entry helpMenu
  helpMenu=new QPopupMenu();
  helpMenu->insertItem("About...", this, SLOT(slotHelpAbout()), 0, ID_HELP_ABOUT);


  ///////////////////////////////////////////////////////////////////
  // MENUBAR CONFIGURATION
  // set menuBar() the current menuBar 

  menuBar()->insertItem("&File", fileMenu);
  menuBar()->insertItem("&Edit", editMenu);
  menuBar()->insertItem("&View", viewMenu);
  menuBar()->insertItem("&Window", windowMenu());
  //menuBar()->insertSeparator();
  menuBar()->insertItem("&Help", helpMenu);
  
  ///////////////////////////////////////////////////////////////////
  // CONNECT THE SUBMENU SLOTS WITH SIGNALS

  QObject::connect(fileMenu, SIGNAL(highlighted(int)), SLOT(statusCallback(int)));
  QObject::connect(editMenu, SIGNAL(highlighted(int)), SLOT(statusCallback(int)));
  QObject::connect(viewMenu, SIGNAL(highlighted(int)), SLOT(statusCallback(int)));
  QObject::connect(helpMenu, SIGNAL(highlighted(int)), SLOT(statusCallback(int)));

  setMenuForSDIModeSysButtons( menuBar());
}

void |NAME|::initToolBar()
{
  ///////////////////////////////////////////////////////////////////
  // TOOLBAR
  QPixmap openIcon, saveIcon, newIcon;

  fileToolbar = new QToolBar(this, "file operations");
 
  newIcon = QPixmap(filenew);
  QToolButton *fileNew = new QToolButton(newIcon, "New File", 0, this,
                                         SLOT(slotFileNew()), fileToolbar);

  openIcon = QPixmap(fileopen);
  QToolButton *fileOpen = new QToolButton(openIcon, "Open File", 0, this,
                                          SLOT(slotFileOpen()), fileToolbar);

  saveIcon = QPixmap(filesave);
  QToolButton *fileSave = new QToolButton(saveIcon, "Save File", 0, this,
                                          SLOT(slotFileSave()), fileToolbar);

	QLabel *space = new QLabel( fileToolbar, "space");
	space->setText("");
	fileToolbar->setStretchableWidget(space);
  
  fileToolbar->addSeparator();
  QWhatsThis::whatsThisButton(fileToolbar);
  QWhatsThis::add(fileNew,"Click this button to create a new file.\n\n"
                  "You can also select the New command from the File menu.");
  QWhatsThis::add(fileOpen,"Click this button to open a new file.\n\n"
                  "You can also select the Open command from the File menu.");
  QWhatsThis::add(fileSave,"Click this button to save the file you are "
                  "editing. You will be prompted for a file name.\n\n"
                  "You can also select the Save command from the File menu.");
}

void |NAME|::initStatusBar()
{
  ///////////////////////////////////////////////////////////////////
  //STATUSBAR
  statusBar()->message(IDS_STATUS_DEFAULT, 2000);
}

void |NAME|::initDoc()
{
	///////////////////////////////////////////////////////////////////
	// set an example doc here
  doc=new |NAME|Doc();
}

void |NAME|::initView()
{ 
  ////////////////////////////////////////////////////////////////////
  // set an example MDI widget here
  view=new |NAME|View(this, doc);
  view->resize(400,400);
  addWindow( view);
}

bool |NAME|::queryExit()
{
  int exit=QMessageBox::information(this, "Quit...",
                                    "Do your really want to quit?",
                                    QMessageBox::Ok, QMessageBox::Cancel);

  if (exit==1)
  {

  }
  else
  {

  };

  return (exit==1);
}

/////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATION
/////////////////////////////////////////////////////////////////////


void |NAME|::slotFileNew()
{
  statusBar()->message("Creating new file...");

	// !This example framework doesn't control doc and view pointers!
	// but pressing the close button will already delete pView...
  	|NAME|Doc* pDoc = new |NAME|Doc();
	QString numberString;
	numberString.setNum( m_currentNumber++);
  	|NAME|View* pView = new |NAME|View(this, pDoc, "Document" + numberString);
	pView->resize(400,400);
	addWindow( pView);

  statusBar()->message(IDS_STATUS_DEFAULT);
}

void |NAME|::slotFileOpen()
{
  statusBar()->message("Opening file...");

  QString fileName = QFileDialog::getOpenFileName(0,0,this);
  if (!fileName.isEmpty())
  {
    doc->load(fileName);
    setCaption(fileName);
    QString message="Loaded document: "+fileName;
    statusBar()->message(message, 2000);
  }
  else
  {
    statusBar()->message("Opening aborted", 2000);
  }
}


void |NAME|::slotFileSave()
{
  statusBar()->message("Saving file...");
  doc->save();
  statusBar()->message(IDS_STATUS_DEFAULT);
}

void |NAME|::slotFileSaveAs()
{
  statusBar()->message("Saving file under new filename...");
  QString fn = QFileDialog::getSaveFileName(0, 0, this);
  if (!fn.isEmpty())
  {
    doc->saveAs(fn);
  }
  else
  {
    statusBar()->message("Saving aborted", 2000);
  }

  statusBar()->message(IDS_STATUS_DEFAULT);
}

void |NAME|::slotFileClose()
{
  statusBar()->message("Closing file...");

  statusBar()->message(IDS_STATUS_DEFAULT);
}

void |NAME|::slotFilePrint()
{
  statusBar()->message("Printing...");
  QPrinter printer;
  if (printer.setup(this))
  {
    QPainter painter;
    painter.begin(&printer);

    ///////////////////////////////////////////////////////////////////
    // TODO: Define printing by using the QPainter methods here

    painter.end();
  };

  statusBar()->message(IDS_STATUS_DEFAULT);
}

void |NAME|::slotFileQuit()
{ 
  statusBar()->message("Exiting application...");
  ///////////////////////////////////////////////////////////////////
  // exits the Application
  if(doc->isModified())
  {
    if(queryExit())
    {
      qApp->quit();
    }
    else
    {

    };
  }
  else
  {
    qApp->quit();
  };

  statusBar()->message(IDS_STATUS_DEFAULT);
}

void |NAME|::slotEditCut()
{
  statusBar()->message("Cutting selection...");

  statusBar()->message(IDS_STATUS_DEFAULT);
}

void |NAME|::slotEditCopy()
{
  statusBar()->message("Copying selection to clipboard...");
  
  statusBar()->message(IDS_STATUS_DEFAULT);
}

void |NAME|::slotEditPaste()
{
  statusBar()->message("Inserting clipboard contents...");
  
  statusBar()->message(IDS_STATUS_DEFAULT);
}


void |NAME|::slotViewToolBar()
{
  statusBar()->message("Toggle toolbar...");
  ///////////////////////////////////////////////////////////////////
  // turn toolbar on or off
  
  if (fileToolbar->isVisible())
  {
    fileToolbar->hide();
    viewMenu->setItemChecked(ID_VIEW_TOOLBAR, false);
  } 
  else
  {
    fileToolbar->show();
    viewMenu->setItemChecked(ID_VIEW_TOOLBAR, true);
  };

  statusBar()->message(IDS_STATUS_DEFAULT);
}

void |NAME|::slotViewStatusBar()
{
  statusBar()->message("Toggle statusbar...");
  ///////////////////////////////////////////////////////////////////
  //turn statusbar on or off
  
  if (statusBar()->isVisible())
  {
    statusBar()->hide();
    viewMenu->setItemChecked(ID_VIEW_STATUSBAR, false);
  }
  else
  {
    statusBar()->show();
    viewMenu->setItemChecked(ID_VIEW_STATUSBAR, true);
  }
  
  statusBar()->message(IDS_STATUS_DEFAULT);
}

void |NAME|::slotViewTaskBar()
{
  statusBar()->message("Toggle taskbar...");
  ///////////////////////////////////////////////////////////////////
  //turn statusbar on or off

  if (m_pTaskBar->isVisible())
  {
    hideViewTaskBar();
    viewMenu->setItemChecked(ID_VIEW_TASKBAR, false);
  }
  else
  {
    showViewTaskBar();
    viewMenu->setItemChecked(ID_VIEW_TASKBAR, true);
  }

  statusBar()->message(IDS_STATUS_DEFAULT);
}

void |NAME|::slotHelpAbout()
{
  QMessageBox::about(this,"About...",
                     IDS_APP_ABOUT );
}

void |NAME|::slotStatusHelpMsg(const QString &text)
{
  ///////////////////////////////////////////////////////////////////
  // change status message of whole statusbar temporary (text, msec)
  statusBar()->message(text, 2000);
}

void |NAME|::statusCallback(int id_)
{
  switch (id_)
  {
    case ID_FILE_NEW:
         slotStatusHelpMsg("Creates a new document");
         break;

    case ID_FILE_OPEN:
         slotStatusHelpMsg("Opens an existing document");
         break;

    case ID_FILE_SAVE:
         slotStatusHelpMsg("Saves the actual document");
         break;

    case ID_FILE_SAVE_AS:
         slotStatusHelpMsg("Saves the actual document as...");
         break;

    case ID_FILE_CLOSE:
         slotStatusHelpMsg("Closes the actual document");
         break;

    case ID_FILE_PRINT:
         slotStatusHelpMsg("Prints out the actual document");
         break;

    case ID_FILE_QUIT:
         slotStatusHelpMsg("Quits the application");
         break;

    case ID_EDIT_CUT:
         slotStatusHelpMsg("Cuts the selected section and puts it to the clipboard");
         break;

    case ID_EDIT_COPY:
         slotStatusHelpMsg("Copies the selected section to the clipboard");
         break;

    case ID_EDIT_PASTE:
         slotStatusHelpMsg("Pastes the clipboard contents to actual position");
         break;

    case ID_EDIT_SELECT_ALL:
         slotStatusHelpMsg("Selects the whole document contents");
         break;

    case ID_VIEW_TOOLBAR:
         slotStatusHelpMsg("Enables/disables the toolbar");
         break;

    case ID_VIEW_STATUSBAR:
         slotStatusHelpMsg("Enables/disables the statusbar");
         break;

    case ID_VIEW_TASKBAR:
         slotStatusHelpMsg( "Enables / disables the taskbar");
         break;

    case ID_HELP_ABOUT:
         slotStatusHelpMsg("Shows an aboutbox");
         break;
  }
}

/**
 * undocks all view windows (unix-like)
 */
void |NAME|::switchToToplevelMode()
{
   QextMdiMainFrm::switchToToplevelMode();
   resize( width(), height()-m_pMdi->height());
}

/**
 * docks all view windows (Windows-like)
 */
void |NAME|::switchToChildframeMode()
{
   QextMdiMainFrm::switchToChildframeMode();
   m_pMdi->resize(600,400);
}

/** just additionally fits the system menu button position to the menu position */
void |NAME|::resizeEvent ( QResizeEvent *e)
{
   QextMdiMainFrm::resizeEvent( e);
   setSysButtonsAtMenuPosition();
}
