/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 2000 by Matthias Kiefer
                            <matthias.kiefer@gmx.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

**************************************************************************** */
#include "dictionarymenu.h"
#include <kaccel.h>
#include <kdebug.h>
#include <qpopupmenu.h>

DictionaryMenu::DictionaryMenu(QPopupMenu *popupMenu, KAccel *_accel
        , QObject *parent)
              : QObject(parent, "dictionarymenu")
              , popup(popupMenu)
              , accel(_accel)
{
   num2id.setAutoDelete(true);
   accel2id.setAutoDelete(true);

   if(popup)
   {
      connect(popup,SIGNAL(activated(int)),this,SLOT(activated(int)));
   }
   if(accel)
   {
      connect(accel,SIGNAL(activated(int)),this,SLOT(accelActivated(int)));
   }
}

DictionaryMenu::~DictionaryMenu()
{
   clear();
}

void DictionaryMenu::clear()
{
   if(popup)
   {
      QIntDictIterator<QString> it( num2id ); // iterator for dict
      while ( it.current() ) 
      {
         popup->removeItem(it.currentKey());
         ++it;
      }
   }

   num2id.clear();
   
   if(accel)
   {
      QIntDictIterator<QString> it( accel2id ); // iterator for dict
      while ( it.current() ) 
      {
         accel->QAccel::removeItem(it.currentKey());
         ++it;
      }
   }

   accel2id.clear();
}

void DictionaryMenu::add(const QString& name, const QString& moduleId)
{
   if(popup)
   {
      int id = popup->insertItem(name);
   
      QString *idString = new QString(moduleId);
      num2id.insert(id,idString);
   }
}

void DictionaryMenu::add(const QString& n, const QString& moduleId
           , const QString& key)
{
    if(popup)
    {
        QString name=n;

        if(accel)
        {
            QString keyString=key;
            if(keyString.contains("%1"))
            {
                keyString=key.arg(accel2id.count()+1);
            }
            int k = KAccel::stringToKey(keyString);

            if(k!=0)
            {
                int id=accel->QAccel::insertItem(k);
                QString *idString = new QString(moduleId);
                accel2id.insert(id,idString);

                name+='\t';
                name+=KAccel::keyToString(k,true);
            }
            else
            {
                kdWarning() << "key not valid" << endl;
            }   
        } 
        
        int id = popup->insertItem(name);
   
        QString *idString = new QString(moduleId);
        num2id.insert(id,idString);
   }
}


void DictionaryMenu::activated(int id)
{
   QString *idString = num2id[id];
   if(idString)
   {
      emit activated(*idString);
   }
}

void DictionaryMenu::accelActivated(int id)
{  
   QString *idString = accel2id[id];
   if(idString)
   {
      emit activated(*idString);
   }

}

#include "dictionarymenu.moc"
