package org.kde.koala;
import org.kde.qt.*;


/** {@link Slave} emits these signals */
public interface SlaveSignals {
	void connected();
	void destroyed();
//	void statEntry( UDSEntry arg1 );
	void connectFinished();

/** 
 Emitted when an io-slave requests cached password to be
 deleted for the specified group.

*/
	void delAuthorization( String grpkey );
	void needSubURLData();
	void needProgressId();
	void infoMessage( String arg1 );
	void gettingFile( String arg1 );
	void canResume( long arg1);
	void error( int arg1, String arg2 );
	void data( byte[] arg1 );
	void dataReq();
	void processedSize( long arg1 );
	void finished();
//	void listEntries( UDSEntryList arg1 );
	void redirection( KURL arg1 );
	void slaveDied( int slave );

/** 
 Emitted whenever login (username/password) information
 needs to be cached.

 NOTE: this signal is also emitted whenever a

*/
	void authorizationKey( String arg1, String arg2, boolean arg3 );

/** 

 NOTE: Do not connect to both this and {@link authorizationKey}.
 {@link authData} at the same time!
     
*/
	void authenticationKey( String arg1, String arg2 );
	void warning( String arg1 );
	void totalSize( long arg1 );
	void errorPage();
	void speed( long arg1);
//	void metaData( MetaData arg1 );
	void slaveStatus( long arg1, String arg2, String arg3, boolean arg4 );
	void mimeType( String arg1 );
}

