/***************************************************************************
                            KWinModule.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**


 The class KWinModule provides information about the state of the
 window manager as required by windowmanager modules. It informs a
 module about all currently managed windows and changes to them (via
 Qt signals).

 KWinModule uses NETRootInfo internally. Modules written with this
 class will work fine under any window manager that implements the
 NET_WM protocol.

 There are no methods to manipulate windows. Those are defined in
 the classes KWin, NETWinInfo and NETRootInfo.

 See {@link KWinModuleSignals} for signals emitted by KWinModule.

 See {@link KWinModuleEventHandling} for event handlers to override in subclasses of KWinModule.

 @author Matthias Ettrich (ettrich@kde.org)

 @version $Id: KWinModule.java,v 1.2.2.1 2001/08/29 23:14:11 rdale Exp $
 
 @short Base class for KDE Window Manager modules.

*/
public class KWinModule extends QObject  {
	protected KWinModule(Class dummy){super((Class) null);}


/** 
 Creates a KWinModule object and connects to the window
 manager.

*/
	private native void newKWinModule( QObject parent);
	public KWinModule( QObject parent) {
		super((Class) null);
		newKWinModule( parent);
	}
	private native void newKWinModule();
	public KWinModule() {
		super((Class) null);
		newKWinModule();
	}

/** 
 Destructor. Internal cleanup, nothing fancy.

*/
	protected native void finalize() throws InternalError;

/** 
 Test to see if <code>WId</code> still managed at present.

*/
	public native boolean hasWId( int arg1);

/** 
 Returns the current virtual desktop

*/
	public native int currentDesktop();

/** 
 Returns the number of  virtual desktops

*/
	public native int numberOfDesktops();

/** 
 Returns the currently active window, or 0 if no window is active.

*/
	public native int activeWindow();

/** 
 Returns the workarea for the specified desktop, or the current
 work area if no desktop has been specified.

*/
	public native QRect workArea( int arg1);

/** 
 Returns the name of the specified desktop

*/
	public native String desktopName( int desktop);

/** 
 Sets the name of the specified desktop

*/
	public native void setDesktopName( int desktop, String name);

/** 
 Informs kwin via dcop to not manage a window with the
 specified <code>title.</code>

 Useful for swallowing legacy applications, for example java
 applets.

     
*/
	public native void doNotManage( String title);
}
