/***************************************************************************
                            KListBox.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Extends the functionality of {@link QListBox} to honor the system
 wide settings for Single Click/Double Click mode, Auto Selection and
 Change Cursor over Link.

 There is a new signal {@link #executed}. It gets connected to either
 {@link QListBox#clicked} or {@link QListBox#doubleClicked}
 depending on the KDE wide Single Click/Double Click settings. It is
 strongly recomended that you use this signal instead of the above
 mentioned. This way you dont need to care about the current
 settings.  If you want to get informed when the user selects
 something connect to the {@link QListBox#selectionChanged} signal.

 See {@link KListBoxSignals} for signals emitted by KListBox.

 See {@link KListBoxEventHandling} for event handlers to override in subclasses of KListBox.

 @short A variant of @ref QListBox that honors KDE's system-wide settings.

*/
public class KListBox extends QListBox  {
	protected KListBox(Class dummy){super((Class) null);}

	private native void newKListBox( QWidget parent, String name, int f);
	public KListBox( QWidget parent, String name, int f) {
		super((Class) null);
		newKListBox( parent, name, f);
	}
	private native void newKListBox();
	public KListBox() {
		super((Class) null);
		newKListBox();
	}
	protected native void emitExecute( QListBoxItem item, QPoint pos);
	protected native void slotOnItem( QListBoxItem item);
	protected native void slotOnViewport();
	protected native void slotSettingsChanged( int arg1);

/** 
 Auto selection happend.
   
*/
	protected native void slotAutoSelect();
}
