/***************************************************************************
                            KFileDetailView.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 A list-view capable of showing {@link KFileViewItems}. Used in the filedialog
 for example. Most of the documentation is in {@link KFileView} class.

 See {@link KFileDetailViewSignals} for signals emitted by KFileDetailView.

 See {@link KFileDetailViewEventHandling} for event handlers to override in subclasses of KFileDetailView.

 @short 
 A list-view capable of showing @ref KFileViewItems.
*/
public class KFileDetailView extends KListView implements  KFileViewInterface {
	protected KFileDetailView(Class dummy){super((Class) null);}

	private native void newKFileDetailView( QWidget parent, String name);
	public KFileDetailView( QWidget parent, String name) {
		super((Class) null);
		newKFileDetailView( parent, name);
	}
	protected native void finalize() throws InternalError;
	public native QWidget widget();
	public native void clearView();
	public native void setAutoUpdate( boolean arg1);
	public native void setSelectionMode( int sm);
	public native void updateView( boolean arg1);
	public native void updateView( KFileViewItem arg1);
	public native void removeItem( KFileViewItem arg1);
	public native void setSelected( KFileViewItem arg1, boolean arg2);
	public native boolean isSelected( KFileViewItem i);
	public native void clearSelection();
	public native void insertItem( KFileViewItem i);
	public native void setSorting( int arg1);
	public native void sortReversed();
	public native void ensureItemVisible( KFileViewItem arg1);
	protected native void setSortIndicator();
	protected native void slotSelectionChanged();

        // From KFileView
        
        /** 
 inserts a list of items.

*/
	public native void addItemList( ArrayList list);



/** 
 set the current item in the view.

 the normal use of this function is to use the parameter filename to
 set the highlight on this file.

 the extend use of this function is to set filename to 0. In this
 case the {@link KFileViewItem} is used to find out the position of the
 file. Since this is faster, this way is used in case a view has
 other child views.

*/
	public native void setCurrentItem( String filename, KFileViewItem entry);
	public native void setCurrentItem( String filename);

/** 
 clears the view and all item lists
      
*/
	public native void clear();

	public native void updateView();


/** 
 specifies the sorting of the internal list. Newly added files
 are added through this sorting.

*/
	public native boolean sorting();


/** 
 set the sorting mode. Default mode is Increasing. Affects only
 newly added items.

*/
	public native void setSortMode( int mode);

/** 

*/
	public native int sortMode();


/** 
 Tells whether the current items are in reversed order (= contrary to
 {@link sortMode}).
     
*/
	public native boolean isReversed();

/** 

*/
	public native int count();

/** 

*/
	public native int numFiles();

/** 

*/
	public native int numDirs();
	public native int selectionMode();
	public native void setViewMode( int vm);
	public native int viewMode();

/** 

*/
	public native String viewName();

/** 
 Sets the name of the view, which could be displayed somewhere.
 E.g. "Image Preview".
     
*/
	public native void setViewName( String name);
	public native void setOperator( QObject ops);





/** 
 Selects all items. You may want to override this, if you can implement
 it more efficiently than calling setSelected() with every item.
 This works only in Multiselection mode of course.
     
*/
	public native void selectAll();

/** 
 Inverts the current selection, i.e. selects all items, that were up to
 now not selected and deselects the other.
     
*/
	public native void invertSelection();



/** 

*/
	public native ArrayList selectedItems();

/** 

*/
	public native ArrayList items();

/** 
 Inserts "counter" KFileViewItems and sorts them conforming to the
 current sort-order.
 If you override this method, you have to call {@link #setFirstItem}
 afterwards, to set the first item of your newly sorted items.
     
*/
	public native void insertSorted( KFileViewItem tfirst, int counter);

/** 

*/
	public native QIconViewItem firstItem();

/** 
 This is a KFileDialog specific hack: we want to select directories with
 single click, but not files. But as a generic class, we have to be able
 to select files on single click as well.

 This gives us the opportunity to do both.

 Every view has to decide when to call select( item ) when a file was
 single-clicked, based on {@link #onlyDoubleClickSelectsFiles}.
     
*/
	public native void setOnlyDoubleClickSelectsFiles( boolean enable);

/** 

*/
	public native boolean onlyDoubleClickSelectsFiles();

/** 
 increases the number of dirs and files.

*/
	public native boolean updateNumbers( KFileViewItem i);

	public native KActionCollection actionCollection();
}
