/* This file is part of the KDE libraries
   Copyright (C) 1996-1998 Martin R. Jones <mjones@kde.org>
   Copyright (C) 2000 David Faure <faure@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License version 2 as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/
#include <qfile.h>
#include <kdebug.h>
#include <stdio.h>
#include <klocale.h>
#include "kbookmarkmanager.h"
#include "kbookmarkexporter.h"
#include <qtextcodec.h>

// write bookmarks file
//
void KNSBookmarkExporter::write( bool utf8 )
{
    if ( QFile::exists( m_fileName ) )
    {
        ::rename( QFile::encodeName( m_fileName ), QFile::encodeName( m_fileName + ".beforekde" ) );
    }

    QFile file( m_fileName );

    if ( !file.open( IO_WriteOnly ) )
    {
        kdError(1203) << "Can't write to file " << m_fileName << endl;
        return;
    }

    QTextStream stream( &file );
    QString charset;
    if ( utf8 ) {
        stream.setEncoding( QTextStream::UnicodeUTF8 );
        charset = "UTF-8";
    } else {
        stream.setEncoding( QTextStream::Locale );
        charset = QString::fromLatin1(QTextCodec::codecForLocale()->name()).upper();
    }

    stream << "<!DOCTYPE NETSCAPE-Bookmark-file-1>" << endl;
    stream << i18n("<!-- This file was generated by Konqueror -->") << endl;
    stream << "<META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html; charset=" << charset << "\">" << endl;

    QString title = i18n("Bookmarks");
    stream << "<TITLE>" << title << "</TITLE>" << endl;
    stream << "<H1>" << title << "</H1>" << endl;

    stream << "<DL><p>" << endl;

    writeFolder( stream, KBookmarkManager::self()->root() );

    stream << "</DL><P>" << endl;
}

// write the contents of a folder (recursive)
//
void KNSBookmarkExporter::writeFolder( QTextStream &stream, KBookmarkGroup parent )
{
    QRegExp amp("&");
    QRegExp lt("<");
    QRegExp gt(">");
    for ( KBookmark bm = parent.first(); !bm.isNull(); bm = parent.next(bm) )
    {
        if ( bm.isSeparator() )
        {
            stream << "<HR>" << endl;
        } else
        {
            QString text = bm.text();
            text.replace( amp, "&amp;" ).replace( lt, "&lt;" ).replace( gt, "&gt;" );
            if ( bm.isGroup() )
            {
                stream << "<DT><H3 ";
                if (!bm.toGroup().isOpen())
                    stream << "FOLDED ";
                stream << bm.internalElement().attribute("netscapeinfo");
                stream << ">" << text << "</H3>" << endl;
                stream << "<DL><P>" << endl;
                writeFolder( stream, bm.toGroup() );
                stream << "</DL><P>" << endl;
            }
            else
            {
                stream << "<DT><A HREF=\"" << bm.url().url() /* netscape seems to use local8bit...*/ << "\"";
                stream << bm.internalElement().attribute("netscapeinfo");
                stream << ">" << text << "</A>" << endl;
            }
        }
    }
}
