/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * A combo box with more features.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgcombobox.h"
#include "skglineedit.h"

SKGComboBox::SKGComboBox(QWidget* iParent)
    : KComboBox(iParent), m_substringCompletionMode(true)
{
}

SKGComboBox::~SKGComboBox()
{
}

QString SKGComboBox::text() const
{
    return currentText();
}

void SKGComboBox::setText(const QString& iText)
{
    int pos2 = findText(iText);
    if (pos2 == -1) {
        pos2 = 0;
        insertItem(pos2, iText);
    }
    setCurrentIndex(pos2);
}

void SKGComboBox::setPalette(const QPalette& iPalette)
{
    KComboBox::setPalette(iPalette);
    lineEdit()->setPalette(iPalette);
}

void SKGComboBox::setEditable(bool iEditable)
{
    if (iEditable) {
        // Create a SKGLineEdit instead of a QLineEdit
        // Compared to QComboBox::setEditable, we might be missing the SH_ComboBox_Popup code though...
        // If a style needs this, then we'll need to call QComboBox::setEditable and then setLineEdit again
        SKGLineEdit* edit = new SKGLineEdit(this);
        edit->setClearButtonShown(true);
        edit->setSubstringCompletionMode(m_substringCompletionMode);
        setLineEdit(edit);
    } else {
        KComboBox::setEditable(iEditable);
    }
}

bool SKGComboBox::substringCompletionMode() const
{
    return m_substringCompletionMode;
}

void SKGComboBox::setSubstringCompletionMode(bool iMode)
{
    m_substringCompletionMode = iMode;
    SKGLineEdit* line = qobject_cast<SKGLineEdit*>(lineEdit());
    if (line) line->setSubstringCompletionMode(iMode);
}

#include "skgcombobox.moc"

