/************************************************************************************
 *   Copyright (C) 2018 by BlueSystems GmbH                                         *
 *   Author : Emmanuel Lepage Vallee <elv1313@gmail.com>                            *
 *                                                                                  *
 *   This library is free software; you can redistribute it and/or                  *
 *   modify it under the terms of the GNU Lesser General Public                     *
 *   License as published by the Free Software Foundation; either                   *
 *   version 2.1 of the License, or (at your option) any later version.             *
 *                                                                                  *
 *   This library is distributed in the hope that it will be useful,                *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of                 *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU              *
 *   Lesser General Public License for more details.                                *
 *                                                                                  *
 *   You should have received a copy of the GNU Lesser General Public               *
 *   License along with this library; if not, write to the Free Software            *
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA *
 ***********************************************************************************/
#include <QtCore/QObject>

struct EventModelNode;
class Individual;
class EventModel;

class EventModelPrivate final : public QObject
{
//     Q_OBJECT
public:
    // Attributes
    QVector<EventModelNode*> m_lEvent;
    QHash<const QByteArray, Event*> m_hUids;

    // Helpers
    void sort(ContactMethod* cm);
    void sort(Individual* ind);
    void mergeEvents(ContactMethod* dest, ContactMethod* src);

    // Unoptimal internal API to get events, time not permitting anything better
    const QVector< QSharedPointer<Event> >& events(const ContactMethod* cm) const;

    EventModel* q_ptr;

public Q_SLOTS:
    void slotFixCache();
};
