/*
   SPDX-FileCopyrightText: 2017 Volker Krause <vkrause@kde.org>

   SPDX-License-Identifier: LGPL-2.0-or-later
*/

#ifndef CONFIG_KITINERARY_H
#define CONFIG_KITINERARY_H

// namespaced by "K" to not interfere with defines poppler provides itself
#define KPOPPLER_VERSION_STRING "@Poppler_VERSION@"
#define KPOPPLER_VERSION_MAJOR @POPPLER_VERSION_MAJOR@
#define KPOPPLER_VERSION_MINOR @POPPLER_VERSION_MINOR@
#define KPOPPLER_VERSION_PATCH @POPPLER_VERSION_PATCH@
#define KPOPPLER_VERSION ((@POPPLER_VERSION_MAJOR@<<16)|(@POPPLER_VERSION_MINOR@<<8)|(@POPPLER_VERSION_PATCH@))

#cmakedefine01 HAVE_ZXING
#define ZXING_VERSION_STRING "@ZXing_VERSION@"
#define ZXING_VERSION_MAJOR @ZXing_VERSION_MAJOR@
#define ZXING_VERSION_MINOR @ZXing_VERSION_MINOR@
#define ZXING_VERSION_PATCH @ZXing_VERSION_PATCH@
#define ZXING_VERSION ((@ZXing_VERSION_MAJOR@<<16)|(@ZXing_VERSION_MINOR@<<8)|(@ZXing_VERSION_PATCH@))

// QT_VERSION_CHECK isn't available in here for the below check
#define K_VERSION_CHECK(major, minor, patch) ((major<<16)|(minor<<8)|(patch))

// this might compile with older versions too, but it only actually works post 1.1.1
#if HAVE_ZXING
    #if ZXING_VERSION > K_VERSION_CHECK(1, 1, 1)
        #define ZXING_USE_READBARCODE 1
    #else
        #define ZXING_USE_READBARCODE 0
    #endif
#endif

#cmakedefine01 HAVE_LIBXML2
#cmakedefine01 HAVE_PHONENUMBER

#define CMAKE_INSTALL_FULL_LIBEXECDIR_KF5 "${CMAKE_INSTALL_FULL_LIBEXECDIR_KF5}"

#endif // CONFIG_KITINERARY_H
