/*
    kftabdlg.h

    SPDX-License-Identifier: GPL-2.0-or-later

*/

#ifndef KFTABDLG_H
#define KFTABDLG_H

#include <QMimeType>
#include <QTabWidget>
#include <QUrl>

class KUrlComboBox;
class QButtonGroup;
class QPushButton;
class QRadioButton;
class QCheckBox;
class KLineEdit;
class QString;
class QDate;
class KDateComboBox;
class KComboBox;
class QSpinBox;
class QLabel;

class KfDirDialog;

class KfindTabWidget : public QTabWidget
{
    Q_OBJECT

public:
    explicit KfindTabWidget(QWidget *parent = nullptr);
    ~KfindTabWidget() override;
    void setQuery(class KQuery *query);
    void setDefaults();

    void beginSearch();
    void endSearch();
    void loadHistory();
    void saveHistory();
    bool isSearchRecursive();

    void setURL(const QUrl &url);

    QSize sizeHint() const override;

public Q_SLOTS:
    void setFocus();
    void slotUpdateDateLabelsForNumber(int value);
    void slotUpdateDateLabelsForType(int index);
    void slotUpdateByteComboBox(int value);

private Q_SLOTS:
    void getDirectory();
    void fixLayout();
    void slotSizeBoxChanged(int);

Q_SIGNALS:
    void startSearch();

protected:
public:
    KComboBox *nameBox;
    KUrlComboBox *dirBox;
    // for first page
    QCheckBox *subdirsCb;
    QCheckBox *useLocateCb;
    QCheckBox *hiddenFilesCb;
    // for third page
    KComboBox *typeBox;
    KLineEdit *textEdit;
    QCheckBox *caseSensCb;
    KComboBox *m_usernameBox;
    KComboBox *m_groupBox;
    //for fourth page
    KLineEdit *metainfoEdit;
    KLineEdit *metainfokeyEdit;

private:
    bool isDateValid();
    void fillDirBox();

    void updateDateLabels(int type, int value);

    QWidget *pages[3];

    //1st page
    QPushButton *browseB;

    KfDirDialog *dirselector;

    //2nd page
    QCheckBox *findCreated;
    KComboBox *betweenType;
    QLabel *andL;
    QButtonGroup *bg;
    QRadioButton *rb[2];
    KDateComboBox *fromDate;
    KDateComboBox *toDate;
    QSpinBox *timeBox;

    //3rd page
    KComboBox *sizeBox;
    KComboBox *sizeUnitBox;
    QSpinBox *sizeEdit;
    QCheckBox *caseContextCb;
    QCheckBox *binaryContextCb;

    QUrl m_url;

    QVector<QMimeType> m_types;
    QStringList m_ImageTypes;
    QStringList m_VideoTypes;
    QStringList m_AudioTypes;
};

#endif
