/*
   SPDX-FileCopyrightText: 2020 Laurent Montel <montel@kde.org>

   SPDX-License-Identifier: GPL-2.0-or-later
*/

#include "folderconfiguresettingspagewidget.h"
#include "folderconfiguresettingswidget.h"
#include "folderconfiguretreewidget.h"
#include <QHBoxLayout>
#include <QSplitter>

FolderConfigureSettingsWidget::FolderConfigureSettingsWidget(QWidget *parent)
    : QWidget(parent)
{
    auto *mainLayout = new QHBoxLayout(this);
    mainLayout->setObjectName(QStringLiteral("mainLayout"));
    mainLayout->setContentsMargins({});

    //TODO add label ?

    auto *splitter = new QSplitter(this);
    splitter->setObjectName(QStringLiteral("splitter"));
    splitter->setChildrenCollapsible(false);
    mainLayout->addWidget(splitter);

    mFolderConfigureTreeWidget = new FolderConfigureTreeWidget(this);
    mFolderConfigureTreeWidget->setObjectName(QStringLiteral("mFolderConfigureTreeWidget"));
    splitter->addWidget(mFolderConfigureTreeWidget);

    mFolderConfigureSettingsPageWidget = new FolderConfigureSettingsPageWidget(this);
    mFolderConfigureSettingsPageWidget->setObjectName(QStringLiteral("mFolderConfigureSettingsPageWidget"));
    splitter->addWidget(mFolderConfigureSettingsPageWidget);
}

FolderConfigureSettingsWidget::~FolderConfigureSettingsWidget()
{
}

void FolderConfigureSettingsWidget::save()
{
    const Akonadi::Collection::List collections = mFolderConfigureTreeWidget->listCollections();
    mFolderConfigureSettingsPageWidget->save(collections);
}
