/*
   SPDX-FileCopyrightText: 2016-2020 Laurent Montel <montel@kde.org>

   SPDX-License-Identifier: LGPL-2.0-or-later
*/

#ifndef WEBHITTEST_H
#define WEBHITTEST_H

#include <QObject>
#include "webengineviewer_export.h"
#include <QPoint>
class QWebEnginePage;
namespace WebEngineViewer {
class WebHitTestResult;
class WebHitTestPrivate;
/**
 * @brief The WebHitTest class
 * @author Laurent Montel <montel@kde.org>
 */
class WEBENGINEVIEWER_EXPORT WebHitTest : public QObject
{
    Q_OBJECT
public:
    explicit WebHitTest(QWebEnginePage *page, const QPoint &zoomedPos, const QPoint &pos, QObject *parent = nullptr);
    ~WebHitTest();

Q_SIGNALS:
    void finished(const WebEngineViewer::WebHitTestResult &result);

private Q_SLOTS:
    void handleHitTest(const QVariant &result);
private:
    WebHitTestPrivate *const d;
};
}

#endif // WEBHITTEST_H
