/******************************************************************************
 *
 *  Copyright 2008 Szymon Tomasz Stefanek <pragma@kvirc.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 *******************************************************************************/

#ifndef MESSAGELIST_UTILS_CONFIGUREAGGREGATIONSDIALOG_H
#define MESSAGELIST_UTILS_CONFIGUREAGGREGATIONSDIALOG_H

#include <QDialog>

namespace MessageList {
namespace Core {
class Manager;
} // namespace Core

namespace Utils {
/**
 * The dialog used for configuring MessageList::Aggregation sets.
 *
 * This is managed by MessageList::Manager. Take a look at it first
 * if you want to display this dialog.
 */
class ConfigureAggregationsDialog : public QDialog
{
    Q_OBJECT

public:
    explicit ConfigureAggregationsDialog(QWidget *parent = nullptr);
    ~ConfigureAggregationsDialog();

    void selectAggregation(const QString &aggregationId);

Q_SIGNALS:
    void okClicked();

private:
    class Private;
    Private *const d;
};
} // namespace Utils
} // namespace MessageList

#endif //!__MESSAGELIST_UTILS_CONFIGUREAGGREGATIONSDIALOG_H
