/*
   This file is part of the Nepomuk KDE project.
   Copyright (C) 2012 Sebastian Trueg <trueg@kde.org>
   
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) version 3, or any
   later version accepted by the membership of KDE e.V. (or its
   successor approved by the membership of KDE e.V.), which shall
   act as a proxy defined in Section 6 of version 3 of the license.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.
   
   You should have received a copy of the GNU Lesser General Public
   License along with this library.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "musicthumbcreator.h"

#include <Nepomuk/ResourceManager>
#include <Nepomuk/Vocabulary/NFO>
#include <Nepomuk/Vocabulary/NMM>
#include <Nepomuk/Vocabulary/NIE>

#include <Soprano/QueryResultIterator>
#include <Soprano/Node>
#include <Soprano/LiteralValue>
#include <Soprano/Model>

#include <KUrl>
#include <KDebug>

#include <QStringList>
#include <QImage>

namespace {
    QUrl recoverUriFromUrlToken(const QString& token)
    {
        return QUrl::fromEncoded(QUrl::fromPercentEncoding(token.toAscii()).toAscii());
    }
}


MusicThumbCreator::MusicThumbCreator()
{
}

bool MusicThumbCreator::create(const QString &path, int width, int height, QImage &img)
{
    // The previewJob does the scaling for us
    Q_UNUSED(width);
    Q_UNUSED(height);

    // although the docs state that path is always local this is not correct
    KUrl url(path);
    const QStringList pathTokens = url.path().split('/', QString::SkipEmptyParts);
    if(pathTokens.count() < 2) {
        return false;
    }

    // there are only two cases for us: artists and albums
    if(pathTokens[pathTokens.count()-2] == QLatin1String("artists") ||
       pathTokens[pathTokens.count()-2] == QLatin1String("albums")) {
        const QUrl uri = recoverUriFromUrlToken(pathTokens.last());
        // we just query the first depiction there is
        Soprano::QueryResultIterator it
                = Nepomuk::ResourceManager::instance()->mainModel()->executeQuery(QString::fromLatin1("select ?u where { %1 nfo:depiction [ nie:url ?u ] . } LIMIT 1")
                                                                                  .arg(Soprano::Node::resourceToN3(uri)),
                                                                                  Soprano::Query::QueryLanguageSparql);
        if(it.next()) {
            img.load(it["u"].uri().toLocalFile());
            return true;
        }
    }

    // fallback
    return false;
}
