//////////////////////////////////////////////////////////////////////////////
//
//    KEXIFUTILS.CPP
//
//    Copyright (C) 2002-2004 Renchi Raju <renchi at pooh.tam.uiuc.edu>
//                            Gilles CAULIER <caulier dot gilles at free.fr>
//                            Ralf Hoelzer <kde at ralfhoelzer.com>
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin Steet, Fifth Floor, Cambridge, MA 02110-1301, USA.
//
//////////////////////////////////////////////////////////////////////////////

// Qt includes.

#include <qptrlist.h>
#include <qpalette.h>
#include <qheader.h>
#include <qwhatsthis.h>

// KDE includes.

#include <klocale.h>

// Local includes.

#include "kexifentry.h"
#include "kexififd.h"
#include "kexiflistviewitem.h"
#include "kexiflistview.h"

KExifListView::KExifListView(QWidget* parent)
             : QListView(parent)
{
    header()->hide();
    addColumn(i18n("Name"));
    addColumn(i18n("Value"));
    setResizeMode(QListView::AllColumns);
    setAllColumnsShowFocus(true);
    
    connect(this, SIGNAL(selectionChanged(QListViewItem*)),
            this, SLOT(slotSelectionChanged(QListViewItem*)));
}

KExifListView::~KExifListView()
{
}

void KExifListView::setIfdList(const QPtrList<KExifIfd>& ifds)
{
    QColor color1 = QColor(255,255,255);
    QColor color2 = QColor(240,240,255);

    int i = 0;
    int sortCount = 0;

    QPtrList<KExifIfd> ifdList(ifds);
    for (KExifIfd* ifd = ifdList.first(); ifd; ifd = ifdList.next())
    {
        if (ifd->entryList().isEmpty())
            continue;
        QColor& color = (i == 0) ? color1 : color2;
        i = (i == 0) ? 1 : 0;

        QPtrList<KExifEntry> entryList = ifd->entryList();
        QPtrListIterator<KExifEntry> it(entryList);
        KExifEntry* exifEntry = 0;
        
        while ((exifEntry = it.current()) != 0)
        {
            KExifListViewItem* item = new KExifListViewItem(this, exifEntry, color);
            item->setSortKey(sortCount++);
            ++it;
        }
    }
}

void KExifListView::setEntryList(const QPtrList<KExifEntry>& _entryList)
{
    QColor color = QColor(255,255,255);

    QPtrList<KExifEntry> entryList(_entryList);
    QPtrListIterator<KExifEntry> it(entryList);
    KExifEntry* exifEntry = 0;

    int sortKey = 0;
    while ((exifEntry = it.current()) != 0)
    {
        KExifListViewItem* item = new KExifListViewItem(this, exifEntry, color);
        item->setSortKey(++sortKey);
        ++it;
    }
}

QString KExifListView::getCurrentItemName() const
{
    if (currentItem())
    {
        KExifListViewItem *item = static_cast<KExifListViewItem *>(currentItem());
        return item->exifEntry()->getName();
    }
    else 
        return QString();
}

void KExifListView::setCurrentItem(const QString& itemName)
{
    if (itemName.isNull())
        return;

    KExifListViewItem *item = dynamic_cast<KExifListViewItem *>(findItem(itemName, 0));
    
    if (item)
    {
        setSelected(item, true);
        ensureItemVisible(item);
        return;
    }
}

void KExifListView::slotSelectionChanged(QListViewItem *item)
{
    if (!item)
        return;

    KExifListViewItem* viewItem = static_cast<KExifListViewItem *>(item);
    QWhatsThis::add( this, i18n("<b>%1</b><p>%2").arg(viewItem->exifEntry()->getTitle())
                                        .arg(viewItem->exifEntry()->getDescription()) );
}

#include "kexiflistview.moc"
