/*
 *  Copyright (c) 2019 Dmitry Kazakov <dimula73@gmail.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include "KoAlphaDarkenParamsWrapper.h"

#include <ksharedconfig.h>
#include <kconfiggroup.h>
#include "kis_debug.h"


bool useCreamyAlphaDarken()
{
    static bool isConfigInitialized = false;
    static bool useCreamyAlphaDarken = true;

    if (!isConfigInitialized) {
        KConfigGroup cfg = KSharedConfig::openConfig()->group("");
        useCreamyAlphaDarken = cfg.readEntry("useCreamyAlphaDarken", true);
        isConfigInitialized = true;
    }

    if (!useCreamyAlphaDarken) {
        qInfo() << "INFO: requested old version of AlphaDarken composite op. Switching...";
    }

    return useCreamyAlphaDarken;
}
