/* Driver template for the LEMON parser generator.
** The author disclaims copyright to this source code.
*/
/* First off, code is include which follows the "include" declaration
** in the input file. */
#include <stdio.h>
#line 33 "parse.y"

#include "sqliteInt.h"
#include "parse.h"

/*
** An instance of this structure holds information about the
** LIMIT clause of a SELECT statement.
*/
struct LimitVal {
  int limit;    /* The LIMIT value.  -1 if there is no limit */
  int offset;   /* The OFFSET.  0 if there is none */
};

/*
** An instance of the following structure describes the event of a
** TRIGGER.  "a" is the event type, one of TK_UPDATE, TK_INSERT,
** TK_DELETE, or TK_INSTEAD.  If the event is of the form
**
**      UPDATE ON (a,b,c)
**
** Then the "b" IdList records the list "a,b,c".
*/
struct TrigEvent { int a; IdList * b; };

/*
** An instance of this structure holds the ATTACH key and the key type.
*/
struct AttachKey { int type;  Token key; };

#line 39 "parse.c"
/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/* 
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands. 
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash 
**                       table.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       have fall-back values which should be used if the
**                       original value of the token will not parse.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    sqlite3ParserTOKENTYPE     is the data type used for minor tokens given 
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is sqlite3ParserTOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.
**    sqlite3ParserARG_SDECL     A static variable declaration for the %extra_argument
**    sqlite3ParserARG_PDECL     A parameter declaration for the %extra_argument
**    sqlite3ParserARG_STORE     Code to store %extra_argument into yypParser
**    sqlite3ParserARG_FETCH     Code to extract %extra_argument from yypParser
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
#define YYCODETYPE unsigned char
#define YYNOCODE 220
#define YYACTIONTYPE unsigned short int
#define sqlite3ParserTOKENTYPE Token
typedef union {
  sqlite3ParserTOKENTYPE yy0;
  struct LimitVal yy22;
  struct AttachKey yy72;
  TriggerStep* yy107;
  Expr* yy164;
  ExprList* yy232;
  IdList* yy246;
  SrcList* yy283;
  struct {int value; int mask;} yy299;
  Token yy318;
  Select* yy375;
  struct TrigEvent yy414;
  int yy424;
  int yy439;
} YYMINORTYPE;
#define YYSTACKDEPTH 100
#define sqlite3ParserARG_SDECL Parse *pParse;
#define sqlite3ParserARG_PDECL ,Parse *pParse
#define sqlite3ParserARG_FETCH Parse *pParse = yypParser->pParse
#define sqlite3ParserARG_STORE yypParser->pParse = pParse
#define YYNSTATE 565
#define YYNRULE 293
#define YYERRORSYMBOL 130
#define YYERRSYMDT yy439
#define YYFALLBACK 1
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)

/* Next are that tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < YYNSTATE                  Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   YYNSTATE <= N < YYNSTATE+YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == YYNSTATE+YYNRULE              A syntax error has occurred.
**
**   N == YYNSTATE+YYNRULE+1            The parser accepts its input.
**
**   N == YYNSTATE+YYNRULE+2            No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as
**
**      yy_action[ yy_shift_ofst[S] + X ]
**
** If the index value yy_shift_ofst[S]+X is out of range or if the value
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X or if yy_shift_ofst[S]
** is equal to YY_SHIFT_USE_DFLT, it means that the action is not in the table
** and that yy_default[S] should be used instead.  
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array and YY_REDUCE_USE_DFLT is used in place of
** YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
*/
static YYACTIONTYPE yy_action[] = {
 /*     0 */   264,  837,  262,  119,  123,  117,  121,  129,  131,  133,
 /*    10 */   135,  144,  146,  148,  150,  152,  154,  429,  143,  859,
 /*    20 */     1,  564,    3,  142,  129,  131,  133,  135,  144,  146,
 /*    30 */   148,  150,  152,  154,  314,  321,  323,  115,  103,  139,
 /*    40 */   127,  125,  156,  161,  157,  162,  166,  119,  123,  117,
 /*    50 */   121,  129,  131,  133,  135,  144,  146,  148,  150,  152,
 /*    60 */   154,  344,   29,  143,  263,  362,  354,  832,  142,  144,
 /*    70 */   146,  148,  150,  152,  154,   34,   67,   45,  562,  563,
 /*    80 */    63,  336,  115,  103,  139,  127,  125,  156,  161,  157,
 /*    90 */   162,  166,  119,  123,  117,  121,  129,  131,  133,  135,
 /*   100 */   144,  146,  148,  150,  152,  154,  382,  193,   35,   53,
 /*   110 */    59,   61,  306,  337,  346,  349,  420,  175,  363,  339,
 /*   120 */   105,   11,  641,  343,   26,  345,   27,   28,  352,  353,
 /*   130 */   296,   57,  143,  181,  179,  301,  642,  142,  365,   58,
 /*   140 */   174,  177,   65,   66,  110,  364,  396,  111,  104,  137,
 /*   150 */   795,  115,  103,  139,  127,  125,  156,  161,  157,  162,
 /*   160 */   166,  119,  123,  117,  121,  129,  131,  133,  135,  144,
 /*   170 */   146,  148,  150,  152,  154,  105,  299,  793,  565,  575,
 /*   180 */   112,  113,  183,   12,   13,  219,  367,  562,  563,  363,
 /*   190 */   369,  375,  380,   11,   23,  303,  167,  397,   28,    5,
 /*   200 */    11,  383,  143,   22,  367,  398,  173,  142,  369,  375,
 /*   210 */   380,  148,  150,  152,  154,  169,  585,  171,  172,  383,
 /*   220 */   191,  115,  103,  139,  127,  125,  156,  161,  157,  162,
 /*   230 */   166,  119,  123,  117,  121,  129,  131,  133,  135,  144,
 /*   240 */   146,  148,  150,  152,  154,  367,   11,  143,  570,  369,
 /*   250 */   375,  380,  142,    2,    3,   12,   13,   31,  341,  262,
 /*   260 */   383,   67,   12,   13,  336,   63,  115,  103,  139,  127,
 /*   270 */   125,  156,  161,  157,  162,  166,  119,  123,  117,  121,
 /*   280 */   129,  131,  133,  135,  144,  146,  148,  150,  152,  154,
 /*   290 */   319,  169,  193,  171,  172,   83,   85,  840,  298,  545,
 /*   300 */   543,  232,  175,   64,  692,  105,   82,  230,   12,   13,
 /*   310 */   105,   11,  169,  320,  171,  172,  794,  143,  181,  179,
 /*   320 */   536,  263,  142,   51,  401,  174,  177,   65,   66,  110,
 /*   330 */   102,   52,  111,  104,  455,  213,  115,  103,  139,  127,
 /*   340 */   125,  156,  161,  157,  162,  166,  119,  123,  117,  121,
 /*   350 */   129,  131,  133,  135,  144,  146,  148,  150,  152,  154,
 /*   360 */   304,  244,  316,   94,  237,  112,  113,  183,  796,  197,
 /*   370 */   219,  450,  279,   12,   13,  311,   11,    8,  201,  143,
 /*   380 */   663,  489,  461,  451,  142,  690,  169,  436,  171,  172,
 /*   390 */   392,  205,   72,  448,  195,  593,  221,   68,  115,  103,
 /*   400 */   139,  127,  125,  156,  161,  157,  162,  166,  119,  123,
 /*   410 */   117,  121,  129,  131,  133,  135,  144,  146,  148,  150,
 /*   420 */   152,  154,  474,  264,  143,  262,  573,  313,  189,  142,
 /*   430 */   209,  295,  339,  394,  310,  294,   10,  456,   12,   13,
 /*   440 */   393,  838,  458,  115,  103,  139,  127,  125,  156,  161,
 /*   450 */   157,  162,  166,  119,  123,  117,  121,  129,  131,  133,
 /*   460 */   135,  144,  146,  148,  150,  152,  154,  845,   11,  143,
 /*   470 */   169,  843,  171,  172,  142,  665,  169,  576,  171,  172,
 /*   480 */   402,  574,   37,  318,    9,  317,  280,  263,  115,  103,
 /*   490 */   139,  127,  125,  156,  161,  157,  162,  166,  119,  123,
 /*   500 */   117,  121,  129,  131,  133,  135,  144,  146,  148,  150,
 /*   510 */   152,  154,   68,   11,  143,  728,  817,   46,  410,  142,
 /*   520 */   405,  426,  428,  427,  281,  259,  546,  247,   48,  282,
 /*   530 */    12,   13,   15,  115,  103,  139,  127,  125,  156,  161,
 /*   540 */   157,  162,  166,  119,  123,  117,  121,  129,  131,  133,
 /*   550 */   135,  144,  146,  148,  150,  152,  154,   11,  254,  143,
 /*   560 */   262,  424,  425,  169,  142,  171,  172,  169,  534,  171,
 /*   570 */   172,  169,  692,  171,  172,   12,   13,  577,  115,  164,
 /*   580 */   139,  127,  125,  156,  161,  157,  162,  166,  119,  123,
 /*   590 */   117,  121,  129,  131,  133,  135,  144,  146,  148,  150,
 /*   600 */   152,  154,   11,  256,  143,  249,  259,  170,   74,  142,
 /*   610 */   668,  169,  293,  171,  172,  287,  216,  248,  217,   12,
 /*   620 */    13,  159,  263,  115,  227,  139,  127,  125,  156,  161,
 /*   630 */   157,  162,  166,  119,  123,  117,  121,  129,  131,  133,
 /*   640 */   135,  144,  146,  148,  150,  152,  154,  105,  105,  143,
 /*   650 */   276,  234,  158,  217,  142,  273,   17,  274,  494,  300,
 /*   660 */   557,  217,  221,  347,   12,   13,  348,  102,  174,  103,
 /*   670 */   139,  127,  125,  156,  161,  157,  162,  166,  119,  123,
 /*   680 */   117,  121,  129,  131,  133,  135,  144,  146,  148,  150,
 /*   690 */   152,  154,  105,  691,  143,  251,  503,  251,  497,  142,
 /*   700 */   355,   96,  272,  578,  262,  579,   67,  266,  266,  327,
 /*   710 */    63,  328,  184,  218,   19,  139,  127,  125,  156,  161,
 /*   720 */   157,  162,  166,  119,  123,  117,  121,  129,  131,  133,
 /*   730 */   135,  144,  146,  148,  150,  152,  154,  193,  289,  267,
 /*   740 */     4,    6,  432,   90,   20,  431,  350,  175,   67,  351,
 /*   750 */   506,  332,   63,  580,  185,  137,  357,  143,  358,  253,
 /*   760 */   433,  253,  142,  181,  179,  535,  263,  810,  266,   88,
 /*   770 */   500,  177,   65,   66,  110,  105,   68,  111,  104,  193,
 /*   780 */   326,   11,  168,  435,  225,  229,  252,  722,  252,  175,
 /*   790 */   311,  373,  378,  328,  328,  174,   72,  274,   67,  284,
 /*   800 */   466,  519,   63,   21,   24,  181,  179,  290,   68,  224,
 /*   810 */   112,  113,  183,  177,   65,   66,  110,  105,  333,  111,
 /*   820 */   104,  105,    7,   40,   14,   16,   18,  400,  332,  193,
 /*   830 */   332,  215,   41,  537,  538,  539,   37,  488,  549,  175,
 /*   840 */   219,  114,  313,   12,   13,   42,  559,   30,   43,  387,
 /*   850 */    45,  328,  112,  113,  183,  181,  179,  372,  447,   44,
 /*   860 */   531,  450,  455,  177,   65,   66,  110,  529,  105,  111,
 /*   870 */   104,  332,  833,  105,   38,  231,  332,  484,   32,  342,
 /*   880 */    69,   35,   53,   59,   61,  306,  337,   68,  174,  332,
 /*   890 */    25,  399,  339,  297,  803,  333,  584,  329,  245,  105,
 /*   900 */   377,   68,  112,  113,  183,  386,   68,   33,  105,  507,
 /*   910 */   512,  451,  474,  409,  105,  493,  692,   68,  444,  488,
 /*   920 */    72,  105,  105,  276,  233,  105,  105,  460,  116,  105,
 /*   930 */   221,  653,  458,  219,  118,  105,  692,  105,  333,   68,
 /*   940 */   105,  120,  122,  333,  105,  124,  126,  105,  105,  381,
 /*   950 */   105,  105,  105,  105,  105,  128,  333,  130,  105,  527,
 /*   960 */   132,  105,  105,  105,  134,  105,  105,  136,  138,  452,
 /*   970 */   141,  145,  147,  149,  151,  430,  105,  105,  153,  105,
 /*   980 */   105,  155,  163,  165,  105,  176,  178,  105,  105,  105,
 /*   990 */   471,  105,  105,  105,  105,  105,  180,  182,  291,  190,
 /*  1000 */   192,  445,  105,  328,  210,  105,  276,  212,  421,  214,
 /*  1010 */   481,  226,  228,  241,  246,  278,   72,  105,  288,   37,
 /*  1020 */   722,  479,  469,  274,  487,  473,  485,  471,   72,  482,
 /*  1030 */   692,  524,  655,  528,  852,  485,   68,  486,  221,  541,
 /*  1040 */   221,  525,  542,   39,   36,   50,   47,  465,   49,   55,
 /*  1050 */    56,   54,   60,   62,  594,  595,   72,   68,  478,  245,
 /*  1060 */    75,   78,  242,   70,   71,   92,  240,   87,   73,   84,
 /*  1070 */    81,  555,   86,   76,   89,   77,   91,   93,   79,   95,
 /*  1080 */    80,   98,   99,  100,  517,  101,  106,  107,  108,  154,
 /*  1090 */   160,  109,  220,  669,   97,  211,  670,  671,  188,  194,
 /*  1100 */   198,  137,  140,  196,  199,  186,  200,  187,  203,  202,
 /*  1110 */   204,  206,  207,  208,  223,  236,  222,  221,  235,  238,
 /*  1120 */   239,  217,  250,  243,  277,  258,  268,  255,  257,  260,
 /*  1130 */   270,  245,  265,  269,  261,  271,  275,  283,  302,  292,
 /*  1140 */   307,  285,  325,  286,  360,  310,  370,  312,  371,  305,
 /*  1150 */   330,  334,  376,  384,  308,  385,  309,  388,   48,  408,
 /*  1160 */   315,  415,  368,  322,  389,  422,  825,  338,  423,  830,
 /*  1170 */   361,  331,  335,  324,  356,  359,  403,  404,  406,  407,
 /*  1180 */   411,  412,  340,  413,  416,  374,  395,  379,  831,  366,
 /*  1190 */   391,  390,  414,  417,  434,  437,  438,  439,  440,  441,
 /*  1200 */   443,  442,  801,  446,  802,  449,  729,  824,  459,  730,
 /*  1210 */   454,  457,  452,  453,  839,  463,  464,  462,  468,  467,
 /*  1220 */   470,  841,  472,  475,  477,  483,  842,  844,  492,  662,
 /*  1230 */   476,  490,  491,  495,  664,  498,  809,  850,  496,  511,
 /*  1240 */   499,  501,  480,  504,  721,  513,  502,  418,  505,  508,
 /*  1250 */   509,  419,  510,  515,  516,  518,  724,  526,  514,  521,
 /*  1260 */   520,  727,  523,  530,  522,  811,  532,  812,  533,  813,
 /*  1270 */   814,  815,  818,  820,  821,  819,  540,  544,  547,  548,
 /*  1280 */   816,  558,  551,  553,  851,  556,  550,  853,  552,  554,
 /*  1290 */   854,  560,  857,  514,  561,
};
static YYCODETYPE yy_lookahead[] = {
 /*     0 */    21,   11,   23,   68,   69,   70,   71,   72,   73,   74,
 /*    10 */    75,   76,   77,   78,   79,   80,   81,   47,   39,  131,
 /*    20 */   132,  133,  134,   44,   72,   73,   74,   75,   76,   77,
 /*    30 */    78,   79,   80,   81,   98,   99,  100,   58,   59,   60,
 /*    40 */    61,   62,   63,   64,   65,   66,   67,   68,   69,   70,
 /*    50 */    71,   72,   73,   74,   75,   76,   77,   78,   79,   80,
 /*    60 */    81,   23,  148,   39,   85,  151,  152,   97,   44,   76,
 /*    70 */    77,   78,   79,   80,   81,  155,   19,   60,    9,   10,
 /*    80 */    23,  161,   58,   59,   60,   61,   62,   63,   64,   65,
 /*    90 */    66,   67,   68,   69,   70,   71,   72,   73,   74,   75,
 /*   100 */    76,   77,   78,   79,   80,   81,  156,   50,   91,   92,
 /*   110 */    93,   94,   95,   96,   76,   77,  126,   60,  138,  102,
 /*   120 */   138,   23,   20,   85,   22,   87,  146,  147,   90,   91,
 /*   130 */    20,   26,   39,   76,   77,   78,   20,   44,   22,   34,
 /*   140 */   158,   84,   85,   86,   87,  165,  166,   90,   91,  199,
 /*   150 */   126,   58,   59,   60,   61,   62,   63,   64,   65,   66,
 /*   160 */    67,   68,   69,   70,   71,   72,   73,   74,   75,   76,
 /*   170 */    77,   78,   79,   80,   81,  138,  194,   14,    0,    9,
 /*   180 */   123,  124,  125,   85,   86,  203,   88,    9,   10,  138,
 /*   190 */    92,   93,   94,   23,  143,  158,   19,  146,  147,    9,
 /*   200 */    23,  103,   39,   19,   88,   21,   20,   44,   92,   93,
 /*   210 */    94,   78,   79,   80,   81,  105,    9,  107,  108,  103,
 /*   220 */   127,   58,   59,   60,   61,   62,   63,   64,   65,   66,
 /*   230 */    67,   68,   69,   70,   71,   72,   73,   74,   75,   76,
 /*   240 */    77,   78,   79,   80,   81,   88,   23,   39,    9,   92,
 /*   250 */    93,   94,   44,  133,  134,   85,   86,  154,  155,   23,
 /*   260 */   103,   19,   85,   86,  161,   23,   58,   59,   60,   61,
 /*   270 */    62,   63,   64,   65,   66,   67,   68,   69,   70,   71,
 /*   280 */    72,   73,   74,   75,   76,   77,   78,   79,   80,   81,
 /*   290 */    29,  105,   50,  107,  108,   76,   77,   14,   20,   76,
 /*   300 */    77,   20,   60,   19,   19,  138,   87,   19,   85,   86,
 /*   310 */   138,   23,  105,   52,  107,  108,   14,   39,   76,   77,
 /*   320 */    97,   85,   44,   33,  141,  158,   84,   85,   86,   87,
 /*   330 */   158,   41,   90,   91,   51,  127,   58,   59,   60,   61,
 /*   340 */    62,   63,   64,   65,   66,   67,   68,   69,   70,   71,
 /*   350 */    72,   73,   74,   75,   76,   77,   78,   79,   80,   81,
 /*   360 */    20,  194,  101,  191,  192,  123,  124,  125,  126,   15,
 /*   370 */   203,  145,   19,   85,   86,   45,   23,  137,   24,   39,
 /*   380 */     9,   98,   99,  100,   44,   20,  105,  204,  107,  108,
 /*   390 */    60,   37,  109,  210,   40,  111,  111,  171,   58,   59,
 /*   400 */    60,   61,   62,   63,   64,   65,   66,   67,   68,   69,
 /*   410 */    70,   71,   72,   73,   74,   75,   76,   77,   78,   79,
 /*   420 */    80,   81,  196,   21,   39,   23,    9,   97,  126,   44,
 /*   430 */   128,  106,  102,  161,  162,  110,  138,  211,   85,   86,
 /*   440 */   168,   11,  216,   58,   59,   60,   61,   62,   63,   64,
 /*   450 */    65,   66,   67,   68,   69,   70,   71,   72,   73,   74,
 /*   460 */    75,   76,   77,   78,   79,   80,   81,    9,   23,   39,
 /*   470 */   105,    9,  107,  108,   44,    9,  105,    9,  107,  108,
 /*   480 */    17,    9,   97,   89,   12,   91,  145,   85,   58,   59,
 /*   490 */    60,   61,   62,   63,   64,   65,   66,   67,   68,   69,
 /*   500 */    70,   71,   72,   73,   74,   75,   76,   77,   78,   79,
 /*   510 */    80,   81,  171,   23,   39,    9,    9,   91,   55,   44,
 /*   520 */    57,   98,   99,  100,  183,  184,   19,   22,  102,  188,
 /*   530 */    85,   86,  137,   58,   59,   60,   61,   62,   63,   64,
 /*   540 */    65,   66,   67,   68,   69,   70,   71,   72,   73,   74,
 /*   550 */    75,   76,   77,   78,   79,   80,   81,   23,  113,   39,
 /*   560 */    23,   53,   54,  105,   44,  107,  108,  105,   61,  107,
 /*   570 */   108,  105,   21,  107,  108,   85,   86,    9,   58,   59,
 /*   580 */    60,   61,   62,   63,   64,   65,   66,   67,   68,   69,
 /*   590 */    70,   71,   72,   73,   74,   75,   76,   77,   78,   79,
 /*   600 */    80,   81,   23,  113,   39,  183,  184,  106,  174,   44,
 /*   610 */   109,  105,   78,  107,  108,  181,   20,  112,   22,   85,
 /*   620 */    86,   60,   85,   58,   59,   60,   61,   62,   63,   64,
 /*   630 */    65,   66,   67,   68,   69,   70,   71,   72,   73,   74,
 /*   640 */    75,   76,   77,   78,   79,   80,   81,  138,  138,   39,
 /*   650 */   138,   20,   91,   22,   44,   20,  137,   22,   17,   20,
 /*   660 */   123,   22,  111,   87,   85,   86,   90,  158,  158,   59,
 /*   670 */    60,   61,   62,   63,   64,   65,   66,   67,   68,   69,
 /*   680 */    70,   71,   72,   73,   74,   75,   76,   77,   78,   79,
 /*   690 */    80,   81,  138,   20,   39,   22,   55,   22,   57,   44,
 /*   700 */    19,  192,  190,    9,   23,    9,   19,  151,  151,   20,
 /*   710 */    23,   22,  158,  203,  137,   60,   61,   62,   63,   64,
 /*   720 */    65,   66,   67,   68,   69,   70,   71,   72,   73,   74,
 /*   730 */    75,   76,   77,   78,   79,   80,   81,   50,  182,  182,
 /*   740 */   135,  136,   25,   22,  139,   28,   87,   60,   19,   90,
 /*   750 */   145,  138,   23,    9,  200,  199,   20,   39,   22,   86,
 /*   760 */    43,   86,   44,   76,   77,  138,   85,    9,  151,   48,
 /*   770 */   129,   84,   85,   86,   87,  138,  171,   90,   91,   50,
 /*   780 */   167,   23,  145,   18,   66,   67,  113,    9,  113,   60,
 /*   790 */    45,   20,   20,   22,   22,  158,  109,   22,   19,  182,
 /*   800 */    22,  196,   23,  140,  144,   76,   77,   78,  171,   91,
 /*   810 */   123,  124,  125,   84,   85,   86,   87,  138,  205,   90,
 /*   820 */    91,  138,   11,   15,   13,   14,   15,   16,  138,   50,
 /*   830 */   138,  194,   24,  206,  207,  208,   97,  158,   27,   60,
 /*   840 */   203,  158,   97,   85,   86,   37,   35,  149,   40,   20,
 /*   850 */    60,   22,  123,  124,  125,   76,   77,  167,   93,   51,
 /*   860 */    49,  145,   51,   84,   85,   86,   87,   56,  138,   90,
 /*   870 */    91,  138,   97,  138,   31,  145,  138,  198,   88,   89,
 /*   880 */   145,   91,   92,   93,   94,   95,   96,  171,  158,  138,
 /*   890 */    20,  145,  102,  158,  129,  205,    9,  205,  120,  138,
 /*   900 */   167,  171,  123,  124,  125,  167,  171,  138,  138,   98,
 /*   910 */    99,  100,  196,  145,  138,  104,   97,  171,  167,  158,
 /*   920 */   109,  138,  138,  138,  194,  138,  138,  211,  158,  138,
 /*   930 */   111,    9,  216,  203,  158,  138,    9,  138,  205,  171,
 /*   940 */   138,  158,  158,  205,  138,  158,  158,  138,  138,  158,
 /*   950 */   138,  138,  138,  138,  138,  158,  205,  158,  138,  198,
 /*   960 */   158,  138,  138,  138,  158,  138,  138,  158,  158,   58,
 /*   970 */   158,  158,  158,  158,  158,  190,  138,  138,  158,  138,
 /*   980 */   138,  158,  158,  158,  138,  158,  158,  138,  138,  138,
 /*   990 */   138,  138,  138,  138,  138,  138,  158,  158,  138,  158,
 /*  1000 */   158,   20,  138,   22,  158,  138,  138,  158,  158,  158,
 /*  1010 */   145,  158,  158,  158,  158,  158,  109,  138,  158,   97,
 /*  1020 */     9,   20,  158,   22,   20,  158,   22,  138,  109,  122,
 /*  1030 */   101,  145,  121,   20,    9,   22,  171,  158,  111,   87,
 /*  1040 */   111,  122,   90,  170,  156,   42,  156,  195,  164,  157,
 /*  1050 */   156,   46,  156,   19,  111,  111,  109,  171,  190,  120,
 /*  1060 */   175,  178,  117,  172,  171,  115,  118,  153,  173,   87,
 /*  1070 */   119,   46,   87,  176,  153,  177,  153,  116,  179,   22,
 /*  1080 */   180,  157,   96,   23,  195,  150,  111,  138,  111,   81,
 /*  1090 */    91,  138,  138,  109,  193,  126,  109,  109,   14,   19,
 /*  1100 */    22,  199,  199,   20,  138,  201,   20,  202,  138,   22,
 /*  1110 */    20,   22,  138,   20,  142,  142,  138,  111,  138,  193,
 /*  1120 */   157,   22,  185,  116,   97,  113,  186,  138,  138,  138,
 /*  1130 */   114,  120,  138,  187,  142,   19,  138,   20,   20,  111,
 /*  1140 */   138,  186,   19,  187,   20,  162,   46,  138,   19,  156,
 /*  1150 */   193,  193,   19,   46,  159,   19,  160,   95,  102,   21,
 /*  1160 */   163,   97,  138,  163,  138,   38,   11,  150,   36,   97,
 /*  1170 */   151,  157,  157,  163,  153,  153,  138,  142,  138,  142,
 /*  1180 */   138,  142,  164,  212,  138,  156,  166,  156,   97,  166,
 /*  1190 */   160,  159,  213,  142,   47,  129,  138,  142,   97,  138,
 /*  1200 */    19,  142,    9,  156,  129,   11,  121,    9,    9,  121,
 /*  1210 */   169,   14,   58,  170,   14,  138,  101,  169,   61,  138,
 /*  1220 */   176,    9,   61,  121,   19,   19,    9,    9,  176,    9,
 /*  1230 */   138,  112,  138,  138,    9,  138,    9,    9,  142,  176,
 /*  1240 */   142,  138,  197,  138,    9,  169,  142,  214,  142,  112,
 /*  1250 */   138,  215,  142,  142,  101,  176,    9,   19,  138,  138,
 /*  1260 */   121,    9,  197,  138,  142,    9,  138,    9,  142,    9,
 /*  1270 */     9,    9,    9,    9,    9,    9,  209,  209,  138,   20,
 /*  1280 */     9,   32,  151,  138,    9,  151,  217,    9,   21,  218,
 /*  1290 */     9,  217,    9,  219,  138,
};
#define YY_SHIFT_USE_DFLT (-66)
static short yy_shift_ofst[] = {
 /*     0 */    69,  178,  -66,  811,  190,  -66,  239,  472,  417,  170,
 /*    10 */   468,  -66,  -66,  -66,  472,  568,  472,  694,  472,  696,
 /*    20 */   184,  744,  579,  102,  870,  887,   98,  -66,  236,  -66,
 /*    30 */   790,  -66,  579,   17,  -66,  739,  -66,  843,  808,  -66,
 /*    40 */   -66,  -66,  -66,  -66,  -66,  426,  739,  -66, 1003,  -66,
 /*    50 */   290,  -66,  -66, 1005,  105,  739,  -66,  -66,  -66,  739,
 /*    60 */   -66, 1034,  779,  284,   57,  943,  944,  687,  -66,  110,
 /*    70 */   947,  -66,  325,  -66,  505,  939,  945,  948,  950,  951,
 /*    80 */   -66,  219,  -66,  982,  -66,  985,  -66,  721,  219,  -66,
 /*    90 */   219,  -66,  961,  779, 1057,  779,  986,  105,  -66, 1060,
 /*   100 */   -66,  -66,  475,  779,  -66,  975,  579,  977,  579,  -66,
 /*   110 */   -66,  -66,  -66,  -66,  655,  779,  610,  779,  -48,  779,
 /*   120 */   -48,  779,  -48,  779,  -48,  779,  -65,  779,  -65,  779,
 /*   130 */    -7,  779,   -7,  779,   -7,  779,   -7,  779,  -65,  718,
 /*   140 */   779,  -65,  -66,  -66,  779,  133,  779,  133,  779, 1008,
 /*   150 */   779, 1008,  779, 1008,  779,  -66,  -66,  561,  -66,  999,
 /*   160 */   -66,  -66,  779,  520,  779,  -65,  177,  687,  186,  501,
 /*   170 */   984,  987,  988,  -66,  475,  779,  655,  779,  -66,  779,
 /*   180 */   -66,  779,  -66,  242,   24,  969,  302, 1084,  -66,  779,
 /*   190 */    93,  779,  475, 1080,  354, 1083,  -66, 1078,  579, 1086,
 /*   200 */   -66, 1087,  579, 1090,  -66, 1089,  579, 1093,  -66,  779,
 /*   210 */   163,  779,  208,  779,  475,  596,  -66,  779,  -66,  -66,
 /*   220 */  1006,  579,  -66,  -66,  -66,  779,  565,  779,  655,  288,
 /*   230 */   687,  281,  -66,  631,  -66, 1006,  -66,  986,  105,  -66,
 /*   240 */   779,  475, 1007,  779, 1099,  779,  475,  -66,  -66,  675,
 /*   250 */   -66,  -66,  -66,  445,  -66,  490,  -66, 1012,  -66,  353,
 /*   260 */  1006,  402,  -66,  -66,  579,  -66,  -66, 1027, 1016,  -66,
 /*   270 */  1116,  579,  635,  -66,  579,  -66,  -66,  779,  475,  947,
 /*   280 */   365,  673, 1117,  402, 1027, 1016,  -66,  729,  -21,  -66,
 /*   290 */   -66, 1028,  534,  -66,  -66,  -66,  -66,  278,  -66,  639,
 /*   300 */   -66, 1118,  -66,  340,  739,  -66,  579, 1123,  -66,  745,
 /*   310 */   -66,  579,  -66,  -64,  261,  -66,  394,  -66,  -66,  -66,
 /*   320 */   -66,  261,  -66,  261,  -66,  579,  689,  -66,  579,  986,
 /*   330 */   105,  -66,  -66,  986,  105,  -66,  -66, 1060,  -66, 1003,
 /*   340 */   -66,  -66,   38,  -66,  -66,  -66,  576,  -66,  -66,  659,
 /*   350 */   -66,  -66,  -66,  -66,  681,  219,  736,  -66,  219, 1124,
 /*   360 */   -66,  -66,  -66,  -66,  116,  157,  -66,  579,  -66, 1100,
 /*   370 */  1129,  579,  771,  739,  -66, 1133,  579,  772,  739,  -66,
 /*   380 */   779,  385,  -66, 1107, 1136,  579,  829, 1062,  579, 1123,
 /*   390 */   -66,  330, 1056,  -66,  -66,  -66,  -66,  -66,  947,  207,
 /*   400 */   765,  463,  579, 1006,  -66,  579,  551, 1138,  947,  371,
 /*   410 */   579, 1006,  717,  423, 1064,  579, 1006, 1127,  -10, 1155,
 /*   420 */   779,  430, 1132,  508,  -66,  -66, 1072, 1091,  -30,  579,
 /*   430 */   775,  -66,  -66, 1147,  -66,  -66, 1066,  579,  819, 1101,
 /*   440 */   579,  285, 1181,  579,  981,  922, 1193, 1075, 1194,  283,
 /*   450 */   458,  911,  808,  -66, 1085, 1088, 1197, 1198, 1199,  283,
 /*   460 */  1200, 1154,  579, 1115,  579,  778,  579, 1157,  779,  475,
 /*   470 */  1212, 1161,  779,  475, 1102,  579, 1205,  579, 1001,  -66,
 /*   480 */   907,  462, 1206,  779, 1004,  779,  475, 1217,  475, 1119,
 /*   490 */   579, 1011, 1218,  641,  579,  927, 1220,  579,  927, 1225,
 /*   500 */   579,  927, 1227,  579,  927, 1228,  466, 1137,  579, 1006,
 /*   510 */  1011, 1235, 1154,  579,  929, 1153,  579,  778, 1247, 1139,
 /*   520 */   579, 1006, 1205,  919,  506, 1238,  779, 1013, 1252,  758,
 /*   530 */  1256,  579, 1006,  507,  223, 1258, 1260, 1261, 1262,  952,
 /*   540 */  1263, 1264, 1265,  952, 1266,  -66,  579, 1259, 1271, 1249,
 /*   550 */   236, 1267,  579, 1025, 1275,  537, 1278, 1281,  -66, 1249,
 /*   560 */   579, 1283,  -66,  -66,  -66,
};
#define YY_REDUCE_USE_DFLT (-113)
static short yy_reduce_ofst[] = {
 /*     0 */  -112,  120, -113,  605, -113, -113, -113,  240, -113,  298,
 /*    10 */  -113, -113, -113, -113,  395, -113,  519, -113,  577, -113,
 /*    20 */   663, -113,   51,  660, -113, -113,  -20, -113,  -86,  698,
 /*    30 */   103, -113,  769,  -80, -113,  888, -113, -113,  873, -113,
 /*    40 */  -113, -113, -113, -113, -113, -113,  890, -113,  884, -113,
 /*    50 */  -113, -113, -113, -113,  892,  894, -113, -113, -113,  896,
 /*    60 */  -113, -113,   37, -113,  -18, -113, -113,  735, -113,  891,
 /*    70 */   893, -113,  895,  434,  885,  897,  898,  883,  899,  900,
 /*    80 */  -113,  914, -113, -113, -113, -113, -113, -113,  921, -113,
 /*    90 */   923, -113, -113,  172, -113,  509,  901,  924, -113,  935,
 /*   100 */  -113, -113,  902,  683, -113, -113,  949, -113,  953, -113,
 /*   110 */  -113, -113, -113, -113,  902,  770,  902,  776,  902,  783,
 /*   120 */   902,  784,  902,  787,  902,  788,  902,  797,  902,  799,
 /*   130 */   902,  802,  902,  806,  902,  809,  902,  810,  902,  903,
 /*   140 */   812,  902, -113, -113,  813,  902,  814,  902,  815,  902,
 /*   150 */   816,  902,  820,  902,  823,  902, -113, -113, -113, -113,
 /*   160 */  -113, -113,  824,  902,  825,  902,  954,  637,  891, -113,
 /*   170 */  -113, -113, -113, -113,  902,  827,  902,  828,  902,  838,
 /*   180 */   902,  839,  902,  554,  902,  904,  905, -113, -113,  841,
 /*   190 */   902,  842,  902, -113, -113, -113, -113, -113,  966, -113,
 /*   200 */  -113, -113,  970, -113, -113, -113,  974, -113, -113,  846,
 /*   210 */   902,  849,  902,  851,  902, -113, -113,  510, -113, -113,
 /*   220 */   972,  978, -113, -113, -113,  853,  902,  854,  902,  980,
 /*   230 */   730,  891, -113, -113, -113,  973, -113,  926,  963, -113,
 /*   240 */   855,  902, -113,  167, -113,  856,  902, -113,  422,  937,
 /*   250 */  -113, -113, -113,  989, -113,  990, -113, -113, -113,  991,
 /*   260 */   992,  557, -113, -113,  994, -113, -113,  940,  946, -113,
 /*   270 */  -113,  512, -113, -113,  998, -113, -113,  857,  902,  341,
 /*   280 */   891,  937, -113,  617,  955,  956, -113,  860,  556, -113,
 /*   290 */  -113, -113,  949, -113, -113, -113, -113,  902, -113, -113,
 /*   300 */  -113, -113, -113,  902,  993, -113, 1002,  995,  996,  983,
 /*   310 */  -113, 1009, -113, -113,  997, -113, -113, -113, -113, -113,
 /*   320 */  -113, 1000, -113, 1010, -113,  613, -113, -113,  692,  957,
 /*   330 */  1014, -113, -113,  958, 1015, -113, -113, 1017, -113, 1018,
 /*   340 */  -113, -113, -113, -113, -113, -113, -113, -113, -113, -113,
 /*   350 */  -113, -113, -113, -113, 1019, 1021, -113, -113, 1022, -113,
 /*   360 */  -113, -113, -113, -113, 1020, 1023, -113, 1024, -113, -113,
 /*   370 */  -113,  690, -113, 1029, -113, -113,  733, -113, 1031, -113,
 /*   380 */   791,  -50, -113, -113, -113,  738, -113, -113, 1026, 1032,
 /*   390 */  1030,  272, -113, -113, -113, -113, -113, -113,  746,  891,
 /*   400 */   183, -113, 1038, 1035, -113, 1040, 1037, -113,  768,  891,
 /*   410 */  1042, 1039,  971,  979, -113, 1046, 1051, 1033, 1036, -113,
 /*   420 */   850,  902, -113, -113, -113, -113, -113, -113, -113,  785,
 /*   430 */  -113, -113, -113, -113, -113, -113, -113, 1058, 1055, -113,
 /*   440 */  1061, 1059, -113,  751, -113, 1047, -113, -113, -113,  226,
 /*   450 */   891, 1041, 1043, -113, -113, -113, -113, -113, -113,  716,
 /*   460 */  -113, 1048, 1077, -113,  852, 1044, 1081, -113,  864,  902,
 /*   470 */  -113, -113,  867,  902, -113, 1092, 1045,  868, -113, -113,
 /*   480 */   865,  891, -113,  679, -113,  879,  902, -113,  902, -113,
 /*   490 */  1094, 1052, -113, -113, 1095, 1096, -113, 1097, 1098, -113,
 /*   500 */  1103, 1104, -113, 1105, 1106, -113,  891, -113, 1112, 1110,
 /*   510 */  1063, -113, 1076, 1120, 1111, -113,  889, 1079, -113, -113,
 /*   520 */  1121, 1122, 1065,  886,  891, -113,  761, -113, -113, 1125,
 /*   530 */  -113, 1128, 1126, -113,  627, -113, -113, -113, -113, 1067,
 /*   540 */  -113, -113, -113, 1068, -113, -113, 1140, -113, -113, 1069,
 /*   550 */  1131, -113, 1145, 1071, -113, 1134, -113, -113, -113, 1074,
 /*   560 */  1156, -113, -113, -113, -113,
};
static YYACTIONTYPE yy_default[] = {
 /*     0 */   572,  572,  566,  858,  858,  568,  858,  858,  858,  858,
 /*    10 */   858,  593,  594,  595,  858,  858,  858,  858,  858,  858,
 /*    20 */   858,  858,  858,  858,  858,  858,  858,  586,  596,  606,
 /*    30 */   588,  605,  858,  858,  607,  653,  618,  858,  858,  654,
 /*    40 */   657,  658,  659,  660,  661,  858,  653,  619,  638,  636,
 /*    50 */   858,  639,  640,  858,  710,  653,  620,  708,  709,  653,
 /*    60 */   621,  858,  858,  739,  800,  745,  740,  858,  666,  858,
 /*    70 */   858,  667,  675,  677,  684,  722,  713,  715,  703,  717,
 /*    80 */   672,  858,  602,  858,  603,  858,  604,  718,  858,  719,
 /*    90 */   858,  720,  858,  858,  704,  858,  711,  710,  705,  858,
 /*   100 */   590,  712,  707,  858,  738,  858,  858,  741,  858,  742,
 /*   110 */   743,  744,  746,  747,  750,  858,  751,  858,  752,  858,
 /*   120 */   753,  858,  754,  858,  755,  858,  756,  858,  757,  858,
 /*   130 */   758,  858,  759,  858,  760,  858,  761,  858,  762,  858,
 /*   140 */   858,  763,  764,  765,  858,  766,  858,  767,  858,  768,
 /*   150 */   858,  769,  858,  770,  858,  771,  772,  858,  773,  858,
 /*   160 */   776,  774,  858,  858,  858,  782,  858,  800,  858,  858,
 /*   170 */   858,  858,  858,  785,  799,  858,  777,  858,  778,  858,
 /*   180 */   779,  858,  780,  858,  858,  858,  858,  858,  790,  858,
 /*   190 */   858,  858,  791,  858,  858,  858,  846,  858,  858,  858,
 /*   200 */   847,  858,  858,  858,  848,  858,  858,  858,  849,  858,
 /*   210 */   858,  858,  858,  858,  792,  858,  784,  800,  797,  798,
 /*   220 */   692,  858,  693,  788,  775,  858,  858,  858,  783,  858,
 /*   230 */   800,  858,  787,  858,  786,  692,  789,  711,  710,  706,
 /*   240 */   858,  716,  858,  800,  714,  858,  723,  676,  687,  685,
 /*   250 */   686,  694,  695,  858,  696,  858,  697,  858,  698,  858,
 /*   260 */   692,  683,  591,  592,  858,  681,  682,  700,  702,  688,
 /*   270 */   858,  858,  858,  701,  858,  735,  736,  858,  699,  687,
 /*   280 */   858,  858,  858,  683,  700,  702,  689,  858,  683,  678,
 /*   290 */   679,  858,  858,  680,  673,  674,  781,  858,  737,  858,
 /*   300 */   748,  858,  749,  858,  653,  622,  858,  804,  626,  623,
 /*   310 */   627,  858,  628,  858,  858,  629,  858,  632,  633,  634,
 /*   320 */   635,  858,  630,  858,  631,  858,  858,  805,  858,  711,
 /*   330 */   710,  806,  808,  711,  710,  807,  624,  858,  625,  638,
 /*   340 */   637,  608,  858,  609,  610,  611,  858,  612,  615,  858,
 /*   350 */   613,  616,  614,  617,  597,  858,  858,  598,  858,  858,
 /*   360 */   599,  601,  600,  589,  858,  858,  643,  858,  646,  858,
 /*   370 */   858,  858,  858,  653,  647,  858,  858,  858,  653,  648,
 /*   380 */   858,  653,  649,  858,  858,  858,  858,  858,  858,  804,
 /*   390 */   626,  651,  858,  650,  652,  644,  645,  587,  858,  858,
 /*   400 */   583,  858,  858,  692,  581,  858,  858,  858,  858,  858,
 /*   410 */   858,  692,  829,  858,  858,  858,  692,  834,  858,  858,
 /*   420 */   858,  858,  858,  858,  835,  836,  858,  858,  858,  858,
 /*   430 */   858,  826,  827,  858,  828,  582,  858,  858,  858,  858,
 /*   440 */   858,  858,  858,  858,  858,  858,  858,  858,  858,  858,
 /*   450 */   858,  858,  858,  656,  858,  858,  858,  858,  858,  858,
 /*   460 */   858,  655,  858,  858,  858,  858,  858,  858,  858,  725,
 /*   470 */   858,  858,  858,  726,  858,  858,  733,  858,  858,  734,
 /*   480 */   858,  858,  858,  858,  858,  858,  731,  858,  732,  858,
 /*   490 */   858,  858,  858,  858,  858,  858,  858,  858,  858,  858,
 /*   500 */   858,  858,  858,  858,  858,  858,  858,  858,  858,  692,
 /*   510 */   858,  858,  655,  858,  858,  858,  858,  858,  858,  858,
 /*   520 */   858,  692,  733,  858,  858,  858,  858,  858,  858,  858,
 /*   530 */   858,  858,  692,  858,  823,  858,  858,  858,  858,  858,
 /*   540 */   858,  858,  858,  858,  858,  822,  858,  858,  858,  856,
 /*   550 */   858,  858,  858,  858,  858,  858,  858,  858,  855,  856,
 /*   560 */   858,  858,  569,  571,  567,
};
#define YY_SZ_ACTTAB (sizeof(yy_action)/sizeof(yy_action[0]))

/* The next table maps tokens into fallback tokens.  If a construct
** like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammer, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /* END_OF_FILE => nothing */
    0,  /*    ILLEGAL => nothing */
    0,  /*      SPACE => nothing */
    0,  /* UNCLOSED_STRING => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*     COLUMN => nothing */
    0,  /* AGG_FUNCTION => nothing */
    0,  /*       SEMI => nothing */
   23,  /*    EXPLAIN => ID */
   23,  /*      BEGIN => ID */
    0,  /* TRANSACTION => nothing */
    0,  /*     COMMIT => nothing */
   23,  /*        END => ID */
    0,  /*   ROLLBACK => nothing */
    0,  /*     CREATE => nothing */
    0,  /*      TABLE => nothing */
   23,  /*       TEMP => ID */
    0,  /*         LP => nothing */
    0,  /*         RP => nothing */
    0,  /*         AS => nothing */
    0,  /*      COMMA => nothing */
    0,  /*         ID => nothing */
   23,  /*      ABORT => ID */
   23,  /*      AFTER => ID */
   23,  /*        ASC => ID */
   23,  /*     ATTACH => ID */
   23,  /*     BEFORE => ID */
   23,  /*    CASCADE => ID */
   23,  /*    CLUSTER => ID */
   23,  /*   CONFLICT => ID */
   23,  /*   DATABASE => ID */
   23,  /*   DEFERRED => ID */
   23,  /*       DESC => ID */
   23,  /*     DETACH => ID */
   23,  /*       EACH => ID */
   23,  /*       FAIL => ID */
   23,  /*        FOR => ID */
   23,  /*       GLOB => ID */
   23,  /*     IGNORE => ID */
   23,  /*  IMMEDIATE => ID */
   23,  /*  INITIALLY => ID */
   23,  /*    INSTEAD => ID */
   23,  /*       LIKE => ID */
   23,  /*      MATCH => ID */
   23,  /*        KEY => ID */
   23,  /*         OF => ID */
   23,  /*     OFFSET => ID */
   23,  /*     PRAGMA => ID */
   23,  /*      RAISE => ID */
   23,  /*    REPLACE => ID */
   23,  /*   RESTRICT => ID */
   23,  /*        ROW => ID */
   23,  /*  STATEMENT => ID */
   23,  /*    TRIGGER => ID */
   23,  /*     VACUUM => ID */
   23,  /*       VIEW => ID */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*        NOT => nothing */
    0,  /*         EQ => nothing */
    0,  /*         NE => nothing */
    0,  /*     ISNULL => nothing */
    0,  /*    NOTNULL => nothing */
    0,  /*         IS => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IN => nothing */
    0,  /*         GT => nothing */
    0,  /*         GE => nothing */
    0,  /*         LT => nothing */
    0,  /*         LE => nothing */
    0,  /*     BITAND => nothing */
    0,  /*      BITOR => nothing */
    0,  /*     LSHIFT => nothing */
    0,  /*     RSHIFT => nothing */
    0,  /*       PLUS => nothing */
    0,  /*      MINUS => nothing */
    0,  /*       STAR => nothing */
    0,  /*      SLASH => nothing */
    0,  /*        REM => nothing */
    0,  /*     CONCAT => nothing */
    0,  /*     UMINUS => nothing */
    0,  /*      UPLUS => nothing */
    0,  /*     BITNOT => nothing */
    0,  /*     STRING => nothing */
    0,  /*    JOIN_KW => nothing */
    0,  /*    INTEGER => nothing */
    0,  /* CONSTRAINT => nothing */
    0,  /*    DEFAULT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*       NULL => nothing */
    0,  /*    PRIMARY => nothing */
    0,  /*     UNIQUE => nothing */
    0,  /*      CHECK => nothing */
    0,  /* REFERENCES => nothing */
    0,  /*    COLLATE => nothing */
    0,  /*         ON => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     UPDATE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*        SET => nothing */
    0,  /* DEFERRABLE => nothing */
    0,  /*    FOREIGN => nothing */
    0,  /*       DROP => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*        DOT => nothing */
    0,  /*       FROM => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      USING => nothing */
    0,  /*      ORDER => nothing */
    0,  /*         BY => nothing */
    0,  /*      GROUP => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*       INTO => nothing */
    0,  /*     VALUES => nothing */
    0,  /*       BLOB => nothing */
    0,  /*   VARIABLE => nothing */
    0,  /*       CASE => nothing */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*      INDEX => nothing */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  int stateno;       /* The state-number */
  int major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
  YYMINORTYPE minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int yyidx;                    /* Index of top element in stack */
  int yyerrcnt;                 /* Shifts left before out of the error */
  sqlite3ParserARG_SDECL                /* A place to hold %extra_argument */
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3ParserTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *yyTokenName[] = { 
  "$",             "END_OF_FILE",   "ILLEGAL",       "SPACE",       
  "UNCLOSED_STRING",  "COMMENT",       "FUNCTION",      "COLUMN",      
  "AGG_FUNCTION",  "SEMI",          "EXPLAIN",       "BEGIN",       
  "TRANSACTION",   "COMMIT",        "END",           "ROLLBACK",    
  "CREATE",        "TABLE",         "TEMP",          "LP",          
  "RP",            "AS",            "COMMA",         "ID",          
  "ABORT",         "AFTER",         "ASC",           "ATTACH",      
  "BEFORE",        "CASCADE",       "CLUSTER",       "CONFLICT",    
  "DATABASE",      "DEFERRED",      "DESC",          "DETACH",      
  "EACH",          "FAIL",          "FOR",           "GLOB",        
  "IGNORE",        "IMMEDIATE",     "INITIALLY",     "INSTEAD",     
  "LIKE",          "MATCH",         "KEY",           "OF",          
  "OFFSET",        "PRAGMA",        "RAISE",         "REPLACE",     
  "RESTRICT",      "ROW",           "STATEMENT",     "TRIGGER",     
  "VACUUM",        "VIEW",          "OR",            "AND",         
  "NOT",           "EQ",            "NE",            "ISNULL",      
  "NOTNULL",       "IS",            "BETWEEN",       "IN",          
  "GT",            "GE",            "LT",            "LE",          
  "BITAND",        "BITOR",         "LSHIFT",        "RSHIFT",      
  "PLUS",          "MINUS",         "STAR",          "SLASH",       
  "REM",           "CONCAT",        "UMINUS",        "UPLUS",       
  "BITNOT",        "STRING",        "JOIN_KW",       "INTEGER",     
  "CONSTRAINT",    "DEFAULT",       "FLOAT",         "NULL",        
  "PRIMARY",       "UNIQUE",        "CHECK",         "REFERENCES",  
  "COLLATE",       "ON",            "DELETE",        "UPDATE",      
  "INSERT",        "SET",           "DEFERRABLE",    "FOREIGN",     
  "DROP",          "UNION",         "ALL",           "INTERSECT",   
  "EXCEPT",        "SELECT",        "DISTINCT",      "DOT",         
  "FROM",          "JOIN",          "USING",         "ORDER",       
  "BY",            "GROUP",         "HAVING",        "LIMIT",       
  "WHERE",         "INTO",          "VALUES",        "BLOB",        
  "VARIABLE",      "CASE",          "WHEN",          "THEN",        
  "ELSE",          "INDEX",         "error",         "input",       
  "cmdlist",       "ecmd",          "explain",       "cmdx",        
  "cmd",           "trans_opt",     "nm",            "create_table",
  "create_table_args",  "temp",          "dbnm",          "columnlist",  
  "conslist_opt",  "select",        "column",        "columnid",    
  "type",          "carglist",      "id",            "ids",         
  "typename",      "signed",        "carg",          "ccons",       
  "onconf",        "sortorder",     "expr",          "idxlist_opt", 
  "refargs",       "defer_subclause",  "refarg",        "refact",      
  "init_deferred_pred_opt",  "conslist",      "tcons",         "idxlist",     
  "defer_subclause_opt",  "orconf",        "resolvetype",   "oneselect",   
  "multiselect_op",  "distinct",      "selcollist",    "from",        
  "where_opt",     "groupby_opt",   "having_opt",    "orderby_opt", 
  "limit_opt",     "sclp",          "as",            "seltablist",  
  "stl_prefix",    "joinop",        "on_opt",        "using_opt",   
  "seltablist_paren",  "joinop2",       "inscollist",    "sortlist",    
  "sortitem",      "collate",       "exprlist",      "setlist",     
  "insert_cmd",    "inscollist_opt",  "itemlist",      "likeop",      
  "case_operand",  "case_exprlist",  "case_else",     "expritem",    
  "uniqueflag",    "idxitem",       "plus_num",      "minus_num",   
  "plus_opt",      "number",        "trigger_decl",  "trigger_cmd_list",
  "trigger_time",  "trigger_event",  "foreach_clause",  "when_clause", 
  "trigger_cmd",   "database_kw_opt",  "key_opt",     
};
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *yyRuleName[] = {
 /*   0 */ "input ::= cmdlist",
 /*   1 */ "cmdlist ::= cmdlist ecmd",
 /*   2 */ "cmdlist ::= ecmd",
 /*   3 */ "ecmd ::= explain cmdx SEMI",
 /*   4 */ "ecmd ::= SEMI",
 /*   5 */ "cmdx ::= cmd",
 /*   6 */ "explain ::= EXPLAIN",
 /*   7 */ "explain ::=",
 /*   8 */ "cmd ::= BEGIN trans_opt",
 /*   9 */ "trans_opt ::=",
 /*  10 */ "trans_opt ::= TRANSACTION",
 /*  11 */ "trans_opt ::= TRANSACTION nm",
 /*  12 */ "cmd ::= COMMIT trans_opt",
 /*  13 */ "cmd ::= END trans_opt",
 /*  14 */ "cmd ::= ROLLBACK trans_opt",
 /*  15 */ "cmd ::= create_table create_table_args",
 /*  16 */ "create_table ::= CREATE temp TABLE nm dbnm",
 /*  17 */ "temp ::= TEMP",
 /*  18 */ "temp ::=",
 /*  19 */ "create_table_args ::= LP columnlist conslist_opt RP",
 /*  20 */ "create_table_args ::= AS select",
 /*  21 */ "columnlist ::= columnlist COMMA column",
 /*  22 */ "columnlist ::= column",
 /*  23 */ "column ::= columnid type carglist",
 /*  24 */ "columnid ::= nm",
 /*  25 */ "id ::= ID",
 /*  26 */ "ids ::= ID",
 /*  27 */ "ids ::= STRING",
 /*  28 */ "nm ::= ID",
 /*  29 */ "nm ::= STRING",
 /*  30 */ "nm ::= JOIN_KW",
 /*  31 */ "type ::=",
 /*  32 */ "type ::= typename",
 /*  33 */ "type ::= typename LP signed RP",
 /*  34 */ "type ::= typename LP signed COMMA signed RP",
 /*  35 */ "typename ::= ids",
 /*  36 */ "typename ::= typename ids",
 /*  37 */ "signed ::= INTEGER",
 /*  38 */ "signed ::= PLUS INTEGER",
 /*  39 */ "signed ::= MINUS INTEGER",
 /*  40 */ "carglist ::= carglist carg",
 /*  41 */ "carglist ::=",
 /*  42 */ "carg ::= CONSTRAINT nm ccons",
 /*  43 */ "carg ::= ccons",
 /*  44 */ "carg ::= DEFAULT STRING",
 /*  45 */ "carg ::= DEFAULT ID",
 /*  46 */ "carg ::= DEFAULT INTEGER",
 /*  47 */ "carg ::= DEFAULT PLUS INTEGER",
 /*  48 */ "carg ::= DEFAULT MINUS INTEGER",
 /*  49 */ "carg ::= DEFAULT FLOAT",
 /*  50 */ "carg ::= DEFAULT PLUS FLOAT",
 /*  51 */ "carg ::= DEFAULT MINUS FLOAT",
 /*  52 */ "carg ::= DEFAULT NULL",
 /*  53 */ "ccons ::= NULL onconf",
 /*  54 */ "ccons ::= NOT NULL onconf",
 /*  55 */ "ccons ::= PRIMARY KEY sortorder onconf",
 /*  56 */ "ccons ::= UNIQUE onconf",
 /*  57 */ "ccons ::= CHECK LP expr RP onconf",
 /*  58 */ "ccons ::= REFERENCES nm idxlist_opt refargs",
 /*  59 */ "ccons ::= defer_subclause",
 /*  60 */ "ccons ::= COLLATE id",
 /*  61 */ "refargs ::=",
 /*  62 */ "refargs ::= refargs refarg",
 /*  63 */ "refarg ::= MATCH nm",
 /*  64 */ "refarg ::= ON DELETE refact",
 /*  65 */ "refarg ::= ON UPDATE refact",
 /*  66 */ "refarg ::= ON INSERT refact",
 /*  67 */ "refact ::= SET NULL",
 /*  68 */ "refact ::= SET DEFAULT",
 /*  69 */ "refact ::= CASCADE",
 /*  70 */ "refact ::= RESTRICT",
 /*  71 */ "defer_subclause ::= NOT DEFERRABLE init_deferred_pred_opt",
 /*  72 */ "defer_subclause ::= DEFERRABLE init_deferred_pred_opt",
 /*  73 */ "init_deferred_pred_opt ::=",
 /*  74 */ "init_deferred_pred_opt ::= INITIALLY DEFERRED",
 /*  75 */ "init_deferred_pred_opt ::= INITIALLY IMMEDIATE",
 /*  76 */ "conslist_opt ::=",
 /*  77 */ "conslist_opt ::= COMMA conslist",
 /*  78 */ "conslist ::= conslist COMMA tcons",
 /*  79 */ "conslist ::= conslist tcons",
 /*  80 */ "conslist ::= tcons",
 /*  81 */ "tcons ::= CONSTRAINT nm",
 /*  82 */ "tcons ::= PRIMARY KEY LP idxlist RP onconf",
 /*  83 */ "tcons ::= UNIQUE LP idxlist RP onconf",
 /*  84 */ "tcons ::= CHECK expr onconf",
 /*  85 */ "tcons ::= FOREIGN KEY LP idxlist RP REFERENCES nm idxlist_opt refargs defer_subclause_opt",
 /*  86 */ "defer_subclause_opt ::=",
 /*  87 */ "defer_subclause_opt ::= defer_subclause",
 /*  88 */ "onconf ::=",
 /*  89 */ "onconf ::= ON CONFLICT resolvetype",
 /*  90 */ "orconf ::=",
 /*  91 */ "orconf ::= OR resolvetype",
 /*  92 */ "resolvetype ::= ROLLBACK",
 /*  93 */ "resolvetype ::= ABORT",
 /*  94 */ "resolvetype ::= FAIL",
 /*  95 */ "resolvetype ::= IGNORE",
 /*  96 */ "resolvetype ::= REPLACE",
 /*  97 */ "cmd ::= DROP TABLE nm dbnm",
 /*  98 */ "cmd ::= CREATE temp VIEW nm dbnm AS select",
 /*  99 */ "cmd ::= DROP VIEW nm dbnm",
 /* 100 */ "cmd ::= select",
 /* 101 */ "select ::= oneselect",
 /* 102 */ "select ::= select multiselect_op oneselect",
 /* 103 */ "multiselect_op ::= UNION",
 /* 104 */ "multiselect_op ::= UNION ALL",
 /* 105 */ "multiselect_op ::= INTERSECT",
 /* 106 */ "multiselect_op ::= EXCEPT",
 /* 107 */ "oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt",
 /* 108 */ "distinct ::= DISTINCT",
 /* 109 */ "distinct ::= ALL",
 /* 110 */ "distinct ::=",
 /* 111 */ "sclp ::= selcollist COMMA",
 /* 112 */ "sclp ::=",
 /* 113 */ "selcollist ::= sclp expr as",
 /* 114 */ "selcollist ::= sclp STAR",
 /* 115 */ "selcollist ::= sclp nm DOT STAR",
 /* 116 */ "as ::= AS nm",
 /* 117 */ "as ::= ids",
 /* 118 */ "as ::=",
 /* 119 */ "from ::=",
 /* 120 */ "from ::= FROM seltablist",
 /* 121 */ "stl_prefix ::= seltablist joinop",
 /* 122 */ "stl_prefix ::=",
 /* 123 */ "seltablist ::= stl_prefix nm dbnm as on_opt using_opt",
 /* 124 */ "seltablist ::= stl_prefix LP seltablist_paren RP as on_opt using_opt",
 /* 125 */ "seltablist_paren ::= select",
 /* 126 */ "seltablist_paren ::= seltablist",
 /* 127 */ "dbnm ::=",
 /* 128 */ "dbnm ::= DOT nm",
 /* 129 */ "joinop ::= COMMA",
 /* 130 */ "joinop ::= JOIN",
 /* 131 */ "joinop ::= JOIN_KW JOIN",
 /* 132 */ "joinop ::= JOIN_KW nm JOIN",
 /* 133 */ "joinop ::= JOIN_KW nm nm JOIN",
 /* 134 */ "on_opt ::= ON expr",
 /* 135 */ "on_opt ::=",
 /* 136 */ "using_opt ::= USING LP inscollist RP",
 /* 137 */ "using_opt ::=",
 /* 138 */ "orderby_opt ::=",
 /* 139 */ "orderby_opt ::= ORDER BY sortlist",
 /* 140 */ "sortlist ::= sortlist COMMA sortitem collate sortorder",
 /* 141 */ "sortlist ::= sortitem collate sortorder",
 /* 142 */ "sortitem ::= expr",
 /* 143 */ "sortorder ::= ASC",
 /* 144 */ "sortorder ::= DESC",
 /* 145 */ "sortorder ::=",
 /* 146 */ "collate ::=",
 /* 147 */ "collate ::= COLLATE id",
 /* 148 */ "groupby_opt ::=",
 /* 149 */ "groupby_opt ::= GROUP BY exprlist",
 /* 150 */ "having_opt ::=",
 /* 151 */ "having_opt ::= HAVING expr",
 /* 152 */ "limit_opt ::=",
 /* 153 */ "limit_opt ::= LIMIT signed",
 /* 154 */ "limit_opt ::= LIMIT signed OFFSET signed",
 /* 155 */ "limit_opt ::= LIMIT signed COMMA signed",
 /* 156 */ "cmd ::= DELETE FROM nm dbnm where_opt",
 /* 157 */ "where_opt ::=",
 /* 158 */ "where_opt ::= WHERE expr",
 /* 159 */ "cmd ::= UPDATE orconf nm dbnm SET setlist where_opt",
 /* 160 */ "setlist ::= setlist COMMA nm EQ expr",
 /* 161 */ "setlist ::= nm EQ expr",
 /* 162 */ "cmd ::= insert_cmd INTO nm dbnm inscollist_opt VALUES LP itemlist RP",
 /* 163 */ "cmd ::= insert_cmd INTO nm dbnm inscollist_opt select",
 /* 164 */ "insert_cmd ::= INSERT orconf",
 /* 165 */ "insert_cmd ::= REPLACE",
 /* 166 */ "itemlist ::= itemlist COMMA expr",
 /* 167 */ "itemlist ::= expr",
 /* 168 */ "inscollist_opt ::=",
 /* 169 */ "inscollist_opt ::= LP inscollist RP",
 /* 170 */ "inscollist ::= inscollist COMMA nm",
 /* 171 */ "inscollist ::= nm",
 /* 172 */ "expr ::= LP expr RP",
 /* 173 */ "expr ::= NULL",
 /* 174 */ "expr ::= ID",
 /* 175 */ "expr ::= JOIN_KW",
 /* 176 */ "expr ::= nm DOT nm",
 /* 177 */ "expr ::= nm DOT nm DOT nm",
 /* 178 */ "expr ::= INTEGER",
 /* 179 */ "expr ::= FLOAT",
 /* 180 */ "expr ::= STRING",
 /* 181 */ "expr ::= BLOB",
 /* 182 */ "expr ::= VARIABLE",
 /* 183 */ "expr ::= ID LP exprlist RP",
 /* 184 */ "expr ::= ID LP STAR RP",
 /* 185 */ "expr ::= expr AND expr",
 /* 186 */ "expr ::= expr OR expr",
 /* 187 */ "expr ::= expr LT expr",
 /* 188 */ "expr ::= expr GT expr",
 /* 189 */ "expr ::= expr LE expr",
 /* 190 */ "expr ::= expr GE expr",
 /* 191 */ "expr ::= expr NE expr",
 /* 192 */ "expr ::= expr EQ expr",
 /* 193 */ "expr ::= expr BITAND expr",
 /* 194 */ "expr ::= expr BITOR expr",
 /* 195 */ "expr ::= expr LSHIFT expr",
 /* 196 */ "expr ::= expr RSHIFT expr",
 /* 197 */ "expr ::= expr likeop expr",
 /* 198 */ "expr ::= expr NOT likeop expr",
 /* 199 */ "likeop ::= LIKE",
 /* 200 */ "likeop ::= GLOB",
 /* 201 */ "expr ::= expr PLUS expr",
 /* 202 */ "expr ::= expr MINUS expr",
 /* 203 */ "expr ::= expr STAR expr",
 /* 204 */ "expr ::= expr SLASH expr",
 /* 205 */ "expr ::= expr REM expr",
 /* 206 */ "expr ::= expr CONCAT expr",
 /* 207 */ "expr ::= expr ISNULL",
 /* 208 */ "expr ::= expr IS NULL",
 /* 209 */ "expr ::= expr NOTNULL",
 /* 210 */ "expr ::= expr NOT NULL",
 /* 211 */ "expr ::= expr IS NOT NULL",
 /* 212 */ "expr ::= NOT expr",
 /* 213 */ "expr ::= BITNOT expr",
 /* 214 */ "expr ::= MINUS expr",
 /* 215 */ "expr ::= PLUS expr",
 /* 216 */ "expr ::= LP select RP",
 /* 217 */ "expr ::= expr BETWEEN expr AND expr",
 /* 218 */ "expr ::= expr NOT BETWEEN expr AND expr",
 /* 219 */ "expr ::= expr IN LP exprlist RP",
 /* 220 */ "expr ::= expr IN LP select RP",
 /* 221 */ "expr ::= expr NOT IN LP exprlist RP",
 /* 222 */ "expr ::= expr NOT IN LP select RP",
 /* 223 */ "expr ::= expr IN nm dbnm",
 /* 224 */ "expr ::= expr NOT IN nm dbnm",
 /* 225 */ "expr ::= CASE case_operand case_exprlist case_else END",
 /* 226 */ "case_exprlist ::= case_exprlist WHEN expr THEN expr",
 /* 227 */ "case_exprlist ::= WHEN expr THEN expr",
 /* 228 */ "case_else ::= ELSE expr",
 /* 229 */ "case_else ::=",
 /* 230 */ "case_operand ::= expr",
 /* 231 */ "case_operand ::=",
 /* 232 */ "exprlist ::= exprlist COMMA expritem",
 /* 233 */ "exprlist ::= expritem",
 /* 234 */ "expritem ::= expr",
 /* 235 */ "expritem ::=",
 /* 236 */ "cmd ::= CREATE uniqueflag INDEX nm dbnm ON nm dbnm LP idxlist RP onconf",
 /* 237 */ "uniqueflag ::= UNIQUE",
 /* 238 */ "uniqueflag ::=",
 /* 239 */ "idxlist_opt ::=",
 /* 240 */ "idxlist_opt ::= LP idxlist RP",
 /* 241 */ "idxlist ::= idxlist COMMA idxitem collate sortorder",
 /* 242 */ "idxlist ::= idxitem collate sortorder",
 /* 243 */ "idxitem ::= nm",
 /* 244 */ "cmd ::= DROP INDEX nm dbnm",
 /* 245 */ "cmd ::= VACUUM",
 /* 246 */ "cmd ::= VACUUM nm",
 /* 247 */ "cmd ::= PRAGMA nm dbnm EQ nm",
 /* 248 */ "cmd ::= PRAGMA nm dbnm EQ ON",
 /* 249 */ "cmd ::= PRAGMA nm dbnm EQ plus_num",
 /* 250 */ "cmd ::= PRAGMA nm dbnm EQ minus_num",
 /* 251 */ "cmd ::= PRAGMA nm dbnm LP nm RP",
 /* 252 */ "cmd ::= PRAGMA nm dbnm",
 /* 253 */ "plus_num ::= plus_opt number",
 /* 254 */ "minus_num ::= MINUS number",
 /* 255 */ "number ::= INTEGER",
 /* 256 */ "number ::= FLOAT",
 /* 257 */ "plus_opt ::= PLUS",
 /* 258 */ "plus_opt ::=",
 /* 259 */ "cmd ::= CREATE trigger_decl BEGIN trigger_cmd_list END",
 /* 260 */ "trigger_decl ::= temp TRIGGER nm dbnm trigger_time trigger_event ON nm dbnm foreach_clause when_clause",
 /* 261 */ "trigger_time ::= BEFORE",
 /* 262 */ "trigger_time ::= AFTER",
 /* 263 */ "trigger_time ::= INSTEAD OF",
 /* 264 */ "trigger_time ::=",
 /* 265 */ "trigger_event ::= DELETE",
 /* 266 */ "trigger_event ::= INSERT",
 /* 267 */ "trigger_event ::= UPDATE",
 /* 268 */ "trigger_event ::= UPDATE OF inscollist",
 /* 269 */ "foreach_clause ::=",
 /* 270 */ "foreach_clause ::= FOR EACH ROW",
 /* 271 */ "foreach_clause ::= FOR EACH STATEMENT",
 /* 272 */ "when_clause ::=",
 /* 273 */ "when_clause ::= WHEN expr",
 /* 274 */ "trigger_cmd_list ::= trigger_cmd SEMI trigger_cmd_list",
 /* 275 */ "trigger_cmd_list ::=",
 /* 276 */ "trigger_cmd ::= UPDATE orconf nm SET setlist where_opt",
 /* 277 */ "trigger_cmd ::= insert_cmd INTO nm inscollist_opt VALUES LP itemlist RP",
 /* 278 */ "trigger_cmd ::= insert_cmd INTO nm inscollist_opt select",
 /* 279 */ "trigger_cmd ::= DELETE FROM nm where_opt",
 /* 280 */ "trigger_cmd ::= select",
 /* 281 */ "expr ::= RAISE LP IGNORE RP",
 /* 282 */ "expr ::= RAISE LP ROLLBACK COMMA nm RP",
 /* 283 */ "expr ::= RAISE LP ABORT COMMA nm RP",
 /* 284 */ "expr ::= RAISE LP FAIL COMMA nm RP",
 /* 285 */ "cmd ::= DROP TRIGGER nm dbnm",
 /* 286 */ "cmd ::= ATTACH database_kw_opt ids AS nm key_opt",
 /* 287 */ "key_opt ::=",
 /* 288 */ "key_opt ::= KEY ids",
 /* 289 */ "key_opt ::= KEY BLOB",
 /* 290 */ "database_kw_opt ::= DATABASE",
 /* 291 */ "database_kw_opt ::=",
 /* 292 */ "cmd ::= DETACH database_kw_opt nm",
};
#endif /* NDEBUG */

/*
** This function returns the symbolic name associated with a token
** value.
*/
const char *sqlite3ParserTokenName(int tokenType){
#ifndef NDEBUG
  if( tokenType>0 && tokenType<(sizeof(yyTokenName)/sizeof(yyTokenName[0])) ){
    return yyTokenName[tokenType];
  }else{
    return "Unknown";
  }
#else
  return "";
#endif
}

/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to sqlite3Parser and sqlite3ParserFree.
*/
void *sqlite3ParserAlloc(void *(*mallocProc)(size_t)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( (size_t)sizeof(yyParser) );
  if( pParser ){
    pParser->yyidx = -1;
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(YYCODETYPE yymajor, YYMINORTYPE *yypminor){
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are not used
    ** inside the C code.
    */
    case 145:
    case 171:
    case 188:
#line 291 "parse.y"
{sqlite3SelectDelete((yypminor->yy375));}
#line 1243 "parse.c"
      break;
    case 158:
    case 176:
    case 178:
    case 186:
    case 192:
    case 203:
#line 538 "parse.y"
{sqlite3ExprDelete((yypminor->yy164));}
#line 1253 "parse.c"
      break;
    case 159:
    case 167:
    case 174:
    case 177:
    case 179:
    case 181:
    case 191:
    case 194:
    case 195:
    case 198:
    case 201:
#line 753 "parse.y"
{sqlite3ExprListDelete((yypminor->yy232));}
#line 1268 "parse.c"
      break;
    case 175:
    case 183:
    case 184:
#line 358 "parse.y"
{sqlite3SrcListDelete((yypminor->yy283));}
#line 1275 "parse.c"
      break;
    case 187:
    case 190:
    case 197:
#line 430 "parse.y"
{sqlite3IdListDelete((yypminor->yy246));}
#line 1282 "parse.c"
      break;
    case 211:
    case 216:
#line 845 "parse.y"
{sqlite3DeleteTriggerStep((yypminor->yy107));}
#line 1288 "parse.c"
      break;
    case 213:
#line 829 "parse.y"
{sqlite3IdListDelete((yypminor->yy414).b);}
#line 1293 "parse.c"
      break;
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;
  yyStackEntry *yytos = &pParser->yystack[pParser->yyidx];

  if( pParser->yyidx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->yyidx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yymajor = yytos->major;
  yy_destructor( yymajor, &yytos->minor);
  pParser->yyidx--;
  return yymajor;
}

/* 
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from sqlite3ParserAlloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void sqlite3ParserFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  if( pParser==0 ) return;
  while( pParser->yyidx>=0 ) yy_pop_parser_stack(pParser);
  (*freeProc)((void*)pParser);
}

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_shift_action(
  yyParser *pParser,        /* The parser */
  int iLookAhead            /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
 
  /* if( pParser->yyidx<0 ) return YY_NO_ACTION;  */
  i = yy_shift_ofst[stateno];
  if( i==YY_SHIFT_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
    int iFallback;            /* Fallback token */
    if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
           && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
           yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
      }
#endif
      return yy_find_shift_action(pParser, iFallback);
    }
#endif
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_reduce_action(
  yyParser *pParser,        /* The parser */
  int iLookAhead            /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
 
  i = yy_reduce_ofst[stateno];
  if( i==YY_REDUCE_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer ot the minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yyidx++;
  if( yypParser->yyidx>=YYSTACKDEPTH ){
     sqlite3ParserARG_FETCH;
     yypParser->yyidx--;
#ifndef NDEBUG
     if( yyTraceFILE ){
       fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
     }
#endif
     while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
     /* Here code is inserted which will execute if the parser
     ** stack every overflows */
     sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument var */
     return;
  }
  yytos = &yypParser->yystack[yypParser->yyidx];
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor = *yypMinor;
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->yyidx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->yyidx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->yystack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 131, 1 },
  { 132, 2 },
  { 132, 1 },
  { 133, 3 },
  { 133, 1 },
  { 135, 1 },
  { 134, 1 },
  { 134, 0 },
  { 136, 2 },
  { 137, 0 },
  { 137, 1 },
  { 137, 2 },
  { 136, 2 },
  { 136, 2 },
  { 136, 2 },
  { 136, 2 },
  { 139, 5 },
  { 141, 1 },
  { 141, 0 },
  { 140, 4 },
  { 140, 2 },
  { 143, 3 },
  { 143, 1 },
  { 146, 3 },
  { 147, 1 },
  { 150, 1 },
  { 151, 1 },
  { 151, 1 },
  { 138, 1 },
  { 138, 1 },
  { 138, 1 },
  { 148, 0 },
  { 148, 1 },
  { 148, 4 },
  { 148, 6 },
  { 152, 1 },
  { 152, 2 },
  { 153, 1 },
  { 153, 2 },
  { 153, 2 },
  { 149, 2 },
  { 149, 0 },
  { 154, 3 },
  { 154, 1 },
  { 154, 2 },
  { 154, 2 },
  { 154, 2 },
  { 154, 3 },
  { 154, 3 },
  { 154, 2 },
  { 154, 3 },
  { 154, 3 },
  { 154, 2 },
  { 155, 2 },
  { 155, 3 },
  { 155, 4 },
  { 155, 2 },
  { 155, 5 },
  { 155, 4 },
  { 155, 1 },
  { 155, 2 },
  { 160, 0 },
  { 160, 2 },
  { 162, 2 },
  { 162, 3 },
  { 162, 3 },
  { 162, 3 },
  { 163, 2 },
  { 163, 2 },
  { 163, 1 },
  { 163, 1 },
  { 161, 3 },
  { 161, 2 },
  { 164, 0 },
  { 164, 2 },
  { 164, 2 },
  { 144, 0 },
  { 144, 2 },
  { 165, 3 },
  { 165, 2 },
  { 165, 1 },
  { 166, 2 },
  { 166, 6 },
  { 166, 5 },
  { 166, 3 },
  { 166, 10 },
  { 168, 0 },
  { 168, 1 },
  { 156, 0 },
  { 156, 3 },
  { 169, 0 },
  { 169, 2 },
  { 170, 1 },
  { 170, 1 },
  { 170, 1 },
  { 170, 1 },
  { 170, 1 },
  { 136, 4 },
  { 136, 7 },
  { 136, 4 },
  { 136, 1 },
  { 145, 1 },
  { 145, 3 },
  { 172, 1 },
  { 172, 2 },
  { 172, 1 },
  { 172, 1 },
  { 171, 9 },
  { 173, 1 },
  { 173, 1 },
  { 173, 0 },
  { 181, 2 },
  { 181, 0 },
  { 174, 3 },
  { 174, 2 },
  { 174, 4 },
  { 182, 2 },
  { 182, 1 },
  { 182, 0 },
  { 175, 0 },
  { 175, 2 },
  { 184, 2 },
  { 184, 0 },
  { 183, 6 },
  { 183, 7 },
  { 188, 1 },
  { 188, 1 },
  { 142, 0 },
  { 142, 2 },
  { 185, 1 },
  { 185, 1 },
  { 185, 2 },
  { 185, 3 },
  { 185, 4 },
  { 186, 2 },
  { 186, 0 },
  { 187, 4 },
  { 187, 0 },
  { 179, 0 },
  { 179, 3 },
  { 191, 5 },
  { 191, 3 },
  { 192, 1 },
  { 157, 1 },
  { 157, 1 },
  { 157, 0 },
  { 193, 0 },
  { 193, 2 },
  { 177, 0 },
  { 177, 3 },
  { 178, 0 },
  { 178, 2 },
  { 180, 0 },
  { 180, 2 },
  { 180, 4 },
  { 180, 4 },
  { 136, 5 },
  { 176, 0 },
  { 176, 2 },
  { 136, 7 },
  { 195, 5 },
  { 195, 3 },
  { 136, 9 },
  { 136, 6 },
  { 196, 2 },
  { 196, 1 },
  { 198, 3 },
  { 198, 1 },
  { 197, 0 },
  { 197, 3 },
  { 190, 3 },
  { 190, 1 },
  { 158, 3 },
  { 158, 1 },
  { 158, 1 },
  { 158, 1 },
  { 158, 3 },
  { 158, 5 },
  { 158, 1 },
  { 158, 1 },
  { 158, 1 },
  { 158, 1 },
  { 158, 1 },
  { 158, 4 },
  { 158, 4 },
  { 158, 3 },
  { 158, 3 },
  { 158, 3 },
  { 158, 3 },
  { 158, 3 },
  { 158, 3 },
  { 158, 3 },
  { 158, 3 },
  { 158, 3 },
  { 158, 3 },
  { 158, 3 },
  { 158, 3 },
  { 158, 3 },
  { 158, 4 },
  { 199, 1 },
  { 199, 1 },
  { 158, 3 },
  { 158, 3 },
  { 158, 3 },
  { 158, 3 },
  { 158, 3 },
  { 158, 3 },
  { 158, 2 },
  { 158, 3 },
  { 158, 2 },
  { 158, 3 },
  { 158, 4 },
  { 158, 2 },
  { 158, 2 },
  { 158, 2 },
  { 158, 2 },
  { 158, 3 },
  { 158, 5 },
  { 158, 6 },
  { 158, 5 },
  { 158, 5 },
  { 158, 6 },
  { 158, 6 },
  { 158, 4 },
  { 158, 5 },
  { 158, 5 },
  { 201, 5 },
  { 201, 4 },
  { 202, 2 },
  { 202, 0 },
  { 200, 1 },
  { 200, 0 },
  { 194, 3 },
  { 194, 1 },
  { 203, 1 },
  { 203, 0 },
  { 136, 12 },
  { 204, 1 },
  { 204, 0 },
  { 159, 0 },
  { 159, 3 },
  { 167, 5 },
  { 167, 3 },
  { 205, 1 },
  { 136, 4 },
  { 136, 1 },
  { 136, 2 },
  { 136, 5 },
  { 136, 5 },
  { 136, 5 },
  { 136, 5 },
  { 136, 6 },
  { 136, 3 },
  { 206, 2 },
  { 207, 2 },
  { 209, 1 },
  { 209, 1 },
  { 208, 1 },
  { 208, 0 },
  { 136, 5 },
  { 210, 11 },
  { 212, 1 },
  { 212, 1 },
  { 212, 2 },
  { 212, 0 },
  { 213, 1 },
  { 213, 1 },
  { 213, 1 },
  { 213, 3 },
  { 214, 0 },
  { 214, 3 },
  { 214, 3 },
  { 215, 0 },
  { 215, 2 },
  { 211, 3 },
  { 211, 0 },
  { 216, 6 },
  { 216, 8 },
  { 216, 5 },
  { 216, 4 },
  { 216, 1 },
  { 158, 4 },
  { 158, 6 },
  { 158, 6 },
  { 158, 6 },
  { 136, 4 },
  { 136, 6 },
  { 218, 0 },
  { 218, 2 },
  { 218, 2 },
  { 217, 1 },
  { 217, 0 },
  { 136, 3 },
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  sqlite3ParserARG_FETCH;
  yymsp = &yypParser->yystack[yypParser->yyidx];
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno>=0 
        && yyruleno<sizeof(yyRuleName)/sizeof(yyRuleName[0]) ){
    fprintf(yyTraceFILE, "%sReduce [%s].\n", yyTracePrompt,
      yyRuleName[yyruleno]);
  }
#endif /* NDEBUG */

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
      case 5:
#line 77 "parse.y"
{ sqlite3FinishCoding(pParse); }
#line 1801 "parse.c"
        break;
      case 6:
#line 78 "parse.y"
{ sqlite3BeginParse(pParse, 1); }
#line 1806 "parse.c"
        break;
      case 7:
#line 79 "parse.y"
{ sqlite3BeginParse(pParse, 0); }
#line 1811 "parse.c"
        break;
      case 8:
#line 84 "parse.y"
{sqlite3BeginTransaction(pParse);}
#line 1816 "parse.c"
        break;
      case 12:
      case 13:
#line 88 "parse.y"
{sqlite3CommitTransaction(pParse);}
#line 1822 "parse.c"
        break;
      case 14:
#line 90 "parse.y"
{sqlite3RollbackTransaction(pParse);}
#line 1827 "parse.c"
        break;
      case 16:
#line 95 "parse.y"
{
   sqlite3StartTable(pParse,&yymsp[-4].minor.yy0,&yymsp[-1].minor.yy318,&yymsp[0].minor.yy318,yymsp[-3].minor.yy424,0);
}
#line 1834 "parse.c"
        break;
      case 17:
      case 74:
      case 108:
#line 99 "parse.y"
{yygotominor.yy424 = 1;}
#line 1841 "parse.c"
        break;
      case 18:
      case 73:
      case 75:
      case 86:
      case 109:
      case 110:
#line 100 "parse.y"
{yygotominor.yy424 = 0;}
#line 1851 "parse.c"
        break;
      case 19:
#line 101 "parse.y"
{
  sqlite3EndTable(pParse,&yymsp[0].minor.yy0,0);
}
#line 1858 "parse.c"
        break;
      case 20:
#line 104 "parse.y"
{
  sqlite3EndTable(pParse,0,yymsp[0].minor.yy375);
  sqlite3SelectDelete(yymsp[0].minor.yy375);
}
#line 1866 "parse.c"
        break;
      case 24:
#line 116 "parse.y"
{sqlite3AddColumn(pParse,&yymsp[0].minor.yy318);}
#line 1871 "parse.c"
        break;
      case 25:
      case 26:
      case 27:
      case 28:
      case 29:
      case 30:
      case 255:
      case 256:
#line 122 "parse.y"
{yygotominor.yy318 = yymsp[0].minor.yy0;}
#line 1883 "parse.c"
        break;
      case 32:
#line 165 "parse.y"
{sqlite3AddColumnType(pParse,&yymsp[0].minor.yy318,&yymsp[0].minor.yy318);}
#line 1888 "parse.c"
        break;
      case 33:
#line 166 "parse.y"
{sqlite3AddColumnType(pParse,&yymsp[-3].minor.yy318,&yymsp[0].minor.yy0);}
#line 1893 "parse.c"
        break;
      case 34:
#line 168 "parse.y"
{sqlite3AddColumnType(pParse,&yymsp[-5].minor.yy318,&yymsp[0].minor.yy0);}
#line 1898 "parse.c"
        break;
      case 35:
      case 128:
      case 147:
      case 243:
      case 253:
      case 254:
#line 170 "parse.y"
{yygotominor.yy318 = yymsp[0].minor.yy318;}
#line 1908 "parse.c"
        break;
      case 36:
#line 171 "parse.y"
{yygotominor.yy318.z=yymsp[-1].minor.yy318.z; yygotominor.yy318.n=yymsp[-1].minor.yy318.n+Addr(yymsp[0].minor.yy318.z)-Addr(yymsp[-1].minor.yy318.z);}
#line 1913 "parse.c"
        break;
      case 37:
      case 38:
#line 173 "parse.y"
{ yygotominor.yy424 = atoi(yymsp[0].minor.yy0.z); }
#line 1919 "parse.c"
        break;
      case 39:
#line 175 "parse.y"
{ yygotominor.yy424 = -atoi(yymsp[0].minor.yy0.z); }
#line 1924 "parse.c"
        break;
      case 44:
      case 45:
      case 46:
      case 47:
      case 49:
      case 50:
#line 180 "parse.y"
{sqlite3AddDefaultValue(pParse,&yymsp[0].minor.yy0,0);}
#line 1934 "parse.c"
        break;
      case 48:
      case 51:
#line 184 "parse.y"
{sqlite3AddDefaultValue(pParse,&yymsp[0].minor.yy0,1);}
#line 1940 "parse.c"
        break;
      case 54:
#line 194 "parse.y"
{sqlite3AddNotNull(pParse, yymsp[0].minor.yy424);}
#line 1945 "parse.c"
        break;
      case 55:
#line 195 "parse.y"
{sqlite3AddPrimaryKey(pParse,0,yymsp[0].minor.yy424);}
#line 1950 "parse.c"
        break;
      case 56:
#line 196 "parse.y"
{sqlite3CreateIndex(pParse,0,0,0,0,yymsp[0].minor.yy424,0,0);}
#line 1955 "parse.c"
        break;
      case 58:
#line 199 "parse.y"
{sqlite3CreateForeignKey(pParse,0,&yymsp[-2].minor.yy318,yymsp[-1].minor.yy232,yymsp[0].minor.yy424);}
#line 1960 "parse.c"
        break;
      case 59:
#line 200 "parse.y"
{sqlite3DeferForeignKey(pParse,yymsp[0].minor.yy424);}
#line 1965 "parse.c"
        break;
      case 60:
#line 201 "parse.y"
{sqlite3AddCollateType(pParse, yymsp[0].minor.yy318.z, yymsp[0].minor.yy318.n);}
#line 1970 "parse.c"
        break;
      case 61:
#line 209 "parse.y"
{ yygotominor.yy424 = OE_Restrict * 0x010101; }
#line 1975 "parse.c"
        break;
      case 62:
#line 210 "parse.y"
{ yygotominor.yy424 = (yymsp[-1].minor.yy424 & yymsp[0].minor.yy299.mask) | yymsp[0].minor.yy299.value; }
#line 1980 "parse.c"
        break;
      case 63:
#line 212 "parse.y"
{ yygotominor.yy299.value = 0;     yygotominor.yy299.mask = 0x000000; }
#line 1985 "parse.c"
        break;
      case 64:
#line 213 "parse.y"
{ yygotominor.yy299.value = yymsp[0].minor.yy424;     yygotominor.yy299.mask = 0x0000ff; }
#line 1990 "parse.c"
        break;
      case 65:
#line 214 "parse.y"
{ yygotominor.yy299.value = yymsp[0].minor.yy424<<8;  yygotominor.yy299.mask = 0x00ff00; }
#line 1995 "parse.c"
        break;
      case 66:
#line 215 "parse.y"
{ yygotominor.yy299.value = yymsp[0].minor.yy424<<16; yygotominor.yy299.mask = 0xff0000; }
#line 2000 "parse.c"
        break;
      case 67:
#line 217 "parse.y"
{ yygotominor.yy424 = OE_SetNull; }
#line 2005 "parse.c"
        break;
      case 68:
#line 218 "parse.y"
{ yygotominor.yy424 = OE_SetDflt; }
#line 2010 "parse.c"
        break;
      case 69:
#line 219 "parse.y"
{ yygotominor.yy424 = OE_Cascade; }
#line 2015 "parse.c"
        break;
      case 70:
#line 220 "parse.y"
{ yygotominor.yy424 = OE_Restrict; }
#line 2020 "parse.c"
        break;
      case 71:
      case 72:
      case 87:
      case 164:
#line 222 "parse.y"
{yygotominor.yy424 = yymsp[0].minor.yy424;}
#line 2028 "parse.c"
        break;
      case 82:
#line 239 "parse.y"
{sqlite3AddPrimaryKey(pParse,yymsp[-2].minor.yy232,yymsp[0].minor.yy424);}
#line 2033 "parse.c"
        break;
      case 83:
#line 241 "parse.y"
{sqlite3CreateIndex(pParse,0,0,0,yymsp[-2].minor.yy232,yymsp[0].minor.yy424,0,0);}
#line 2038 "parse.c"
        break;
      case 85:
#line 244 "parse.y"
{
    sqlite3CreateForeignKey(pParse, yymsp[-6].minor.yy232, &yymsp[-3].minor.yy318, yymsp[-2].minor.yy232, yymsp[-1].minor.yy424);
    sqlite3DeferForeignKey(pParse, yymsp[0].minor.yy424);
}
#line 2046 "parse.c"
        break;
      case 88:
      case 90:
#line 258 "parse.y"
{ yygotominor.yy424 = OE_Default; }
#line 2052 "parse.c"
        break;
      case 89:
      case 91:
#line 259 "parse.y"
{ yygotominor.yy424 = yymsp[0].minor.yy424; }
#line 2058 "parse.c"
        break;
      case 92:
#line 262 "parse.y"
{ yygotominor.yy424 = OE_Rollback; }
#line 2063 "parse.c"
        break;
      case 93:
      case 237:
#line 263 "parse.y"
{ yygotominor.yy424 = OE_Abort; }
#line 2069 "parse.c"
        break;
      case 94:
#line 264 "parse.y"
{ yygotominor.yy424 = OE_Fail; }
#line 2074 "parse.c"
        break;
      case 95:
#line 265 "parse.y"
{ yygotominor.yy424 = OE_Ignore; }
#line 2079 "parse.c"
        break;
      case 96:
#line 266 "parse.y"
{ yygotominor.yy424 = OE_Replace; }
#line 2084 "parse.c"
        break;
      case 97:
#line 270 "parse.y"
{
  sqlite3DropTable(pParse, sqlite3SrcListAppend(0,&yymsp[-1].minor.yy318,&yymsp[0].minor.yy318), 0);
}
#line 2091 "parse.c"
        break;
      case 98:
#line 276 "parse.y"
{
  sqlite3CreateView(pParse, &yymsp[-6].minor.yy0, &yymsp[-3].minor.yy318, &yymsp[-2].minor.yy318, yymsp[0].minor.yy375, yymsp[-5].minor.yy424);
}
#line 2098 "parse.c"
        break;
      case 99:
#line 279 "parse.y"
{
  sqlite3DropTable(pParse, sqlite3SrcListAppend(0,&yymsp[-1].minor.yy318,&yymsp[0].minor.yy318), 1);
}
#line 2105 "parse.c"
        break;
      case 100:
#line 285 "parse.y"
{
  sqlite3Select(pParse, yymsp[0].minor.yy375, SRT_Callback, 0, 0, 0, 0, 0);
  sqlite3SelectDelete(yymsp[0].minor.yy375);
}
#line 2113 "parse.c"
        break;
      case 101:
      case 125:
#line 295 "parse.y"
{yygotominor.yy375 = yymsp[0].minor.yy375;}
#line 2119 "parse.c"
        break;
      case 102:
#line 296 "parse.y"
{
  if( yymsp[0].minor.yy375 ){
    yymsp[0].minor.yy375->op = yymsp[-1].minor.yy424;
    yymsp[0].minor.yy375->pPrior = yymsp[-2].minor.yy375;
  }
  yygotominor.yy375 = yymsp[0].minor.yy375;
}
#line 2130 "parse.c"
        break;
      case 103:
#line 304 "parse.y"
{yygotominor.yy424 = TK_UNION;}
#line 2135 "parse.c"
        break;
      case 104:
#line 305 "parse.y"
{yygotominor.yy424 = TK_ALL;}
#line 2140 "parse.c"
        break;
      case 105:
#line 306 "parse.y"
{yygotominor.yy424 = TK_INTERSECT;}
#line 2145 "parse.c"
        break;
      case 106:
#line 307 "parse.y"
{yygotominor.yy424 = TK_EXCEPT;}
#line 2150 "parse.c"
        break;
      case 107:
#line 309 "parse.y"
{
  yygotominor.yy375 = sqlite3SelectNew(yymsp[-6].minor.yy232,yymsp[-5].minor.yy283,yymsp[-4].minor.yy164,yymsp[-3].minor.yy232,yymsp[-2].minor.yy164,yymsp[-1].minor.yy232,yymsp[-7].minor.yy424,yymsp[0].minor.yy22.limit,yymsp[0].minor.yy22.offset);
}
#line 2157 "parse.c"
        break;
      case 111:
      case 240:
#line 330 "parse.y"
{yygotominor.yy232 = yymsp[-1].minor.yy232;}
#line 2163 "parse.c"
        break;
      case 112:
      case 138:
      case 148:
      case 239:
#line 331 "parse.y"
{yygotominor.yy232 = 0;}
#line 2171 "parse.c"
        break;
      case 113:
#line 332 "parse.y"
{
   yygotominor.yy232 = sqlite3ExprListAppend(yymsp[-2].minor.yy232,yymsp[-1].minor.yy164,yymsp[0].minor.yy318.n?&yymsp[0].minor.yy318:0);
}
#line 2178 "parse.c"
        break;
      case 114:
#line 335 "parse.y"
{
  yygotominor.yy232 = sqlite3ExprListAppend(yymsp[-1].minor.yy232, sqlite3Expr(TK_ALL, 0, 0, 0), 0);
}
#line 2185 "parse.c"
        break;
      case 115:
#line 338 "parse.y"
{
  Expr *pRight = sqlite3Expr(TK_ALL, 0, 0, 0);
  Expr *pLeft = sqlite3Expr(TK_ID, 0, 0, &yymsp[-2].minor.yy318);
  yygotominor.yy232 = sqlite3ExprListAppend(yymsp[-3].minor.yy232, sqlite3Expr(TK_DOT, pLeft, pRight, 0), 0);
}
#line 2194 "parse.c"
        break;
      case 116:
      case 117:
#line 348 "parse.y"
{ yygotominor.yy318 = yymsp[0].minor.yy318; }
#line 2200 "parse.c"
        break;
      case 118:
#line 350 "parse.y"
{ yygotominor.yy318.n = 0; }
#line 2205 "parse.c"
        break;
      case 119:
#line 362 "parse.y"
{yygotominor.yy283 = sqliteMalloc(sizeof(*yygotominor.yy283));}
#line 2210 "parse.c"
        break;
      case 120:
#line 363 "parse.y"
{yygotominor.yy283 = yymsp[0].minor.yy283;}
#line 2215 "parse.c"
        break;
      case 121:
#line 368 "parse.y"
{
   yygotominor.yy283 = yymsp[-1].minor.yy283;
   if( yygotominor.yy283 && yygotominor.yy283->nSrc>0 ) yygotominor.yy283->a[yygotominor.yy283->nSrc-1].jointype = yymsp[0].minor.yy424;
}
#line 2223 "parse.c"
        break;
      case 122:
#line 372 "parse.y"
{yygotominor.yy283 = 0;}
#line 2228 "parse.c"
        break;
      case 123:
#line 373 "parse.y"
{
  yygotominor.yy283 = sqlite3SrcListAppend(yymsp[-5].minor.yy283,&yymsp[-4].minor.yy318,&yymsp[-3].minor.yy318);
  if( yymsp[-2].minor.yy318.n ) sqlite3SrcListAddAlias(yygotominor.yy283,&yymsp[-2].minor.yy318);
  if( yymsp[-1].minor.yy164 ){
    if( yygotominor.yy283 && yygotominor.yy283->nSrc>1 ){ yygotominor.yy283->a[yygotominor.yy283->nSrc-2].pOn = yymsp[-1].minor.yy164; }
    else { sqlite3ExprDelete(yymsp[-1].minor.yy164); }
  }
  if( yymsp[0].minor.yy246 ){
    if( yygotominor.yy283 && yygotominor.yy283->nSrc>1 ){ yygotominor.yy283->a[yygotominor.yy283->nSrc-2].pUsing = yymsp[0].minor.yy246; }
    else { sqlite3IdListDelete(yymsp[0].minor.yy246); }
  }
}
#line 2244 "parse.c"
        break;
      case 124:
#line 386 "parse.y"
{
  yygotominor.yy283 = sqlite3SrcListAppend(yymsp[-6].minor.yy283,0,0);
  yygotominor.yy283->a[yygotominor.yy283->nSrc-1].pSelect = yymsp[-4].minor.yy375;
  if( yymsp[-2].minor.yy318.n ) sqlite3SrcListAddAlias(yygotominor.yy283,&yymsp[-2].minor.yy318);
  if( yymsp[-1].minor.yy164 ){
    if( yygotominor.yy283 && yygotominor.yy283->nSrc>1 ){ yygotominor.yy283->a[yygotominor.yy283->nSrc-2].pOn = yymsp[-1].minor.yy164; }
    else { sqlite3ExprDelete(yymsp[-1].minor.yy164); }
  }
  if( yymsp[0].minor.yy246 ){
    if( yygotominor.yy283 && yygotominor.yy283->nSrc>1 ){ yygotominor.yy283->a[yygotominor.yy283->nSrc-2].pUsing = yymsp[0].minor.yy246; }
    else { sqlite3IdListDelete(yymsp[0].minor.yy246); }
  }
}
#line 2261 "parse.c"
        break;
      case 126:
#line 407 "parse.y"
{
   yygotominor.yy375 = sqlite3SelectNew(0,yymsp[0].minor.yy283,0,0,0,0,0,-1,0);
}
#line 2268 "parse.c"
        break;
      case 127:
#line 412 "parse.y"
{yygotominor.yy318.z=0; yygotominor.yy318.n=0;}
#line 2273 "parse.c"
        break;
      case 129:
      case 130:
#line 417 "parse.y"
{ yygotominor.yy424 = JT_INNER; }
#line 2279 "parse.c"
        break;
      case 131:
#line 419 "parse.y"
{ yygotominor.yy424 = sqlite3JoinType(pParse,&yymsp[-1].minor.yy0,0,0); }
#line 2284 "parse.c"
        break;
      case 132:
#line 420 "parse.y"
{ yygotominor.yy424 = sqlite3JoinType(pParse,&yymsp[-2].minor.yy0,&yymsp[-1].minor.yy318,0); }
#line 2289 "parse.c"
        break;
      case 133:
#line 422 "parse.y"
{ yygotominor.yy424 = sqlite3JoinType(pParse,&yymsp[-3].minor.yy0,&yymsp[-2].minor.yy318,&yymsp[-1].minor.yy318); }
#line 2294 "parse.c"
        break;
      case 134:
      case 142:
      case 151:
      case 158:
      case 228:
      case 230:
      case 234:
#line 426 "parse.y"
{yygotominor.yy164 = yymsp[0].minor.yy164;}
#line 2305 "parse.c"
        break;
      case 135:
      case 150:
      case 157:
      case 229:
      case 231:
      case 235:
#line 427 "parse.y"
{yygotominor.yy164 = 0;}
#line 2315 "parse.c"
        break;
      case 136:
      case 169:
#line 431 "parse.y"
{yygotominor.yy246 = yymsp[-1].minor.yy246;}
#line 2321 "parse.c"
        break;
      case 137:
      case 168:
#line 432 "parse.y"
{yygotominor.yy246 = 0;}
#line 2327 "parse.c"
        break;
      case 139:
      case 149:
#line 443 "parse.y"
{yygotominor.yy232 = yymsp[0].minor.yy232;}
#line 2333 "parse.c"
        break;
      case 140:
#line 444 "parse.y"
{
  yygotominor.yy232 = sqlite3ExprListAppend(yymsp[-4].minor.yy232,yymsp[-2].minor.yy164,yymsp[-1].minor.yy318.n>0?&yymsp[-1].minor.yy318:0);
  if( yygotominor.yy232 ) yygotominor.yy232->a[yygotominor.yy232->nExpr-1].sortOrder = yymsp[0].minor.yy424;
}
#line 2341 "parse.c"
        break;
      case 141:
#line 448 "parse.y"
{
  yygotominor.yy232 = sqlite3ExprListAppend(0,yymsp[-2].minor.yy164,yymsp[-1].minor.yy318.n>0?&yymsp[-1].minor.yy318:0);
  if( yygotominor.yy232 && yygotominor.yy232->a ) yygotominor.yy232->a[0].sortOrder = yymsp[0].minor.yy424;
}
#line 2349 "parse.c"
        break;
      case 143:
      case 145:
#line 457 "parse.y"
{yygotominor.yy424 = SQLITE_SO_ASC;}
#line 2355 "parse.c"
        break;
      case 144:
#line 458 "parse.y"
{yygotominor.yy424 = SQLITE_SO_DESC;}
#line 2360 "parse.c"
        break;
      case 146:
#line 460 "parse.y"
{yygotominor.yy318.z = 0; yygotominor.yy318.n = 0;}
#line 2365 "parse.c"
        break;
      case 152:
#line 474 "parse.y"
{yygotominor.yy22.limit = -1; yygotominor.yy22.offset = 0;}
#line 2370 "parse.c"
        break;
      case 153:
#line 475 "parse.y"
{yygotominor.yy22.limit = yymsp[0].minor.yy424; yygotominor.yy22.offset = 0;}
#line 2375 "parse.c"
        break;
      case 154:
#line 477 "parse.y"
{yygotominor.yy22.limit = yymsp[-2].minor.yy424; yygotominor.yy22.offset = yymsp[0].minor.yy424;}
#line 2380 "parse.c"
        break;
      case 155:
#line 479 "parse.y"
{yygotominor.yy22.limit = yymsp[0].minor.yy424; yygotominor.yy22.offset = yymsp[-2].minor.yy424;}
#line 2385 "parse.c"
        break;
      case 156:
#line 483 "parse.y"
{
   sqlite3DeleteFrom(pParse, sqlite3SrcListAppend(0,&yymsp[-2].minor.yy318,&yymsp[-1].minor.yy318), yymsp[0].minor.yy164);
}
#line 2392 "parse.c"
        break;
      case 159:
#line 499 "parse.y"
{sqlite3Update(pParse,sqlite3SrcListAppend(0,&yymsp[-4].minor.yy318,&yymsp[-3].minor.yy318),yymsp[-1].minor.yy232,yymsp[0].minor.yy164,yymsp[-5].minor.yy424);}
#line 2397 "parse.c"
        break;
      case 160:
#line 502 "parse.y"
{yygotominor.yy232 = sqlite3ExprListAppend(yymsp[-4].minor.yy232,yymsp[0].minor.yy164,&yymsp[-2].minor.yy318);}
#line 2402 "parse.c"
        break;
      case 161:
#line 503 "parse.y"
{yygotominor.yy232 = sqlite3ExprListAppend(0,yymsp[0].minor.yy164,&yymsp[-2].minor.yy318);}
#line 2407 "parse.c"
        break;
      case 162:
#line 509 "parse.y"
{sqlite3Insert(pParse, sqlite3SrcListAppend(0,&yymsp[-6].minor.yy318,&yymsp[-5].minor.yy318), yymsp[-1].minor.yy232, 0, yymsp[-4].minor.yy246, yymsp[-8].minor.yy424);}
#line 2412 "parse.c"
        break;
      case 163:
#line 511 "parse.y"
{sqlite3Insert(pParse, sqlite3SrcListAppend(0,&yymsp[-3].minor.yy318,&yymsp[-2].minor.yy318), 0, yymsp[0].minor.yy375, yymsp[-1].minor.yy246, yymsp[-5].minor.yy424);}
#line 2417 "parse.c"
        break;
      case 165:
#line 515 "parse.y"
{yygotominor.yy424 = OE_Replace;}
#line 2422 "parse.c"
        break;
      case 166:
      case 232:
#line 521 "parse.y"
{yygotominor.yy232 = sqlite3ExprListAppend(yymsp[-2].minor.yy232,yymsp[0].minor.yy164,0);}
#line 2428 "parse.c"
        break;
      case 167:
      case 233:
#line 522 "parse.y"
{yygotominor.yy232 = sqlite3ExprListAppend(0,yymsp[0].minor.yy164,0);}
#line 2434 "parse.c"
        break;
      case 170:
#line 531 "parse.y"
{yygotominor.yy246 = sqlite3IdListAppend(yymsp[-2].minor.yy246,&yymsp[0].minor.yy318);}
#line 2439 "parse.c"
        break;
      case 171:
#line 532 "parse.y"
{yygotominor.yy246 = sqlite3IdListAppend(0,&yymsp[0].minor.yy318);}
#line 2444 "parse.c"
        break;
      case 172:
#line 540 "parse.y"
{yygotominor.yy164 = yymsp[-1].minor.yy164; sqlite3ExprSpan(yygotominor.yy164,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0); }
#line 2449 "parse.c"
        break;
      case 173:
      case 178:
      case 179:
      case 180:
      case 181:
#line 541 "parse.y"
{yygotominor.yy164 = sqlite3Expr(yymsp[0].major, 0, 0, &yymsp[0].minor.yy0);}
#line 2458 "parse.c"
        break;
      case 174:
      case 175:
#line 542 "parse.y"
{yygotominor.yy164 = sqlite3Expr(TK_ID, 0, 0, &yymsp[0].minor.yy0);}
#line 2464 "parse.c"
        break;
      case 176:
#line 544 "parse.y"
{
  Expr *temp1 = sqlite3Expr(TK_ID, 0, 0, &yymsp[-2].minor.yy318);
  Expr *temp2 = sqlite3Expr(TK_ID, 0, 0, &yymsp[0].minor.yy318);
  yygotominor.yy164 = sqlite3Expr(TK_DOT, temp1, temp2, 0);
}
#line 2473 "parse.c"
        break;
      case 177:
#line 549 "parse.y"
{
  Expr *temp1 = sqlite3Expr(TK_ID, 0, 0, &yymsp[-4].minor.yy318);
  Expr *temp2 = sqlite3Expr(TK_ID, 0, 0, &yymsp[-2].minor.yy318);
  Expr *temp3 = sqlite3Expr(TK_ID, 0, 0, &yymsp[0].minor.yy318);
  Expr *temp4 = sqlite3Expr(TK_DOT, temp2, temp3, 0);
  yygotominor.yy164 = sqlite3Expr(TK_DOT, temp1, temp4, 0);
}
#line 2484 "parse.c"
        break;
      case 182:
#line 560 "parse.y"
{
  Token *pToken = &yymsp[0].minor.yy0;
  Expr *pExpr = yygotominor.yy164 = sqlite3Expr(TK_VARIABLE, 0, 0, pToken);
  sqlite3ExprAssignVarNumber(pParse, pExpr);
}
#line 2493 "parse.c"
        break;
      case 183:
#line 565 "parse.y"
{
  yygotominor.yy164 = sqlite3ExprFunction(yymsp[-1].minor.yy232, &yymsp[-3].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy164,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
}
#line 2501 "parse.c"
        break;
      case 184:
#line 569 "parse.y"
{
  yygotominor.yy164 = sqlite3ExprFunction(0, &yymsp[-3].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy164,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
}
#line 2509 "parse.c"
        break;
      case 185:
      case 186:
      case 187:
      case 188:
      case 189:
      case 190:
      case 191:
      case 192:
      case 193:
      case 194:
      case 195:
      case 196:
      case 201:
      case 202:
      case 203:
      case 204:
      case 205:
      case 206:
#line 573 "parse.y"
{yygotominor.yy164 = sqlite3Expr(yymsp[-1].major, yymsp[-2].minor.yy164, yymsp[0].minor.yy164, 0);}
#line 2531 "parse.c"
        break;
      case 197:
#line 585 "parse.y"
{
  ExprList *pList = sqlite3ExprListAppend(0, yymsp[0].minor.yy164, 0);
  pList = sqlite3ExprListAppend(pList, yymsp[-2].minor.yy164, 0);
  yygotominor.yy164 = sqlite3ExprFunction(pList, 0);
  if( yygotominor.yy164 ) yygotominor.yy164->op = yymsp[-1].minor.yy424;
  sqlite3ExprSpan(yygotominor.yy164, &yymsp[-2].minor.yy164->span, &yymsp[0].minor.yy164->span);
}
#line 2542 "parse.c"
        break;
      case 198:
#line 592 "parse.y"
{
  ExprList *pList = sqlite3ExprListAppend(0, yymsp[0].minor.yy164, 0);
  pList = sqlite3ExprListAppend(pList, yymsp[-3].minor.yy164, 0);
  yygotominor.yy164 = sqlite3ExprFunction(pList, 0);
  if( yygotominor.yy164 ) yygotominor.yy164->op = yymsp[-1].minor.yy424;
  yygotominor.yy164 = sqlite3Expr(TK_NOT, yygotominor.yy164, 0, 0);
  sqlite3ExprSpan(yygotominor.yy164,&yymsp[-3].minor.yy164->span,&yymsp[0].minor.yy164->span);
}
#line 2554 "parse.c"
        break;
      case 199:
#line 601 "parse.y"
{yygotominor.yy424 = TK_LIKE;}
#line 2559 "parse.c"
        break;
      case 200:
#line 602 "parse.y"
{yygotominor.yy424 = TK_GLOB;}
#line 2564 "parse.c"
        break;
      case 207:
#line 609 "parse.y"
{
  yygotominor.yy164 = sqlite3Expr(TK_ISNULL, yymsp[-1].minor.yy164, 0, 0);
  sqlite3ExprSpan(yygotominor.yy164,&yymsp[-1].minor.yy164->span,&yymsp[0].minor.yy0);
}
#line 2572 "parse.c"
        break;
      case 208:
#line 613 "parse.y"
{
  yygotominor.yy164 = sqlite3Expr(TK_ISNULL, yymsp[-2].minor.yy164, 0, 0);
  sqlite3ExprSpan(yygotominor.yy164,&yymsp[-2].minor.yy164->span,&yymsp[0].minor.yy0);
}
#line 2580 "parse.c"
        break;
      case 209:
#line 617 "parse.y"
{
  yygotominor.yy164 = sqlite3Expr(TK_NOTNULL, yymsp[-1].minor.yy164, 0, 0);
  sqlite3ExprSpan(yygotominor.yy164,&yymsp[-1].minor.yy164->span,&yymsp[0].minor.yy0);
}
#line 2588 "parse.c"
        break;
      case 210:
#line 621 "parse.y"
{
  yygotominor.yy164 = sqlite3Expr(TK_NOTNULL, yymsp[-2].minor.yy164, 0, 0);
  sqlite3ExprSpan(yygotominor.yy164,&yymsp[-2].minor.yy164->span,&yymsp[0].minor.yy0);
}
#line 2596 "parse.c"
        break;
      case 211:
#line 625 "parse.y"
{
  yygotominor.yy164 = sqlite3Expr(TK_NOTNULL, yymsp[-3].minor.yy164, 0, 0);
  sqlite3ExprSpan(yygotominor.yy164,&yymsp[-3].minor.yy164->span,&yymsp[0].minor.yy0);
}
#line 2604 "parse.c"
        break;
      case 212:
      case 213:
#line 629 "parse.y"
{
  yygotominor.yy164 = sqlite3Expr(yymsp[-1].major, yymsp[0].minor.yy164, 0, 0);
  sqlite3ExprSpan(yygotominor.yy164,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy164->span);
}
#line 2613 "parse.c"
        break;
      case 214:
#line 637 "parse.y"
{
  yygotominor.yy164 = sqlite3Expr(TK_UMINUS, yymsp[0].minor.yy164, 0, 0);
  sqlite3ExprSpan(yygotominor.yy164,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy164->span);
}
#line 2621 "parse.c"
        break;
      case 215:
#line 641 "parse.y"
{
  yygotominor.yy164 = sqlite3Expr(TK_UPLUS, yymsp[0].minor.yy164, 0, 0);
  sqlite3ExprSpan(yygotominor.yy164,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy164->span);
}
#line 2629 "parse.c"
        break;
      case 216:
#line 645 "parse.y"
{
  yygotominor.yy164 = sqlite3Expr(TK_SELECT, 0, 0, 0);
  if( yygotominor.yy164 ) yygotominor.yy164->pSelect = yymsp[-1].minor.yy375;
  sqlite3ExprSpan(yygotominor.yy164,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0);
}
#line 2638 "parse.c"
        break;
      case 217:
#line 650 "parse.y"
{
  ExprList *pList = sqlite3ExprListAppend(0, yymsp[-2].minor.yy164, 0);
  pList = sqlite3ExprListAppend(pList, yymsp[0].minor.yy164, 0);
  yygotominor.yy164 = sqlite3Expr(TK_BETWEEN, yymsp[-4].minor.yy164, 0, 0);
  if( yygotominor.yy164 ) yygotominor.yy164->pList = pList;
  sqlite3ExprSpan(yygotominor.yy164,&yymsp[-4].minor.yy164->span,&yymsp[0].minor.yy164->span);
}
#line 2649 "parse.c"
        break;
      case 218:
#line 657 "parse.y"
{
  ExprList *pList = sqlite3ExprListAppend(0, yymsp[-2].minor.yy164, 0);
  pList = sqlite3ExprListAppend(pList, yymsp[0].minor.yy164, 0);
  yygotominor.yy164 = sqlite3Expr(TK_BETWEEN, yymsp[-5].minor.yy164, 0, 0);
  if( yygotominor.yy164 ) yygotominor.yy164->pList = pList;
  yygotominor.yy164 = sqlite3Expr(TK_NOT, yygotominor.yy164, 0, 0);
  sqlite3ExprSpan(yygotominor.yy164,&yymsp[-5].minor.yy164->span,&yymsp[0].minor.yy164->span);
}
#line 2661 "parse.c"
        break;
      case 219:
#line 665 "parse.y"
{
  yygotominor.yy164 = sqlite3Expr(TK_IN, yymsp[-4].minor.yy164, 0, 0);
  if( yygotominor.yy164 ) yygotominor.yy164->pList = yymsp[-1].minor.yy232;
  sqlite3ExprSpan(yygotominor.yy164,&yymsp[-4].minor.yy164->span,&yymsp[0].minor.yy0);
}
#line 2670 "parse.c"
        break;
      case 220:
#line 670 "parse.y"
{
  yygotominor.yy164 = sqlite3Expr(TK_IN, yymsp[-4].minor.yy164, 0, 0);
  if( yygotominor.yy164 ) yygotominor.yy164->pSelect = yymsp[-1].minor.yy375;
  sqlite3ExprSpan(yygotominor.yy164,&yymsp[-4].minor.yy164->span,&yymsp[0].minor.yy0);
}
#line 2679 "parse.c"
        break;
      case 221:
#line 675 "parse.y"
{
  yygotominor.yy164 = sqlite3Expr(TK_IN, yymsp[-5].minor.yy164, 0, 0);
  if( yygotominor.yy164 ) yygotominor.yy164->pList = yymsp[-1].minor.yy232;
  yygotominor.yy164 = sqlite3Expr(TK_NOT, yygotominor.yy164, 0, 0);
  sqlite3ExprSpan(yygotominor.yy164,&yymsp[-5].minor.yy164->span,&yymsp[0].minor.yy0);
}
#line 2689 "parse.c"
        break;
      case 222:
#line 681 "parse.y"
{
  yygotominor.yy164 = sqlite3Expr(TK_IN, yymsp[-5].minor.yy164, 0, 0);
  if( yygotominor.yy164 ) yygotominor.yy164->pSelect = yymsp[-1].minor.yy375;
  yygotominor.yy164 = sqlite3Expr(TK_NOT, yygotominor.yy164, 0, 0);
  sqlite3ExprSpan(yygotominor.yy164,&yymsp[-5].minor.yy164->span,&yymsp[0].minor.yy0);
}
#line 2699 "parse.c"
        break;
      case 223:
#line 687 "parse.y"
{
  SrcList *pSrc = sqlite3SrcListAppend(0, &yymsp[-1].minor.yy318, &yymsp[0].minor.yy318);
  yygotominor.yy164 = sqlite3Expr(TK_IN, yymsp[-3].minor.yy164, 0, 0);
  if( yygotominor.yy164 ) yygotominor.yy164->pSelect = sqlite3SelectNew(0,pSrc,0,0,0,0,0,-1,0);
  sqlite3ExprSpan(yygotominor.yy164,&yymsp[-3].minor.yy164->span,yymsp[0].minor.yy318.z?&yymsp[0].minor.yy318:&yymsp[-1].minor.yy318);
}
#line 2709 "parse.c"
        break;
      case 224:
#line 693 "parse.y"
{
  SrcList *pSrc = sqlite3SrcListAppend(0, &yymsp[-1].minor.yy318, &yymsp[0].minor.yy318);
  yygotominor.yy164 = sqlite3Expr(TK_IN, yymsp[-4].minor.yy164, 0, 0);
  if( yygotominor.yy164 ) yygotominor.yy164->pSelect = sqlite3SelectNew(0,pSrc,0,0,0,0,0,-1,0);
  yygotominor.yy164 = sqlite3Expr(TK_NOT, yygotominor.yy164, 0, 0);
  sqlite3ExprSpan(yygotominor.yy164,&yymsp[-4].minor.yy164->span,yymsp[0].minor.yy318.z?&yymsp[0].minor.yy318:&yymsp[-1].minor.yy318);
}
#line 2720 "parse.c"
        break;
      case 225:
#line 703 "parse.y"
{
  yygotominor.yy164 = sqlite3Expr(TK_CASE, yymsp[-3].minor.yy164, yymsp[-1].minor.yy164, 0);
  if( yygotominor.yy164 ) yygotominor.yy164->pList = yymsp[-2].minor.yy232;
  sqlite3ExprSpan(yygotominor.yy164, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0);
}
#line 2729 "parse.c"
        break;
      case 226:
#line 710 "parse.y"
{
  yygotominor.yy232 = sqlite3ExprListAppend(yymsp[-4].minor.yy232, yymsp[-2].minor.yy164, 0);
  yygotominor.yy232 = sqlite3ExprListAppend(yygotominor.yy232, yymsp[0].minor.yy164, 0);
}
#line 2737 "parse.c"
        break;
      case 227:
#line 714 "parse.y"
{
  yygotominor.yy232 = sqlite3ExprListAppend(0, yymsp[-2].minor.yy164, 0);
  yygotominor.yy232 = sqlite3ExprListAppend(yygotominor.yy232, yymsp[0].minor.yy164, 0);
}
#line 2745 "parse.c"
        break;
      case 236:
#line 739 "parse.y"
{
  if( yymsp[-10].minor.yy424!=OE_None ) yymsp[-10].minor.yy424 = yymsp[0].minor.yy424;
  if( yymsp[-10].minor.yy424==OE_Default) yymsp[-10].minor.yy424 = OE_Abort;
  sqlite3CreateIndex(pParse, &yymsp[-8].minor.yy318, &yymsp[-7].minor.yy318, sqlite3SrcListAppend(0,&yymsp[-5].minor.yy318,&yymsp[-4].minor.yy318),
      yymsp[-2].minor.yy232, yymsp[-10].minor.yy424, &yymsp[-11].minor.yy0, &yymsp[-1].minor.yy0);
}
#line 2755 "parse.c"
        break;
      case 238:
#line 748 "parse.y"
{ yygotominor.yy424 = OE_None; }
#line 2760 "parse.c"
        break;
      case 241:
#line 758 "parse.y"
{
  Expr *p = 0;
  if( yymsp[-1].minor.yy318.n>0 ){
    p = sqlite3Expr(TK_COLUMN, 0, 0, 0);
    if( p ) p->pColl = sqlite3LocateCollSeq(pParse, yymsp[-1].minor.yy318.z, yymsp[-1].minor.yy318.n);
  }
  yygotominor.yy232 = sqlite3ExprListAppend(yymsp[-4].minor.yy232, p, &yymsp[-2].minor.yy318);
}
#line 2772 "parse.c"
        break;
      case 242:
#line 766 "parse.y"
{
  Expr *p = 0;
  if( yymsp[-1].minor.yy318.n>0 ){
    p = sqlite3Expr(TK_COLUMN, 0, 0, 0);
    if( p ) p->pColl = sqlite3LocateCollSeq(pParse, yymsp[-1].minor.yy318.z, yymsp[-1].minor.yy318.n);
  }
  yygotominor.yy232 = sqlite3ExprListAppend(0, p, &yymsp[-2].minor.yy318);
}
#line 2784 "parse.c"
        break;
      case 244:
#line 780 "parse.y"
{
  sqlite3DropIndex(pParse, sqlite3SrcListAppend(0,&yymsp[-1].minor.yy318,&yymsp[0].minor.yy318));
}
#line 2791 "parse.c"
        break;
      case 245:
#line 786 "parse.y"
{sqlite3Vacuum(pParse,0);}
#line 2796 "parse.c"
        break;
      case 246:
#line 787 "parse.y"
{sqlite3Vacuum(pParse,&yymsp[0].minor.yy318);}
#line 2801 "parse.c"
        break;
      case 247:
      case 249:
#line 791 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-3].minor.yy318,&yymsp[-2].minor.yy318,&yymsp[0].minor.yy318,0);}
#line 2807 "parse.c"
        break;
      case 248:
#line 792 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-3].minor.yy318,&yymsp[-2].minor.yy318,&yymsp[0].minor.yy0,0);}
#line 2812 "parse.c"
        break;
      case 250:
#line 794 "parse.y"
{
  sqlite3Pragma(pParse,&yymsp[-3].minor.yy318,&yymsp[-2].minor.yy318,&yymsp[0].minor.yy318,1);
}
#line 2819 "parse.c"
        break;
      case 251:
#line 797 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-4].minor.yy318,&yymsp[-3].minor.yy318,&yymsp[-1].minor.yy318,0);}
#line 2824 "parse.c"
        break;
      case 252:
#line 798 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-1].minor.yy318,&yymsp[0].minor.yy318,0,0);}
#line 2829 "parse.c"
        break;
      case 259:
#line 808 "parse.y"
{
  Token all;
  all.z = yymsp[-3].minor.yy318.z;
  all.n = (yymsp[0].minor.yy0.z - yymsp[-3].minor.yy318.z) + yymsp[0].minor.yy0.n;
  sqlite3FinishTrigger(pParse, yymsp[-1].minor.yy107, &all);
}
#line 2839 "parse.c"
        break;
      case 260:
#line 816 "parse.y"
{
  SrcList *pTab = sqlite3SrcListAppend(0, &yymsp[-3].minor.yy318, &yymsp[-2].minor.yy318);
  sqlite3BeginTrigger(pParse, &yymsp[-8].minor.yy318, &yymsp[-7].minor.yy318, yymsp[-6].minor.yy424, yymsp[-5].minor.yy414.a, yymsp[-5].minor.yy414.b, pTab, yymsp[-1].minor.yy424, yymsp[0].minor.yy164, yymsp[-10].minor.yy424);
  yygotominor.yy318 = (yymsp[-7].minor.yy318.n==0?yymsp[-8].minor.yy318:yymsp[-7].minor.yy318);
}
#line 2848 "parse.c"
        break;
      case 261:
      case 264:
#line 823 "parse.y"
{ yygotominor.yy424 = TK_BEFORE; }
#line 2854 "parse.c"
        break;
      case 262:
#line 824 "parse.y"
{ yygotominor.yy424 = TK_AFTER;  }
#line 2859 "parse.c"
        break;
      case 263:
#line 825 "parse.y"
{ yygotominor.yy424 = TK_INSTEAD;}
#line 2864 "parse.c"
        break;
      case 265:
#line 830 "parse.y"
{ yygotominor.yy414.a = TK_DELETE; yygotominor.yy414.b = 0; }
#line 2869 "parse.c"
        break;
      case 266:
#line 831 "parse.y"
{ yygotominor.yy414.a = TK_INSERT; yygotominor.yy414.b = 0; }
#line 2874 "parse.c"
        break;
      case 267:
#line 832 "parse.y"
{ yygotominor.yy414.a = TK_UPDATE; yygotominor.yy414.b = 0;}
#line 2879 "parse.c"
        break;
      case 268:
#line 833 "parse.y"
{yygotominor.yy414.a = TK_UPDATE; yygotominor.yy414.b = yymsp[0].minor.yy246; }
#line 2884 "parse.c"
        break;
      case 269:
      case 270:
#line 836 "parse.y"
{ yygotominor.yy424 = TK_ROW; }
#line 2890 "parse.c"
        break;
      case 271:
#line 838 "parse.y"
{ yygotominor.yy424 = TK_STATEMENT; }
#line 2895 "parse.c"
        break;
      case 272:
#line 841 "parse.y"
{ yygotominor.yy164 = 0; }
#line 2900 "parse.c"
        break;
      case 273:
#line 842 "parse.y"
{ yygotominor.yy164 = yymsp[0].minor.yy164; }
#line 2905 "parse.c"
        break;
      case 274:
#line 846 "parse.y"
{
  yymsp[-2].minor.yy107->pNext = yymsp[0].minor.yy107;
  yygotominor.yy107 = yymsp[-2].minor.yy107;
}
#line 2913 "parse.c"
        break;
      case 275:
#line 850 "parse.y"
{ yygotominor.yy107 = 0; }
#line 2918 "parse.c"
        break;
      case 276:
#line 856 "parse.y"
{ yygotominor.yy107 = sqlite3TriggerUpdateStep(&yymsp[-3].minor.yy318, yymsp[-1].minor.yy232, yymsp[0].minor.yy164, yymsp[-4].minor.yy424); }
#line 2923 "parse.c"
        break;
      case 277:
#line 861 "parse.y"
{yygotominor.yy107 = sqlite3TriggerInsertStep(&yymsp[-5].minor.yy318, yymsp[-4].minor.yy246, yymsp[-1].minor.yy232, 0, yymsp[-7].minor.yy424);}
#line 2928 "parse.c"
        break;
      case 278:
#line 864 "parse.y"
{yygotominor.yy107 = sqlite3TriggerInsertStep(&yymsp[-2].minor.yy318, yymsp[-1].minor.yy246, 0, yymsp[0].minor.yy375, yymsp[-4].minor.yy424);}
#line 2933 "parse.c"
        break;
      case 279:
#line 868 "parse.y"
{yygotominor.yy107 = sqlite3TriggerDeleteStep(&yymsp[-1].minor.yy318, yymsp[0].minor.yy164);}
#line 2938 "parse.c"
        break;
      case 280:
#line 871 "parse.y"
{yygotominor.yy107 = sqlite3TriggerSelectStep(yymsp[0].minor.yy375); }
#line 2943 "parse.c"
        break;
      case 281:
#line 874 "parse.y"
{
  yygotominor.yy164 = sqlite3Expr(TK_RAISE, 0, 0, 0); 
  yygotominor.yy164->iColumn = OE_Ignore;
  sqlite3ExprSpan(yygotominor.yy164, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0);
}
#line 2952 "parse.c"
        break;
      case 282:
#line 879 "parse.y"
{
  yygotominor.yy164 = sqlite3Expr(TK_RAISE, 0, 0, &yymsp[-1].minor.yy318); 
  yygotominor.yy164->iColumn = OE_Rollback;
  sqlite3ExprSpan(yygotominor.yy164, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0);
}
#line 2961 "parse.c"
        break;
      case 283:
#line 884 "parse.y"
{
  yygotominor.yy164 = sqlite3Expr(TK_RAISE, 0, 0, &yymsp[-1].minor.yy318); 
  yygotominor.yy164->iColumn = OE_Abort;
  sqlite3ExprSpan(yygotominor.yy164, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0);
}
#line 2970 "parse.c"
        break;
      case 284:
#line 889 "parse.y"
{
  yygotominor.yy164 = sqlite3Expr(TK_RAISE, 0, 0, &yymsp[-1].minor.yy318); 
  yygotominor.yy164->iColumn = OE_Fail;
  sqlite3ExprSpan(yygotominor.yy164, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0);
}
#line 2979 "parse.c"
        break;
      case 285:
#line 896 "parse.y"
{
  sqlite3DropTrigger(pParse,sqlite3SrcListAppend(0,&yymsp[-1].minor.yy318,&yymsp[0].minor.yy318));
}
#line 2986 "parse.c"
        break;
      case 286:
#line 901 "parse.y"
{
  sqlite3Attach(pParse, &yymsp[-3].minor.yy318, &yymsp[-1].minor.yy318, yymsp[0].minor.yy72.type, &yymsp[0].minor.yy72.key);
}
#line 2993 "parse.c"
        break;
      case 287:
#line 905 "parse.y"
{ yygotominor.yy72.type = 0; }
#line 2998 "parse.c"
        break;
      case 288:
#line 906 "parse.y"
{ yygotominor.yy72.type=1; yygotominor.yy72.key = yymsp[0].minor.yy318; }
#line 3003 "parse.c"
        break;
      case 289:
#line 907 "parse.y"
{ yygotominor.yy72.type=2; yygotominor.yy72.key = yymsp[0].minor.yy0; }
#line 3008 "parse.c"
        break;
      case 292:
#line 913 "parse.y"
{
  sqlite3Detach(pParse, &yymsp[0].minor.yy318);
}
#line 3015 "parse.c"
        break;
  };
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yypParser->yyidx -= yysize;
  yyact = yy_find_reduce_action(yypParser,yygoto);
  if( yyact < YYNSTATE ){
    yy_shift(yypParser,yyact,yygoto,&yygotominor);
  }else if( yyact == YYNSTATE + YYNRULE + 1 ){
    yy_accept(yypParser);
  }
}

/*
** The following code executes when the parse fails
*/
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  sqlite3ParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
){
  sqlite3ParserARG_FETCH;
#define TOKEN (yyminor.yy0)
#line 23 "parse.y"

  if( pParse->zErrMsg==0 ){
    if( TOKEN.z[0] ){
      sqlite3ErrorMsg(pParse, "near \"%T\": syntax error", &TOKEN);
    }else{
      sqlite3ErrorMsg(pParse, "incomplete SQL statement");
    }
  }
#line 3067 "parse.c"
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  sqlite3ParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "sqlite3ParserAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3Parser(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  sqlite3ParserTOKENTYPE yyminor       /* The value for the token */
  sqlite3ParserARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
  int yyendofinput;     /* True if we are at the end of input */
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->yyidx<0 ){
    if( yymajor==0 ) return;
    yypParser->yyidx = 0;
    yypParser->yyerrcnt = -1;
    yypParser->yystack[0].stateno = 0;
    yypParser->yystack[0].major = 0;
  }
  yyminorunion.yy0 = yyminor;
  yyendofinput = (yymajor==0);
  sqlite3ParserARG_STORE;

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s\n",yyTracePrompt,yyTokenName[yymajor]);
  }
#endif

  do{
    yyact = yy_find_shift_action(yypParser,yymajor);
    if( yyact<YYNSTATE ){
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->yyerrcnt--;
      if( yyendofinput && yypParser->yyidx>=0 ){
        yymajor = 0;
      }else{
        yymajor = YYNOCODE;
      }
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE);
    }else if( yyact == YY_ERROR_ACTION ){
      int yymx;
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yymx = yypParser->yystack[yypParser->yyidx].major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->yyidx >= 0 &&
          yymx != YYERRORSYMBOL &&
          (yyact = yy_find_shift_action(yypParser,YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yyidx < 0 || yymajor==0 ){
          yy_destructor(yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
      }
      yymajor = YYNOCODE;
#endif
    }else{
      yy_accept(yypParser);
      yymajor = YYNOCODE;
    }
  }while( yymajor!=YYNOCODE && yypParser->yyidx>=0 );
  return;
}
