/*======================================================================
 FILE: icalderivedproperty.c
 CREATOR: eric 15 Feb 2001

 (C) COPYRIGHT 2000, Eric Busboom, http://www.softwarestudio.org

 This program is free software; you can redistribute it and/or modify
 it under the terms of either:

    The LGPL as published by the Free Software Foundation, version
    2.1, available at: http://www.fsf.org/copyleft/lesser.html

 Or:

    The Mozilla Public License Version 1.0. You may obtain a copy of
    the License at http://www.mozilla.org/MPL/
======================================================================*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "icalderivedproperty.h"
#include "icalproperty.h"
#include "icalcomponent.h"
#include "icalerror.h"
#include "icalmemory.h"
#include "icaltimezone.h"

#include <string.h>

struct icalproperty_impl *icalproperty_new_impl (icalproperty_kind kind);
void icalproperty_add_parameters(struct icalproperty_impl *prop,va_list args);

/* This map associates the property kinds with the string
   representation of the property name and the kind of VALUE that the
   property uses as a default */

struct  icalproperty_map {
        icalproperty_kind kind;
        const char *name;
        icalvalue_kind value;

};

/* This map associates the property enumerations with the king of
   property that they are used in and the string representation of the
   enumeration */

struct icalproperty_enum_map {
    icalproperty_kind prop;
    int prop_enum;
    const char* str;
};


static const struct icalproperty_map property_map[116] = {
{ICAL_ANY_PROPERTY,"ANY",ICAL_NO_VALUE},
{ICAL_ACKNOWLEDGED_PROPERTY,"ACKNOWLEDGED",ICAL_DATETIME_VALUE},
{ICAL_ACTION_PROPERTY,"ACTION",ICAL_ACTION_VALUE},
{ICAL_ALLOWCONFLICT_PROPERTY,"ALLOW-CONFLICT",ICAL_TEXT_VALUE},
{ICAL_ATTACH_PROPERTY,"ATTACH",ICAL_ATTACH_VALUE},
{ICAL_ATTENDEE_PROPERTY,"ATTENDEE",ICAL_CALADDRESS_VALUE},
{ICAL_CALID_PROPERTY,"CALID",ICAL_TEXT_VALUE},
{ICAL_CALMASTER_PROPERTY,"CALMASTER",ICAL_TEXT_VALUE},
{ICAL_CALSCALE_PROPERTY,"CALSCALE",ICAL_TEXT_VALUE},
{ICAL_CAPVERSION_PROPERTY,"CAP-VERSION",ICAL_TEXT_VALUE},
{ICAL_CARLEVEL_PROPERTY,"CAR-LEVEL",ICAL_CARLEVEL_VALUE},
{ICAL_CARID_PROPERTY,"CARID",ICAL_TEXT_VALUE},
{ICAL_CATEGORIES_PROPERTY,"CATEGORIES",ICAL_TEXT_VALUE},
{ICAL_CLASS_PROPERTY,"CLASS",ICAL_CLASS_VALUE},
{ICAL_CMD_PROPERTY,"CMD",ICAL_CMD_VALUE},
{ICAL_COMMENT_PROPERTY,"COMMENT",ICAL_TEXT_VALUE},
{ICAL_COMPLETED_PROPERTY,"COMPLETED",ICAL_DATETIME_VALUE},
{ICAL_COMPONENTS_PROPERTY,"COMPONENTS",ICAL_TEXT_VALUE},
{ICAL_CONTACT_PROPERTY,"CONTACT",ICAL_TEXT_VALUE},
{ICAL_CREATED_PROPERTY,"CREATED",ICAL_DATETIME_VALUE},
{ICAL_CSID_PROPERTY,"CSID",ICAL_URI_VALUE},
{ICAL_DATEMAX_PROPERTY,"DATE-MAX",ICAL_DATETIME_VALUE},
{ICAL_DATEMIN_PROPERTY,"DATE-MIN",ICAL_DATETIME_VALUE},
{ICAL_DECREED_PROPERTY,"DECREED",ICAL_TEXT_VALUE},
{ICAL_DEFAULTCHARSET_PROPERTY,"DEFAULT-CHARSET",ICAL_TEXT_VALUE},
{ICAL_DEFAULTLOCALE_PROPERTY,"DEFAULT-LOCALE",ICAL_TEXT_VALUE},
{ICAL_DEFAULTTZID_PROPERTY,"DEFAULT-TZID",ICAL_TEXT_VALUE},
{ICAL_DEFAULTVCARS_PROPERTY,"DEFAULT-VCARS",ICAL_TEXT_VALUE},
{ICAL_DENY_PROPERTY,"DENY",ICAL_TEXT_VALUE},
{ICAL_DESCRIPTION_PROPERTY,"DESCRIPTION",ICAL_TEXT_VALUE},
{ICAL_DTEND_PROPERTY,"DTEND",ICAL_DATETIME_VALUE},
{ICAL_DTSTAMP_PROPERTY,"DTSTAMP",ICAL_DATETIME_VALUE},
{ICAL_DTSTART_PROPERTY,"DTSTART",ICAL_DATETIME_VALUE},
{ICAL_DUE_PROPERTY,"DUE",ICAL_DATETIME_VALUE},
{ICAL_DURATION_PROPERTY,"DURATION",ICAL_DURATION_VALUE},
{ICAL_EXDATE_PROPERTY,"EXDATE",ICAL_DATETIME_VALUE},
{ICAL_EXPAND_PROPERTY,"EXPAND",ICAL_INTEGER_VALUE},
{ICAL_EXRULE_PROPERTY,"EXRULE",ICAL_RECUR_VALUE},
{ICAL_FREEBUSY_PROPERTY,"FREEBUSY",ICAL_PERIOD_VALUE},
{ICAL_GEO_PROPERTY,"GEO",ICAL_GEO_VALUE},
{ICAL_GRANT_PROPERTY,"GRANT",ICAL_TEXT_VALUE},
{ICAL_ITIPVERSION_PROPERTY,"ITIP-VERSION",ICAL_TEXT_VALUE},
{ICAL_LASTMODIFIED_PROPERTY,"LAST-MODIFIED",ICAL_DATETIME_VALUE},
{ICAL_LOCATION_PROPERTY,"LOCATION",ICAL_TEXT_VALUE},
{ICAL_MAXCOMPONENTSIZE_PROPERTY,"MAX-COMPONENT-SIZE",ICAL_INTEGER_VALUE},
{ICAL_MAXDATE_PROPERTY,"MAXDATE",ICAL_DATETIME_VALUE},
{ICAL_MAXRESULTS_PROPERTY,"MAXRESULTS",ICAL_INTEGER_VALUE},
{ICAL_MAXRESULTSSIZE_PROPERTY,"MAXRESULTSSIZE",ICAL_INTEGER_VALUE},
{ICAL_METHOD_PROPERTY,"METHOD",ICAL_METHOD_VALUE},
{ICAL_MINDATE_PROPERTY,"MINDATE",ICAL_DATETIME_VALUE},
{ICAL_MULTIPART_PROPERTY,"MULTIPART",ICAL_TEXT_VALUE},
{ICAL_NAME_PROPERTY,"NAME",ICAL_TEXT_VALUE},
{ICAL_ORGANIZER_PROPERTY,"ORGANIZER",ICAL_CALADDRESS_VALUE},
{ICAL_OWNER_PROPERTY,"OWNER",ICAL_TEXT_VALUE},
{ICAL_PERCENTCOMPLETE_PROPERTY,"PERCENT-COMPLETE",ICAL_INTEGER_VALUE},
{ICAL_PERMISSION_PROPERTY,"PERMISSION",ICAL_TEXT_VALUE},
{ICAL_PRIORITY_PROPERTY,"PRIORITY",ICAL_INTEGER_VALUE},
{ICAL_PRODID_PROPERTY,"PRODID",ICAL_TEXT_VALUE},
{ICAL_QUERY_PROPERTY,"QUERY",ICAL_QUERY_VALUE},
{ICAL_QUERYLEVEL_PROPERTY,"QUERY-LEVEL",ICAL_QUERYLEVEL_VALUE},
{ICAL_QUERYID_PROPERTY,"QUERYID",ICAL_TEXT_VALUE},
{ICAL_QUERYNAME_PROPERTY,"QUERYNAME",ICAL_TEXT_VALUE},
{ICAL_RDATE_PROPERTY,"RDATE",ICAL_DATETIMEPERIOD_VALUE},
{ICAL_RECURACCEPTED_PROPERTY,"RECUR-ACCEPTED",ICAL_TEXT_VALUE},
{ICAL_RECUREXPAND_PROPERTY,"RECUR-EXPAND",ICAL_TEXT_VALUE},
{ICAL_RECURLIMIT_PROPERTY,"RECUR-LIMIT",ICAL_TEXT_VALUE},
{ICAL_RECURRENCEID_PROPERTY,"RECURRENCE-ID",ICAL_DATETIME_VALUE},
{ICAL_RELATEDTO_PROPERTY,"RELATED-TO",ICAL_TEXT_VALUE},
{ICAL_RELCALID_PROPERTY,"RELCALID",ICAL_TEXT_VALUE},
{ICAL_REPEAT_PROPERTY,"REPEAT",ICAL_INTEGER_VALUE},
{ICAL_REQUESTSTATUS_PROPERTY,"REQUEST-STATUS",ICAL_REQUESTSTATUS_VALUE},
{ICAL_RESOURCES_PROPERTY,"RESOURCES",ICAL_TEXT_VALUE},
{ICAL_RESTRICTION_PROPERTY,"RESTRICTION",ICAL_QUERY_VALUE},
{ICAL_RRULE_PROPERTY,"RRULE",ICAL_RECUR_VALUE},
{ICAL_SCOPE_PROPERTY,"SCOPE",ICAL_TEXT_VALUE},
{ICAL_SEQUENCE_PROPERTY,"SEQUENCE",ICAL_INTEGER_VALUE},
{ICAL_STATUS_PROPERTY,"STATUS",ICAL_STATUS_VALUE},
{ICAL_STORESEXPANDED_PROPERTY,"STORES-EXPANDED",ICAL_TEXT_VALUE},
{ICAL_SUMMARY_PROPERTY,"SUMMARY",ICAL_TEXT_VALUE},
{ICAL_TARGET_PROPERTY,"TARGET",ICAL_CALADDRESS_VALUE},
{ICAL_TRANSP_PROPERTY,"TRANSP",ICAL_TRANSP_VALUE},
{ICAL_TRIGGER_PROPERTY,"TRIGGER",ICAL_TRIGGER_VALUE},
{ICAL_TZID_PROPERTY,"TZID",ICAL_TEXT_VALUE},
{ICAL_TZNAME_PROPERTY,"TZNAME",ICAL_TEXT_VALUE},
{ICAL_TZOFFSETFROM_PROPERTY,"TZOFFSETFROM",ICAL_UTCOFFSET_VALUE},
{ICAL_TZOFFSETTO_PROPERTY,"TZOFFSETTO",ICAL_UTCOFFSET_VALUE},
{ICAL_TZURL_PROPERTY,"TZURL",ICAL_URI_VALUE},
{ICAL_UID_PROPERTY,"UID",ICAL_TEXT_VALUE},
{ICAL_URL_PROPERTY,"URL",ICAL_URI_VALUE},
{ICAL_VERSION_PROPERTY,"VERSION",ICAL_TEXT_VALUE},
{ICAL_X_PROPERTY,"X",ICAL_X_VALUE},
{ICAL_XLICCLASS_PROPERTY,"X-LIC-CLASS",ICAL_XLICCLASS_VALUE},
{ICAL_XLICCLUSTERCOUNT_PROPERTY,"X-LIC-CLUSTERCOUNT",ICAL_STRING_VALUE},
{ICAL_XLICERROR_PROPERTY,"X-LIC-ERROR",ICAL_TEXT_VALUE},
{ICAL_XLICMIMECHARSET_PROPERTY,"X-LIC-MIMECHARSET",ICAL_STRING_VALUE},
{ICAL_XLICMIMECID_PROPERTY,"X-LIC-MIMECID",ICAL_STRING_VALUE},
{ICAL_XLICMIMECONTENTTYPE_PROPERTY,"X-LIC-MIMECONTENTTYPE",ICAL_STRING_VALUE},
{ICAL_XLICMIMEENCODING_PROPERTY,"X-LIC-MIMEENCODING",ICAL_STRING_VALUE},
{ICAL_XLICMIMEFILENAME_PROPERTY,"X-LIC-MIMEFILENAME",ICAL_STRING_VALUE},
{ICAL_XLICMIMEOPTINFO_PROPERTY,"X-LIC-MIMEOPTINFO",ICAL_STRING_VALUE},
{ICAL_BUSYTYPE_PROPERTY,"BUSYTYPE",ICAL_BUSYTYPE_VALUE},
{ICAL_ACCEPTRESPONSE_PROPERTY,"ACCEPT-RESPONSE",ICAL_TEXT_VALUE},
{ICAL_POLLITEMID_PROPERTY,"POLL-ITEM-ID",ICAL_INTEGER_VALUE},
{ICAL_POLLMODE_PROPERTY,"POLL-MODE",ICAL_POLLMODE_VALUE},
{ICAL_POLLPROPERTIES_PROPERTY,"POLL-PROPERTIES",ICAL_TEXT_VALUE},
{ICAL_POLLWINNER_PROPERTY,"POLL-WINNER",ICAL_INTEGER_VALUE},
{ICAL_VOTER_PROPERTY,"VOTER",ICAL_CALADDRESS_VALUE},
{ICAL_TZIDALIASOF_PROPERTY,"TZID-ALIAS-OF",ICAL_TEXT_VALUE},
{ICAL_TZUNTIL_PROPERTY,"TZUNTIL",ICAL_DATETIME_VALUE},
{ICAL_POLLCOMPLETION_PROPERTY,"POLL-COMPLETION",ICAL_POLLCOMPLETION_VALUE},
{ICAL_REPLYURL_PROPERTY,"REPLY-URL",ICAL_URI_VALUE},
{ICAL_RESPONSE_PROPERTY,"RESPONSE",ICAL_INTEGER_VALUE},
{ICAL_ESTIMATEDDURATION_PROPERTY,"ESTIMATED-DURATION",ICAL_DURATION_VALUE},
{ICAL_TASKMODE_PROPERTY,"TASK-MODE",ICAL_TASKMODE_VALUE},
{ICAL_NO_PROPERTY,"",ICAL_NO_VALUE}};

static const struct icalproperty_enum_map enum_map[1301] = {
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_X,"" }, /*10000*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_AUDIO,"AUDIO" }, /*10001*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_DISPLAY,"DISPLAY" }, /*10002*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_EMAIL,"EMAIL" }, /*10003*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_PROCEDURE,"PROCEDURE" }, /*10004*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10005*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10006*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10007*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10008*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10009*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10010*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10011*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10012*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10013*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10014*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10015*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10016*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10017*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10018*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10019*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10020*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10021*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10022*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10023*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10024*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10025*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10026*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10027*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10028*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10029*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10030*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10031*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10032*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10033*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10034*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10035*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10036*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10037*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10038*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10039*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10040*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10041*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10042*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10043*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10044*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10045*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10046*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10047*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10048*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10049*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10050*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10051*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10052*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10053*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10054*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10055*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10056*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10057*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10058*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10059*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10060*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10061*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10062*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10063*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10064*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10065*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10066*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10067*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10068*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10069*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10070*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10071*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10072*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10073*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10074*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10075*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10076*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10077*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10078*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10079*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10080*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10081*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10082*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10083*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10084*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10085*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10086*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10087*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10088*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10089*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10090*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10091*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10092*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10093*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10094*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10095*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10096*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10097*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10098*/
    {ICAL_ACTION_PROPERTY,ICAL_ACTION_NONE,"" }, /*10099*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_X,"" }, /*10100*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_BUSY,"BUSY" }, /*10101*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_BUSYUNAVAILABLE,"BUSY-UNAVAILABLE" }, /*10102*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_BUSYTENTATIVE,"BUSY-TENTATIVE" }, /*10103*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10104*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10105*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10106*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10107*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10108*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10109*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10110*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10111*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10112*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10113*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10114*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10115*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10116*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10117*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10118*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10119*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10120*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10121*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10122*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10123*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10124*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10125*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10126*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10127*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10128*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10129*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10130*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10131*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10132*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10133*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10134*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10135*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10136*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10137*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10138*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10139*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10140*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10141*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10142*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10143*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10144*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10145*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10146*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10147*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10148*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10149*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10150*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10151*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10152*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10153*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10154*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10155*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10156*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10157*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10158*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10159*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10160*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10161*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10162*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10163*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10164*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10165*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10166*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10167*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10168*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10169*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10170*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10171*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10172*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10173*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10174*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10175*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10176*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10177*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10178*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10179*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10180*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10181*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10182*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10183*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10184*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10185*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10186*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10187*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10188*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10189*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10190*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10191*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10192*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10193*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10194*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10195*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10196*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10197*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10198*/
    {ICAL_BUSYTYPE_PROPERTY,ICAL_BUSYTYPE_NONE,"" }, /*10199*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_X,"" }, /*10200*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_CARNONE,"CAR-NONE" }, /*10201*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_CARMIN,"CAR-MIN" }, /*10202*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_CARFULL1,"CAR-FULL-1" }, /*10203*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10204*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10205*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10206*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10207*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10208*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10209*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10210*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10211*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10212*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10213*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10214*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10215*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10216*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10217*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10218*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10219*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10220*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10221*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10222*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10223*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10224*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10225*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10226*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10227*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10228*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10229*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10230*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10231*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10232*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10233*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10234*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10235*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10236*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10237*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10238*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10239*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10240*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10241*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10242*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10243*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10244*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10245*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10246*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10247*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10248*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10249*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10250*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10251*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10252*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10253*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10254*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10255*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10256*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10257*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10258*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10259*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10260*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10261*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10262*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10263*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10264*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10265*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10266*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10267*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10268*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10269*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10270*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10271*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10272*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10273*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10274*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10275*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10276*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10277*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10278*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10279*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10280*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10281*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10282*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10283*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10284*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10285*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10286*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10287*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10288*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10289*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10290*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10291*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10292*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10293*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10294*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10295*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10296*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10297*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10298*/
    {ICAL_CARLEVEL_PROPERTY,ICAL_CARLEVEL_NONE,"" }, /*10299*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_X,"" }, /*10300*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_PUBLIC,"PUBLIC" }, /*10301*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_PRIVATE,"PRIVATE" }, /*10302*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_CONFIDENTIAL,"CONFIDENTIAL" }, /*10303*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10304*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10305*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10306*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10307*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10308*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10309*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10310*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10311*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10312*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10313*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10314*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10315*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10316*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10317*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10318*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10319*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10320*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10321*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10322*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10323*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10324*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10325*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10326*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10327*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10328*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10329*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10330*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10331*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10332*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10333*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10334*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10335*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10336*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10337*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10338*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10339*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10340*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10341*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10342*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10343*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10344*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10345*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10346*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10347*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10348*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10349*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10350*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10351*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10352*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10353*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10354*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10355*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10356*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10357*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10358*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10359*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10360*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10361*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10362*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10363*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10364*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10365*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10366*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10367*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10368*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10369*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10370*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10371*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10372*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10373*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10374*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10375*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10376*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10377*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10378*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10379*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10380*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10381*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10382*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10383*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10384*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10385*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10386*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10387*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10388*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10389*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10390*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10391*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10392*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10393*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10394*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10395*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10396*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10397*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10398*/
    {ICAL_CLASS_PROPERTY,ICAL_CLASS_NONE,"" }, /*10399*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_X,"" }, /*10400*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_ABORT,"ABORT" }, /*10401*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_CONTINUE,"CONTINUE" }, /*10402*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_CREATE,"CREATE" }, /*10403*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_DELETE,"DELETE" }, /*10404*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_GENERATEUID,"GENERATE-UID" }, /*10405*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_GETCAPABILITY,"GET-CAPABILITY" }, /*10406*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_IDENTIFY,"IDENTIFY" }, /*10407*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_MODIFY,"MODIFY" }, /*10408*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_MOVE,"MOVE" }, /*10409*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_REPLY,"REPLY" }, /*10410*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_SEARCH,"SEARCH" }, /*10411*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_SETLOCALE,"SET-LOCALE" }, /*10412*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10413*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10414*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10415*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10416*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10417*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10418*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10419*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10420*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10421*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10422*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10423*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10424*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10425*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10426*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10427*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10428*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10429*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10430*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10431*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10432*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10433*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10434*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10435*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10436*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10437*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10438*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10439*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10440*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10441*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10442*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10443*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10444*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10445*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10446*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10447*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10448*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10449*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10450*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10451*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10452*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10453*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10454*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10455*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10456*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10457*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10458*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10459*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10460*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10461*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10462*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10463*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10464*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10465*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10466*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10467*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10468*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10469*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10470*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10471*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10472*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10473*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10474*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10475*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10476*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10477*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10478*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10479*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10480*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10481*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10482*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10483*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10484*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10485*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10486*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10487*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10488*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10489*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10490*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10491*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10492*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10493*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10494*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10495*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10496*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10497*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10498*/
    {ICAL_CMD_PROPERTY,ICAL_CMD_NONE,"" }, /*10499*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_X,"" }, /*10500*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_PUBLISH,"PUBLISH" }, /*10501*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_REQUEST,"REQUEST" }, /*10502*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_REPLY,"REPLY" }, /*10503*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_ADD,"ADD" }, /*10504*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_CANCEL,"CANCEL" }, /*10505*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_REFRESH,"REFRESH" }, /*10506*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_COUNTER,"COUNTER" }, /*10507*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_DECLINECOUNTER,"DECLINECOUNTER" }, /*10508*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_CREATE,"CREATE" }, /*10509*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_READ,"READ" }, /*10510*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_RESPONSE,"RESPONSE" }, /*10511*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_MOVE,"MOVE" }, /*10512*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_MODIFY,"MODIFY" }, /*10513*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_GENERATEUID,"GENERATEUID" }, /*10514*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_DELETE,"DELETE" }, /*10515*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_POLLSTATUS,"POLLSTATUS" }, /*10516*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10517*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10518*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10519*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10520*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10521*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10522*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10523*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10524*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10525*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10526*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10527*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10528*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10529*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10530*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10531*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10532*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10533*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10534*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10535*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10536*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10537*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10538*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10539*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10540*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10541*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10542*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10543*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10544*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10545*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10546*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10547*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10548*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10549*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10550*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10551*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10552*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10553*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10554*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10555*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10556*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10557*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10558*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10559*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10560*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10561*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10562*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10563*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10564*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10565*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10566*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10567*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10568*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10569*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10570*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10571*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10572*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10573*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10574*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10575*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10576*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10577*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10578*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10579*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10580*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10581*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10582*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10583*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10584*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10585*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10586*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10587*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10588*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10589*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10590*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10591*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10592*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10593*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10594*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10595*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10596*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10597*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10598*/
    {ICAL_METHOD_PROPERTY,ICAL_METHOD_NONE,"" }, /*10599*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_X,"" }, /*10600*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_SERVER,"SERVER" }, /*10601*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_SERVERSUBMIT,"SERVER-SUBMIT" }, /*10602*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_SERVERCHOICE,"SERVER-CHOICE" }, /*10603*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_CLIENT,"CLIENT" }, /*10604*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10605*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10606*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10607*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10608*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10609*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10610*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10611*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10612*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10613*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10614*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10615*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10616*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10617*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10618*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10619*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10620*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10621*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10622*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10623*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10624*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10625*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10626*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10627*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10628*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10629*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10630*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10631*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10632*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10633*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10634*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10635*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10636*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10637*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10638*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10639*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10640*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10641*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10642*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10643*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10644*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10645*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10646*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10647*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10648*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10649*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10650*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10651*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10652*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10653*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10654*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10655*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10656*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10657*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10658*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10659*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10660*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10661*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10662*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10663*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10664*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10665*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10666*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10667*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10668*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10669*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10670*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10671*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10672*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10673*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10674*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10675*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10676*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10677*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10678*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10679*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10680*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10681*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10682*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10683*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10684*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10685*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10686*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10687*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10688*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10689*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10690*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10691*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10692*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10693*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10694*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10695*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10696*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10697*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10698*/
    {ICAL_POLLCOMPLETION_PROPERTY,ICAL_POLLCOMPLETION_NONE,"" }, /*10699*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_X,"" }, /*10700*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_BASIC,"BASIC" }, /*10701*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10702*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10703*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10704*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10705*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10706*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10707*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10708*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10709*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10710*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10711*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10712*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10713*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10714*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10715*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10716*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10717*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10718*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10719*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10720*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10721*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10722*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10723*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10724*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10725*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10726*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10727*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10728*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10729*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10730*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10731*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10732*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10733*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10734*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10735*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10736*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10737*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10738*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10739*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10740*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10741*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10742*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10743*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10744*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10745*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10746*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10747*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10748*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10749*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10750*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10751*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10752*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10753*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10754*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10755*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10756*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10757*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10758*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10759*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10760*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10761*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10762*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10763*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10764*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10765*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10766*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10767*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10768*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10769*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10770*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10771*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10772*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10773*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10774*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10775*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10776*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10777*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10778*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10779*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10780*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10781*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10782*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10783*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10784*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10785*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10786*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10787*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10788*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10789*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10790*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10791*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10792*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10793*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10794*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10795*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10796*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10797*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10798*/
    {ICAL_POLLMODE_PROPERTY,ICAL_POLLMODE_NONE,"" }, /*10799*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_X,"" }, /*10800*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_CALQL1,"CAL-QL-1" }, /*10801*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_CALQLNONE,"CAL-QL-NONE" }, /*10802*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10803*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10804*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10805*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10806*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10807*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10808*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10809*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10810*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10811*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10812*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10813*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10814*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10815*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10816*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10817*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10818*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10819*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10820*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10821*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10822*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10823*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10824*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10825*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10826*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10827*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10828*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10829*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10830*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10831*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10832*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10833*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10834*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10835*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10836*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10837*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10838*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10839*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10840*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10841*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10842*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10843*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10844*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10845*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10846*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10847*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10848*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10849*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10850*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10851*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10852*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10853*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10854*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10855*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10856*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10857*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10858*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10859*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10860*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10861*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10862*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10863*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10864*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10865*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10866*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10867*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10868*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10869*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10870*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10871*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10872*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10873*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10874*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10875*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10876*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10877*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10878*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10879*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10880*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10881*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10882*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10883*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10884*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10885*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10886*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10887*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10888*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10889*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10890*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10891*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10892*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10893*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10894*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10895*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10896*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10897*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10898*/
    {ICAL_QUERYLEVEL_PROPERTY,ICAL_QUERYLEVEL_NONE,"" }, /*10899*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_X,"" }, /*10900*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_TENTATIVE,"TENTATIVE" }, /*10901*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_CONFIRMED,"CONFIRMED" }, /*10902*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_COMPLETED,"COMPLETED" }, /*10903*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NEEDSACTION,"NEEDS-ACTION" }, /*10904*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_CANCELLED,"CANCELLED" }, /*10905*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_INPROCESS,"IN-PROCESS" }, /*10906*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_DRAFT,"DRAFT" }, /*10907*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_FINAL,"FINAL" }, /*10908*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_SUBMITTED,"SUBMITTED" }, /*10909*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_PENDING,"PENDING" }, /*10910*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_FAILED,"FAILED" }, /*10911*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10912*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10913*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10914*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10915*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10916*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10917*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10918*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10919*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10920*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10921*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10922*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10923*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10924*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10925*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10926*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10927*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10928*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10929*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10930*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10931*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10932*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10933*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10934*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10935*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10936*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10937*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10938*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10939*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10940*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10941*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10942*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10943*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10944*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10945*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10946*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10947*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10948*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10949*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10950*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10951*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10952*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10953*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10954*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10955*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10956*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10957*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10958*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10959*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10960*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10961*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10962*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10963*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10964*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10965*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10966*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10967*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10968*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10969*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10970*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10971*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10972*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10973*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10974*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10975*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10976*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10977*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10978*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10979*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10980*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10981*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10982*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10983*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10984*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10985*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10986*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10987*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10988*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10989*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10990*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10991*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10992*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10993*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10994*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10995*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10996*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10997*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10998*/
    {ICAL_STATUS_PROPERTY,ICAL_STATUS_NONE,"" }, /*10999*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_X,"" }, /*11000*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_OPAQUE,"OPAQUE" }, /*11001*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_OPAQUENOCONFLICT,"OPAQUE-NOCONFLICT" }, /*11002*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_TRANSPARENT,"TRANSPARENT" }, /*11003*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_TRANSPARENTNOCONFLICT,"TRANSPARENT-NOCONFLICT" }, /*11004*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11005*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11006*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11007*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11008*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11009*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11010*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11011*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11012*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11013*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11014*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11015*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11016*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11017*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11018*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11019*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11020*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11021*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11022*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11023*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11024*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11025*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11026*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11027*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11028*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11029*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11030*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11031*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11032*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11033*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11034*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11035*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11036*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11037*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11038*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11039*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11040*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11041*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11042*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11043*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11044*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11045*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11046*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11047*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11048*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11049*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11050*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11051*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11052*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11053*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11054*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11055*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11056*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11057*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11058*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11059*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11060*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11061*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11062*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11063*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11064*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11065*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11066*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11067*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11068*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11069*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11070*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11071*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11072*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11073*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11074*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11075*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11076*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11077*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11078*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11079*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11080*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11081*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11082*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11083*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11084*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11085*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11086*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11087*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11088*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11089*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11090*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11091*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11092*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11093*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11094*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11095*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11096*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11097*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11098*/
    {ICAL_TRANSP_PROPERTY,ICAL_TRANSP_NONE,"" }, /*11099*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_X,"" }, /*11100*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_PUBLISHNEW,"PUBLISH-NEW" }, /*11101*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_PUBLISHUPDATE,"PUBLISH-UPDATE" }, /*11102*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_PUBLISHFREEBUSY,"PUBLISH-FREEBUSY" }, /*11103*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_REQUESTNEW,"REQUEST-NEW" }, /*11104*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_REQUESTUPDATE,"REQUEST-UPDATE" }, /*11105*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_REQUESTRESCHEDULE,"REQUEST-RESCHEDULE" }, /*11106*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_REQUESTDELEGATE,"REQUEST-DELEGATE" }, /*11107*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_REQUESTNEWORGANIZER,"REQUEST-NEW-ORGANIZER" }, /*11108*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_REQUESTFORWARD,"REQUEST-FORWARD" }, /*11109*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_REQUESTSTATUS,"REQUEST-STATUS" }, /*11110*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_REQUESTFREEBUSY,"REQUEST-FREEBUSY" }, /*11111*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_REPLYACCEPT,"REPLY-ACCEPT" }, /*11112*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_REPLYDECLINE,"REPLY-DECLINE" }, /*11113*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_REPLYDELEGATE,"REPLY-DELEGATE" }, /*11114*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_REPLYCRASHERACCEPT,"REPLY-CRASHER-ACCEPT" }, /*11115*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_REPLYCRASHERDECLINE,"REPLY-CRASHER-DECLINE" }, /*11116*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_ADDINSTANCE,"ADD-INSTANCE" }, /*11117*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_CANCELEVENT,"CANCEL-EVENT" }, /*11118*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_CANCELINSTANCE,"CANCEL-INSTANCE" }, /*11119*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_CANCELALL,"CANCEL-ALL" }, /*11120*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_REFRESH,"REFRESH" }, /*11121*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_COUNTER,"COUNTER" }, /*11122*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_DECLINECOUNTER,"DECLINECOUNTER" }, /*11123*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_MALFORMED,"MALFORMED" }, /*11124*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_OBSOLETE,"OBSOLETE" }, /*11125*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_MISSEQUENCED,"MISSEQUENCED" }, /*11126*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_UNKNOWN,"UNKNOWN" }, /*11127*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_NONE,"" }, /*11128*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_NONE,"" }, /*11129*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_NONE,"" }, /*11130*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_NONE,"" }, /*11131*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_NONE,"" }, /*11132*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_NONE,"" }, /*11133*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_NONE,"" }, /*11134*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_NONE,"" }, /*11135*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_NONE,"" }, /*11136*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_NONE,"" }, /*11137*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_NONE,"" }, /*11138*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_NONE,"" }, /*11139*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_NONE,"" }, /*11140*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_NONE,"" }, /*11141*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_NONE,"" }, /*11142*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_NONE,"" }, /*11143*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_NONE,"" }, /*11144*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_NONE,"" }, /*11145*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_NONE,"" }, /*11146*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_NONE,"" }, /*11147*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_NONE,"" }, /*11148*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_NONE,"" }, /*11149*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_NONE,"" }, /*11150*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_NONE,"" }, /*11151*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_NONE,"" }, /*11152*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_NONE,"" }, /*11153*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_NONE,"" }, /*11154*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_NONE,"" }, /*11155*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_NONE,"" }, /*11156*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_NONE,"" }, /*11157*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_NONE,"" }, /*11158*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_NONE,"" }, /*11159*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_NONE,"" }, /*11160*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_NONE,"" }, /*11161*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_NONE,"" }, /*11162*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_NONE,"" }, /*11163*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_NONE,"" }, /*11164*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_NONE,"" }, /*11165*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_NONE,"" }, /*11166*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_NONE,"" }, /*11167*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_NONE,"" }, /*11168*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_NONE,"" }, /*11169*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_NONE,"" }, /*11170*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_NONE,"" }, /*11171*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_NONE,"" }, /*11172*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_NONE,"" }, /*11173*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_NONE,"" }, /*11174*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_NONE,"" }, /*11175*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_NONE,"" }, /*11176*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_NONE,"" }, /*11177*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_NONE,"" }, /*11178*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_NONE,"" }, /*11179*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_NONE,"" }, /*11180*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_NONE,"" }, /*11181*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_NONE,"" }, /*11182*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_NONE,"" }, /*11183*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_NONE,"" }, /*11184*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_NONE,"" }, /*11185*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_NONE,"" }, /*11186*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_NONE,"" }, /*11187*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_NONE,"" }, /*11188*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_NONE,"" }, /*11189*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_NONE,"" }, /*11190*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_NONE,"" }, /*11191*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_NONE,"" }, /*11192*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_NONE,"" }, /*11193*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_NONE,"" }, /*11194*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_NONE,"" }, /*11195*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_NONE,"" }, /*11196*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_NONE,"" }, /*11197*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_NONE,"" }, /*11198*/
    {ICAL_XLICCLASS_PROPERTY,ICAL_XLICCLASS_NONE,"" }, /*11199*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_X,"" }, /*11200*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_AUTOMATICCOMPLETION,"AUTOMATIC-COMPLETION" }, /*11201*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_AUTOMATICFAILURE,"AUTOMATIC-FAILURE" }, /*11202*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_AUTOMATICSTATUS,"AUTOMATIC-STATUS" }, /*11203*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11204*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11205*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11206*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11207*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11208*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11209*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11210*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11211*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11212*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11213*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11214*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11215*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11216*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11217*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11218*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11219*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11220*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11221*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11222*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11223*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11224*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11225*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11226*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11227*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11228*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11229*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11230*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11231*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11232*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11233*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11234*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11235*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11236*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11237*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11238*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11239*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11240*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11241*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11242*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11243*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11244*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11245*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11246*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11247*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11248*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11249*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11250*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11251*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11252*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11253*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11254*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11255*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11256*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11257*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11258*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11259*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11260*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11261*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11262*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11263*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11264*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11265*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11266*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11267*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11268*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11269*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11270*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11271*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11272*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11273*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11274*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11275*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11276*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11277*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11278*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11279*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11280*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11281*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11282*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11283*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11284*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11285*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11286*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11287*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11288*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11289*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11290*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11291*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11292*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11293*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11294*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11295*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11296*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11297*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11298*/
    {ICAL_TASKMODE_PROPERTY,ICAL_TASKMODE_NONE,"" }, /*11299*/
    {ICAL_NO_PROPERTY,0,""}
};

icalproperty* icalproperty_vanew_acceptresponse(const char* v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl= icalproperty_new_impl(ICAL_ACCEPTRESPONSE_PROPERTY);
   icalproperty_set_acceptresponse((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* ACCEPT-RESPONSE */
icalproperty* icalproperty_new_acceptresponse(const char* v) {
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl = icalproperty_new_impl(ICAL_ACCEPTRESPONSE_PROPERTY);
   icalproperty_set_acceptresponse((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_acceptresponse(icalproperty* prop, const char* v){
    icalerror_check_arg_rv( (v!=0),"v");

    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_text(v));
}
const char* icalproperty_get_acceptresponse(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_text(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_acknowledged(struct icaltimetype v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   
   impl= icalproperty_new_impl(ICAL_ACKNOWLEDGED_PROPERTY);
   icalproperty_set_acknowledged((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* ACKNOWLEDGED */
icalproperty* icalproperty_new_acknowledged(struct icaltimetype v) {
   struct icalproperty_impl *impl;
   
   impl = icalproperty_new_impl(ICAL_ACKNOWLEDGED_PROPERTY);
   icalproperty_set_acknowledged((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_acknowledged(icalproperty* prop, struct icaltimetype v){
    
    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_datetime(v));
}
struct icaltimetype icalproperty_get_acknowledged(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_datetime(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_action(enum icalproperty_action v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   
   impl= icalproperty_new_impl(ICAL_ACTION_PROPERTY);
   icalproperty_set_action((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* ACTION */
icalproperty* icalproperty_new_action(enum icalproperty_action v) {
   struct icalproperty_impl *impl;
   
   impl = icalproperty_new_impl(ICAL_ACTION_PROPERTY);
   icalproperty_set_action((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_action(icalproperty* prop, enum icalproperty_action v){
    
    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_action(v));
}
enum icalproperty_action icalproperty_get_action(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_action(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_allowconflict(const char* v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl= icalproperty_new_impl(ICAL_ALLOWCONFLICT_PROPERTY);
   icalproperty_set_allowconflict((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* ALLOW-CONFLICT */
icalproperty* icalproperty_new_allowconflict(const char* v) {
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl = icalproperty_new_impl(ICAL_ALLOWCONFLICT_PROPERTY);
   icalproperty_set_allowconflict((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_allowconflict(icalproperty* prop, const char* v){
    icalerror_check_arg_rv( (v!=0),"v");

    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_text(v));
}
const char* icalproperty_get_allowconflict(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_text(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_attach(icalattach * v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl= icalproperty_new_impl(ICAL_ATTACH_PROPERTY);
   icalproperty_set_attach((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* ATTACH */
icalproperty* icalproperty_new_attach(icalattach * v) {
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl = icalproperty_new_impl(ICAL_ATTACH_PROPERTY);
   icalproperty_set_attach((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_attach(icalproperty* prop, icalattach * v){
    icalerror_check_arg_rv( (v!=0),"v");

    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_attach(v));
}
icalattach * icalproperty_get_attach(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_attach(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_attendee(const char* v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl= icalproperty_new_impl(ICAL_ATTENDEE_PROPERTY);
   icalproperty_set_attendee((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* ATTENDEE */
icalproperty* icalproperty_new_attendee(const char* v) {
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl = icalproperty_new_impl(ICAL_ATTENDEE_PROPERTY);
   icalproperty_set_attendee((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_attendee(icalproperty* prop, const char* v){
    icalerror_check_arg_rv( (v!=0),"v");

    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_caladdress(v));
}
const char* icalproperty_get_attendee(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_caladdress(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_busytype(enum icalproperty_busytype v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   
   impl= icalproperty_new_impl(ICAL_BUSYTYPE_PROPERTY);
   icalproperty_set_busytype((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* BUSYTYPE */
icalproperty* icalproperty_new_busytype(enum icalproperty_busytype v) {
   struct icalproperty_impl *impl;
   
   impl = icalproperty_new_impl(ICAL_BUSYTYPE_PROPERTY);
   icalproperty_set_busytype((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_busytype(icalproperty* prop, enum icalproperty_busytype v){
    
    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_busytype(v));
}
enum icalproperty_busytype icalproperty_get_busytype(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_busytype(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_calid(const char* v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl= icalproperty_new_impl(ICAL_CALID_PROPERTY);
   icalproperty_set_calid((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* CALID */
icalproperty* icalproperty_new_calid(const char* v) {
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl = icalproperty_new_impl(ICAL_CALID_PROPERTY);
   icalproperty_set_calid((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_calid(icalproperty* prop, const char* v){
    icalerror_check_arg_rv( (v!=0),"v");

    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_text(v));
}
const char* icalproperty_get_calid(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_text(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_calmaster(const char* v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl= icalproperty_new_impl(ICAL_CALMASTER_PROPERTY);
   icalproperty_set_calmaster((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* CALMASTER */
icalproperty* icalproperty_new_calmaster(const char* v) {
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl = icalproperty_new_impl(ICAL_CALMASTER_PROPERTY);
   icalproperty_set_calmaster((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_calmaster(icalproperty* prop, const char* v){
    icalerror_check_arg_rv( (v!=0),"v");

    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_text(v));
}
const char* icalproperty_get_calmaster(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_text(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_calscale(const char* v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl= icalproperty_new_impl(ICAL_CALSCALE_PROPERTY);
   icalproperty_set_calscale((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* CALSCALE */
icalproperty* icalproperty_new_calscale(const char* v) {
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl = icalproperty_new_impl(ICAL_CALSCALE_PROPERTY);
   icalproperty_set_calscale((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_calscale(icalproperty* prop, const char* v){
    icalerror_check_arg_rv( (v!=0),"v");

    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_text(v));
}
const char* icalproperty_get_calscale(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_text(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_capversion(const char* v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl= icalproperty_new_impl(ICAL_CAPVERSION_PROPERTY);
   icalproperty_set_capversion((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* CAP-VERSION */
icalproperty* icalproperty_new_capversion(const char* v) {
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl = icalproperty_new_impl(ICAL_CAPVERSION_PROPERTY);
   icalproperty_set_capversion((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_capversion(icalproperty* prop, const char* v){
    icalerror_check_arg_rv( (v!=0),"v");

    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_text(v));
}
const char* icalproperty_get_capversion(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_text(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_carlevel(enum icalproperty_carlevel v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   
   impl= icalproperty_new_impl(ICAL_CARLEVEL_PROPERTY);
   icalproperty_set_carlevel((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* CAR-LEVEL */
icalproperty* icalproperty_new_carlevel(enum icalproperty_carlevel v) {
   struct icalproperty_impl *impl;
   
   impl = icalproperty_new_impl(ICAL_CARLEVEL_PROPERTY);
   icalproperty_set_carlevel((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_carlevel(icalproperty* prop, enum icalproperty_carlevel v){
    
    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_carlevel(v));
}
enum icalproperty_carlevel icalproperty_get_carlevel(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_carlevel(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_carid(const char* v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl= icalproperty_new_impl(ICAL_CARID_PROPERTY);
   icalproperty_set_carid((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* CARID */
icalproperty* icalproperty_new_carid(const char* v) {
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl = icalproperty_new_impl(ICAL_CARID_PROPERTY);
   icalproperty_set_carid((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_carid(icalproperty* prop, const char* v){
    icalerror_check_arg_rv( (v!=0),"v");

    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_text(v));
}
const char* icalproperty_get_carid(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_text(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_categories(const char* v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl= icalproperty_new_impl(ICAL_CATEGORIES_PROPERTY);
   icalproperty_set_categories((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* CATEGORIES */
icalproperty* icalproperty_new_categories(const char* v) {
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl = icalproperty_new_impl(ICAL_CATEGORIES_PROPERTY);
   icalproperty_set_categories((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_categories(icalproperty* prop, const char* v){
    icalerror_check_arg_rv( (v!=0),"v");

    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_text(v));
}
const char* icalproperty_get_categories(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_text(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_class(enum icalproperty_class v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   
   impl= icalproperty_new_impl(ICAL_CLASS_PROPERTY);
   icalproperty_set_class((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* CLASS */
icalproperty* icalproperty_new_class(enum icalproperty_class v) {
   struct icalproperty_impl *impl;
   
   impl = icalproperty_new_impl(ICAL_CLASS_PROPERTY);
   icalproperty_set_class((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_class(icalproperty* prop, enum icalproperty_class v){
    
    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_class(v));
}
enum icalproperty_class icalproperty_get_class(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_class(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_cmd(enum icalproperty_cmd v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   
   impl= icalproperty_new_impl(ICAL_CMD_PROPERTY);
   icalproperty_set_cmd((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* CMD */
icalproperty* icalproperty_new_cmd(enum icalproperty_cmd v) {
   struct icalproperty_impl *impl;
   
   impl = icalproperty_new_impl(ICAL_CMD_PROPERTY);
   icalproperty_set_cmd((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_cmd(icalproperty* prop, enum icalproperty_cmd v){
    
    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_cmd(v));
}
enum icalproperty_cmd icalproperty_get_cmd(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_cmd(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_comment(const char* v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl= icalproperty_new_impl(ICAL_COMMENT_PROPERTY);
   icalproperty_set_comment((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* COMMENT */
icalproperty* icalproperty_new_comment(const char* v) {
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl = icalproperty_new_impl(ICAL_COMMENT_PROPERTY);
   icalproperty_set_comment((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_comment(icalproperty* prop, const char* v){
    icalerror_check_arg_rv( (v!=0),"v");

    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_text(v));
}
const char* icalproperty_get_comment(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_text(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_completed(struct icaltimetype v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   
   impl= icalproperty_new_impl(ICAL_COMPLETED_PROPERTY);
   icalproperty_set_completed((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* COMPLETED */
icalproperty* icalproperty_new_completed(struct icaltimetype v) {
   struct icalproperty_impl *impl;
   
   impl = icalproperty_new_impl(ICAL_COMPLETED_PROPERTY);
   icalproperty_set_completed((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_completed(icalproperty* prop, struct icaltimetype v){
    
    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_datetime(v));
}
struct icaltimetype icalproperty_get_completed(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_datetime(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_components(const char* v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl= icalproperty_new_impl(ICAL_COMPONENTS_PROPERTY);
   icalproperty_set_components((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* COMPONENTS */
icalproperty* icalproperty_new_components(const char* v) {
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl = icalproperty_new_impl(ICAL_COMPONENTS_PROPERTY);
   icalproperty_set_components((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_components(icalproperty* prop, const char* v){
    icalerror_check_arg_rv( (v!=0),"v");

    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_text(v));
}
const char* icalproperty_get_components(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_text(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_contact(const char* v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl= icalproperty_new_impl(ICAL_CONTACT_PROPERTY);
   icalproperty_set_contact((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* CONTACT */
icalproperty* icalproperty_new_contact(const char* v) {
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl = icalproperty_new_impl(ICAL_CONTACT_PROPERTY);
   icalproperty_set_contact((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_contact(icalproperty* prop, const char* v){
    icalerror_check_arg_rv( (v!=0),"v");

    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_text(v));
}
const char* icalproperty_get_contact(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_text(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_created(struct icaltimetype v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   
   impl= icalproperty_new_impl(ICAL_CREATED_PROPERTY);
   icalproperty_set_created((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* CREATED */
icalproperty* icalproperty_new_created(struct icaltimetype v) {
   struct icalproperty_impl *impl;
   
   impl = icalproperty_new_impl(ICAL_CREATED_PROPERTY);
   icalproperty_set_created((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_created(icalproperty* prop, struct icaltimetype v){
    
    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_datetime(v));
}
struct icaltimetype icalproperty_get_created(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_datetime(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_csid(const char* v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl= icalproperty_new_impl(ICAL_CSID_PROPERTY);
   icalproperty_set_csid((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* CSID */
icalproperty* icalproperty_new_csid(const char* v) {
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl = icalproperty_new_impl(ICAL_CSID_PROPERTY);
   icalproperty_set_csid((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_csid(icalproperty* prop, const char* v){
    icalerror_check_arg_rv( (v!=0),"v");

    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_uri(v));
}
const char* icalproperty_get_csid(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_uri(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_datemax(struct icaltimetype v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   
   impl= icalproperty_new_impl(ICAL_DATEMAX_PROPERTY);
   icalproperty_set_datemax((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* DATE-MAX */
icalproperty* icalproperty_new_datemax(struct icaltimetype v) {
   struct icalproperty_impl *impl;
   
   impl = icalproperty_new_impl(ICAL_DATEMAX_PROPERTY);
   icalproperty_set_datemax((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_datemax(icalproperty* prop, struct icaltimetype v){
    
    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_datetime(v));
}
struct icaltimetype icalproperty_get_datemax(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_datetime(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_datemin(struct icaltimetype v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   
   impl= icalproperty_new_impl(ICAL_DATEMIN_PROPERTY);
   icalproperty_set_datemin((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* DATE-MIN */
icalproperty* icalproperty_new_datemin(struct icaltimetype v) {
   struct icalproperty_impl *impl;
   
   impl = icalproperty_new_impl(ICAL_DATEMIN_PROPERTY);
   icalproperty_set_datemin((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_datemin(icalproperty* prop, struct icaltimetype v){
    
    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_datetime(v));
}
struct icaltimetype icalproperty_get_datemin(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_datetime(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_decreed(const char* v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl= icalproperty_new_impl(ICAL_DECREED_PROPERTY);
   icalproperty_set_decreed((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* DECREED */
icalproperty* icalproperty_new_decreed(const char* v) {
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl = icalproperty_new_impl(ICAL_DECREED_PROPERTY);
   icalproperty_set_decreed((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_decreed(icalproperty* prop, const char* v){
    icalerror_check_arg_rv( (v!=0),"v");

    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_text(v));
}
const char* icalproperty_get_decreed(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_text(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_defaultcharset(const char* v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl= icalproperty_new_impl(ICAL_DEFAULTCHARSET_PROPERTY);
   icalproperty_set_defaultcharset((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* DEFAULT-CHARSET */
icalproperty* icalproperty_new_defaultcharset(const char* v) {
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl = icalproperty_new_impl(ICAL_DEFAULTCHARSET_PROPERTY);
   icalproperty_set_defaultcharset((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_defaultcharset(icalproperty* prop, const char* v){
    icalerror_check_arg_rv( (v!=0),"v");

    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_text(v));
}
const char* icalproperty_get_defaultcharset(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_text(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_defaultlocale(const char* v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl= icalproperty_new_impl(ICAL_DEFAULTLOCALE_PROPERTY);
   icalproperty_set_defaultlocale((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* DEFAULT-LOCALE */
icalproperty* icalproperty_new_defaultlocale(const char* v) {
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl = icalproperty_new_impl(ICAL_DEFAULTLOCALE_PROPERTY);
   icalproperty_set_defaultlocale((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_defaultlocale(icalproperty* prop, const char* v){
    icalerror_check_arg_rv( (v!=0),"v");

    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_text(v));
}
const char* icalproperty_get_defaultlocale(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_text(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_defaulttzid(const char* v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl= icalproperty_new_impl(ICAL_DEFAULTTZID_PROPERTY);
   icalproperty_set_defaulttzid((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* DEFAULT-TZID */
icalproperty* icalproperty_new_defaulttzid(const char* v) {
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl = icalproperty_new_impl(ICAL_DEFAULTTZID_PROPERTY);
   icalproperty_set_defaulttzid((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_defaulttzid(icalproperty* prop, const char* v){
    icalerror_check_arg_rv( (v!=0),"v");

    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_text(v));
}
const char* icalproperty_get_defaulttzid(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_text(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_defaultvcars(const char* v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl= icalproperty_new_impl(ICAL_DEFAULTVCARS_PROPERTY);
   icalproperty_set_defaultvcars((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* DEFAULT-VCARS */
icalproperty* icalproperty_new_defaultvcars(const char* v) {
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl = icalproperty_new_impl(ICAL_DEFAULTVCARS_PROPERTY);
   icalproperty_set_defaultvcars((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_defaultvcars(icalproperty* prop, const char* v){
    icalerror_check_arg_rv( (v!=0),"v");

    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_text(v));
}
const char* icalproperty_get_defaultvcars(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_text(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_deny(const char* v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl= icalproperty_new_impl(ICAL_DENY_PROPERTY);
   icalproperty_set_deny((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* DENY */
icalproperty* icalproperty_new_deny(const char* v) {
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl = icalproperty_new_impl(ICAL_DENY_PROPERTY);
   icalproperty_set_deny((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_deny(icalproperty* prop, const char* v){
    icalerror_check_arg_rv( (v!=0),"v");

    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_text(v));
}
const char* icalproperty_get_deny(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_text(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_description(const char* v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl= icalproperty_new_impl(ICAL_DESCRIPTION_PROPERTY);
   icalproperty_set_description((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* DESCRIPTION */
icalproperty* icalproperty_new_description(const char* v) {
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl = icalproperty_new_impl(ICAL_DESCRIPTION_PROPERTY);
   icalproperty_set_description((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_description(icalproperty* prop, const char* v){
    icalerror_check_arg_rv( (v!=0),"v");

    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_text(v));
}
const char* icalproperty_get_description(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_text(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_dtend(struct icaltimetype v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   
   impl= icalproperty_new_impl(ICAL_DTEND_PROPERTY);
   icalproperty_set_dtend((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* DTEND */
icalproperty* icalproperty_new_dtend(struct icaltimetype v) {
   struct icalproperty_impl *impl;
   
   impl = icalproperty_new_impl(ICAL_DTEND_PROPERTY);
   icalproperty_set_dtend((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_dtend(icalproperty* prop, struct icaltimetype v){
    icalvalue *value;
    
    icalerror_check_arg_rv( (prop!=0),"prop");
    if (v.is_date)
        value = icalvalue_new_date(v);
    else
        value = icalvalue_new_datetime(v);
    icalproperty_set_value(prop,value);
}
struct icaltimetype icalproperty_get_dtend(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_datetime(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_dtstamp(struct icaltimetype v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   
   impl= icalproperty_new_impl(ICAL_DTSTAMP_PROPERTY);
   icalproperty_set_dtstamp((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* DTSTAMP */
icalproperty* icalproperty_new_dtstamp(struct icaltimetype v) {
   struct icalproperty_impl *impl;
   
   impl = icalproperty_new_impl(ICAL_DTSTAMP_PROPERTY);
   icalproperty_set_dtstamp((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_dtstamp(icalproperty* prop, struct icaltimetype v){
    
    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_datetime(v));
}
struct icaltimetype icalproperty_get_dtstamp(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_datetime(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_dtstart(struct icaltimetype v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   
   impl= icalproperty_new_impl(ICAL_DTSTART_PROPERTY);
   icalproperty_set_dtstart((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* DTSTART */
icalproperty* icalproperty_new_dtstart(struct icaltimetype v) {
   struct icalproperty_impl *impl;
   
   impl = icalproperty_new_impl(ICAL_DTSTART_PROPERTY);
   icalproperty_set_dtstart((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_dtstart(icalproperty* prop, struct icaltimetype v){
    icalvalue *value;
    
    icalerror_check_arg_rv( (prop!=0),"prop");
    if (v.is_date)
        value = icalvalue_new_date(v);
    else
        value = icalvalue_new_datetime(v);
    icalproperty_set_value(prop,value);
}
struct icaltimetype icalproperty_get_dtstart(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_datetime(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_due(struct icaltimetype v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   
   impl= icalproperty_new_impl(ICAL_DUE_PROPERTY);
   icalproperty_set_due((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* DUE */
icalproperty* icalproperty_new_due(struct icaltimetype v) {
   struct icalproperty_impl *impl;
   
   impl = icalproperty_new_impl(ICAL_DUE_PROPERTY);
   icalproperty_set_due((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_due(icalproperty* prop, struct icaltimetype v){
    icalvalue *value;
    
    icalerror_check_arg_rv( (prop!=0),"prop");
    if (v.is_date)
        value = icalvalue_new_date(v);
    else
        value = icalvalue_new_datetime(v);
    icalproperty_set_value(prop,value);
}
struct icaltimetype icalproperty_get_due(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_datetime(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_duration(struct icaldurationtype v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   
   impl= icalproperty_new_impl(ICAL_DURATION_PROPERTY);
   icalproperty_set_duration((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* DURATION */
icalproperty* icalproperty_new_duration(struct icaldurationtype v) {
   struct icalproperty_impl *impl;
   
   impl = icalproperty_new_impl(ICAL_DURATION_PROPERTY);
   icalproperty_set_duration((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_duration(icalproperty* prop, struct icaldurationtype v){
    
    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_duration(v));
}
struct icaldurationtype icalproperty_get_duration(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_duration(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_estimatedduration(struct icaldurationtype v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   
   impl= icalproperty_new_impl(ICAL_ESTIMATEDDURATION_PROPERTY);
   icalproperty_set_estimatedduration((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* ESTIMATED-DURATION */
icalproperty* icalproperty_new_estimatedduration(struct icaldurationtype v) {
   struct icalproperty_impl *impl;
   
   impl = icalproperty_new_impl(ICAL_ESTIMATEDDURATION_PROPERTY);
   icalproperty_set_estimatedduration((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_estimatedduration(icalproperty* prop, struct icaldurationtype v){
    
    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_duration(v));
}
struct icaldurationtype icalproperty_get_estimatedduration(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_duration(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_exdate(struct icaltimetype v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   
   impl= icalproperty_new_impl(ICAL_EXDATE_PROPERTY);
   icalproperty_set_exdate((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* EXDATE */
icalproperty* icalproperty_new_exdate(struct icaltimetype v) {
   struct icalproperty_impl *impl;
   
   impl = icalproperty_new_impl(ICAL_EXDATE_PROPERTY);
   icalproperty_set_exdate((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_exdate(icalproperty* prop, struct icaltimetype v){
    icalvalue *value;
    
    icalerror_check_arg_rv( (prop!=0),"prop");
    if (v.is_date)
        value = icalvalue_new_date(v);
    else
        value = icalvalue_new_datetime(v);
    icalproperty_set_value(prop,value);
}
struct icaltimetype icalproperty_get_exdate(const icalproperty* prop){
#ifndef _MSC_VER
        struct icaltimetype itt;
        icalparameter* param;
        icaltimezone *zone;
#endif
        icalerror_check_arg( (prop!=0),"prop");
#ifndef _MSC_VER
        /*
         * Code by dirk@objectpark.net:
         * Set the time zone manually. I am really puzzled that
         * it doesnot work automatically like in the other functions
         * like icalproperty_get_dtstart().
         */
        itt = icalvalue_get_datetime(icalproperty_get_value(prop));
        param = icalproperty_get_first_parameter((icalproperty *)prop, ICAL_TZID_PARAMETER);
        if (param) {
                zone = icaltimezone_get_builtin_timezone(icalparameter_get_tzid(param));
                (void)icaltime_set_timezone(&itt, zone);
        }
        return itt;
#else
    return icalvalue_get_datetime(icalproperty_get_value(prop));
#endif
}
icalproperty* icalproperty_vanew_expand(int v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   
   impl= icalproperty_new_impl(ICAL_EXPAND_PROPERTY);
   icalproperty_set_expand((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* EXPAND */
icalproperty* icalproperty_new_expand(int v) {
   struct icalproperty_impl *impl;
   
   impl = icalproperty_new_impl(ICAL_EXPAND_PROPERTY);
   icalproperty_set_expand((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_expand(icalproperty* prop, int v){
    
    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_integer(v));
}
int icalproperty_get_expand(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_integer(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_exrule(struct icalrecurrencetype v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   
   impl= icalproperty_new_impl(ICAL_EXRULE_PROPERTY);
   icalproperty_set_exrule((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* EXRULE */
icalproperty* icalproperty_new_exrule(struct icalrecurrencetype v) {
   struct icalproperty_impl *impl;
   
   impl = icalproperty_new_impl(ICAL_EXRULE_PROPERTY);
   icalproperty_set_exrule((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_exrule(icalproperty* prop, struct icalrecurrencetype v){
    
    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_recur(v));
}
struct icalrecurrencetype icalproperty_get_exrule(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_recur(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_freebusy(struct icalperiodtype v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   
   impl= icalproperty_new_impl(ICAL_FREEBUSY_PROPERTY);
   icalproperty_set_freebusy((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* FREEBUSY */
icalproperty* icalproperty_new_freebusy(struct icalperiodtype v) {
   struct icalproperty_impl *impl;
   
   impl = icalproperty_new_impl(ICAL_FREEBUSY_PROPERTY);
   icalproperty_set_freebusy((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_freebusy(icalproperty* prop, struct icalperiodtype v){
    
    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_period(v));
}
struct icalperiodtype icalproperty_get_freebusy(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_period(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_geo(struct icalgeotype v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   
   impl= icalproperty_new_impl(ICAL_GEO_PROPERTY);
   icalproperty_set_geo((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* GEO */
icalproperty* icalproperty_new_geo(struct icalgeotype v) {
   struct icalproperty_impl *impl;
   
   impl = icalproperty_new_impl(ICAL_GEO_PROPERTY);
   icalproperty_set_geo((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_geo(icalproperty* prop, struct icalgeotype v){
    
    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_geo(v));
}
struct icalgeotype icalproperty_get_geo(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_geo(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_grant(const char* v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl= icalproperty_new_impl(ICAL_GRANT_PROPERTY);
   icalproperty_set_grant((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* GRANT */
icalproperty* icalproperty_new_grant(const char* v) {
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl = icalproperty_new_impl(ICAL_GRANT_PROPERTY);
   icalproperty_set_grant((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_grant(icalproperty* prop, const char* v){
    icalerror_check_arg_rv( (v!=0),"v");

    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_text(v));
}
const char* icalproperty_get_grant(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_text(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_itipversion(const char* v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl= icalproperty_new_impl(ICAL_ITIPVERSION_PROPERTY);
   icalproperty_set_itipversion((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* ITIP-VERSION */
icalproperty* icalproperty_new_itipversion(const char* v) {
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl = icalproperty_new_impl(ICAL_ITIPVERSION_PROPERTY);
   icalproperty_set_itipversion((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_itipversion(icalproperty* prop, const char* v){
    icalerror_check_arg_rv( (v!=0),"v");

    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_text(v));
}
const char* icalproperty_get_itipversion(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_text(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_lastmodified(struct icaltimetype v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   
   impl= icalproperty_new_impl(ICAL_LASTMODIFIED_PROPERTY);
   icalproperty_set_lastmodified((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* LAST-MODIFIED */
icalproperty* icalproperty_new_lastmodified(struct icaltimetype v) {
   struct icalproperty_impl *impl;
   
   impl = icalproperty_new_impl(ICAL_LASTMODIFIED_PROPERTY);
   icalproperty_set_lastmodified((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_lastmodified(icalproperty* prop, struct icaltimetype v){
    
    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_datetime(v));
}
struct icaltimetype icalproperty_get_lastmodified(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_datetime(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_location(const char* v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl= icalproperty_new_impl(ICAL_LOCATION_PROPERTY);
   icalproperty_set_location((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* LOCATION */
icalproperty* icalproperty_new_location(const char* v) {
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl = icalproperty_new_impl(ICAL_LOCATION_PROPERTY);
   icalproperty_set_location((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_location(icalproperty* prop, const char* v){
    icalerror_check_arg_rv( (v!=0),"v");

    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_text(v));
}
const char* icalproperty_get_location(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_text(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_maxcomponentsize(int v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   
   impl= icalproperty_new_impl(ICAL_MAXCOMPONENTSIZE_PROPERTY);
   icalproperty_set_maxcomponentsize((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* MAX-COMPONENT-SIZE */
icalproperty* icalproperty_new_maxcomponentsize(int v) {
   struct icalproperty_impl *impl;
   
   impl = icalproperty_new_impl(ICAL_MAXCOMPONENTSIZE_PROPERTY);
   icalproperty_set_maxcomponentsize((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_maxcomponentsize(icalproperty* prop, int v){
    
    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_integer(v));
}
int icalproperty_get_maxcomponentsize(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_integer(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_maxdate(struct icaltimetype v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   
   impl= icalproperty_new_impl(ICAL_MAXDATE_PROPERTY);
   icalproperty_set_maxdate((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* MAXDATE */
icalproperty* icalproperty_new_maxdate(struct icaltimetype v) {
   struct icalproperty_impl *impl;
   
   impl = icalproperty_new_impl(ICAL_MAXDATE_PROPERTY);
   icalproperty_set_maxdate((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_maxdate(icalproperty* prop, struct icaltimetype v){
    
    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_datetime(v));
}
struct icaltimetype icalproperty_get_maxdate(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_datetime(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_maxresults(int v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   
   impl= icalproperty_new_impl(ICAL_MAXRESULTS_PROPERTY);
   icalproperty_set_maxresults((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* MAXRESULTS */
icalproperty* icalproperty_new_maxresults(int v) {
   struct icalproperty_impl *impl;
   
   impl = icalproperty_new_impl(ICAL_MAXRESULTS_PROPERTY);
   icalproperty_set_maxresults((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_maxresults(icalproperty* prop, int v){
    
    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_integer(v));
}
int icalproperty_get_maxresults(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_integer(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_maxresultssize(int v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   
   impl= icalproperty_new_impl(ICAL_MAXRESULTSSIZE_PROPERTY);
   icalproperty_set_maxresultssize((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* MAXRESULTSSIZE */
icalproperty* icalproperty_new_maxresultssize(int v) {
   struct icalproperty_impl *impl;
   
   impl = icalproperty_new_impl(ICAL_MAXRESULTSSIZE_PROPERTY);
   icalproperty_set_maxresultssize((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_maxresultssize(icalproperty* prop, int v){
    
    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_integer(v));
}
int icalproperty_get_maxresultssize(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_integer(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_method(enum icalproperty_method v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   
   impl= icalproperty_new_impl(ICAL_METHOD_PROPERTY);
   icalproperty_set_method((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* METHOD */
icalproperty* icalproperty_new_method(enum icalproperty_method v) {
   struct icalproperty_impl *impl;
   
   impl = icalproperty_new_impl(ICAL_METHOD_PROPERTY);
   icalproperty_set_method((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_method(icalproperty* prop, enum icalproperty_method v){
    
    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_method(v));
}
enum icalproperty_method icalproperty_get_method(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_method(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_mindate(struct icaltimetype v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   
   impl= icalproperty_new_impl(ICAL_MINDATE_PROPERTY);
   icalproperty_set_mindate((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* MINDATE */
icalproperty* icalproperty_new_mindate(struct icaltimetype v) {
   struct icalproperty_impl *impl;
   
   impl = icalproperty_new_impl(ICAL_MINDATE_PROPERTY);
   icalproperty_set_mindate((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_mindate(icalproperty* prop, struct icaltimetype v){
    
    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_datetime(v));
}
struct icaltimetype icalproperty_get_mindate(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_datetime(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_multipart(const char* v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl= icalproperty_new_impl(ICAL_MULTIPART_PROPERTY);
   icalproperty_set_multipart((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* MULTIPART */
icalproperty* icalproperty_new_multipart(const char* v) {
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl = icalproperty_new_impl(ICAL_MULTIPART_PROPERTY);
   icalproperty_set_multipart((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_multipart(icalproperty* prop, const char* v){
    icalerror_check_arg_rv( (v!=0),"v");

    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_text(v));
}
const char* icalproperty_get_multipart(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_text(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_name(const char* v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl= icalproperty_new_impl(ICAL_NAME_PROPERTY);
   icalproperty_set_name((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* NAME */
icalproperty* icalproperty_new_name(const char* v) {
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl = icalproperty_new_impl(ICAL_NAME_PROPERTY);
   icalproperty_set_name((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_name(icalproperty* prop, const char* v){
    icalerror_check_arg_rv( (v!=0),"v");

    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_text(v));
}
const char* icalproperty_get_name(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_text(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_organizer(const char* v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl= icalproperty_new_impl(ICAL_ORGANIZER_PROPERTY);
   icalproperty_set_organizer((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* ORGANIZER */
icalproperty* icalproperty_new_organizer(const char* v) {
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl = icalproperty_new_impl(ICAL_ORGANIZER_PROPERTY);
   icalproperty_set_organizer((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_organizer(icalproperty* prop, const char* v){
    icalerror_check_arg_rv( (v!=0),"v");

    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_caladdress(v));
}
const char* icalproperty_get_organizer(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_caladdress(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_owner(const char* v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl= icalproperty_new_impl(ICAL_OWNER_PROPERTY);
   icalproperty_set_owner((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* OWNER */
icalproperty* icalproperty_new_owner(const char* v) {
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl = icalproperty_new_impl(ICAL_OWNER_PROPERTY);
   icalproperty_set_owner((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_owner(icalproperty* prop, const char* v){
    icalerror_check_arg_rv( (v!=0),"v");

    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_text(v));
}
const char* icalproperty_get_owner(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_text(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_percentcomplete(int v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   
   impl= icalproperty_new_impl(ICAL_PERCENTCOMPLETE_PROPERTY);
   icalproperty_set_percentcomplete((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* PERCENT-COMPLETE */
icalproperty* icalproperty_new_percentcomplete(int v) {
   struct icalproperty_impl *impl;
   
   impl = icalproperty_new_impl(ICAL_PERCENTCOMPLETE_PROPERTY);
   icalproperty_set_percentcomplete((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_percentcomplete(icalproperty* prop, int v){
    
    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_integer(v));
}
int icalproperty_get_percentcomplete(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_integer(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_permission(const char* v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl= icalproperty_new_impl(ICAL_PERMISSION_PROPERTY);
   icalproperty_set_permission((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* PERMISSION */
icalproperty* icalproperty_new_permission(const char* v) {
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl = icalproperty_new_impl(ICAL_PERMISSION_PROPERTY);
   icalproperty_set_permission((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_permission(icalproperty* prop, const char* v){
    icalerror_check_arg_rv( (v!=0),"v");

    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_text(v));
}
const char* icalproperty_get_permission(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_text(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_pollcompletion(enum icalproperty_pollcompletion v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   
   impl= icalproperty_new_impl(ICAL_POLLCOMPLETION_PROPERTY);
   icalproperty_set_pollcompletion((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* POLL-COMPLETION */
icalproperty* icalproperty_new_pollcompletion(enum icalproperty_pollcompletion v) {
   struct icalproperty_impl *impl;
   
   impl = icalproperty_new_impl(ICAL_POLLCOMPLETION_PROPERTY);
   icalproperty_set_pollcompletion((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_pollcompletion(icalproperty* prop, enum icalproperty_pollcompletion v){
    
    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_pollcompletion(v));
}
enum icalproperty_pollcompletion icalproperty_get_pollcompletion(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_pollcompletion(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_pollitemid(int v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   
   impl= icalproperty_new_impl(ICAL_POLLITEMID_PROPERTY);
   icalproperty_set_pollitemid((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* POLL-ITEM-ID */
icalproperty* icalproperty_new_pollitemid(int v) {
   struct icalproperty_impl *impl;
   
   impl = icalproperty_new_impl(ICAL_POLLITEMID_PROPERTY);
   icalproperty_set_pollitemid((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_pollitemid(icalproperty* prop, int v){
    
    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_integer(v));
}
int icalproperty_get_pollitemid(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_integer(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_pollmode(enum icalproperty_pollmode v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   
   impl= icalproperty_new_impl(ICAL_POLLMODE_PROPERTY);
   icalproperty_set_pollmode((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* POLL-MODE */
icalproperty* icalproperty_new_pollmode(enum icalproperty_pollmode v) {
   struct icalproperty_impl *impl;
   
   impl = icalproperty_new_impl(ICAL_POLLMODE_PROPERTY);
   icalproperty_set_pollmode((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_pollmode(icalproperty* prop, enum icalproperty_pollmode v){
    
    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_pollmode(v));
}
enum icalproperty_pollmode icalproperty_get_pollmode(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_pollmode(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_pollproperties(const char* v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl= icalproperty_new_impl(ICAL_POLLPROPERTIES_PROPERTY);
   icalproperty_set_pollproperties((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* POLL-PROPERTIES */
icalproperty* icalproperty_new_pollproperties(const char* v) {
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl = icalproperty_new_impl(ICAL_POLLPROPERTIES_PROPERTY);
   icalproperty_set_pollproperties((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_pollproperties(icalproperty* prop, const char* v){
    icalerror_check_arg_rv( (v!=0),"v");

    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_text(v));
}
const char* icalproperty_get_pollproperties(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_text(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_pollwinner(int v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   
   impl= icalproperty_new_impl(ICAL_POLLWINNER_PROPERTY);
   icalproperty_set_pollwinner((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* POLL-WINNER */
icalproperty* icalproperty_new_pollwinner(int v) {
   struct icalproperty_impl *impl;
   
   impl = icalproperty_new_impl(ICAL_POLLWINNER_PROPERTY);
   icalproperty_set_pollwinner((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_pollwinner(icalproperty* prop, int v){
    
    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_integer(v));
}
int icalproperty_get_pollwinner(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_integer(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_priority(int v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   
   impl= icalproperty_new_impl(ICAL_PRIORITY_PROPERTY);
   icalproperty_set_priority((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* PRIORITY */
icalproperty* icalproperty_new_priority(int v) {
   struct icalproperty_impl *impl;
   
   impl = icalproperty_new_impl(ICAL_PRIORITY_PROPERTY);
   icalproperty_set_priority((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_priority(icalproperty* prop, int v){
    
    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_integer(v));
}
int icalproperty_get_priority(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_integer(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_prodid(const char* v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl= icalproperty_new_impl(ICAL_PRODID_PROPERTY);
   icalproperty_set_prodid((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* PRODID */
icalproperty* icalproperty_new_prodid(const char* v) {
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl = icalproperty_new_impl(ICAL_PRODID_PROPERTY);
   icalproperty_set_prodid((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_prodid(icalproperty* prop, const char* v){
    icalerror_check_arg_rv( (v!=0),"v");

    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_text(v));
}
const char* icalproperty_get_prodid(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_text(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_query(const char* v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl= icalproperty_new_impl(ICAL_QUERY_PROPERTY);
   icalproperty_set_query((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* QUERY */
icalproperty* icalproperty_new_query(const char* v) {
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl = icalproperty_new_impl(ICAL_QUERY_PROPERTY);
   icalproperty_set_query((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_query(icalproperty* prop, const char* v){
    icalerror_check_arg_rv( (v!=0),"v");

    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_query(v));
}
const char* icalproperty_get_query(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_query(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_querylevel(enum icalproperty_querylevel v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   
   impl= icalproperty_new_impl(ICAL_QUERYLEVEL_PROPERTY);
   icalproperty_set_querylevel((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* QUERY-LEVEL */
icalproperty* icalproperty_new_querylevel(enum icalproperty_querylevel v) {
   struct icalproperty_impl *impl;
   
   impl = icalproperty_new_impl(ICAL_QUERYLEVEL_PROPERTY);
   icalproperty_set_querylevel((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_querylevel(icalproperty* prop, enum icalproperty_querylevel v){
    
    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_querylevel(v));
}
enum icalproperty_querylevel icalproperty_get_querylevel(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_querylevel(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_queryid(const char* v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl= icalproperty_new_impl(ICAL_QUERYID_PROPERTY);
   icalproperty_set_queryid((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* QUERYID */
icalproperty* icalproperty_new_queryid(const char* v) {
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl = icalproperty_new_impl(ICAL_QUERYID_PROPERTY);
   icalproperty_set_queryid((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_queryid(icalproperty* prop, const char* v){
    icalerror_check_arg_rv( (v!=0),"v");

    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_text(v));
}
const char* icalproperty_get_queryid(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_text(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_queryname(const char* v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl= icalproperty_new_impl(ICAL_QUERYNAME_PROPERTY);
   icalproperty_set_queryname((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* QUERYNAME */
icalproperty* icalproperty_new_queryname(const char* v) {
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl = icalproperty_new_impl(ICAL_QUERYNAME_PROPERTY);
   icalproperty_set_queryname((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_queryname(icalproperty* prop, const char* v){
    icalerror_check_arg_rv( (v!=0),"v");

    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_text(v));
}
const char* icalproperty_get_queryname(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_text(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_rdate(struct icaldatetimeperiodtype v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   
   impl= icalproperty_new_impl(ICAL_RDATE_PROPERTY);
   icalproperty_set_rdate((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* RDATE */
icalproperty* icalproperty_new_rdate(struct icaldatetimeperiodtype v) {
   struct icalproperty_impl *impl;
   
   impl = icalproperty_new_impl(ICAL_RDATE_PROPERTY);
   icalproperty_set_rdate((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_rdate(icalproperty* prop, struct icaldatetimeperiodtype v){
    
    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_datetimeperiod(v));
}
struct icaldatetimeperiodtype icalproperty_get_rdate(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_datetimeperiod(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_recuraccepted(const char* v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl= icalproperty_new_impl(ICAL_RECURACCEPTED_PROPERTY);
   icalproperty_set_recuraccepted((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* RECUR-ACCEPTED */
icalproperty* icalproperty_new_recuraccepted(const char* v) {
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl = icalproperty_new_impl(ICAL_RECURACCEPTED_PROPERTY);
   icalproperty_set_recuraccepted((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_recuraccepted(icalproperty* prop, const char* v){
    icalerror_check_arg_rv( (v!=0),"v");

    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_text(v));
}
const char* icalproperty_get_recuraccepted(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_text(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_recurexpand(const char* v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl= icalproperty_new_impl(ICAL_RECUREXPAND_PROPERTY);
   icalproperty_set_recurexpand((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* RECUR-EXPAND */
icalproperty* icalproperty_new_recurexpand(const char* v) {
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl = icalproperty_new_impl(ICAL_RECUREXPAND_PROPERTY);
   icalproperty_set_recurexpand((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_recurexpand(icalproperty* prop, const char* v){
    icalerror_check_arg_rv( (v!=0),"v");

    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_text(v));
}
const char* icalproperty_get_recurexpand(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_text(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_recurlimit(const char* v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl= icalproperty_new_impl(ICAL_RECURLIMIT_PROPERTY);
   icalproperty_set_recurlimit((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* RECUR-LIMIT */
icalproperty* icalproperty_new_recurlimit(const char* v) {
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl = icalproperty_new_impl(ICAL_RECURLIMIT_PROPERTY);
   icalproperty_set_recurlimit((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_recurlimit(icalproperty* prop, const char* v){
    icalerror_check_arg_rv( (v!=0),"v");

    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_text(v));
}
const char* icalproperty_get_recurlimit(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_text(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_recurrenceid(struct icaltimetype v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   
   impl= icalproperty_new_impl(ICAL_RECURRENCEID_PROPERTY);
   icalproperty_set_recurrenceid((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* RECURRENCE-ID */
icalproperty* icalproperty_new_recurrenceid(struct icaltimetype v) {
   struct icalproperty_impl *impl;
   
   impl = icalproperty_new_impl(ICAL_RECURRENCEID_PROPERTY);
   icalproperty_set_recurrenceid((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_recurrenceid(icalproperty* prop, struct icaltimetype v){
    icalvalue *value;
    
    icalerror_check_arg_rv( (prop!=0),"prop");
    if (v.is_date)
        value = icalvalue_new_date(v);
    else
        value = icalvalue_new_datetime(v);
    icalproperty_set_value(prop,value);
}
struct icaltimetype icalproperty_get_recurrenceid(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_datetime(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_relatedto(const char* v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl= icalproperty_new_impl(ICAL_RELATEDTO_PROPERTY);
   icalproperty_set_relatedto((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* RELATED-TO */
icalproperty* icalproperty_new_relatedto(const char* v) {
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl = icalproperty_new_impl(ICAL_RELATEDTO_PROPERTY);
   icalproperty_set_relatedto((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_relatedto(icalproperty* prop, const char* v){
    icalerror_check_arg_rv( (v!=0),"v");

    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_text(v));
}
const char* icalproperty_get_relatedto(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_text(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_relcalid(const char* v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl= icalproperty_new_impl(ICAL_RELCALID_PROPERTY);
   icalproperty_set_relcalid((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* RELCALID */
icalproperty* icalproperty_new_relcalid(const char* v) {
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl = icalproperty_new_impl(ICAL_RELCALID_PROPERTY);
   icalproperty_set_relcalid((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_relcalid(icalproperty* prop, const char* v){
    icalerror_check_arg_rv( (v!=0),"v");

    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_text(v));
}
const char* icalproperty_get_relcalid(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_text(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_repeat(int v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   
   impl= icalproperty_new_impl(ICAL_REPEAT_PROPERTY);
   icalproperty_set_repeat((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* REPEAT */
icalproperty* icalproperty_new_repeat(int v) {
   struct icalproperty_impl *impl;
   
   impl = icalproperty_new_impl(ICAL_REPEAT_PROPERTY);
   icalproperty_set_repeat((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_repeat(icalproperty* prop, int v){
    
    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_integer(v));
}
int icalproperty_get_repeat(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_integer(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_replyurl(const char* v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl= icalproperty_new_impl(ICAL_REPLYURL_PROPERTY);
   icalproperty_set_replyurl((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* REPLY-URL */
icalproperty* icalproperty_new_replyurl(const char* v) {
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl = icalproperty_new_impl(ICAL_REPLYURL_PROPERTY);
   icalproperty_set_replyurl((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_replyurl(icalproperty* prop, const char* v){
    icalerror_check_arg_rv( (v!=0),"v");

    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_uri(v));
}
const char* icalproperty_get_replyurl(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_uri(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_requeststatus(struct icalreqstattype v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   
   impl= icalproperty_new_impl(ICAL_REQUESTSTATUS_PROPERTY);
   icalproperty_set_requeststatus((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* REQUEST-STATUS */
icalproperty* icalproperty_new_requeststatus(struct icalreqstattype v) {
   struct icalproperty_impl *impl;
   
   impl = icalproperty_new_impl(ICAL_REQUESTSTATUS_PROPERTY);
   icalproperty_set_requeststatus((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_requeststatus(icalproperty* prop, struct icalreqstattype v){
    
    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_requeststatus(v));
}
struct icalreqstattype icalproperty_get_requeststatus(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_requeststatus(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_resources(const char* v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl= icalproperty_new_impl(ICAL_RESOURCES_PROPERTY);
   icalproperty_set_resources((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* RESOURCES */
icalproperty* icalproperty_new_resources(const char* v) {
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl = icalproperty_new_impl(ICAL_RESOURCES_PROPERTY);
   icalproperty_set_resources((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_resources(icalproperty* prop, const char* v){
    icalerror_check_arg_rv( (v!=0),"v");

    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_text(v));
}
const char* icalproperty_get_resources(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_text(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_response(int v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   
   impl= icalproperty_new_impl(ICAL_RESPONSE_PROPERTY);
   icalproperty_set_response((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* RESPONSE */
icalproperty* icalproperty_new_response(int v) {
   struct icalproperty_impl *impl;
   
   impl = icalproperty_new_impl(ICAL_RESPONSE_PROPERTY);
   icalproperty_set_response((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_response(icalproperty* prop, int v){
    
    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_integer(v));
}
int icalproperty_get_response(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_integer(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_restriction(const char* v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl= icalproperty_new_impl(ICAL_RESTRICTION_PROPERTY);
   icalproperty_set_restriction((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* RESTRICTION */
icalproperty* icalproperty_new_restriction(const char* v) {
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl = icalproperty_new_impl(ICAL_RESTRICTION_PROPERTY);
   icalproperty_set_restriction((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_restriction(icalproperty* prop, const char* v){
    icalerror_check_arg_rv( (v!=0),"v");

    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_query(v));
}
const char* icalproperty_get_restriction(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_query(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_rrule(struct icalrecurrencetype v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   
   impl= icalproperty_new_impl(ICAL_RRULE_PROPERTY);
   icalproperty_set_rrule((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* RRULE */
icalproperty* icalproperty_new_rrule(struct icalrecurrencetype v) {
   struct icalproperty_impl *impl;
   
   impl = icalproperty_new_impl(ICAL_RRULE_PROPERTY);
   icalproperty_set_rrule((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_rrule(icalproperty* prop, struct icalrecurrencetype v){
    
    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_recur(v));
}
struct icalrecurrencetype icalproperty_get_rrule(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_recur(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_scope(const char* v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl= icalproperty_new_impl(ICAL_SCOPE_PROPERTY);
   icalproperty_set_scope((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* SCOPE */
icalproperty* icalproperty_new_scope(const char* v) {
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl = icalproperty_new_impl(ICAL_SCOPE_PROPERTY);
   icalproperty_set_scope((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_scope(icalproperty* prop, const char* v){
    icalerror_check_arg_rv( (v!=0),"v");

    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_text(v));
}
const char* icalproperty_get_scope(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_text(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_sequence(int v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   
   impl= icalproperty_new_impl(ICAL_SEQUENCE_PROPERTY);
   icalproperty_set_sequence((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* SEQUENCE */
icalproperty* icalproperty_new_sequence(int v) {
   struct icalproperty_impl *impl;
   
   impl = icalproperty_new_impl(ICAL_SEQUENCE_PROPERTY);
   icalproperty_set_sequence((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_sequence(icalproperty* prop, int v){
    
    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_integer(v));
}
int icalproperty_get_sequence(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_integer(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_status(enum icalproperty_status v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   
   impl= icalproperty_new_impl(ICAL_STATUS_PROPERTY);
   icalproperty_set_status((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* STATUS */
icalproperty* icalproperty_new_status(enum icalproperty_status v) {
   struct icalproperty_impl *impl;
   
   impl = icalproperty_new_impl(ICAL_STATUS_PROPERTY);
   icalproperty_set_status((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_status(icalproperty* prop, enum icalproperty_status v){
    
    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_status(v));
}
enum icalproperty_status icalproperty_get_status(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_status(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_storesexpanded(const char* v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl= icalproperty_new_impl(ICAL_STORESEXPANDED_PROPERTY);
   icalproperty_set_storesexpanded((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* STORES-EXPANDED */
icalproperty* icalproperty_new_storesexpanded(const char* v) {
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl = icalproperty_new_impl(ICAL_STORESEXPANDED_PROPERTY);
   icalproperty_set_storesexpanded((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_storesexpanded(icalproperty* prop, const char* v){
    icalerror_check_arg_rv( (v!=0),"v");

    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_text(v));
}
const char* icalproperty_get_storesexpanded(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_text(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_summary(const char* v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl= icalproperty_new_impl(ICAL_SUMMARY_PROPERTY);
   icalproperty_set_summary((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* SUMMARY */
icalproperty* icalproperty_new_summary(const char* v) {
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl = icalproperty_new_impl(ICAL_SUMMARY_PROPERTY);
   icalproperty_set_summary((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_summary(icalproperty* prop, const char* v){
    icalerror_check_arg_rv( (v!=0),"v");

    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_text(v));
}
const char* icalproperty_get_summary(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_text(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_target(const char* v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl= icalproperty_new_impl(ICAL_TARGET_PROPERTY);
   icalproperty_set_target((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* TARGET */
icalproperty* icalproperty_new_target(const char* v) {
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl = icalproperty_new_impl(ICAL_TARGET_PROPERTY);
   icalproperty_set_target((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_target(icalproperty* prop, const char* v){
    icalerror_check_arg_rv( (v!=0),"v");

    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_caladdress(v));
}
const char* icalproperty_get_target(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_caladdress(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_taskmode(enum icalproperty_taskmode v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   
   impl= icalproperty_new_impl(ICAL_TASKMODE_PROPERTY);
   icalproperty_set_taskmode((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* TASK-MODE */
icalproperty* icalproperty_new_taskmode(enum icalproperty_taskmode v) {
   struct icalproperty_impl *impl;
   
   impl = icalproperty_new_impl(ICAL_TASKMODE_PROPERTY);
   icalproperty_set_taskmode((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_taskmode(icalproperty* prop, enum icalproperty_taskmode v){
    
    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_taskmode(v));
}
enum icalproperty_taskmode icalproperty_get_taskmode(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_taskmode(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_transp(enum icalproperty_transp v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   
   impl= icalproperty_new_impl(ICAL_TRANSP_PROPERTY);
   icalproperty_set_transp((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* TRANSP */
icalproperty* icalproperty_new_transp(enum icalproperty_transp v) {
   struct icalproperty_impl *impl;
   
   impl = icalproperty_new_impl(ICAL_TRANSP_PROPERTY);
   icalproperty_set_transp((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_transp(icalproperty* prop, enum icalproperty_transp v){
    
    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_transp(v));
}
enum icalproperty_transp icalproperty_get_transp(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_transp(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_trigger(struct icaltriggertype v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   
   impl= icalproperty_new_impl(ICAL_TRIGGER_PROPERTY);
   icalproperty_set_trigger((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* TRIGGER */
icalproperty* icalproperty_new_trigger(struct icaltriggertype v) {
   struct icalproperty_impl *impl;
   
   impl = icalproperty_new_impl(ICAL_TRIGGER_PROPERTY);
   icalproperty_set_trigger((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_trigger(icalproperty* prop, struct icaltriggertype v){
    
    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_trigger(v));
}
struct icaltriggertype icalproperty_get_trigger(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_trigger(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_tzid(const char* v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl= icalproperty_new_impl(ICAL_TZID_PROPERTY);
   icalproperty_set_tzid((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* TZID */
icalproperty* icalproperty_new_tzid(const char* v) {
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl = icalproperty_new_impl(ICAL_TZID_PROPERTY);
   icalproperty_set_tzid((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_tzid(icalproperty* prop, const char* v){
    icalerror_check_arg_rv( (v!=0),"v");

    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_text(v));
}
const char* icalproperty_get_tzid(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_text(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_tzidaliasof(const char* v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl= icalproperty_new_impl(ICAL_TZIDALIASOF_PROPERTY);
   icalproperty_set_tzidaliasof((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* TZID-ALIAS-OF */
icalproperty* icalproperty_new_tzidaliasof(const char* v) {
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl = icalproperty_new_impl(ICAL_TZIDALIASOF_PROPERTY);
   icalproperty_set_tzidaliasof((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_tzidaliasof(icalproperty* prop, const char* v){
    icalerror_check_arg_rv( (v!=0),"v");

    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_text(v));
}
const char* icalproperty_get_tzidaliasof(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_text(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_tzname(const char* v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl= icalproperty_new_impl(ICAL_TZNAME_PROPERTY);
   icalproperty_set_tzname((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* TZNAME */
icalproperty* icalproperty_new_tzname(const char* v) {
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl = icalproperty_new_impl(ICAL_TZNAME_PROPERTY);
   icalproperty_set_tzname((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_tzname(icalproperty* prop, const char* v){
    icalerror_check_arg_rv( (v!=0),"v");

    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_text(v));
}
const char* icalproperty_get_tzname(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_text(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_tzoffsetfrom(int v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   
   impl= icalproperty_new_impl(ICAL_TZOFFSETFROM_PROPERTY);
   icalproperty_set_tzoffsetfrom((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* TZOFFSETFROM */
icalproperty* icalproperty_new_tzoffsetfrom(int v) {
   struct icalproperty_impl *impl;
   
   impl = icalproperty_new_impl(ICAL_TZOFFSETFROM_PROPERTY);
   icalproperty_set_tzoffsetfrom((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_tzoffsetfrom(icalproperty* prop, int v){
    
    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_utcoffset(v));
}
int icalproperty_get_tzoffsetfrom(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_utcoffset(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_tzoffsetto(int v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   
   impl= icalproperty_new_impl(ICAL_TZOFFSETTO_PROPERTY);
   icalproperty_set_tzoffsetto((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* TZOFFSETTO */
icalproperty* icalproperty_new_tzoffsetto(int v) {
   struct icalproperty_impl *impl;
   
   impl = icalproperty_new_impl(ICAL_TZOFFSETTO_PROPERTY);
   icalproperty_set_tzoffsetto((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_tzoffsetto(icalproperty* prop, int v){
    
    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_utcoffset(v));
}
int icalproperty_get_tzoffsetto(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_utcoffset(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_tzuntil(struct icaltimetype v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   
   impl= icalproperty_new_impl(ICAL_TZUNTIL_PROPERTY);
   icalproperty_set_tzuntil((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* TZUNTIL */
icalproperty* icalproperty_new_tzuntil(struct icaltimetype v) {
   struct icalproperty_impl *impl;
   
   impl = icalproperty_new_impl(ICAL_TZUNTIL_PROPERTY);
   icalproperty_set_tzuntil((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_tzuntil(icalproperty* prop, struct icaltimetype v){
    
    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_datetime(v));
}
struct icaltimetype icalproperty_get_tzuntil(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_datetime(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_tzurl(const char* v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl= icalproperty_new_impl(ICAL_TZURL_PROPERTY);
   icalproperty_set_tzurl((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* TZURL */
icalproperty* icalproperty_new_tzurl(const char* v) {
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl = icalproperty_new_impl(ICAL_TZURL_PROPERTY);
   icalproperty_set_tzurl((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_tzurl(icalproperty* prop, const char* v){
    icalerror_check_arg_rv( (v!=0),"v");

    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_uri(v));
}
const char* icalproperty_get_tzurl(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_uri(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_uid(const char* v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl= icalproperty_new_impl(ICAL_UID_PROPERTY);
   icalproperty_set_uid((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* UID */
icalproperty* icalproperty_new_uid(const char* v) {
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl = icalproperty_new_impl(ICAL_UID_PROPERTY);
   icalproperty_set_uid((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_uid(icalproperty* prop, const char* v){
    icalerror_check_arg_rv( (v!=0),"v");

    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_text(v));
}
const char* icalproperty_get_uid(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_text(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_url(const char* v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl= icalproperty_new_impl(ICAL_URL_PROPERTY);
   icalproperty_set_url((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* URL */
icalproperty* icalproperty_new_url(const char* v) {
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl = icalproperty_new_impl(ICAL_URL_PROPERTY);
   icalproperty_set_url((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_url(icalproperty* prop, const char* v){
    icalerror_check_arg_rv( (v!=0),"v");

    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_uri(v));
}
const char* icalproperty_get_url(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_uri(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_version(const char* v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl= icalproperty_new_impl(ICAL_VERSION_PROPERTY);
   icalproperty_set_version((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* VERSION */
icalproperty* icalproperty_new_version(const char* v) {
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl = icalproperty_new_impl(ICAL_VERSION_PROPERTY);
   icalproperty_set_version((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_version(icalproperty* prop, const char* v){
    icalerror_check_arg_rv( (v!=0),"v");

    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_text(v));
}
const char* icalproperty_get_version(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_text(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_voter(const char* v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl= icalproperty_new_impl(ICAL_VOTER_PROPERTY);
   icalproperty_set_voter((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* VOTER */
icalproperty* icalproperty_new_voter(const char* v) {
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl = icalproperty_new_impl(ICAL_VOTER_PROPERTY);
   icalproperty_set_voter((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_voter(icalproperty* prop, const char* v){
    icalerror_check_arg_rv( (v!=0),"v");

    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_caladdress(v));
}
const char* icalproperty_get_voter(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_caladdress(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_x(const char* v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl= icalproperty_new_impl(ICAL_X_PROPERTY);
   icalproperty_set_x((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* X */
icalproperty* icalproperty_new_x(const char* v) {
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl = icalproperty_new_impl(ICAL_X_PROPERTY);
   icalproperty_set_x((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_x(icalproperty* prop, const char* v){
    icalerror_check_arg_rv( (v!=0),"v");

    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_x(v));
}
const char* icalproperty_get_x(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_x(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_xlicclass(enum icalproperty_xlicclass v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   
   impl= icalproperty_new_impl(ICAL_XLICCLASS_PROPERTY);
   icalproperty_set_xlicclass((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* X-LIC-CLASS */
icalproperty* icalproperty_new_xlicclass(enum icalproperty_xlicclass v) {
   struct icalproperty_impl *impl;
   
   impl = icalproperty_new_impl(ICAL_XLICCLASS_PROPERTY);
   icalproperty_set_xlicclass((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_xlicclass(icalproperty* prop, enum icalproperty_xlicclass v){
    
    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_xlicclass(v));
}
enum icalproperty_xlicclass icalproperty_get_xlicclass(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_xlicclass(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_xlicclustercount(const char* v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl= icalproperty_new_impl(ICAL_XLICCLUSTERCOUNT_PROPERTY);
   icalproperty_set_xlicclustercount((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* X-LIC-CLUSTERCOUNT */
icalproperty* icalproperty_new_xlicclustercount(const char* v) {
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl = icalproperty_new_impl(ICAL_XLICCLUSTERCOUNT_PROPERTY);
   icalproperty_set_xlicclustercount((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_xlicclustercount(icalproperty* prop, const char* v){
    icalerror_check_arg_rv( (v!=0),"v");

    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_string(v));
}
const char* icalproperty_get_xlicclustercount(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_string(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_xlicerror(const char* v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl= icalproperty_new_impl(ICAL_XLICERROR_PROPERTY);
   icalproperty_set_xlicerror((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* X-LIC-ERROR */
icalproperty* icalproperty_new_xlicerror(const char* v) {
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl = icalproperty_new_impl(ICAL_XLICERROR_PROPERTY);
   icalproperty_set_xlicerror((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_xlicerror(icalproperty* prop, const char* v){
    icalerror_check_arg_rv( (v!=0),"v");

    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_text(v));
}
const char* icalproperty_get_xlicerror(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_text(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_xlicmimecharset(const char* v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl= icalproperty_new_impl(ICAL_XLICMIMECHARSET_PROPERTY);
   icalproperty_set_xlicmimecharset((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* X-LIC-MIMECHARSET */
icalproperty* icalproperty_new_xlicmimecharset(const char* v) {
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl = icalproperty_new_impl(ICAL_XLICMIMECHARSET_PROPERTY);
   icalproperty_set_xlicmimecharset((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_xlicmimecharset(icalproperty* prop, const char* v){
    icalerror_check_arg_rv( (v!=0),"v");

    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_string(v));
}
const char* icalproperty_get_xlicmimecharset(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_string(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_xlicmimecid(const char* v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl= icalproperty_new_impl(ICAL_XLICMIMECID_PROPERTY);
   icalproperty_set_xlicmimecid((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* X-LIC-MIMECID */
icalproperty* icalproperty_new_xlicmimecid(const char* v) {
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl = icalproperty_new_impl(ICAL_XLICMIMECID_PROPERTY);
   icalproperty_set_xlicmimecid((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_xlicmimecid(icalproperty* prop, const char* v){
    icalerror_check_arg_rv( (v!=0),"v");

    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_string(v));
}
const char* icalproperty_get_xlicmimecid(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_string(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_xlicmimecontenttype(const char* v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl= icalproperty_new_impl(ICAL_XLICMIMECONTENTTYPE_PROPERTY);
   icalproperty_set_xlicmimecontenttype((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* X-LIC-MIMECONTENTTYPE */
icalproperty* icalproperty_new_xlicmimecontenttype(const char* v) {
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl = icalproperty_new_impl(ICAL_XLICMIMECONTENTTYPE_PROPERTY);
   icalproperty_set_xlicmimecontenttype((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_xlicmimecontenttype(icalproperty* prop, const char* v){
    icalerror_check_arg_rv( (v!=0),"v");

    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_string(v));
}
const char* icalproperty_get_xlicmimecontenttype(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_string(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_xlicmimeencoding(const char* v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl= icalproperty_new_impl(ICAL_XLICMIMEENCODING_PROPERTY);
   icalproperty_set_xlicmimeencoding((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* X-LIC-MIMEENCODING */
icalproperty* icalproperty_new_xlicmimeencoding(const char* v) {
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl = icalproperty_new_impl(ICAL_XLICMIMEENCODING_PROPERTY);
   icalproperty_set_xlicmimeencoding((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_xlicmimeencoding(icalproperty* prop, const char* v){
    icalerror_check_arg_rv( (v!=0),"v");

    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_string(v));
}
const char* icalproperty_get_xlicmimeencoding(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_string(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_xlicmimefilename(const char* v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl= icalproperty_new_impl(ICAL_XLICMIMEFILENAME_PROPERTY);
   icalproperty_set_xlicmimefilename((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* X-LIC-MIMEFILENAME */
icalproperty* icalproperty_new_xlicmimefilename(const char* v) {
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl = icalproperty_new_impl(ICAL_XLICMIMEFILENAME_PROPERTY);
   icalproperty_set_xlicmimefilename((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_xlicmimefilename(icalproperty* prop, const char* v){
    icalerror_check_arg_rv( (v!=0),"v");

    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_string(v));
}
const char* icalproperty_get_xlicmimefilename(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_string(icalproperty_get_value(prop));
}
icalproperty* icalproperty_vanew_xlicmimeoptinfo(const char* v, ...){
   va_list args;
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl= icalproperty_new_impl(ICAL_XLICMIMEOPTINFO_PROPERTY);
   icalproperty_set_xlicmimeoptinfo((icalproperty*)impl,v);
   va_start(args,v);
   icalproperty_add_parameters(impl, args);
   va_end(args);
   return (icalproperty*)impl;
}

/* X-LIC-MIMEOPTINFO */
icalproperty* icalproperty_new_xlicmimeoptinfo(const char* v) {
   struct icalproperty_impl *impl;
   icalerror_check_arg_rz( (v!=0),"v");

   impl = icalproperty_new_impl(ICAL_XLICMIMEOPTINFO_PROPERTY);
   icalproperty_set_xlicmimeoptinfo((icalproperty*)impl,v);
   return (icalproperty*)impl;
}

void icalproperty_set_xlicmimeoptinfo(icalproperty* prop, const char* v){
    icalerror_check_arg_rv( (v!=0),"v");

    icalerror_check_arg_rv( (prop!=0),"prop");
    icalproperty_set_value(prop,icalvalue_new_string(v));
}
const char* icalproperty_get_xlicmimeoptinfo(const icalproperty* prop){
    icalerror_check_arg( (prop!=0),"prop");
    return icalvalue_get_string(icalproperty_get_value(prop));
}

int icalproperty_kind_is_valid(const icalproperty_kind kind)
{
    int i = 0;
    do {
      if (property_map[i].kind == kind)
        return 1;
    } while (property_map[i++].kind != ICAL_NO_PROPERTY);

    return 0;
}

const char* icalproperty_kind_to_string(icalproperty_kind kind)
{
    int i;

    for (i=0; property_map[i].kind != ICAL_NO_PROPERTY; i++) {
        if (property_map[i].kind == kind) {
            return property_map[i].name;
        }
    }

    return 0;

}


icalproperty_kind icalproperty_string_to_kind(const char* string)
{
    int i;

    if (string ==0 ) {
        return ICAL_NO_PROPERTY;
    }


    for (i=0; property_map[i].kind  != ICAL_NO_PROPERTY; i++) {
        if (strcasecmp(property_map[i].name, string) == 0) {
            return property_map[i].kind;
        }
    }

    if(strncmp(string,"X-",2)==0){
        return ICAL_X_PROPERTY;
    }


    return ICAL_NO_PROPERTY;
}


icalproperty_kind icalproperty_value_kind_to_kind(icalvalue_kind kind)
{
    int i;

    for (i=0; property_map[i].kind  != ICAL_NO_PROPERTY; i++) {
        if ( property_map[i].value == kind ) {
            return property_map[i].kind;
        }
    }

    return ICAL_NO_PROPERTY;
}



icalvalue_kind icalproperty_kind_to_value_kind(icalproperty_kind kind)
{
    int i;

    for (i=0; property_map[i].kind  != ICAL_NO_PROPERTY; i++) {
        if ( property_map[i].kind == kind ) {
            return property_map[i].value;
        }
    }

    return ICAL_NO_VALUE;
}


const char* icalproperty_enum_to_string(int e)
{
    icalerror_check_arg_rz(e >= ICALPROPERTY_FIRST_ENUM,"e");
    icalerror_check_arg_rz(e <= ICALPROPERTY_LAST_ENUM,"e");

    return enum_map[e-ICALPROPERTY_FIRST_ENUM].str;
}


char *icalproperty_enum_to_string_r(int e)
{
        return icalmemory_strdup(icalproperty_enum_to_string(e));
}


int icalproperty_kind_and_string_to_enum(const int kind, const char* str)
{
    icalproperty_kind pkind;
    int i;

    icalerror_check_arg_rz(str!=0,"str")

    if ((pkind = icalproperty_value_kind_to_kind(kind)) == ICAL_NO_PROPERTY)
        return 0;

    while(*str == ' '){
        str++;
    }

    for (i=ICALPROPERTY_FIRST_ENUM; i != ICALPROPERTY_LAST_ENUM; i++) {
        if (enum_map[i-ICALPROPERTY_FIRST_ENUM].prop == pkind)
            break;
    }
    if (i == ICALPROPERTY_LAST_ENUM)
            return 0;

    for (; i != ICALPROPERTY_LAST_ENUM; i++) {
        if(enum_map[i-ICALPROPERTY_FIRST_ENUM].prop == pkind &&
           strcasecmp(enum_map[i-ICALPROPERTY_FIRST_ENUM].str, str) == 0) {
            return enum_map[i-ICALPROPERTY_FIRST_ENUM].prop_enum;
        }
    }

    return 0;
}

/** @deprecated please use icalproperty_kind_and_string_to_enum instead */
int icalproperty_string_to_enum(const char* str)
{
    int i;

    icalerror_check_arg_rz(str!=0,"str")

    while(*str == ' '){
        str++;
    }

    for (i=ICALPROPERTY_FIRST_ENUM; i != ICALPROPERTY_LAST_ENUM; i++) {
        if ( strcasecmp(enum_map[i-ICALPROPERTY_FIRST_ENUM].str, str) == 0) {
            return enum_map[i-ICALPROPERTY_FIRST_ENUM].prop_enum;
        }
    }

    return 0;
}

int icalproperty_enum_belongs_to_property(icalproperty_kind kind, int e)
{
    int i;


    for (i=ICALPROPERTY_FIRST_ENUM; i != ICALPROPERTY_LAST_ENUM; i++) {
        if(enum_map[i-ICALPROPERTY_FIRST_ENUM].prop_enum == e &&
           enum_map[i-ICALPROPERTY_FIRST_ENUM].prop == kind ){
            return 1;
        }
    }

    return 0;
}


const char* icalproperty_method_to_string(icalproperty_method method)
{
    icalerror_check_arg_rz(method >= ICAL_METHOD_X,"method");
    icalerror_check_arg_rz(method <= ICAL_METHOD_NONE,"method");

    return enum_map[method-ICALPROPERTY_FIRST_ENUM].str;
}

icalproperty_method icalproperty_string_to_method(const char* str)
{
    int i;

    icalerror_check_arg_rx(str!=0,"str",ICAL_METHOD_NONE)

    while(*str == ' '){
        str++;
    }

    for (i=ICAL_METHOD_X-ICALPROPERTY_FIRST_ENUM;
         i != ICAL_METHOD_NONE-ICALPROPERTY_FIRST_ENUM;
         i++) {
        if ( strcasecmp(enum_map[i].str, str) == 0) {
            return (icalproperty_method)enum_map[i].prop_enum;
        }
    }

    return ICAL_METHOD_NONE;
}


const char* icalenum_status_to_string(icalproperty_status status)
{
    icalerror_check_arg_rz(status >= ICAL_STATUS_X,"status");
    icalerror_check_arg_rz(status <= ICAL_STATUS_NONE,"status");

    return enum_map[status-ICALPROPERTY_FIRST_ENUM].str;
}

icalproperty_status icalenum_string_to_status(const char* str)
{
    int i;

    icalerror_check_arg_rx(str!=0,"str",ICAL_STATUS_NONE)

    while(*str == ' '){
        str++;
    }

    for (i=ICAL_STATUS_X-ICALPROPERTY_FIRST_ENUM;
         i != ICAL_STATUS_NONE-ICALPROPERTY_FIRST_ENUM;
         i++) {
        if ( strcasecmp(enum_map[i].str, str) == 0) {
            return (icalproperty_status)enum_map[i].prop_enum;
        }
    }

    return ICAL_STATUS_NONE;

}
