/***************************************************************************
                          digikamsplash.cpp  -  description
                             -------------------
    begin                : mar ao 27 2002
    copyright            : (C) 2002 by Renchi Raju
    email                : renchi@green.tam.uiuc.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include <qstring.h>
#include <qpixmap.h>
#include <qlabel.h>
#include <qapplication.h>
#include <qtimer.h>

#include <klocale.h>
#include <kstandarddirs.h>
#include <kdebug.h>


#include "digikamsplash.h"


DigikamSplash::DigikamSplash()
    : QWidget( 0L, "Digikam Splash",
               WStyle_NoBorder | WStyle_StaysOnTop |
               WStyle_Customize | WDestructiveClose )
{
    setGeometry( QApplication::desktop()->width ()/2-250,
                 QApplication::desktop()->height()/2-175, 500, 350 );
    setFixedSize( 500, 350 );

    QString text = i18n( "A KDE Image Management Application");
    QString file = locate( "appdata", "digikam-splash.png" );
    //QString file("/home/renchi/Devel/Digikam/Working/digikam3/digikam/pics/digikam-splash.png");
    QPixmap pixmap(file);

    setPaletteBackgroundPixmap(pixmap);

    QLabel* splashText = new QLabel( text, this);
    splashText->setBackgroundOrigin( ParentOrigin );
    splashText->setPaletteForegroundColor( QColor( 255, 223, 136 ) );
    QFont splashText_font(  splashText->font() );
    splashText_font.setBold( true );
    int xpos = -1;
    for( int i = 24; i > 8 && xpos < 0; i -= 2 ) {
        // we have to make sure the localized text is fitted into splash
        splashText_font.setPointSize( i );
        splashText->setFont( splashText_font );
        xpos = (500 - splashText->fontMetrics().width( text ) ) / 2;
    }
    splashText->setGeometry( xpos, 225, splashText->fontMetrics().width( text ),
                             splashText->fontMetrics().height() );
    splashText->show();

    mTimer = new QTimer();
    connect(mTimer, SIGNAL(timeout()),
            this, SLOT(slot_close()));

    mTimer->start(1200, true);

}


DigikamSplash::~DigikamSplash()
{
    delete mTimer;
}

void DigikamSplash::slot_close()
{
    close();
}
