#ifndef ALBUMICONVIEW_H
#define ALBUMICONVIEW_H

#include <qiconview.h>
#include <qstring.h>

#include <kfileitem.h>

#include "thumbnailsize.h"

class QCustomEvent;
class QPoint;
class KURL;

class ThumbnailCreator;


class AlbumIconView : public QIconView {

    Q_OBJECT

public:

    AlbumIconView(QWidget *_parent);
    ~AlbumIconView();

    void setPath(const KURL& path);

    void addItem(KFileItem* fileItem);
    void deleteItem(KFileItem* fileItem);
    void refreshItem(KFileItem* fileItem);

    void setThumbnailSize(const ThumbnailSize& thumbSize);
    ThumbnailSize getThumbnailSize() const;
    void resizeThumbnails(const ThumbnailSize& thumbSize);

    void cancelThumbnailGeneration();
    void pauseThumbnailGeneration();
    void regenerateThumbnails();
    void startSlideShow();
    void setSlideShowParams(int delay, bool effect,
                            const QString& fileNamePos);
    void setImageViewerParams(bool useInternal,
                              const QString& viewerName);


private:

    ThumbnailCreator *mThumbCreator;
    ThumbnailSize mThumbSize;
    KURL mCurrentPath;
    QString mThumbBaseCacheDir;

    int mNumThumbsRequested;
    int mNumThumbsDownloaded;

    bool mBusy;

    int mSlideShowDelay;
    bool mSlideShowTransitionEffect;
    int mSlideShowFileNamePosition;

    bool    mUseInternalImageViewer;
    QString mImageViewerName;

private:

    void customEvent(QCustomEvent *event);
    void deleteSelectedItems();
    void startDrag();

signals:

    void signal_albumProgress(int);
    void signal_albumBusy(bool busy);

private slots:

    void slot_rightClicked(QIconViewItem*,
                           const QPoint&);
    void slot_doubleClicked(QIconViewItem*);
    void slot_itemRenamed(QIconViewItem* item,
                          const QString& newName);

};

#endif
