#include <qtabwidget.h>
#include <qlayout.h>

#include "digikam_view.h"
#include "camera_browser.h"


Digikam_View::Digikam_View(QWidget *parent) : QWidget(parent) {

    m_mainLayout = new QGridLayout(this);

    m_tabWidget = new QTabWidget(this);
    m_tabWidget->setTabPosition( QTabWidget::Top );
    m_tabWidget->setTabShape( QTabWidget::Rounded );

    m_cameraBrowser = new Camera_Browser(m_tabWidget);

    m_tabWidget->insertTab(m_cameraBrowser, tr("Camera Browser"));

    m_mainLayout->addWidget(m_tabWidget, 0, 0);

}

Digikam_View::~Digikam_View()
{

    delete m_cameraBrowser;

}

