/***************************************************************************
                          exif_info.h  -  description
                             -------------------
    begin                : Thu Jan 31 14:34:36 CST 2002
    copyright            : (C) 2002 by Renchi Raju
    email                : renchi@green.tam.uiuc.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef EXIF_INFO_H
#define EXIF_INFO_H

#include <qwidget.h>

class QGridLayout; 
class QGroupBox;
class QPushButton;
class QTabWidget;
class QLabel;
class QMultiLineEdit;
class QString;
class QStringList;

class KListView;
class KListViewItem;

class Exif_Parser;

class Exif_Info : public QWidget
{
  Q_OBJECT 

 public:
    Exif_Info(Exif_Parser* _exifParser, QWidget* parent=0, 
	      const char *name=0, WFlags fl =  WDestructiveClose);
    ~Exif_Info();

    void setListViewFullWidth(KListView *listview);

    QTabWidget* tabWidget;
    QWidget* tab_IFD0;
    QWidget* tab_subIFD;
    QWidget* tab_interIFD;
    QWidget* tab_makerIFD;
    QWidget* tab_IFD1;
    QWidget* tab_comments;


    KListView* ListView_IFD0;
    KListView* ListView_subIFD;
    KListView* ListView_interIFD;
    KListView* ListView_makerIFD;
    KListView* ListView_IFD1;
    QLabel*  Label_thumbnail;
    QMultiLineEdit* MultiLineEdit_comments;
    
    QPushButton* closeButton;
    QPushButton* saveButton;
    QPushButton* saveImageButton;

    bool commentsChanged;
    QString getNewComments();

 protected:

    QGridLayout* Layout_main;
    QGridLayout* tabLayout_IFD0;
    QGridLayout* tabLayout_subIFD;
    QGridLayout* tabLayout_interIFD;
    QGridLayout* tabLayout_makerIFD;
    QGridLayout* tabLayout_IFD1;
    QGridLayout* tabLayout_comments;

    QGroupBox*   buttonBox;
    QGridLayout* Layout_buttonBox;

    Exif_Parser* exifParser;
    QStringList  exifStrings;

 private slots:
   
  void slot_commentsChanged();
  void slot_close();
  void slot_save();
  void slot_saveImage();

 signals:
    


};

#endif
