#include "fileOp.h"

#include <kiconloader.h>
#include <kmessagebox.h>
#include <klocale.h>
#include <qpixmap.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qfileinfo.h>

FileOpDialog::FileOpDialog(const QString &src, const QString &dest,
			   QWidget *parent, const char *name)
  : QDialog(parent, name, true)
{
  QFileInfo srcInfo(src);
  QFileInfo destInfo(dest);

  setCaption(i18n("File already exists"));
  QLabel *descLbl = new QLabel(i18n("The file \'") + destInfo.absFilePath() + i18n("\' already exists!"), 
			       this);
  QLabel *srcIconLbl = new QLabel(this);
  QLabel *destIconLbl = new QLabel(this);


  srcIconLbl->setPixmap(BarIcon("document", KIcon::SizeLarge));
  destIconLbl->setPixmap(BarIcon("document", KIcon::SizeLarge));


  renameEdit = new QLineEdit(this);
  renameEdit->setText(srcInfo.fileName());
  connect(renameEdit, SIGNAL(textChanged(const QString &)), this,
	  SLOT(slotRenameEnabled(const QString &)));
  
  // Bug in KButtonBox means one button has to not be noexpand or there is no
  // sizehint height :P
  KButtonBox *bbox = new KButtonBox(this);
  renameBtn = bbox->addButton(i18n("Rename"), this, SLOT(slotRename()), true);
  renameBtn->setEnabled(false);
  bbox->addButton(i18n("Skip"), this, SLOT(slotSkip()), false);
  bbox->addButton(i18n("Skip All"), this, SLOT(slotSkipAll()), true);
  bbox->addButton(i18n("Overwrite"), this, SLOT(slotOverwrite()), true);
  bbox->addButton(i18n("Overwrite All"), this, SLOT(slotOverwriteAll()), true);
  QPushButton *cancelBtn = bbox->addButton(i18n("Cancel"), this, SLOT(reject()), true);
  cancelBtn->setDefault(true);
  bbox->layout();
  
  QGridLayout *layout = new QGridLayout(this, 0, 0, 15);
  layout->addMultiCellWidget(descLbl, 0, 0, 0, 3);
  layout->addMultiCellWidget(srcIconLbl, 1, 2, 0, 0);
  layout->addMultiCellWidget(destIconLbl, 3, 4, 0, 0);
  layout->addMultiCellWidget(renameEdit, 5, 5, 0, 3);
  layout->addMultiCellWidget(bbox, 6, 6, 0, 3);

}

FileOpDialog::~FileOpDialog() {
}
